<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Api\Base;
use App\Michaelswebapi\Components\Listing as ComponentListing;

/**
 * Class Taxonomy
 * @package App\Michaelswebapi\Api
 */
class Listing extends Base
{
    protected $_component = 'Listing';

    /**
     * @param array $data
     * @return array
     */
    public function getQueryListing($data = [])
    {
        // return ['success'=>true,'message'=>'acsa'];
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getQueryListing($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getAllListing($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getAllListing($data);
            } else {
                return [
                    'success' => false,
                    'reg' => $this->di->getRegistry()->getCurrentShop(),
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    public function getUploadListingTasks($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getUploadListingTasks($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getListingBySkuNumber($data = [])
    {

        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                if (!isset($data['skuNumber'])) {
                    return [
                        'success' => false,
                        'message' => "Required String parameter 'skuNumber' is not present.",
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getListingBySkuNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getInventoriesByPrimarySkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getInventoriesByPrimarySkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getPriceByPrimarySkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getPriceByPrimarySkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function createListing($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                if (isset($data['variation']['variationDetails'])) {
                    foreach ($data['variation']['variationDetails'] as $key => $variationDetail) {
                        if (isset($variationDetail['attrs'])) {
                            $attrs = [];
                            foreach ($variationDetail['attrs'] as $variationKey => $attr) {
                                $attrs[strval($variationKey)] = $attr;
                            }
                            $data['variation']['variationDetails'][$key]['attrs'] = (object) $attrs;
                        }
                    }
                }
                if (isset($data['shippingAndRegulation'])) {
                    if ($data['shippingAndRegulation']['groundShipOnly'] == '1') {
                        $data['shippingAndRegulation']['groundShipOnly'] = true;
                    } else {
                        $data['shippingAndRegulation']['groundShipOnly'] = false;
                    }
                    if ($data['shippingAndRegulation']['restrictAKHIShip'] == '1') {
                        $data['shippingAndRegulation']['restrictAKHIShip'] = true;
                    } else {
                        $data['shippingAndRegulation']['restrictAKHIShip'] = false;
                    }
                    if ($data['shippingAndRegulation']['flammableContent'] == '1') {
                        $data['shippingAndRegulation']['flammableContent'] = true;
                    } else {
                        $data['shippingAndRegulation']['flammableContent'] = false;
                    }
                    if ($data['shippingAndRegulation']['hazmatIndicator'] == '1') {
                        $data['shippingAndRegulation']['hazmatIndicator'] = true;
                    } else {
                        $data['shippingAndRegulation']['hazmatIndicator'] = false;
                    }
                    if ($data['shippingAndRegulation']['overrideShippingRate'] == '1') {
                        $data['shippingAndRegulation']['overrideShippingRate'] = true;
                        if ($data['shippingAndRegulation']['freeStandardShipping'] == '1') {
                            $data['shippingAndRegulation']['freeStandardShipping'] = true;
                        } else {
                            $data['shippingAndRegulation']['freeStandardShipping'] = false;
                        }
                    } else {
                        $data['shippingAndRegulation']['overrideShippingRate'] = false;
                    }
                    if ($data['shippingAndRegulation']['overrideReturnPolicy'] == '1') {
                        $data['shippingAndRegulation']['overrideReturnPolicy'] = true;
                        if ($data['shippingAndRegulation']['refundOnly'] == '1') {
                            $data['shippingAndRegulation']['refundOnly'] = true;
                        } else {
                            $data['shippingAndRegulation']['refundOnly'] = false;
                        }
                    } else {
                        $data['shippingAndRegulation']['overrideReturnPolicy'] = false;
                    }
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->createListing($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updateListing($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                if (!isset($data['skuNumber'])) {
                    return [
                        'success' => false,
                        'message' => "Required String parameter 'skuNumber' is not present.",
                    ];
                }
                if (isset($data['variation']['variationDetails'])) {
                    foreach ($data['variation']['variationDetails'] as $key => $variationDetail) {
                        if (isset($variationDetail['attrs'])) {
                            $attrs = [];
                            foreach ($variationDetail['attrs'] as $variationKey => $attr) {
                                $attrs[strval($variationKey)] = $attr;
                            }
                            $data['variation']['variationDetails'][$key]['attrs'] = (object) $attrs;
                        }
                    }
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->updateListing($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updateListingBySellerSkuNumber($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                if (isset($data['variation']['variationDetails'])) {
                    foreach ($data['variation']['variationDetails'] as $key => $variationDetail) {
                        if (isset($variationDetail['attrs'])) {
                            $attrs = [];
                            foreach ($variationDetail['attrs'] as $variationKey => $attr) {
                                $attrs[strval($variationKey)] = $attr;
                            }
                            $data['variation']['variationDetails'][$key]['attrs'] = (object) $attrs;
                        }
                    }
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->updateListingBySellerSkuNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updatePriceBySellerSkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->updatePriceBySellerSkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updateInventoryBySellerSkuNumber($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->updateInventoryBySellerSkuNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getListingInBatchBySkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getListingInBatchBySkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getListingInBatchBySellerSkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getListingInBatchBySellerSkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getInventoryInBatchBySkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getInventoryInBatchBySkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getSkuPriceInBatchBySkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getSkuPriceInBatchBySkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function activateListing($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->activateListing($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function deactivateListing($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->deactivateListing($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function activateDeactivateSkus($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->activateDeactivateSkus($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updateInventoryBySkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                if (!isset($data['inventory'])) {
                    return [
                        'success' => false,
                        'message' => "Required Array parameter 'inventory' is not present.",
                    ];
                }
                if (!is_array($data['inventory'])) {
                    return [
                        'success' => false,
                        'message' => "Parameter 'inventory' is not an array.",
                    ];
                }
                if (count($data['inventory']) == 0) {
                    return [
                        'success' => false,
                        'message' => "Parameter 'inventory' can not be empty.",
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->updateInventoryBySkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function updatePriceBySkuNumbers($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                if (!isset($data['price'])) {
                    return [
                        'success' => false,
                        'message' => "Required Array parameter 'price' is not present.",
                    ];
                }
                if (!is_array($data['price'])) {
                    return [
                        'success' => false,
                        'message' => "Parameter 'price' is not an array.",
                    ];
                }
                if (count($data['price']) == 0) {
                    return [
                        'success' => false,
                        'message' => "Parameter 'price' can not be empty.",
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->updatePriceBySkuNumbers($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function createUpdateListingByExcelTemplate($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->createUpdateListingByExcelTemplate($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }


    public function cancelUploadTasks($data = [])
    {
        // return ['abs'=>true];
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->cancelUploadTasks($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }


    /**
     * @param array $data
     * @return array
     */
    public function asynchronousCreateUpdateListingByExcelTemplate($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->asynchronousCreateUpdateListingByExcelTemplate($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function createMediaUrl($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->createMediaUrl($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }
    /**
     * @param array $data
     * @return array
     */
    public function exportExcel($data = [])
    {
        // die('123');
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->exportExcel($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getInventoryInBatchBySellerSkuNumber($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getInventoryInBatchBySellerSkuNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }

    /**
     * @param array $data
     * @return array
     */
    public function getPriceInBatchBySellerSkuNumber($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->getPriceInBatchBySellerSkuNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }
    public function deleteListingBySkuNumber($data = [])
    {
        try {
            if ($shop = $this->di->getRegistry()->getCurrentShop()) {
                if (!$this->apiKeyExist()) {
                    return [
                        'success' => false,
                        'message' => ComponentListing::API_KEY_DOES_NOT_EXIST_ERROR_MESSAGE,
                    ];
                }
                return $this->di->getObjectManager()->get(ComponentListing::class)->deleteListingBySkuNumber($data);
            } else {
                return [
                    'success' => false,
                    'message' => ComponentListing::SHOP_NOT_FOUND_ERROR_MESSAGE,
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage(),
            ];
        }
    }
}
