<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Components\Core\Common As MichaelsCoreCommon;

/**
 * Class Base
 * @package App\Michaelswebapi\Api
 */
class Base extends \App\Apiconnect\Api\Base
{
    /**
     * @return bool
     */
    public function apiKeyExist() {
        $shop = $this->di->getRegistry()->getCurrentShop();
        if (isset($shop['apps'][0][MichaelsCoreCommon::MICHAELS_API_KEY_FIELD])) {
            return true;
        }
        return false;
    }
}