<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Michaelswebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Michaelswebapi\Api;

use App\Michaelswebapi\Api\Base;
use App\Michaelswebapi\Components\Authenticate As ComponentAuthenticate;

/**
 * Class Authenticate
 * @package App\Michaelswebapi\Api
 */
class Authenticate extends Base
{
    protected $_component = 'Authenticate';

    /**
     * @param array $data
     * @return array
     */
    public function addMichaelsInformation($data = []) {
        try{
            return $this->di->getObjectManager()->get(ComponentAuthenticate::class)->addMichaelsInformation($data);
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}