<?php

namespace App\Core\Controllers;

use Phalcon\Mvc\Controller;

class BaseController extends Controller
{
    public function prepareResponse($data, $type = 'json')
    {
        $data['ip'] = $_SERVER['REMOTE_ADDR'];
        $app = $this->di->getRegistry()->getRequestingApp();
        try {
            if ($type == 'json') {
                $controller = ucfirst(
                    str_replace(
                        '-',
                        '',
                        ucwords($this->router->getControllerName(), '-')
                    )
                );
                $action = $this->router->getActionName();
                $modifiedResponse = $this->di
                    ->get('App\\' . ucfirst($app) . '\Components\Modifiers\\' . $controller)
                    ->$action($data);
                if ($this->di->getConfig()->path("requests.track_global_requests", false))
                    $data["time_taken"] = number_format(abs(microtime(true) - TRACK_INIT), 3);
                $response = $this->response->setJsonContent($modifiedResponse);
            }
        } catch (\Exception $exception) {
            if ($this->di->getConfig()->path("requests.track_global_requests", false))
                $data["time_taken"] = number_format(abs(microtime(true) - TRACK_INIT), 3);
            $code = (int) ($data["status_code"] ?? ($data["statusCode"] ?? 200 ));
            if ($code)
                $this->response->setStatusCode($code);
            $response = $this->response->setJsonContent($data);
        }
        if (!isset($modifiedResponse)) {
            $modifiedResponse = $data;
        }
        $this->logResponse($response, $modifiedResponse);
        return $response;
    }
    public function getRequestData()
    {
        $contentType = $this->request->getHeader('Content-Type');
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }
        return $rawBody;
    }
    private function logResponse($responseObj, $modifiedResponse)
    {
        $configData = $this->di->getRegistry()->getAppConfig();
        $logData = [
            '_id'               => $this->di->getRegistry()->getRequestLogId(),
            'channel'           => $configData['marketplace'],
            'response_headers'  => $responseObj->getHeaders()->toArray(),
            'url' => $this->request->get()["_url"] ?? "/",
            'method' => $this->request->getMethod(),
            'payload' => array_merge(
                is_array($this->request->getJsonRawBody()) ? $this->request->getJsonRawBody() : [],
                $this->request->get() ?? []
            )
        ];
        $requestLogger = $this->di->getObjectManager()->get('\App\Core\Components\RequestLogger');

        if ($requestLogger->canLogResponse($modifiedResponse)) {
            $logData['response_body'] = $modifiedResponse;
            $logData['started'] = $modifiedResponse["started"] ?? microtime(true);
            $logData['ended'] = microtime(true);
            $logData['time_taken'] =
                $logData["ended"] - ($modifiedResponse["started"] ?? microtime(true));
        }
        $requestLogger->logContent($logData);
    }
}
