<?php

namespace App\Core\Components;

use \Phalcon\Di\DiInterface;
use \Phalcon\Di\FactoryDefault,
    \Phalcon\Loader;
use PHPUnit\Framework\TestCase;

class UnitTestApp extends TestCase
{
    public function setUp(): void
    {
        $di = new FactoryDefault();
        require_once BP . DS . 'vendor' . DS . 'autoload.php';
        /**Register loader for modules**/
        $di->set(
            'loader',
            function () {
                return new Loader();
            }
        );

        $loader = $di['loader'];
        $loader->registerNamespaces(
            [
                'Phalcon' => BP . DS . 'vendor' . DS . 'phalcon' . DS . 'incubator' . DS . 'Phalcon' . DS,
                'App\Core'   => CODE . DS . 'core',
                'App\Core\Middlewares'   => CODE . DS . 'core' . DS . 'Middlewares' . DS,
            ]
        );
        $loader->register();
        // Create an application
        new \App\Core\UnitApplication($di);
        $this->setDi($di);
        $this->_loaded = true;
    }

    public function setDi(DiInterface $di)
    {
        $this->di = $di;
    }
}
