<?php

namespace App\Core\Components\Mailers;

class PhpMailer extends \App\Core\Components\Base
{
    public function sendmail($email, $subject, $body, $debug = 0, $isHtml = true, $bccs = [], $files = [])
    {
        try {
            $mail = new \PHPMailer\PHPMailer\PHPMailer();
            $mail->CharSet = "UTF-8";
            // Enable verbose debug output
            $mail->SMTPDebug = $debug;
            // Set mailer to use SMTP
            $mail->isSMTP();
            // Specify main and backup SMTP servers
            $mail->Host = $this->di->getConfig()->get('mailer')->get('smtp')->get('host');
            // Enable SMTP authentication
            $mail->SMTPAuth = true;
            // SMTP username
            $mail->Username = $this->di->getConfig()->get('mailer')->get('smtp')->get('username');
            // SMTP password
            $mail->Password = $this->di->getConfig()->get('mailer')->get('smtp')->get('password');
            // Enable TLS encryption, `ssl` also accepted
            $mail->SMTPSecure = 'tls';
            // TCP port to connect to
            $mail->Port = $this->di->getConfig()->get('mailer')->get('smtp')->get('port');
            //Recipients
            $mail->setFrom(
                $this->di->getConfig()->get('mailer')->get('sender_email'),
                $this->di->getConfig()->get('mailer')->get('sender_name')
            );
            // Add a recipient
            $mail->addAddress($email, $email);
            if (!count($bccs)) {
                $bccs = explode(',', $this->di->getConfig()->get('mailer')->get('bcc'));
            }
            
            // Attachments
            if ($files) {
                foreach ($files as $file) {
                    $mail->addAttachment($file['path'], $file['name']);
                }
            }

            foreach ($bccs as $value) {
                $mail->addBCC($value);
            }
            //
            //  CONTENT
            //
            // Set email format to HTML
            $mail->isHTML($isHtml);
            $mail->Subject = $subject;
            $mail->Body = $body;
            $mail->AltBody = $body;
            if (!$mail->send()) {
                $this->di->getLog()->logContent(
                    "Mail [to $email] could not be sent : " . $mail->ErrorInfo,
                    \Phalcon\Logger::CRITICAL,
                    'mail.log'
                );
                return false;
            }
            return true;
        } catch (\Exception $e) {
            $this->di->getLog()->logContent(
                'Message could not be sent. Mailer Error: ' . $email . '=>' . $subject . ' : ' . $mail->ErrorInfo,
                \Phalcon\Logger::CRITICAL,
                'mail.log'
            );
        }
    }
}
