<?php

namespace App\Core\Components;

use Phalcon\Logger;

class Log extends Base
{
    protected $log;
    protected $adapters = [];
    public function setDi(\Phalcon\Di\DiInterface $di): void
    {
        parent::setDi($di);
        $adapter = fopen(BP . DS . 'var' . DS . 'log' . DS . 'system.log', 'a+');
        $this->adapters['system.log'] = $adapter;
        $this->di->set('log', $this);
    }

    public function createDirectory($dir)
    {
        $path = BP . DS . 'var' . DS . 'log' . DS . $dir;
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
    }

    public function logContent(
        $content,
        $type = Logger::DEBUG,
        $file = 'system.log',
        $closeConnectionNow = false,
        $messageUniqueCode = false
    ) {
        if ($this->di->getConfig()->get('log_level') <= $type) {
            if (isset($this->adapters[$file])) {
                $adapter = $this->adapters[$file];
            } else {
                $oldmask = umask(0);
                $this->createDirectory(dirname($file));
                $adapter = fopen(BP . DS . 'var' . DS . 'log' . DS . $file, 'a+');
                umask($oldmask);
                if (!$closeConnectionNow) {
                    $this->adapters[$file] = $adapter;
                }
            }

            switch ($type) {
                case Logger::CRITICAL:
                    $this->log($adapter, Logger::CRITICAL, $content);

                    break;
                case Logger::EMERGENCY:

                    if ($messageUniqueCode) {
                        $currentTimestamp = time();
                        $email = '';
                        if ($this->di->getConfig()->get('mailer'))
                            $email = $this->di->getConfig()->get('mailer')->get('critical_mail_reciever');

                        $debug = 0;
                        $isHtml = true;

                        $subject = 'Critical issue';
                        if($this->di->getConfig()->get('mailer') && $this->di->getConfig()->get('mailer')->get('critical_mail_subject'))
                            $subject = $this->di->getConfig()->get('mailer')->get('critical_mail_subject');

                        $appCode = $this->di->getConfig()->get('app_code');
                        $subject = $subject . " - {$appCode}";
                        
                        $bccs = [];
                        if($this->di->getConfig()->get('mailer') && $this->di->getConfig()->get('mailer')->get('critical_mail_reciever_bcc'))
                            $bccs = $this->di->getConfig()->get('mailer')->get('critical_mail_reciever_bcc');

                        if ($lastMessageTime = $this->di->getCache()->get('sendmail_' . $messageUniqueCode)) {
                            if ($lastMessageTime < $currentTimestamp - 3600) {
                                $this->di->getCache()->set('sendmail_' . $messageUniqueCode, $currentTimestamp);
                                // $this->di->getMailer()->sendmail($email, "Critical issue", $content);
                                $this->di->getMailer()->sendmail($email, $subject, $content, $debug, $isHtml, $bccs);
                            }
                        } else {
                            $this->di->getCache()->set('sendmail_' . $messageUniqueCode, $currentTimestamp);
                            // $this->di->getMailer()->sendmail($email, "Critical issue", $content);
                            $this->di->getMailer()->sendmail($email, $subject, $content, $debug, $isHtml, $bccs);
                        }
                    }
                    $this->log($adapter, Logger::CRITICAL, $content);
                    break;
                case Logger::DEBUG:
                    $this->log($adapter, Logger::DEBUG, $content);
                    break;
                case Logger::ERROR:
                    $this->log($adapter, Logger::ERROR, $content);
                    break;
                case Logger::INFO:
                    $this->log($adapter, Logger::INFO, $content);
                    break;
                case Logger::NOTICE:
                    $this->log($adapter, Logger::NOTICE, $content);
                    break;
                case Logger::WARNING:
                    $this->log($adapter, Logger::WARNING, $content);
                    break;
                case Logger::ALERT:
                    $this->log($adapter, Logger::ALERT, $content);
                    break;
                default:
                    $this->log($adapter, Logger::CUSTOM, $content);
                    break;
            }

            if ($closeConnectionNow) {
                $this->close($adapter);
                return false;
            } else {
                return $adapter;
            }
        }
    }
    public function log($adapter, $loglevel, $content)
    {
        $content = date('c') . " => " . $content;
        fwrite($adapter, $content . PHP_EOL);
    }

    public function close($adapter)
    {
        fclose($adapter);
    }

    /**
     * This function returns a stack trace with no truncated strings
     * @var \Exception $exception
     * 
     * @return String
     */
    public static function getExceptionTraceAsString($exception)
    {
        $rtn = "";
        $count = 0;
        foreach ($exception->getTrace() as $frame) {

            // var_dump($frame);die;
            $args = "";
            if (isset($frame['args'])) {
                $args = array();
                foreach ($frame['args'] as $arg) {
                    if (is_string($arg)) {
                        $args[] = "'" . $arg . "'";
                    } elseif (is_array($arg)) {
                        $args[] = "Array";
                    } elseif (is_null($arg)) {
                        $args[] = 'NULL';
                    } elseif (is_bool($arg)) {
                        $args[] = ($arg) ? "true" : "false";
                    } elseif (is_object($arg)) {
                        $args[] = get_class($arg);
                    } elseif (is_resource($arg)) {
                        $args[] = get_resource_type($arg);
                    } else {
                        $args[] = $arg;
                    }
                }
                $args = join(", ", $args);
            }
            $current_file = "[internal function]";
            if(isset($frame['file']))
            {
                $current_file = $frame['file'];
            }
            $current_line = "";
            if(isset($frame['line']))
            {
                $current_line = $frame['line'];
            }
            $rtn .= sprintf( "#%s %s(%s): %s%s%s(%s)\n",
                $count,
                $current_file,
                $current_line,
                $frame['class']??'',
                $frame['type']??'',
                $frame['function'],
                $args );
            $count++;
        }
        return $rtn;
    }
}
