<?php

namespace App\Connector\Controllers;

use Phalcon\Mvc\Controller;
use App\Connector\Components\Order\Order;
use App\Connector\Components\Dynamo;
use Aws\DynamoDb\Exception\DynamoDbException;

// use Phalcon\Di;
// use App\Connector\Models\Profile\Helper;
// use App\Connector\Models\Profile\UploadHelper;
// use App\Connector\Models\Profile\ProductHelper;
// use App\Connector\Components\Dynamo;
// use App\Core\Models\BaseMongo;

class TestController extends Controller
{

    public function createCustomOrderAction()
    {

        $homeShopId = $_GET['home_shop_id'];
        $marketplace = $_GET['marketplace'];

        if ($this->isSyncAllowed($homeShopId) === false) {
          echo 'sync off';
          return json_encode([
            'success' => false,
            'message' => 'Syncing off'
          ]);
        }


        // if (isset($_GET['skus'])) {
        //   $explode = explode(',', $_GET['skus']);
        //   $skus = $explode;
        // } else {
        //   print_r('skus not found.');
        //   die();
        // }
        // $orderedQuntity = '2';
        // if (isset($_GET['qty'])) {
        //   $orderedQuntity = (string)$_GET['qty'];
        // }
        // $itemsList = '';
        // foreach ($skus as $sku) {
        //   if (!empty($itemsList)) {
        //     $itemsList .= ',';
        //   }
        //     $itemsList .= '{"ProductInfo":{"NumberOfItems":"1"},"BuyerInfo":{},"ItemTax":{"CurrencyCode":"EUR","Amount":"10.26"},"QuantityShipped":0,"BuyerRequestedCancel":{"IsBuyerRequestedCancel":"true","BuyerCancelReason":"REASON_LEFT_UNSPECIFIED"},"ItemPrice":{"CurrencyCode":"EUR","Amount":"59.11"},"ASIN":"B01ISTGDY6","SellerSKU":"' . $sku . '","Title":"Bosch TAT6A004 Comfort Line - Tostadora de ranura larga, 1090 W, centrado automático de la rebanada, función de descongelación, color rojo/antracita","ShippingTax":{"CurrencyCode":"EUR","Amount":"1.40"},"IsGift":"false","ShippingPrice":{"CurrencyCode":"EUR","Amount":"8.04"},"ConditionSubtypeId":"New","ShippingDiscount":{"CurrencyCode":"EUR","Amount":"0.00"},"ShippingDiscountTax":{"CurrencyCode":"EUR","Amount":"0.00"},"IsTransparency":false,"QuantityOrdered":"' . $orderedQuntity . '","PromotionDiscountTax":{"CurrencyCode":"EUR","Amount":"0.00"},"ConditionId":"New","PromotionDiscount":{"CurrencyCode":"EUR","Amount":"0.00"},"OrderItemId":"' . mt_rand(10000000000000, 99999999999999) . '"}';
        //   }
        //   $marketplaceOrder = '{"success":true,"orders":[{"region":"EU","country":"ES","url":"https://sellercentral-europe.amazon.com/orders-v3/order/404-8381560-8742769","data":{"BuyerInfo":{"BuyerEmail":"g25xm1cdp8kxzyq@marketplace.amazon.es","BuyerName":"Maria Antonia Rivero"},"AmazonOrderId":"' . mt_rand(100, 999) . "-" . mt_rand(1000000, 9999999) . "-" . mt_rand(1000000, 9999999) . '","EarliestDeliveryDate":"2022-10-10T22:00:00Z","EarliestShipDate":"2022-10-06T22:00:00Z","SalesChannel":"Amazon.es","AutomatedShippingSettings":{"HasAutomatedShippingSettings":false},"OrderStatus":"Unshipped","NumberOfItemsShipped":0,"OrderType":"StandardOrder","IsPremiumOrder":false,"IsPrime":false,"FulfillmentChannel":"MFN","NumberOfItemsUnshipped":1,"HasRegulatedItems":false,"IsReplacementOrder":"false","IsSoldByAB":false,"LatestShipDate":"2022-10-10T21:59:59Z","ShipServiceLevel":"Std ES Dom_1","DefaultShipFromLocationAddress":{"StateOrRegion":"Aveiro","AddressLine1":"Rua Antero Andrade e Silva, N63","Phone":"607277606","PostalCode":"4520-290","City":"Santa Maria da Feira","CountryCode":"PT","Name":"Diversity Unipessoal Lda"},"IsISPU":false,"MarketplaceId":"A1RKKUPIHCS9HS","LatestDeliveryDate":"2022-10-14T21:59:59Z","PurchaseDate":"2022-10-06T14:08:15Z","ShippingAddress":{"StateOrRegion":"Andalucía","AddressLine1":"Calle luz arriero 4-2B","Phone":"607277606","PostalCode":"41010","City":"Sevilla","CountryCode":"ES","AddressType":"Residential","Name":"Maria Antonia Rivero","AddressLine2":"","AddressLine3":""},"IsAccessPointOrder":false,"PaymentMethod":"Other","IsBusinessOrder":false,"OrderTotal":{"CurrencyCode":"EUR","Amount":"67.15"},"PaymentMethodDetails":["Standard"],"IsGlobalExpressEnabled":false,"LastUpdateDate":"2022-10-10T10:20:59Z","ShipmentServiceLevelCategory":"Standard","ShipServiceLevelCategory":"Standard"},"items":[' . $itemsList . '],"home_shop_id":"' . $homeShopId . '","shop_id":"' . $homeShopId . '"}]}';

        // $amaozonOrder = json_decode($marketplaceOrder, true)['orders'][0];
        // echo "<pre>";
        // print_r(json_encode($amaozonOrder));die;

        $contentType = $this->request->getHeader('Content-Type');
        $rawBody = [];
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }

        $data['shop_id'] = $homeShopId;
        $data['marketplace'] = 'amazon';
        $data['order'] = $rawBody;
        $amazonOrderComponent = $this->di->getObjectManager()->get(Order::class);
        $response = $amazonOrderComponent->create($data);
        echo "<pre>";
        print_r($response);
        die('vjjv');

        // for test

        $amazonOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class, [], 'amazon');

        $preparedData = $amazonOrderService->prepareForDb($data);


        if ($preparedData['success']) {
            $connectorOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class);
            $connectorOrderService->setSchemaObject('source_order');
            $connectorResponse = $connectorOrderService->create($preparedData['data']);

            if ($connectorResponse['success']) {
                $shopifyOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class, [], 'shopify');

                $objectManager = $this->di->getObjectManager();
                $configObj = $objectManager->get(\App\Core\Models\Config\Config::class);
                $configObj->setGroupCode("order");
                $configObj->setUserId($this->di->getUser()->id);
                $configObj->setTargetShopId($homeShopId);
                $setting = $configObj->getConfig();
                $connectorResponse['data']['attributes'][] = [
                    "key" => 'cpf',
                    "value" => 'trestcpf'
                ];
                $connectorResponse['data']['order_settings'] = $setting;
                $response = $shopifyOrderService->create($connectorResponse['data']);
                echo "order created successfully";

                die("vhhvhv");
                if ($response['success']) {
                    $data['shop_id'] = $homeShopId;
                    $data['marketplace'] = 'shopify';

                    $shopifyPrepareData = $shopifyOrderService->prepareForDb($response['data']);

                    $connectorOrderService->setSchemaObject('target_order');
                    $connectorResponse = $connectorOrderService->create($preparedData['data']);
                }
            }
        } else {
            print_r($preparedData);
        }

        echo get_class($amazonOrderService);
        die;
    }

    public function isSyncAllowed($shopId)
    {
        $filterData = [
            '_id' => (string)$shopId
        ];
        $tableName = 'user_details';
        $dynamoObj = $this->di->getObjectManager()->get(Dynamo::class);
        $dynamoClientObj = $dynamoObj->getDetails();
        $shop = $this->di->getObjectManager()
          ->get('\App\Core\Models\User\Details')
          ->findShop($filterData, $this->di->getUser()->id)[0] ?? [];

        if (!empty($shop) && isset($shop['remote_shop_id'])) {
            $dynamoData = $dynamoClientObj->getItem(array(
              'ConsistentRead' => true,
              'TableName' => $tableName,
              'Key'       => array(
                  'id'   => array('S' => (string)$shop['remote_shop_id'])
              )
          ));
          if (!empty($dynamoData) && isset($dynamoData['Item'])) {
            $item = $dynamoData['Item'];
             if(isset($item['disable_order_sync'])) {
              $value = array_values($item['disable_order_sync'])[0];
              if(!$value) {
                return true;
              } else {
                return false;
              }
             } else {
              return true;
             }
          }
        }
    }

    public function manualCancellationAction()
    {
        $contentType = $this->request->getHeader('Content-Type');
        $rawBody = [];
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }
        $orderCancel = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderCancel');
        $result = $orderCancel->manualCancel($rawBody);
        print_r($result);
        die;
    }

    public function cancelOrderAction()
    {

        if (!isset($_GET['home_shop_id'])) {
            print_r('home_shop_id required');
        }
        if (!isset($_GET['amazon_order_id'])) {
            print_r('amazon_order_id required');
        }
        $homeShopId = $_GET['home_shop_id'];
        $amazonOrderId = $_GET['amazon_order_id'];
        if (isset($_GET['skus'])) {
            $explode = explode(',', $_GET['skus']);
            $skus = $explode;
        } else {
            print_r('skus not found.');
            die();
        }
        $cancelQty = '1';
        if (isset($_GET['qty'])) {
            $cancelQty = (string)$_GET['qty'];
        }
        $itemsList = '';
        foreach ($skus as $sku) {
            if (!empty($itemsList)) {
                $itemsList .= ',';
            }
            $itemsList .= '{
        "ProductInfo": {
            "NumberOfItems": "1"
        },
        "IsGift": "false",
        "BuyerInfo": [],
        "QuantityShipped": 0,
        "IsTransparency": false,
        "QuantityOrdered": 2,
        "QuantityCancelled": ' . $cancelQty . ',
        "ASIN": "B00VDEK0I4",
        "SellerSKU": "' . $sku . '",
        "Title": "Halloween Themed Decorative Felt Shapes - 24pc",
        "OrderItemId": "40607937547002"
    }';
        }
        $marketplaceOrder = '{
      "success": true,
      "marketplace": "amazon",
      "data": {
          "_url": "/webapi/rest/v1/order",
          "home_shop_id": "' . $homeShopId . '",
          "amazon_order_id": "' . $amazonOrderId . '"
      },
      "orders": [
          {
              "data": {
                  "BuyerInfo": [],
                  "AmazonOrderId": "' . $amazonOrderId . '",
                  "EarliestShipDate": "2022-09-17T06:59:59Z",
                  "SalesChannel": "Amazon.com",
                  "OrderStatus": "Canceled",
                  "NumberOfItemsShipped": 0,
                  "OrderType": "StandardOrder",
                  "IsPremiumOrder": false,
                  "IsPrime": false,
                  "FulfillmentChannel": "AFN",
                  "NumberOfItemsUnshipped": 0,
                  "HasRegulatedItems": false,
                  "IsReplacementOrder": false,
                  "IsSoldByAB": false,
                  "LatestShipDate": "2022-09-17T06:59:59Z",
                  "ShipServiceLevel": "Expedited",
                  "IsISPU": false,
                  "MarketplaceId": "ATVPDKIKX0DER",
                  "PurchaseDate": "2022-09-16T22:17:44Z",
                  "IsAccessPointOrder": false,
                  "SellerOrderId": "111-9074480-5777822",
                  "PaymentMethod": "Other",
                  "IsBusinessOrder": false,
                  "PaymentMethodDetails": [
                      "Standard"
                  ],
                  "IsGlobalExpressEnabled": false,
                  "LastUpdateDate": "2022-09-18T09:52:03Z",
                  "ShipmentServiceLevelCategory": "Expedited"
              },
              "items": [
                ' . $itemsList . '
              ],
              "region": "NA",
              "country": "US",
              "url": "https://sellercentral.amazon.com/orders-v3/order/111-9074480-5777822",
              "shop_id": "' . $homeShopId . '"
          }
      ],
      "spapi": true,
      "start_time": "09-22-2022 06:41:44",
      "end_time": "09-22-2022 06:41:45",
      "execution_time": 0.5602819919586182,
      "ip": "103.97.184.106"
  }';
        $order = json_decode($marketplaceOrder, true);
        $orderCancel = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderCancel');
        $result = $orderCancel->cancel($order);
        print_r($result);
        die;
    }

    public function orderCancellationAction()
    {
        $contentType = $this->request->getHeader('Content-Type');
        $rawBody = [];
        if (strpos($contentType, 'application/json') !== false) {

            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }
        $orderCancel = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderCancel');
        $result = $orderCancel->cancel($rawBody);
        print_r($result);
        die;
    }

    public function shipTestAction()
    {
        $contentType = $this->request->getHeader('Content-Type');
        $rawBody = [];
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }

        $this->di->getObjectManager()->get('\App\Connector\Models\SourceModel')->triggerWebhooks($rawBody);
        return true;
    }

    public function testSettingsAction()
    {
        $contentType = $this->request->getHeader('Content-Type');
        $rawBody = [];
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }

        $orderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\Order\RefundInterface::class, [], 'amazon');
        $res = $orderService->refund($rawBody);
        echo '<pre>';
        print_r($res);
        echo '<br><br><b>';
        die(__FILE__ . '/line ' . __LINE__);
    }

    public function testFeedAction()
    {
        $orderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\Order\RefundInterface::class, [], 'amazon');
        //$data = $orderService->refund($amaozn['amazon']);
        //$feedId = '126346019242'; //single
        // $feedId = '126428019242'; //more items
        $feedId = '134267019265'; //two message id
        $data = $orderService->syncFeed($feedId);
        echo '<pre>';
        print_r($data);
        die;
    }

    public function testResponseAction()
    {
        $contentType = $this->request->getHeader('Content-Type');
        $rawBody = [];
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }

        $orderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\Order\RefundInterface::class, [], 'amazon');
        $res = $orderService->refundResponse($rawBody);
        echo '<pre>';
        print_r($res);
        echo '<br><br><b>';
        die(__FILE__ . '/line ' . __LINE__);
    }

    public function testWebhookAction()
    {
        $data = array(
            'title' => 'User type Event Destination',
            'type' => 'user',
            'event_handler' => 'sqs',
            'destination_data' => [
                'type' => 'sqs',
                'sqs' => [
                    'region' => 'ap-south-1',
                    'key' => 'AKIAYQBKXVXDV4BF76HI',
                    'secret' => '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',
                    'queue_base_url' => "https://sqs.ap-south-1.amazonaws.com/584205184455/"
                ],
            ]
        );
        $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
            ->init('cedcommerce', false)
            ->call('event/destination', [], ['data' => $data, 'app_code' => "cedcommerce"], 'POST');

        print_r($remoteResponse);
        die;
    }

    public function createSubscriptionAction()
    {
        $data = array(
            'event_code' => 'orders/create',
            'event_handler_id' => '1',
            'marketplace_data' => [],
            'queue_data' => [
                'type' => 'full_class',
                'class_name' => '\App\Connector\Models\SourceModel',
                'method' => 'triggerWebhooks',
                'user_id' => '6305cb2e87a4ec2309641db5',
                'shop_id' => '2',
                'action' => 'order_create',
                'queue_name' => 'order_create',
                'app_code' => 'default',
                'marketplace' => 'shopify',
            ],
        );
        $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
            ->init('cedcommerce', true)
            ->call('event/subscription', [], ['shop_id' => 2, 'app_code' => "cedcommerce", 'data' => $data], 'POST');

        echo '<pre>';
        print_r($remoteResponse);
        die;
    }


    public function createRefundSubscriptionAction()
    {
        $data = array(
            'event_code' => 'refunds/create',
            'event_handler_id' => '1',
            'marketplace_data' => [],
            'queue_data' => [
                'type' => 'full_class',
                'class_name' => '\App\Connector\Models\SourceModel',
                'method' => 'triggerWebhooks',
                'user_id' => '6305cb2e87a4ec2309641db5',
                'shop_id' => '2',
                'action' => 'refunds_create',
                'queue_name' => 'refunds_create',
                'app_code' => 'default',
                'marketplace' => 'shopify',
            ],
        );
        $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
            ->init('cedcommerce', true)
            ->call('event/subscription', [], ['shop_id' => 2, 'app_code' => "cedcommerce", 'data' => $data], 'POST');

        echo '<pre>';
        print_r($remoteResponse);
        die;
    }


    public function testRefundAction()
    {
        $start = microtime(true);
        $data = '{
      "data": {
        "id": 839281737821,
        "order_id": 4608445481053,
        "created_at": "2022-09-26T16:23:23+05:30",
        "note": "Testing refund",
        "user_id": 75581620317,
        "processed_at": "2022-09-26T16:23:23+05:30",
        "restock": false,
        "duties": [],
        "total_duties_set": {
          "shop_money": {
            "amount": "0.00",
            "currency_code": "USD"
          },
          "presentment_money": {
            "amount": "0.00",
            "currency_code": "USD"
          }
        },
        "admin_graphql_api_id": "gid://shopify/Refund/839281737821",
        "refund_line_items": [
          {
            "id": 343507566685,
            "quantity": 1,
            "line_item_id": 11414484189277,
            "location_id": null,
            "restock_type": "no_restock",
            "subtotal": 29.99,
            "total_tax": 0,
            "subtotal_set": {
              "shop_money": {
                "amount": "29.99",
                "currency_code": "USD"
              },
              "presentment_money": {
                "amount": "29.99",
                "currency_code": "USD"
              }
            },
            "total_tax_set": {
              "shop_money": {
                "amount": "0.00",
                "currency_code": "USD"
              },
              "presentment_money": {
                "amount": "0.00",
                "currency_code": "USD"
              }
            },
            "line_item": {
              "id": 11414484189277,
              "variant_id": null,
              "title": "Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple",
              "quantity": 1,
              "sku": "1001",
              "variant_title": null,
              "vendor": null,
              "fulfillment_service": "manual",
              "product_id": null,
              "requires_shipping": true,
              "taxable": true,
              "gift_card": false,
              "name": "Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple",
              "variant_inventory_management": null,
              "properties": [],
              "product_exists": false,
              "fulfillable_quantity": 0,
              "grams": 0,
              "price": "29.99",
              "total_discount": "0.00",
              "fulfillment_status": null,
              "price_set": {
                "shop_money": {
                  "amount": "29.99",
                  "currency_code": "USD"
                },
                "presentment_money": {
                  "amount": "29.99",
                  "currency_code": "USD"
                }
              },
              "total_discount_set": {
                "shop_money": {
                  "amount": "0.00",
                  "currency_code": "USD"
                },
                "presentment_money": {
                  "amount": "0.00",
                  "currency_code": "USD"
                }
              },
              "discount_allocations": [],
              "duties": [],
              "admin_graphql_api_id": "gid://shopify/LineItem/11414484189277",
              "tax_lines": []
            }
          },
          {
            "id": 343507599453,
            "quantity": 1,
            "line_item_id": 11414484222045,
            "location_id": null,
            "restock_type": "no_restock",
            "subtotal": 29.99,
            "total_tax": 0,
            "subtotal_set": {
              "shop_money": {
                "amount": "29.99",
                "currency_code": "USD"
              },
              "presentment_money": {
                "amount": "29.99",
                "currency_code": "USD"
              }
            },
            "total_tax_set": {
              "shop_money": {
                "amount": "0.00",
                "currency_code": "USD"
              },
              "presentment_money": {
                "amount": "0.00",
                "currency_code": "USD"
              }
            },
            "line_item": {
              "id": 11414484222045,
              "variant_id": null,
              "title": "Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple",
              "quantity": 1,
              "sku": "1002",
              "variant_title": null,
              "vendor": null,
              "fulfillment_service": "manual",
              "product_id": null,
              "requires_shipping": true,
              "taxable": true,
              "gift_card": false,
              "name": "Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple",
              "variant_inventory_management": null,
              "properties": [],
              "product_exists": false,
              "fulfillable_quantity": 0,
              "grams": 0,
              "price": "29.99",
              "total_discount": "0.00",
              "fulfillment_status": null,
              "price_set": {
                "shop_money": {
                  "amount": "29.99",
                  "currency_code": "USD"
                },
                "presentment_money": {
                  "amount": "29.99",
                  "currency_code": "USD"
                }
              },
              "total_discount_set": {
                "shop_money": {
                  "amount": "0.00",
                  "currency_code": "USD"
                },
                "presentment_money": {
                  "amount": "0.00",
                  "currency_code": "USD"
                }
              },
              "discount_allocations": [],
              "duties": [],
              "admin_graphql_api_id": "gid://shopify/LineItem/11414484222045",
              "tax_lines": []
            }
          }
        ],
        "transactions": [
          {
            "id": 5735645282397,
            "order_id": 4608445481053,
            "kind": "refund",
            "gateway": "amazon",
            "status": "success",
            "message": "Refunded 55.00 from manual gateway",
            "created_at": "2022-09-26T16:23:23+05:30",
            "test": false,
            "authorization": null,
            "location_id": null,
            "user_id": 75581620317,
            "parent_id": 5735643840605,
            "processed_at": "2022-09-26T16:23:23+05:30",
            "device_id": null,
            "error_code": null,
            "source_name": "1830279",
            "receipt": {},
            "amount": "55.00",
            "currency": "USD",
            "admin_graphql_api_id": "gid://shopify/OrderTransaction/5735645282397"
          }
        ],
        "order_adjustments": [
          {
            "id": 192275841117,
            "order_id": 4608445481053,
            "refund_id": 839281737821,
            "amount": "4.98",
            "tax_amount": "0.00",
            "kind": "refund_discrepancy",
            "reason": "Refund discrepancy",
            "amount_set": {
              "shop_money": {
                "amount": "4.98",
                "currency_code": "USD"
              },
              "presentment_money": {
                "amount": "4.98",
                "currency_code": "USD"
              }
            },
            "tax_amount_set": {
              "shop_money": {
                "amount": "0.00",
                "currency_code": "USD"
              },
              "presentment_money": {
                "amount": "0.00",
                "currency_code": "USD"
              }
            }
          }
        ]
      },
      "shop_id": "11",
      "marketplace": "shopify"
    }';
        $rawBody = $this->request->getJsonRawBody(true);
        // $data = json_decode($data, true);
        $response = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderRefund')->refund($rawBody);
        $end = microtime(true);
        echo '<pre>';
        print_r($response);
        echo '<br><br><b>';
        echo $end - $start;
        echo PHP_EOL;
        die(__FILE__ . '/line ' . __LINE__);
    }

    public function createCustomFailRefundAction()
    {
        $rawBody = $this->request->getJsonRawBody(true);
        $response = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderRefund')->createCustomFail($rawBody);
        echo '<pre>';
        print_r($response);
        echo '<br><br><b>';
        die(__FILE__ . '/line ' . __LINE__);
    }

    public function testOrderRefundAction()
    {
        $requestData = $this->request->get();
        if (empty($requestData['skus'])) {
            return 'skus not found!';
        }
        $skus = explode(',', $requestData['skus']);
        if (!isset($requestData['qty'])) {
            $requestData['qty'] = '1';
        }
        if (!isset($requestData['refund_qty'])) {
            $requestData['refund_qty'] = '1';
        }
        $refund_test_data = '{"id":840169128029,"order_id":4625954308189,"created_at":"2022-10-07T10:06:12+05:30","note":"inventory","user_id":75581620317,"processed_at":"2022-10-07T10:06:12+05:30","restock":false,"duties":[],"total_duties_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"admin_graphql_api_id":"gid:\/\/shopify\/Refund\/840169128029","refund_line_items":[{"id":344713330781,"quantity":2,"line_item_id":11447578755165,"location_id":null,"restock_type":"no_restock","subtotal":59.98,"total_tax":0.0,"subtotal_set":{"shop_money":{"amount":"59.98","currency_code":"USD"},"presentment_money":{"amount":"59.98","currency_code":"USD"}},"total_tax_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"line_item":{"id":11447578755165,"variant_id":null,"title":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","quantity":2,"sku":"1001","variant_title":null,"vendor":null,"fulfillment_service":"manual","product_id":null,"requires_shipping":true,"taxable":true,"gift_card":false,"name":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","variant_inventory_management":null,"properties":[],"product_exists":false,"fulfillable_quantity":0,"grams":0,"price":"29.99","total_discount":"0.00","fulfillment_status":null,"price_set":{"shop_money":{"amount":"29.99","currency_code":"USD"},"presentment_money":{"amount":"29.99","currency_code":"USD"}},"total_discount_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"discount_allocations":[],"duties":[],"admin_graphql_api_id":"gid:\/\/shopify\/LineItem\/11447578755165","tax_lines":[]}},{"id":344713363549,"quantity":1,"line_item_id":11447578853469,"location_id":null,"restock_type":"no_restock",
      "subtotal":29.99,"total_tax":0.0,"subtotal_set":{"shop_money":{"amount":"29.99","currency_code":"USD"},"presentment_money":{"amount":"29.99","currency_code":"USD"}},"total_tax_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"line_item":{"id":11447578853469,"variant_id":null,"title":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","quantity":2,"sku":"1004","variant_title":null,"vendor":null,"fulfillment_service":"manual","product_id":null,"requires_shipping":true,"taxable":true,"gift_card":false,"name":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","variant_inventory_management":null,"properties":[],"product_exists":false,"fulfillable_quantity":1,"grams":0,"price":"29.99","total_discount":"0.00","fulfillment_status":null,"price_set":{"shop_money":{"amount":"29.99","currency_code":"USD"},"presentment_money":{"amount":"29.99","currency_code":"USD"}},"total_discount_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"discount_allocations":[],"duties":[],"admin_graphql_api_id":"gid:\/\/shopify\/LineItem\/11447578853469","tax_lines":[]}},{"id":344713396317,"quantity":1,"line_item_id":11447578919005,"location_id":null,"restock_type":"no_restock","subtotal":29.99,"total_tax":0.0,"subtotal_set":{"shop_money":{"amount":"29.99","currency_code":"USD"},"presentment_money":{"amount":"29.99","currency_code":"USD"}},"total_tax_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"line_item":{"id":11447578919005,"variant_id":null,"title":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","quantity":2,"sku":"1006","variant_title":null,"vendor":null,"fulfillment_service":"manual","product_id":null,
      "requires_shipping":true,"taxable":true,"gift_card":false,"name":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","variant_inventory_management":null,"properties":[],"product_exists":false,"fulfillable_quantity":1,"grams":0,"price":"29.99","total_discount":"0.00","fulfillment_status":null,"price_set":{"shop_money":{"amount":"29.99","currency_code":"USD"},"presentment_money":{"amount":"29.99","currency_code":"USD"}},"total_discount_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"discount_allocations":[],"duties":[],"admin_graphql_api_id":"gid:\/\/shopify\/LineItem\/11447578919005","tax_lines":[]}},{"id":344713429085,"quantity":1,"line_item_id":11447579050077,"location_id":null,"restock_type":"no_restock","subtotal":29.99,"total_tax":0.0,"subtotal_set":{"shop_money":{"amount":"29.99","currency_code":"USD"},"presentment_money":{"amount":"29.99","currency_code":"USD"}},"total_tax_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},"line_item":{"id":11447579050077,"variant_id":null,"title":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","quantity":2,"sku":"1010","variant_title":null,"vendor":null,"fulfillment_service":"manual","product_id":null,"requires_shipping":true,"taxable":true,"gift_card":false,"name":"Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple","variant_inventory_management":null,"properties":[],"product_exists":false,"fulfillable_quantity":1,"grams":0,"price":"29.99","total_discount":"0.00","fulfillment_status":null,"price_set":{"shop_money":{"amount":"29.99","currency_code":"USD"},"presentment_money":{"amount":"29.99","currency_code":"USD"}},"total_discount_set":{"shop_money":{"amount":"0.00","currency_code":"USD"},"presentment_money":{"amount":"0.00","currency_code":"USD"}},
      "discount_allocations":[],"duties":[],"admin_graphql_api_id":"gid:\/\/shopify\/LineItem\/11447579050077","tax_lines":[]}}],"transactions":[{"id":5761829666909,"order_id":4625954308189,"kind":"refund","gateway":"amazon","status":"success","message":"Refunded 149.95 from manual gateway","created_at":"2022-10-07T10:06:12+05:30","test":false,"authorization":null,"location_id":null,"user_id":75581620317,"parent_id":5757157376093,"processed_at":"2022-10-07T10:06:12+05:30","device_id":null,"error_code":null,"source_name":"1830279","receipt":{},"amount":"149.95","currency":"USD","admin_graphql_api_id":"gid:\/\/shopify\/OrderTransaction\/5761829666909"}],"order_adjustments":[]}';

        $refund_data = json_decode($refund_test_data, true);

        if (!isset($requestData['order_id'])) {
            return 'order_id not found.';
        }
        $refund_data['order_id'] = $requestData['order_id'];
        $refund_data['note'] = '';
        if (isset($requestData['reason'])) {
            $refund_data['note'] = $requestData['reason'];
        }
        $refund_line = $refund_data['refund_line_items'][0];

        foreach ($skus as $index => $sku) {
            $refund_line['line_item']['sku'] = $sku;
            $refund_line['line_item']['quantity'] = $requestData['qty'];
            $refund_line['quantity'] = $requestData['refund_qty'];
            $refundsLineItems[] = $refund_line;
        }
        $refund_data['refund_line_items'] = $refundsLineItems;
        $refund_data = [
            'data' => $refund_data
        ];
        $refund_data['shop_id'] = $requestData['shop_id'];
        $refund_data['marketplace'] = 'shopify';
        $response = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderRefund')->refund($refund_data);
        $message = 'Order refund initiated';
        if (isset($response['success']) && !$response['success']) {
            $message = 'There was an error refunding your order';
        }
        if (isset($response['errors'])) {
            $message = $response['errors'];
        }
        echo '<pre>';
        print_r($message);
        echo '<br><br><b>';
        die('testOrderRefundAction');
    }

    public function testRefundResponseAction()
    {
        $rawBody = $this->request->getJsonRawBody(true);
        $response = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderRefund')->refundResponse($rawBody);
        echo '<pre>';
        print_r($response);
        echo '<br><br><b>';
        die(__FILE__ . '/line ' . __LINE__);
    }

    public function testAmazonFeedResponseAction()
    {
        $amazonRefundService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\Order\RefundInterface::class, [], 'amazon');
        $response = $amazonRefundService->initiateFeedSync();
        echo '<pre>';
        print_r($response);
        echo '<br><br><b>';
        die(__FILE__ . '/line ' . __LINE__);
    }

    public function testRefundFeedSyncAction()
    {
        $response = $this->di->getObjectManager()->get('\App\Connector\Components\Order\OrderRefund')->initiateFeedSync();
        echo '<pre>';
        print_r($response);
        echo '<br><br><b>';
        die(__FILE__ . '/line ' . __LINE__);
    }

    public function indexAction()
    {
        $shipment = '{
        "shop": "faizan7985.myshopify.com",
        "data": {
          "id": 4164731469981,
          "order_id": 4241557880889,
          "status": "success",
          "created_at": "2022-07-12T15:16:09+05:30",
          "service": "manual",
          "updated_at": "2022-07-12T15:16:09+05:30",
          "tracking_company": "TNT",
          "shipment_status": null,
          "location_id": 63762989212,
          "origin_address": null,
          "email": "",
          "destination": {
            "first_name": "Anita",
            "address1": "520 UNION LN",
            "phone": "",
            "city": "BRIELLE",
            "zip": "08730-1421",
            "province": "New Jersey",
            "country": "United States",
            "last_name": "Gerards",
            "address2": "",
            "company": null,
            "latitude": 40.1104829,
            "longitude": -74.0565646,
            "name": "Anita Gerards",
            "country_code": "US",
            "province_code": "NJ"
          },
          "line_items": [
            {
              "id": "62c3fbac85415ee196023332",
              "variant_id": 40389938413625,
              "title": "Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple",
              "quantity": 2,
              "sku": "akk12345",
              "variant_title": null,
              "vendor": "gaurav-fb",
              "fulfillment_service": "manual",
              "product_id": 7029165457564,
              "requires_shipping": true,
              "taxable": true,
              "gift_card": false,
              "name": "Rolling Sands Premium Solid Color Mexican Yoga Blanket, Purple",
              "variant_inventory_management": "shopify",
              "properties": [],
              "product_exists": true,
              "fulfillable_quantity": 0,
              "grams": 0,
              "price": "29.99",
              "total_discount": "0.00",
              "fulfillment_status": "fulfilled",
              "price_set": {
                "shop_money": {
                  "amount": "29.99",
                  "currency_code": "USD"
                },
                "presentment_money": {
                  "amount": "29.99",
                  "currency_code": "USD"
                }
              },
              "total_discount_set": {
                "shop_money": {
                  "amount": "0.00",
                  "currency_code": "USD"
                },
                "presentment_money": {
                  "amount": "0.00",
                  "currency_code": "USD"
                }
              },
              "discount_allocations": [],
              "duties": [],
              "admin_graphql_api_id": "gid://shopify/LineItem/11297764180124",
              "tax_lines": [
                {
                  "title": "Item Tax",
                  "price": "850.00",
                  "rate": 28.3428,
                  "channel_liable": null,
                  "price_set": {
                    "shop_money": {
                      "amount": "850.00",
                      "currency_code": "USD"
                    },
                    "presentment_money": {
                      "amount": "850.00",
                      "currency_code": "USD"
                    }
                  }
                }
              ]
            }
          ],
          "tracking_number": "1233567901",
          "tracking_numbers": [
            "12335678"
          ],
          "tracking_url": "https://www.tnt.com/express/en_us/site/tracking.html?searchType=con&cons=12335678",
          "tracking_urls": [
            "https://www.tnt.com/express/en_us/site/tracking.html?searchType=con&cons=12335678"
          ],
          "receipt": {},
          "name": "#1003.1",
          "admin_graphql_api_id": "gid://shopify/Fulfillment/4164731469980"
        },
        "type": "full_class",
        "handle_added": "1",
        "method": "triggerWebhooks",
        "user_id": "62b4116d0eba88f212056652",
        "code": "Shopifyhome",
        "action": "fulfillments_create",
        "queue_name": "amazon_shopify_orders_fulfillments_create",
        "marketplace": "amazon",
        "app_code": "amazon_sales_channel"
      }';
        $data = json_decode($shipment, true);
        $this->di->getObjectManager()->get('\App\Connector\Models\SourceModel')->triggerWebhooks($data);
        return true;
        $moduleHome = "Amazon";
        $class = '\App\\' . $moduleHome . '\Components\Order\Hook';
        if (class_exists($class)) {
            if (method_exists($class, 'createQueueToFulfillOrder')) {
                if (isset($data['data'])) {
                    $prepareData = [];
                    $prepareData['data'] = [];
                    $prepareData['data']['name'] = '';
                    $prepareData['data']['id'] = $data['data']['order_id'];
                    if (isset($data['data'][0])) {
                        $prepareData['data']['fulfillments'] = $data['data'];
                    } else {
                        $prepareData['data']['fulfillments'][0] = $data['data'];
                    }
                    $updatedDatabase = $this->di->getObjectManager()->get($class)->createQueueToFulfillOrder($prepareData);
                } else {
                    $updatedDatabase = $this->di->getObjectManager()->get($class)->createQueueToFulfillOrder($data);
                }
            } else {
                $this->di->getLog()->logContent('createQueueToFulfillOrder Class found, method not found. ' . json_encode($data), 'info', 'MethodNotFound.log');
            }
        } else {
            $this->di->getLog()->logContent($class . ' Class not found. ' . json_encode($data), 'info', 'ClassNotFound.log');
        }
        die;
        $orderData = '{
          "success": true,
          "data": {
              "_url": "/webapi/rest/v1/order",
              "shop_id": "179",
              "home_shop_id": "246",
              "amazon_order_id": "113-0578565-3499440"
          },
          "orders": [
              {
                  "data": {
                      "BuyerInfo": {
                          "BuyerEmail": "mailto:dwmzg16xttrvgy8@marketplace.amazon.com",
                          "BuyerName": "Bud Stone"
                      },
                      "AmazonOrderId": "113-0578565-3499440",
                      "EarliestDeliveryDate": "2022-05-26T07:00:00Z",
                      "EarliestShipDate": "2022-05-23T07:00:00Z",
                      "SalesChannel": "Amazon.com",
                      "AutomatedShippingSettings": {
                          "HasAutomatedShippingSettings": false
                      },
                      "OrderStatus": "Shipped",
                      "NumberOfItemsShipped": 1,
                      "OrderType": "StandardOrder",
                      "IsPremiumOrder": false,
                      "IsPrime": false,
                      "FulfillmentChannel": "MFN",
                      "NumberOfItemsUnshipped": 0,
                      "HasRegulatedItems": false,
                      "IsReplacementOrder": false,
                      "IsSoldByAB": false,
                      "LatestShipDate": "2022-05-25T06:59:59Z",
                      "ShipServiceLevel": "Econ US Dom",
                      "DefaultShipFromLocationAddress": {
                          "StateOrRegion": "TX",
                          "AddressLine1": "null",
                          "PostalCode": "75001",
                          "City": "Addison",
                          "CountryCode": "US",
                          "Name": "null"
                      },
                      "IsISPU": false,
                      "MarketplaceId": "ATVPDKIKX0DER",
                      "LatestDeliveryDate": "2022-06-02T06:59:59Z",
                      "PurchaseDate": "2022-05-21T14:38:05Z",
                      "ShippingAddress": {
                          "StateOrRegion": "GA",
                          "AddressLine1": "80 PHILPOT FERRY RD",
                          "PostalCode": "30230-2134",
                          "City": "HOGANSVILLE",
                          "CountryCode": "US",
                          "AddressType": "Residential",
                          "Name": "Bud Stone"
                      },
                      "IsAccessPointOrder": false,
                      "PaymentMethod": "Other",
                      "IsBusinessOrder": false,
                      "OrderTotal": {
                          "CurrencyCode": "USD",
                          "Amount": "34.23"
                      },
                      "PaymentMethodDetails": [
                          "Standard"
                      ],
                      "IsGlobalExpressEnabled": false,
                      "LastUpdateDate": "2022-05-23T16:18:47Z",
                      "ShipmentServiceLevelCategory": "FreeEconomy"
                  },
                  "items": [
                      {
                          "TaxCollection": {
                              "Model": "MarketplaceFacilitator",
                              "ResponsibleParty": "Amazon Services, Inc."
                          },
                          "ProductInfo": {
                              "NumberOfItems": "1"
                          },
                          "BuyerInfo": [],
                          "ItemTax": {
                              "CurrencyCode": "USD",
                              "Amount": "2.24"
                          },
                          "QuantityShipped": 1,
                          "ItemPrice": {
                              "CurrencyCode": "USD",
                              "Amount": "31.99"
                          },
                          "ASIN": "B08W5FLBS1",
                          "SellerSKU": "BE-PA-56080-DP",
                          "Title": "T-H Marine Supplies 60\" Wood Canoe Paddle",
                          "IsGift": "false",
                          "ConditionSubtypeId": "New",
                          "IsTransparency": false,
                          "QuantityOrdered": 1,
                          "PromotionDiscountTax": {
                              "CurrencyCode": "USD",
                              "Amount": "0.80"
                          },
                          "ConditionId": "New",
                          "PromotionDiscount": {
                              "CurrencyCode": "USD",
                              "Amount": "0.70"
                          },
                          "OrderItemId": "59084248006946"
                      }
                  ],
                  "region": "NA",
                  "country": "US",
                  "url": "https://sellercentral.amazon.com/orders-v3/order/113-0578565-3499440",
                  "shop_id": "246"
              }
          ],
          "spapi": true,
          "start_time": "06-29-2022 10:56:10",
          "end_time": "06-29-2022 10:56:11",
          "execution_time": 0.5785560607910156,
          "ip": "103.97.184.106"
      }
      ';
        $orderArray = json_decode($orderData, true);

        $data = $orderArray['orders'][0];
        $amazonOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class, [], 'amazon');

        $preparedData = $amazonOrderService->prepareForDb($data);
        print_r("here");
        if ($preparedData['success']) {
            $connectorOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class);
            $connectorOrderService->create($preparedData['data']);
            $amazonOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class, [], 'amazon');
            echo get_class($connectorOrderService);
            echo "</br>";
        } else {
            print_r($preparedData);
        }

        echo get_class($amazonOrderService);
        die;


        $productContainerTableAlias = 'pc';
        $productTableAlias = 'p';
        $productAttrTable = 'product_attribute';
        $productAttrTableAlias = 'pa';

        $prod_id = 10;

        $query = 'Select `pc`.*';
        $attType = [];
        $attId = [];
        $proAttr = new \App\Connector\Models\ProductAttribute;
        $containerAttr = $proAttr::find(["created_for='container' AND merchant_id='59'"]);
        foreach ($containerAttr as $attr) {
            $attType[] = $attr->getBackendType();
            $attId[] = $attr->getId();
            $query .= ', `pa_' . $attr->getBackendType() . '`.`value` as `' . $attr->getCode() . '`';
        }
        $attType = array_unique($attType);
        $attId = array_unique($attId);
        $query .= ' FROM `product_container` as `pc` ';
        foreach ($attType as $type) {
            $query .= "LEFT JOIN `product_attribute_" . $type . "` as `pa_" . $type . "` on `pa_" . $type . "`.`entity_id` = `pc`.`id` Where `pa_" . $type . "`.`type` = 'container' AND `pa_" . $type . "`.`attribute_id` IN  (" . implode(',', $attId) . ") ";
        }

        echo $query;
        die;
        foreach ($filterParams as $key => $value) {
            $query = "SELECT id FROM `" . $productAttrTable . "` WHERE `code`='" . $key . "'";
            $attribute = $sqlConfig->sqlRecords($query, "one");
            if (isset($attribute['id'])) {
                $isAttributeExist = true;
                $table = $productAttrTable . "_" . $attribute['backend_type'];
                $joinQuery[] = " LEFT JOIN `" . $table . "` `" . $table . "` ON `" . $productContainerTableAlias . "`.`id`=`" . $table . "`.`entity_id` OR `" . $productTableAlias . "`.`id`=`" . $table . "`.`entity_id`";
                $onCondition[] = "`" . $productAttrTableAlias . "`.`id`=`" . $table . "`.`attribute_id`";
                $conditions[] = "`code`='" . $key . "'";
            }
        }
        echo '<h1>Hello1121!</h1>';
    }

    public function testAction()
    {

        $migrationHelper = $this->di->getObjectManager()->get(\App\Connector\Components\Migration\Migration::class);
        $userId = "61d5827398530c1808770a44";
        //$shopData = $migrationHelper->start($userId, '1');
        // $setp = $migrationHelper->stepComplete($userId);
        // $plan = $migrationHelper->plan($userId);
        $moveProduct = $migrationHelper->editProductMove($userId);

        echo "<pre>";
        //print_r($shopData);
        die;


        //   $fvp = fopen(BP . DS . 'var' . DS . 'upload-report' . DS . 'bing' . DS . 'csv'. DS . 'test' . '.csv', 'w');
        //   fputcsv($fvp, ['SNo.', 'Report']);
        //   fclose($fvp);
        //   echo 'done';
        $product = [
            "count" => 10,
            "from" => [
                "shop_id" => "7"
            ],
            "to" => [
                "shop_id" => "2"
            ],
            "productOnly" => "true",
            "source_product_id" => [
                4597646655625
            ],
            "user_id" => "61e9058c11bd1940736da7a2"
        ];
        $objectManager = $this->di->getObjectManager();
        $helper = $objectManager->get('\App\Connector\Models\Product\Index');
        $res = $helper->getProducts($product);
        print_r($res);
        die();
        $product = [
            "sku" => "140439",
            "source_product_id" => "140439",
            "target_product_id" => "4546546",
            'any other details' => ' you want to add in container DB',
            "status" => [
                'status' => "error",
                'any other details' => ' you want to add in container DB'
            ],
        ];
        $objectManager = $this->di->getObjectManager();
        $helper = $objectManager->get('\App\Connector\Models\MarketplaceProduct');
        $res = $helper->createMarketplaceProduct([$product], 'mercado_cbt', 23, 4, "608920e62c89040c1c543822");
        print_r($res);
        die();
        //        // Resolve the service (NOTE: $myClass->setDi($di) is automatically called)
        //
        //        var_dump($this->di->getConfig());
        //        die;
        //        $config = $objectManager->create('\App\Core\Models\Config');
        //        var_dump($config->get('checking'));
        //        //$objectManager->get('\MyInterface')->createRoute();
        //        return 'test123';
    }


    public function test1Action()
    {
        $data = '{"services":[

            {
                "title":"Amazon Importer",
                "code":"amazon_importer",
                "type":"importer",
                "charge_type":"Prepaid",
                "required":0,
                "service_charge":"20",
                "prepaid":{
                    "service_credits":"20",
                    "validity_changes":"Replace",
                    "fixed_price":20,
                    "reset_credit_after":20,
                    "expiring_at":"20"
                },
                "postpaid":{
                    "per_unit_usage_price":"",
                    "capped_amount":""
                }
            },
            {
                "title":"Ebay Importer",
                "code":"ebay_importer",
                "type":"importer",
                "charge_type":"Prepaid",
                "required":"yes",
                "service_charge":"20",
                "prepaid":{
                    "service_credits":"20",
                    "validity_changes":"Replace",
                    "fixed_price":20,
                    "reset_credit_after":20,
                    "expiring_at":"20"
                },
                "postpaid":{
                    "per_unit_usage_price":"",
                    "capped_amount":""
                }
            }
        
        ]}';
        $data = json_decode($data);
        // Resolve the service (NOTE: $myClass->setDi($di) is automatically called)
        // $objectManager = $this->di->getObjectManager();
        $product = $this->di->getObjectManager()->get('\App\Shopify\Models\SourceModel')->initiateSync($userId = 69);
        //$objectManager->get('\MyInterface')->createRoute();
        return 'test1WAESDR3';
    }


    public function testprofileAction()
    {
        $data = '{
            "name":"Clothing",
            "query":"(type %LIKE% variation)",
            "category_id":"6030bfefe728c462780f2da2",
            "profile_id":"601a7910785aac6e81021bb2",
            "data":{
               "inventory_settings":{
                  "data_type":"template",
                  "id":"6017ff27940d874f856de7c6"
               }
            },
            "attributes_mapping":{
               "name":{
                  "type":"attribute",
                  "value":"title1"
               }
            },
            "targets":{
               "ebay":{
                  "skip_query":"(product_type %LIKE% OUTDOOR_LIVING)",
                  "data":{
                     "inventory_settings":{
                        "threshhold":44
                     }
                  },
                  "shops":{
                     "123":{
                        "shop_id":"123",
                        "warehouses":{
                           "321":{
                              "warehouse_id":"321",
                              "data":{
                                 "inventory_settings":{
                                    "threshhold":44
                                 }
                              },
                              "sources":{
                                 "587":{
                                    "data":{
                                       "inventory_settings":{
                                          "threshhold":42
                                       }
                                    },
                                    "shops":{
                                       "158":{
                                          "shop_id":"158",
                                          "warehouses":{
                                             "546":{
                                                "warehouse_id":"546",
                                                "data":{
                                                   "inventory_settings":{
                                                      "threshhold":47
                                                   }
                                                },
                                                            "attributes_mapping":{
                                                      "name":{
                                                         "type":"attribute",
                                                         "value":"title"
                                                      },
                                                      "brand":{
                                                         "type":"fixed",
                                                         "value":"levis"
                                                      },
                                                      "color":{
                                                         "type":"attribute_and_value",
                                                         "value":"colour",
                                                         "value_mapping":{
                                                            "Dark Red":"Red",
                                                            "Sky Blue":"Blue"
                                                         }
                                                      },
                                                      "clothingMaterial":{
                                                         "type":"rule",
                                                         "value":"applied rules"
                                                      }
                                                   }
                                             }
                                          }
                                       }
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }';

        $data = json_decode($data, true);

        $test = [];

        $test['profile_data'] = $data;
        $test['marketplace'] = 'ebay';
        $test['source_marketplace'] = 'shopify_vendor';

        $profileHelperObj = new Helper();
        $profileHelperObj->process_data = $test;
        // $profileHelperObj->source_marketplace = "shopify_vendor1";
        $response = $profileHelperObj->getMappedProduct();

        print_r($response);
        die;
    }


    public function checkUploadingAction()
    {
        //  die("chhc");
        $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
            ->init('shopify', 'true')
            ->call('/order', ['Response-Modifier' => '0'], ['id' => '4030333550768', 'shop_id' => '1139', 'fields' => 'id,name', 'status' => 'any'], 'GET');

        var_dump($remoteResponse);

        die("cjjc");
        $baseObj = new BaseMongo();
        $userCollections = $baseObj->getCollectionForTable('user_details');
        $allUser = $baseObj->findByField([]);
        $user_details = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');
        $target = 'shopify';
        $marketplace = $target;
        $appCode = "amazon_sales_channel";
        $installedUser = [];

        foreach ($allUser as $key => $value) {
            if (!empty($value['shops']) && isset($value['username']) && (strpos($value['username'], 'myshopify') !== false)) {
                $user_details_shopify = $user_details->getDataByUserID($value['user_id'], $target);

                $shopResponse = $this->di->getObjectManager()->get('\App\Connector\Components\ApiClient')->init($marketplace, true, $appCode)->call('/shop', [], [
                    'shop_id' => $user_details_shopify['remote_shop_id'],
                    'app_code' => $appCode
                ]);
                if ($shopResponse['success']) {
                    if (is_null($shopResponse['data'])) {
                        $installedUser[] = ['name' => $shopResponse['data']['name'], 'email' => $shopResponse['data']['email']];
                    }
                } else {
                }
            }
        }

        var_dump(json_encode($installedUser));

        die("vchvhhv");


        $inventoryComponent = $this->di->getObjectManager()->get('\App\Amazon\Components\Product\InventoryWebhook');
        $userId = '612259c05926ff021922baa8';
        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $productContainer = $mongo->getCollectionForTable('product_container');
        $inventoryItemId = '1230';

        //  $product = $productContainer->findOne(['match'=>['inventory_item_id'=>$inventoryItemId,'user_id'=>$this->di->getUser()->id,'marketplace.amazon.status'=>['$in'=>['Active','Inactive','Incomplete','Uploaded']]]]);
        /*   print_r(json_encode(['$match'=>['inventory_item_id'=>$inventoryItemId,'user_id'=>$userId,'marketplace.amazon.status'=>['$in'=>['Active','Inactive','Incomplete','Uploaded']]]]));die;

              die("cjj");*/

        $product = $productContainer->aggregate([['$match' => ['inventory_item_id' => $inventoryItemId, 'user_id' => $userId, 'marketplace.amazon.status' => ['$in' => ['Active', 'Inactive', 'Incomplete', 'Uploaded']]]]], ['typeMap' => ['root' => 'array', 'document' => 'array']]);
        $product = $product->toArray();

        var_dump($product);
        die;

        $query = [];
        $query[] = ['$match' => ['user_id' => $userId, 'marketplace.amazon.status' => ['$exists' => true], 'quantity' => ['$exists' => true]]];
        $query[] = ['$match' => ['marketplace.amazon.status' => 'Active']];

        // $query[] = ['$match'=>['user_id' =>$userId]];
        $productData = $productCollection->aggregate($query, ['typeMap' => ['root' => 'array', 'document' => 'array']]);
        $productData = $productData->toArray();

        $chunkData = array_chunk($productData, 25);
        echo "start process";
        echo PHP_EOL;
        foreach ($chunkData as $key => $product) {
            echo "inloop process";
            echo PHP_EOL;
            echo $key;
            echo PHP_EOL;
            $sourceProductIds = [];

            foreach ($product as $key => $value) {
                echo PHP_EOL;
                $sourceProductIds['source_product_ids'][] = $value['source_product_id'];
            }

            $return = $inventoryComponent->init(['user_id' => $userId])->updateNew($sourceProductIds);

            echo "innerloop process";
            echo PHP_EOL;
            sleep(2);
        }
        die("chhv");

        /* die("cjjvv");

              $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
              $userCollections = $mongo->getCollectionForTable('user_details');

              $userData = $userCollections->find([], ['typeMap'=>['root'=> 'array', 'document' => 'array']]);
              $userDatas =  $userData->toArray();
              $awsConfig = include_once(BP . DS . 'app' . DS . 'etc' . DS . 'aws.php');*/

        // var_dump($awsConfig);die;
        /*
              foreach ($userDatas as $key => $userData) {
                if(!empty($userData['shops']) && isset($userData['shops'][1]))
                {
                  $target = $this->di->getObjectManager()->get('\App\Shopifyhome\Components\Shop\Shop')->getUserMarkeplace();
                  $userId = $userData['user_id'];

                  $user_details = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');
                  $user_details = $user_details->getDataByUserID($userId, $target);
                  if($user_details['remote_shop_id'] == '54')
                  {
                    $sqsConfig = [
                      'region' => $awsConfig['region'],
                      'key' => $awsConfig['credentials']['key'],
                      'secret' => $awsConfig['credentials']['secret']
                  ];

                  $handlerData = [
                      'type' => 'full_class',
                      'class_name' => '\App\Shopifyhome\Components\Webhook\Route\Requestcontrol',
                      'method' => 'registerWebhooks',
                      'queue_name' => 'shopify_register_webhook',
                      'user_id' => $userId,
                      'data' => [
                          'user_id' => $userId,
                          'remote_shop_id' => $user_details['remote_shop_id'],
                          'sqs' => $sqsConfig,
                          'cursor' => 0,
                          'source' => 'amazon_sales_channel',
                          'target' => $target
                      ]
                  ];
                  $rmqHelper = $this->di->getObjectManager()->get('\App\Rmq\Components\Helper');
                  $queueNo = $rmqHelper->createQueue($handlerData['queue_name'], $handlerData);
                  die("cjjc");

                  }*/

        /*$sqsConfig = [
                      'region' => $awsConfig['region'],
                      'key' => $awsConfig['credentials']['key'],
                      'secret' => $awsConfig['credentials']['secret']
                  ];

                  $handlerData = [
                      'type' => 'full_class',
                      'class_name' => '\App\Shopifyhome\Components\Webhook\Route\Requestcontrol',
                      'method' => 'registerWebhooks',
                      'queue_name' => 'shopify_register_webhook',
                      'user_id' => $userId,
                      'data' => [
                          'user_id' => $userId,
                          'remote_shop_id' => $user_details['remote_shop_id'],
                          'sqs' => $sqsConfig,
                          'cursor' => 0,
                          'source' => 'amazon_sales_channel',
                          'target' => $target
                      ]
                  ];
                  $rmqHelper = $this->di->getObjectManager()->get('\App\Rmq\Components\Helper');
                  $queueNo = $rmqHelper->createQueue($handlerData['queue_name'], $handlerData);*/

        // var_dump($queueNo,$handlerData);die;


        /*       }
              }


              die("cvjvj");*/

        /* $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                      ->init('shopify', 'true')
                      ->call('/order',['Response-Modifier'=>'0'],['shop_id'=>'178','fields'=>'id,name','status'=>'any'], 'GET');
                      var_dump($remoteResponse);die;*/


        $orderJson = '/var/www/invalidOrderWithAmazonOrderId.json';
        $orderDatas = json_decode(file_get_contents($orderJson), true);
        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $userCollections = $mongo->getCollectionForTable('user_details');

        $orderFile = '/var/www/order.json';

        $satyaSirdatas = json_decode(file_get_contents($orderFile), true);

        /*    $page = $this->request->get()['page'];
              $limit = 2;
              $lower = $limit * (int)$page;
              $uper =  $lower+$limit;
              $counter = 0;*/

        $needToWork = [];
        foreach ($satyaSirdatas as $key => $satyaSirdata) {
            if (isset($orderDatas[$satyaSirdata['order_id']])) {
                $customers = $satyaSirdata['customers'];
                $userId = $orderDatas[$satyaSirdata['order_id']]['user_id'];
                unset($customers[$userId]);

                $needToWork[$orderDatas[$satyaSirdata['order_id']]['shopifyId']] = $customers;
            }
        }
        $remoteShopIds = [];
        $deleteUserFound = [];

        //var_dump($needToWork);die;


        foreach ($needToWork as $orderId => $customers) {
            /*        if($lower>$counter)
                    {
                      $counter++;
                      continue;
                    }
                    if($uper<$counter)
                    {
                      $counter++;
                      continue;
                    }*/
            foreach ($customers as $customer => $attempt) {
                $remote_shop_id = 0;

                if (!isset($remoteShopIds[$customer])) {
                    $userData = $userCollections->findOne(['user_id' => $customer], ['typeMap' => ['root' => 'array', 'document' => 'array']]);

                    if ($userData) {

                        $remoteShopIds[$customer] = $userData['shops'][0]['remote_shop_id'];
                        $remote_shop_id = $remoteShopIds[$customer];
                    }
                } else {
                    $remote_shop_id = $remoteShopIds[$customer];
                }

                $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                    ->init('shopify', 'true')
                    ->call('/order', ['Response-Modifier' => '0'], ['id' => $orderId, 'shop_id' => $remote_shop_id, 'fields' => 'id,name', 'status' => 'any'], 'DELETE');

                var_dump($remoteResponse);

                if ($remoteResponse && $remoteResponse['success']) {
                    $deleteUserFound[$customer][] = $orderId;
                }
                sleep(2);
            }

            die;
        }
        var_dump($deleteUserFound);
        die;

        die("out");


        /*$orderJson = '/var/www/invalidOrderWithAmazonOrderId.json';
              $orderDatas = json_decode(file_get_contents($orderJson),true);
              $remoteShopIds = [];
              $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');

              $userCollections = $mongo->getCollectionForTable('user_details');
              $collection = $mongo->getCollectionForTable('order_container');
              $userWiseData = [];

               foreach ($orderDatas as $amazonOrderId => $orderData) {
                  $userWiseData[$orderData['user_id']][] = $orderData;
               }

               foreach ($userWiseData as $userId => $allData) {
                  if(!isset($remoteShopIds[$userId]))
                  {
                    $userData = $userCollections->findOne(['user_id'=>$userId], ['typeMap'=>['root'=> 'array', 'document' => 'array']]);

                    if($userData)
                    {
                      $userWiseData[$userId]['shop'] = $userData['username'];

                      $remoteShopIds[$userId] = $userData['shops'][0]['remote_shop_id'];
                      $remote_shop_id = $remoteShopIds[$userId];
                    }
                  } else {
                    $remote_shop_id = $remoteShopIds[$userId];
                  }
                  $orderIds = [];

                  foreach ($allData as $key => $singleData) {
                    $orderIds[] = $singleData['shopifyId'];
                    $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                      ->init('shopify', 'true')
                      ->call('/order',['Response-Modifier'=>'0'],['id'=>$singleData['shopifyId'],'shop_id'=>$remote_shop_id,'fields'=>'id,name','status'=>'any'], 'GET');
                    if(!$remoteResponse['success'])
                    {
                      $unset = ['$unset'=>['target_status'=>1,
                          'target_order_id'=>1,
                          'shopify_order_name'=>1,
                          'imported_at'=>1,
                          'target_error_message'=>1,
                          'target_errors'=>1,
                          'target_order_data'=>1]];
                      $res = $collection->updateOne(['source_order_id'=>$singleData['amazon_order_id']],$unset);


                    }

                  }
               }*/

        var_dump(json_encode($userWiseData));
        die;


        var_dump($userWiseData);
        die;


        /*    foreach ($orderDatas as $amazonOrderId => $orderData) {
                $shopifyOrderId = $orderData['shopifyId'];
                $userId = $orderData['user_id'];
                $remote_shop_id = 0;
                if(!isset($remoteShopIds[$userId]))
                {
                  $userData = $userCollections->findOne(['user_id'=>$userId], ['typeMap'=>['root'=> 'array', 'document' => 'array']]);

                  if($userData)
                  {
                    $remoteShopIds[$userId] = $userData['shops'][0]['remote_shop_id'];
                    $remote_shop_id = $remoteShopIds[$userId];
                  }
                } else {
                  $remote_shop_id = $remoteShopIds[$userId];
                }

                $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                  ->init('shopify', 'true')
                  ->call('/order',['Response-Modifier'=>'0'],['id'=>$shopifyOrderId,'shop_id'=>$remote_shop_id,'sales_channel'=>0,'fields'=>'id,name'], 'GET');


                if($remoteResponse && $remoteResponse['success'] && !empty($remoteResponse['data']))
                {
                  if(isset($remoteResponse['data']['id']))
                  {

                  } else {
                    $collection->deleteOne(['source_order_id'=>$amazonOrderId]);
                  }

                } else {
                  if(!$remoteResponse['success'])
                  {
                    $collection->deleteOne(['source_order_id'=>$amazonOrderId]);
                  }
                }
              }
              die("cjjcj");*/

        /*    $orderJson = '/var/www/invalidOrders.json';
              $orderDatas = json_decode(file_get_contents($orderJson),true);
              $orderDatas = array_values($orderDatas);

              $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
              $collection = $mongo->getCollectionForTable('order_container');

              $orderChunk = array_chunk($orderDatas, 100);
              $dataWithAmazonOrderId = [];

              foreach ($orderChunk as $key => $targetOrderIds)
              {
                $query = [];
                $query[] = ['$match'=>['target_order_id' =>['$in'=>$targetOrderIds]]];
                $getOrders = $collection->aggregate($query, ['typeMap'=>['root'=> 'array', 'document' => 'array']]);
                if(!empty($getOrders))
                {
                  $getOrders = $getOrders->toArray();
                  foreach ($getOrders as $key => $getOrder) {
                    $dataWithAmazonOrderId[$getOrder['source_order_id']] = ['amazon_order_id'=>$getOrder['source_order_id'],'shopifyId'=>$getOrder['target_order_id'],'user_id'=>$getOrder['user_id'],'imported_at'=>$getOrder['imported_at']];
                  }
                }
              }*/

        print_r(json_encode($dataWithAmazonOrderId));
        die;


        /*$orderJson = '/var/www/orders-shopify.json';
                $orderDatas = json_decode(file_get_contents($orderJson),true);
                $needToWork = [];
                $fetchedData = $orderDatas;
                $neetNotWork = [];
                $allShopifyIds = [];

                foreach ($orderDatas as $remote_shop_id => $orderData) {
                  $orderchunk = array_chunk($orderData, 50);


                  foreach ($orderchunk as $key => $allIds) {
                    $orderIds = implode(',', $allIds);
                    $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                    ->init('shopify', 'true')
                    ->call('/order',['Response-Modifier'=>'0'],['ids'=>$orderIds,'shop_id'=>$remote_shop_id,'fields'=>'id,name','status'=>'any'], 'GET');

                    if($remoteResponse && $remoteResponse['success'] && $remoteResponse['data'] && !empty($remoteResponse['data']['orders']))
                    {
                      foreach ($remoteResponse['data']['orders'] as $key => $shopifyOrder) {
                          if(in_array($shopifyOrder['id'], $fetchedData[$remote_shop_id]))
                          {
                            $neetNotWork[$remote_shop_id][] = $shopifyOrder['id'];

                          } else
                          {
                            $needToWork[$remote_shop_id][] = $shopifyOrder['id'];
                            $allShopifyIds[$shopifyOrder['id']] = $shopifyOrder['id'];
                          }
                      }

                    } else {
                      if($remoteResponse['success'])
                      {
                       foreach ($allIds as $key => $id) {
                         $allShopifyIds[$id] = $id;
                       }
                        $needToWork[$remote_shop_id][] = $allIds;
                      }

                    }

                  }*/

        /*    $orderIds = implode(',', $orderData);


                  $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                  ->init('shopify', 'true')
                  ->call('/order',['Response-Modifier'=>'0'],['ids'=>$orderIds,'shop_id'=>$remote_shop_id,'sales_channel'=>0,'fields'=>'id,name'], 'GET');


                  if($remoteResponse && $remoteResponse['success'] && $remoteResponse['data'] && !empty($remoteResponse['data']['orders']))
                  {
                    foreach ($remoteResponse['data']['orders'] as $key => $shopifyOrder) {
                        if(in_array($shopifyOrder['id'], $fetchedData[$remote_shop_id]))
                        {
                          $neetNotWork[$remote_shop_id][] = $shopifyOrder['id'];

                        } else
                        {
                          $needToWork[$remote_shop_id][] = $shopifyOrder['id'];
                        }
                    }

                  } else {
                    $needToWork[$remote_shop_id][] = $orderData;
                  }*/

        /* }
                var_dump(count($allShopifyIds),json_encode($allShopifyIds));
                die("jjvjvj");*/


        /*    $orderJson = '/var/www/order.json';
              $orderData = json_decode(file_get_contents($orderJson),true);

              $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
              $userCollections = $mongo->getCollectionForTable('user_details');
              $collection = $mongo->getCollectionForTable('order_container');
              $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
              $count = 1;
              $ncout = 1;
              $notFoundOrder = [];
              $commonHelper = $this->di->getObjectManager()->get('App\Amazon\Components\Common\Helper');
              $page = $this->request->get()['page'];
              $limit = 1000;
              $lower = $limit * (int)$page;
              $uper =  $lower+$limit;
              $orderNeedToWork = [];

              $orderIds = [];
              $userIds = [];

              foreach ($orderData as $key => $value) {
                if($lower>$key)
                {
                  continue;
                }
                if($uper<$key)
                {
                  continue;
                }
                $orderIds[] = $value['order_id'];
              }
              $query[] = ['$match'=>['source_order_id' =>['$in'=>$orderIds]]];
              $getOrders = $collection->aggregate($query, ['typeMap'=>['root'=> 'array', 'document' => 'array']]);

              if(!empty($getOrders))
              {
                $getOrders = $getOrders->toArray();
                foreach ($getOrders as $key => $getOrder) {
                  $userIds[] = $getOrder['user_id'];
                }


                $userQuery[] = ['$match'=>['user_id' =>['$in'=>$userIds]]];
                $allUsers = $userCollections->aggregate($userQuery, ['typeMap'=>['root'=> 'array', 'document' => 'array']]);

                if(!empty($allUsers))
                {
                  $allUsers = $allUsers->toArray();
                  $userWiseData = [];
                  foreach ($allUsers as $key => $value) {
                    $userWiseData[$value['user_id']] = $value;
                  }
                }

                foreach ($getOrders as $key => $getOrder) {
                  $remoteShopId = 0;
                  $allUsers[] = $getOrder['user_id'];

                  if(isset($getOrder['target_order_id']))
                  {

                    $userData = $userCollections->findOne(['user_id'=>$getOrder['user_id']],$options);
                    if(isset($userWiseData,$userWiseData[$getOrder['user_id']]))
                    {
                      $shops = $userWiseData[$getOrder['user_id']]['shops'];
                        foreach ($shops as $key => $userVal) {
                            if(!$key)
                            {
                              $remoteShopId = $userVal['remote_shop_id'];
                            }
                          if($userVal['_id'] == $getOrder['shop_id'])
                          {

                          }
                        }
                    }

                    if($remoteShopId)
                    {
                      $params = [
                      'shop_id' => $remoteShopId,
                      'amazon_order_id' => $getOrder['source_order_id'],
                      'home_shop_id' => $getOrder['shop_id']
                      ];
                      $orderNeedToWork[$remoteShopId][] = $getOrder['target_order_id'];

                    } else {
                      die("jjvjv");

                      $orderNeedToWork[] = $getOrder['source_order_id'];
                    }

                  }
                }

              }
              var_dump(count($orderNeedToWork),json_encode($orderNeedToWork));*/


        /*$content = file_get_contents('/var/www/orders-make.json');

              $getDatas = json_decode($content,true);*/


        /*      $dynamoData = [];
              $counter = 1000;

              foreach ($getDatas as $remote_shop_id => $getData) {
                foreach ($getData as $key => $value) {
                  $counter++;
                  $dynamoData[] = [
                    'amazon_order_id'=>$value,
                    'remote_shop_id'=> (string)$remote_shop_id,
                    'id'=>(string) $counter,
                    'iserror'=>'3'
                  ];
                }
              }
              $dynamoData = array_chunk($dynamoData, 24);
              foreach ($dynamoData as $key => $data) {
               // var_dump($data);die;

                $dynamoObj = $this->di->getObjectManager()->get(Dynamo::class);
                $dynamoObj->setTable('order_dublicate');
                $dynamoObj->setUniqueKeys(['id']);
                $dynamoObj->setTableUniqueColumn('id');
                $res = $dynamoObj->save($data);
              }*/

        die("cjjcj");
        /*filter from amazon*/

        /*      $orderJson = '/var/www/order.json';
              $orderData = json_decode(file_get_contents($orderJson),true);

              $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
              $userCollections = $mongo->getCollectionForTable('user_details');
              $collection = $mongo->getCollectionForTable('order_container');
              $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
              $count = 1;
              $ncout = 1;
              $notFoundOrder = [];
              $commonHelper = $this->di->getObjectManager()->get('App\Amazon\Components\Common\Helper');
              $page = $this->request->get()['page'];
              $limit = 1000;
              $lower = $limit * (int)$page;
              $uper =  $lower+$limit;
              $orderNeedToWork = [];
             // var_dump($lower,$uper);die;
              $orderIds = [];
              $userIds = [];

              foreach ($orderData as $key => $value) {
                if($lower>$key)
                {
                  continue;
                }
                if($uper<$key)
                {
                  continue;
                }
                $orderIds[] = $value['order_id'];
              }
              $query[] = ['$match'=>['source_order_id' =>['$in'=>$orderIds]]];
              $getOrders = $collection->aggregate($query, ['typeMap'=>['root'=> 'array', 'document' => 'array']]);

              if(!empty($getOrders))
              {
                $getOrders = $getOrders->toArray();
                foreach ($getOrders as $key => $getOrder) {
                  $userIds[] = $getOrder['user_id'];
                }


                $userQuery[] = ['$match'=>['user_id' =>['$in'=>$userIds]]];
                $allUsers = $userCollections->aggregate($userQuery, ['typeMap'=>['root'=> 'array', 'document' => 'array']]);

                if(!empty($allUsers))
                {
                  $allUsers = $allUsers->toArray();
                  $userWiseData = [];
                  foreach ($allUsers as $key => $value) {
                    $userWiseData[$value['user_id']] = $value;
                  }
                }

                foreach ($getOrders as $key => $getOrder) {
                  $remoteShopId = 0;
                  $allUsers[] = $getOrder['user_id'];

                  if(isset($getOrder['target_order_id']))
                  {

                    $userData = $userCollections->findOne(['user_id'=>$getOrder['user_id']],$options);
                    if(isset($userWiseData,$userWiseData[$getOrder['user_id']]))
                    {
                      $shops = $userWiseData[$getOrder['user_id']]['shops'];
                        foreach ($shops as $key => $userVal) {
                            if(!$key)
                            {
                              continue;
                            }
                          if($userVal['_id'] == $getOrder['shop_id'])
                          {
                              $remoteShopId = $userVal['remote_shop_id'];
                          }
                        }
                    }

                    if($remoteShopId)
                    {
                      $params = [
                      'shop_id' => $remoteShopId,
                      'amazon_order_id' => $getOrder['source_order_id'],
                      'home_shop_id' => $getOrder['shop_id']
                      ];
                      $orderNeedToWork[$remoteShopId][] = $getOrder['source_order_id'];

                    } else {
                      die("jjvjv");

                      $orderNeedToWork[] = $getOrder['source_order_id'];
                    }

                  }
                }

              }
              var_dump(count($orderNeedToWork),json_encode($orderNeedToWork));*/
        /*filter from amazon done*/

        die("done");

        $params = [
            'imported_at' => ['$gte' => '2021-08-05T01:54:33-04:00']
        ];
        $orderData = $collection->find($params, ['projection' => ['_id' => 0, 'source_order_id' => 1]])->toArray();

        $logFile = "amazon/test/" . date('d-m-Y') . '.log';

        $this->di->getLog()->logContent('orderData : ' . json_encode($orderData), 'info', $logFile);
        die;


        die("need to remove die");
        $baseObj = new BaseMongo();
        $userCollections = $baseObj->getCollectionForTable('user_details');
        $allUser = $baseObj->findByField([]);
        $user_details = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');
        $target = 'shopify';
        $marketplace = $target;
        $appCode = "amazon_sales_channel";

        foreach ($allUser as $key => $value) {
            if (!empty($value['shops']) && isset($value['username']) && (strpos($value['username'], 'myshopify') !== false)) {
                $user_details_shopify = $user_details->getDataByUserID($value['user_id'], $target);

                $shopResponse = $this->di->getObjectManager()->get('\App\Connector\Components\ApiClient')->init($marketplace, true, $appCode)->call('/shop', [], [
                    'shop_id' => $user_details_shopify['remote_shop_id'],
                    'app_code' => $appCode
                ]);
                if ($shopResponse['success']) {
                    if (is_null($shopResponse['data'])) {
                        print_r($value['username']);

                        $user_id = $value['user_id'];

                        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
                        $collection = $mongo->getCollectionForTable('uninstalled_user');
                        $exists = $mongo->loadByField([
                            "user_id" => $user_id,
                        ]);

                        if ($exists) {
                            //$collection->updateOne(['user_id'=>$user_id],[]);
                        } else {
                            $collection->insertOne($value);
                        }

                        $collection = $mongo->getCollectionForTable('product_container');
                        $collection->deleteMany(['user_id' => (string)$user_id]);

                        $collection = $mongo->getCollectionForTable('amazon_product_container');
                        $collection->deleteMany(['user_id' => (string)$user_id]);

                        $collection = $mongo->getCollectionForTable('configuration');
                        $collection->deleteMany(['user_id' => (string)$user_id]);

                        $collection = $mongo->getCollectionForTable('profiles');
                        $collection->deleteMany(['user_id' => (string)$user_id]);

                        $collection = $mongo->getCollectionForTable('profile_settings');
                        $collection->deleteMany(['merchant_id' => (string)$user_id]);

                        $collection = $mongo->getCollectionForTable('amazon_listing');
                        $collection->deleteMany(['user_id' => (string)$user_id]);

                        $collection = $mongo->getCollectionForTable('user_details');
                        $collection->deleteOne(['user_id' => (string)$user_id]);

                        $responseWbhook = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                            ->init($target, 'true')
                            ->call("/webhook/unregister", [], ['shop_id' => $user_details_shopify['remote_shop_id']], 'DELETE');
                        print_r($responseWbhook);
                        echo "<br>";
                        $target = $this->di->getObjectManager()->get('\App\Shopifyhome\Components\Shop\Shop')->getUserMarkeplace();
                        $shopifyUninstall = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                            ->init($target, 'true')
                            ->call('app-shop', [], ['shop_id' => $user_details_shopify['remote_shop_id']], 'DELETE');

                        print_r($shopifyUninstall);
                        echo "<br>";
                    }
                } else {
                    print_r($shopResponse);
                    die;
                }
            }
        }

        die("vchvhhv");


        $jsonData = '[ { "Date": "2021-06-24 17:21:33 UTC", "Shop domain": "the-village-country-store.myshopify.com" }, { "Date": "2021-06-24 19:52:16 UTC", "Shop domain": "the-southern-magnolia-too.myshopify.com" }, { "Date": "2021-06-24 20:22:04 UTC", "Shop domain": "ticoroasters.myshopify.com" }, { "Date": "2021-06-24 22:12:27 UTC", "Shop domain": "oh-boy-records.myshopify.com" }, { "Date": "2021-06-25 01:16:43 UTC", "Shop domain": "empiremotor.myshopify.com" }, { "Date": "2021-06-25 01:48:13 UTC", "Shop domain": "nomad-discoveries.myshopify.com" }, { "Date": "2021-06-25 13:15:51 UTC", "Shop domain": "unminced-words.myshopify.com" }, { "Date": "2021-06-25 16:23:14 UTC", "Shop domain": "ticoroasters.myshopify.com" }, { "Date": "2021-06-27 03:49:52 UTC", "Shop domain": "marlyn-boutique-llc.myshopify.com" }, { "Date": "2021-06-27 18:21:19 UTC", "Shop domain": "ms-ms-plus-size-shop.myshopify.com" }, { "Date": "2021-06-28 04:11:43 UTC", "Shop domain": "sarahlewisjewelrycom.myshopify.com" }, { "Date": "2021-06-28 13:30:59 UTC", "Shop domain": "shoxtec-suspension.myshopify.com" }, { "Date": "2021-06-29 08:26:04 UTC", "Shop domain": "sockball.myshopify.com" }, { "Date": "2021-06-29 15:59:36 UTC", "Shop domain": "muratis-studios.myshopify.com" }, { "Date": "2021-06-29 18:22:27 UTC", "Shop domain": "ms-ms-plus-size-shop.myshopify.com" }, { "Date": "2021-06-29 21:11:15 UTC", "Shop domain": "love-to-hold-gift-store.myshopify.com" }, { "Date": "2021-06-30 06:00:02 UTC", "Shop domain": "sumairabass.myshopify.com" }, { "Date": "2021-07-04 20:35:30 UTC", "Shop domain": "dragons-den-collectibles.myshopify.com" }, { "Date": "2021-07-04 21:03:50 UTC", "Shop domain": "pivag-multi-trade.myshopify.com" }, { "Date": "2021-07-04 21:26:14 UTC", "Shop domain": "dragons-den-collectibles.myshopify.com" }, { "Date": "2021-07-05 15:35:27 UTC", "Shop domain": "bunker27.myshopify.com" }, { "Date": "2021-07-06 20:55:13 UTC", "Shop domain": "truff-hot-sauce.myshopify.com" }, { "Date": "2021-07-07 19:59:41 UTC", "Shop domain": "the-shoppe-depot.myshopify.com" }, { "Date": "2021-07-07 23:28:30 UTC", "Shop domain": "marlyn-boutique-llc.myshopify.com" }, { "Date": "2021-07-08 01:16:12 UTC", "Shop domain": "the-shoppe-depot.myshopify.com" }, { "Date": "2021-07-08 13:58:56 UTC", "Shop domain": "joepauls.myshopify.com" }, { "Date": "2021-07-08 16:39:44 UTC", "Shop domain": "shirtnado.myshopify.com" }, { "Date": "2021-07-08 17:03:11 UTC", "Shop domain": "stoneweardesigns.myshopify.com" }, { "Date": "2021-07-08 18:40:40 UTC", "Shop domain": "mikescooltest.myshopify.com" }, { "Date": "2021-07-08 19:37:45 UTC", "Shop domain": "cardboard-memories-inc.myshopify.com" }, { "Date": "2021-07-08 20:03:29 UTC", "Shop domain": "cellcynergy-nutrition.myshopify.com" }, { "Date": "2021-07-09 10:18:38 UTC", "Shop domain": "crossnet-game.myshopify.com" }, { "Date": "2021-07-09 17:42:15 UTC", "Shop domain": "prep-obsessed.myshopify.com" }, { "Date": "2021-07-09 21:04:18 UTC", "Shop domain": "lubelifeca.myshopify.com" }, { "Date": "2021-07-10 14:48:42 UTC", "Shop domain": "jickles-and-co.myshopify.com" }, { "Date": "2021-07-10 17:47:22 UTC", "Shop domain": "florida-state-line.myshopify.com" }, { "Date": "2021-07-11 13:09:52 UTC", "Shop domain": "shrunken-head.myshopify.com" }, { "Date": "2021-07-11 19:53:57 UTC", "Shop domain": "black-alpha-supplements-usa.myshopify.com" }, { "Date": "2021-07-11 21:19:25 UTC", "Shop domain": "thebossybrowshop.myshopify.com" }, { "Date": "2021-07-11 21:51:40 UTC", "Shop domain": "thebossybrowshop.myshopify.com" }, { "Date": "2021-07-12 10:35:10 UTC", "Shop domain": "onsalebeauty.myshopify.com" }, { "Date": "2021-07-12 15:48:18 UTC", "Shop domain": "mythicplasmaart.myshopify.com" }, { "Date": "2021-07-12 16:08:03 UTC", "Shop domain": "best-phone-band.myshopify.com" }, { "Date": "2021-07-12 16:14:40 UTC", "Shop domain": "umbrella-games.myshopify.com" }, { "Date": "2021-07-12 18:09:08 UTC", "Shop domain": "shop-ilusion.myshopify.com" }, { "Date": "2021-07-12 19:25:42 UTC", "Shop domain": "mintandlily.myshopify.com" }, { "Date": "2021-07-12 21:27:31 UTC", "Shop domain": "babyo-clothing-co.myshopify.com" }, { "Date": "2021-07-12 22:18:50 UTC", "Shop domain": "flavortoothpicks.myshopify.com" }, { "Date": "2021-07-12 23:03:58 UTC", "Shop domain": "juice-krate-shop.myshopify.com" }, { "Date": "2021-07-12 23:07:24 UTC", "Shop domain": "bamboo-little-shop.myshopify.com" }, { "Date": "2021-07-12 23:34:50 UTC", "Shop domain": "litt-ind.myshopify.com" }, { "Date": "2021-07-12 23:58:27 UTC", "Shop domain": "tkb-trading-llc.myshopify.com" }, { "Date": "2021-07-13 02:59:22 UTC", "Shop domain": "vent-works.myshopify.com" }, { "Date": "2021-07-13 03:04:04 UTC", "Shop domain": "madoorablecreations.myshopify.com" }, { "Date": "2021-07-13 12:14:43 UTC", "Shop domain": "gallery57wallart.myshopify.com" }, { "Date": "2021-07-13 14:17:57 UTC", "Shop domain": "new-york-puzzle-company.myshopify.com" }, { "Date": "2021-07-13 16:03:10 UTC", "Shop domain": "iaad.myshopify.com" }, { "Date": "2021-07-13 16:50:27 UTC", "Shop domain": "fat-kitty-designs.myshopify.com" }, { "Date": "2021-07-13 16:59:04 UTC", "Shop domain": "bohica-pepper-hut-2.myshopify.com" }, { "Date": "2021-07-13 17:00:37 UTC", "Shop domain": "kavu-hq.myshopify.com" }, { "Date": "2021-07-13 17:29:00 UTC", "Shop domain": "nashua-nutrition.myshopify.com" }, { "Date": "2021-07-13 17:50:52 UTC", "Shop domain": "anchoring-com.myshopify.com" }, { "Date": "2021-07-13 18:56:24 UTC", "Shop domain": "thapparel.myshopify.com" }, { "Date": "2021-07-13 23:10:36 UTC", "Shop domain": "refurbishedpro.myshopify.com" }, { "Date": "2021-07-14 07:32:47 UTC", "Shop domain": "bestforlessdrugtest.myshopify.com" }, { "Date": "2021-07-14 12:23:41 UTC", "Shop domain": "cedar-creek-rv-outdoor-center.myshopify.com" }, { "Date": "2021-07-14 14:43:40 UTC", "Shop domain": "skinperfectionnaturalandorganicskincare.myshopify.com" }, { "Date": "2021-07-14 16:45:05 UTC", "Shop domain": "hotleathers.myshopify.com" }, { "Date": "2021-07-14 17:44:30 UTC", "Shop domain": "loon-raccoon.myshopify.com" }, { "Date": "2021-07-14 18:00:14 UTC", "Shop domain": "carobou.myshopify.com" }, { "Date": "2021-07-15 01:48:32 UTC", "Shop domain": "your-auto-gear.myshopify.com" }, { "Date": "2021-07-15 15:14:35 UTC", "Shop domain": "dirty-hooker.myshopify.com" }, { "Date": "2021-07-15 18:47:28 UTC", "Shop domain": "modernboatsalesnadservice.myshopify.com" }, { "Date": "2021-07-15 20:26:34 UTC", "Shop domain": "destira-leotards.myshopify.com" }, { "Date": "2021-07-15 23:53:00 UTC", "Shop domain": "pack-simply.myshopify.com" }, { "Date": "2021-07-16 17:22:29 UTC", "Shop domain": "konnextixn.myshopify.com" }, { "Date": "2021-07-16 17:39:43 UTC", "Shop domain": "honeycat-jewelry.myshopify.com" }, { "Date": "2021-07-16 18:27:24 UTC", "Shop domain": "chez-shay-studio.myshopify.com" }, { "Date": "2021-07-17 05:03:40 UTC", "Shop domain": "tucannamerica.myshopify.com" }, { "Date": "2021-07-17 17:52:02 UTC", "Shop domain": "kriszbella.myshopify.com" }, { "Date": "2021-07-17 19:28:25 UTC", "Shop domain": "infinitec-store.myshopify.com" }, { "Date": "2021-07-19 01:34:54 UTC", "Shop domain": "ecotimelife.myshopify.com" }, { "Date": "2021-07-20 00:24:09 UTC", "Shop domain": "black-alpha-supplements-usa.myshopify.com" }, { "Date": "2021-07-20 11:33:02 UTC", "Shop domain": "giftsandmorebylinny.myshopify.com" }, { "Date": "2021-07-20 12:47:41 UTC", "Shop domain": "temey.myshopify.com" }, { "Date": "2021-07-20 15:15:50 UTC", "Shop domain": "bronxxotica.myshopify.com" }, { "Date": "2021-07-20 20:40:42 UTC", "Shop domain": "black-alpha-supplements-usa.myshopify.com" }, { "Date": "2021-07-21 18:50:25 UTC", "Shop domain": "lucky-ames-shop.myshopify.com" }, { "Date": "2021-07-21 23:38:18 UTC", "Shop domain": "srb-products-inc.myshopify.com" }, { "Date": "2021-07-22 00:22:11 UTC", "Shop domain": "bronxxotica.myshopify.com" } ]';

        $array = json_decode($jsonData, true);
        $baseObj = new BaseMongo();

        $userCollections = $baseObj->getCollectionForTable('user_details');
        foreach ($array as $key => $value) {
            $timeStamp = (new \DateTime($value['Date']))->getTimeStamp();
            $newDate = new \MongoDB\BSON\UTCDateTime($timeStamp * 1000);
            $shopName = $value['Shop domain'];
            $userCollections->updateOne(['username' => $shopName], ['$push' => ['created_at' => $newDate, 'shops.0.created_at' => $newDate, 'shops.0.updated_at' => $newDate, 'shops.1.created_at' => $newDate, 'shops.1.updated_at' => $newDate]]);
            print_r($shopName);
            die;
        }
        $timeStamp = (new \DateTime('2021-06-24 17:21:33 UTC'))->getTimeStamp();
        $newDate = new \MongoDB\BSON\UTCDateTime($timeStamp * 1000);
        print_r($value);
        die;


        $dynamoObj = $this->di->getObjectManager()->get('App\Connector\Components\Dynamo');
        $dynamoObj->setTable('amazon_inventory_mgmt');

        $feedContent = [];
        /*      $feedContent['123'] = [
                        'home_shop_id' =>'8',
                        'marketplace_id' => '10',
                        'shop_id' => '8',
                        'source_product_id'=>'123',
                        'feedContent' => json_encode([
                          'Id' => 123,
                          'SKU' => 'abc',
                          'Quantity' =>1,
                          'Latency' => 1
                        ])
              ];*/
        /*      $feedContent['123'] = [
                        'home_shop_id' =>'8',
                        'marketplace_id' => '11',
                        'shop_id' => '8',
                        'source_product_id'=>'123',
                        'feedContent' => json_encode([
                          'Id' => 123,
                          'SKU' => 'abc',
                          'Quantity' =>1,
                          'Latency' => 1
                        ])
              ];*/

        /*       $feedContent['1234'] = [
                        'home_shop_id' =>'8',
                        'marketplace_id' => '10',
                        'shop_id' => '8',
                        'source_product_id'=>'1234',
                        'feedContent' => json_encode([
                          'Id' => 123,
                          'SKU' => 'abc',
                          'Quantity' =>1,
                          'Latency' => 1
                        ])
              ];*/

        /*   $feedContent['1234'] = [
                        'home_shop_id' =>'51',
                        'marketplace_id' => '523',
                        'shop_id' => '197',
                        'source_product_id'=>'1234',
                        'process'=>'1',
                        'feedContent' => json_encode([
                          'Id' => 1234,
                          'SKU' => 'abcde',
                          'Quantity' =>1,
                          'Latency' => 1
                        ])
              ];*/

        $feedContent['393011982500568'] = [
            'home_shop_id' => '77',
            'marketplace_id' => 'A21TJRUUN4KGVARA',
            'shop_id' => '54',
            'source_product_id' => '393011982500568',
            'process' => '1',
            'feedContent' => json_encode([
                'Id' => 175580,
                'SKU' => '12374',
                'Quantity' => 100,
                'Latency' => 12
            ])
        ];

        $feedContent['393011982500569'] = [
            'home_shop_id' => '77',
            'marketplace_id' => 'A21TJRUUN4KGVARA',
            'shop_id' => '54',
            'source_product_id' => '393011982500569',
            'process' => '1',
            'feedContent' => json_encode([
                'Id' => 175580,
                'SKU' => '12374',
                'Quantity' => 100,
                'Latency' => 12
            ])
        ];

        $dynamoObj->setTable('amazon_inventory_update');
        $dynamoObj->setUniqueKeys(['source_product_id', 'marketplace_id']);
        $dynamoObj->setTableUniqueColumn('id');

        $res = $dynamoObj->save($feedContent);
        print_r($res);
        die;


        $test = [];
        //$test['profile_id'] = '60b0c4fe7cd778765d6c43f3';
        $test['profile_id'] = '60b3a4abb6da67506a79bac3';

        $test['target_marketplace'] = 'ebay';
        $test['target_shop_id'] = '1';
        $test['warehouse_id'] = '1';
        $test['source_maketplace'] = 'shopify';
        $test['source_shop_id'] = '1';
        $test['source_shop_warehouse_id'] = '1';
        $test['app_tag'] = 'test2';

        $profileids = ["6619633778860", "6619634696364"];
        $test['container_ids'] = $profileids;
        //$test['target_shop_id'] = 's11';

        $profileHelperObj = new ProductHelper();
        $profileHelperObj->process_data = $test;
        // $profileHelperObj->source_marketplace = "shopify_vendor1";
        //$response = $profileHelperObj->getProductByProfileId();

        $response = $profileHelperObj->getProductByProductIds();
        print_r($response);
        die;
    }

    public function savedynamoAction()
    {
        $dynamoObj = $this->di->getObjectManager()->get('App\Connector\Components\Dynamo');
        $dynamoObj->setTable('amazon_inventory_mgmt');

        $feedContent = [];
        $feedContent['123'] = [
            'home_shop_id' => '8',
            'marketplace_id' => '10',
            'shop_id' => '8',
            'source_product_id' => '123',
            'feedContent' => json_encode([
                'Id' => 123,
                'SKU' => 'abc',
                'Quantity' => 1,
                'Latency' => 1
            ])
        ];
        $feedContent['123'] = [
            'home_shop_id' => '8',
            'marketplace_id' => '11',
            'shop_id' => '8',
            'source_product_id' => '123',
            'feedContent' => json_encode([
                'Id' => 123,
                'SKU' => 'abc',
                'Quantity' => 1,
                'Latency' => 1
            ])
        ];

        $feedContent['1234'] = [
            'home_shop_id' => '8',
            'marketplace_id' => '10',
            'shop_id' => '8',
            'source_product_id' => '1234',
            'feedContent' => json_encode([
                'Id' => 123,
                'SKU' => 'abc',
                'Quantity' => 1,
                'Latency' => 1
            ])
        ];

        $feedContent['1234'] = [
            'home_shop_id' => '8',
            'marketplace_id' => '11',
            'shop_id' => '8',
            'source_product_id' => '1234',
            'feedContent' => json_encode([
                'Id' => 123,
                'SKU' => 'abc',
                'Quantity' => 1,
                'Latency' => 1
            ])
        ];

        $dynamoObj->setTable('amazon_inventory_mgmt');
        $dynamoObj->setUniqueKeys(['source_product_id', 'marketplace_id']);
        $res = $dynamoObj->processData('amazon_inventory_mgmt');
        print_r($res);
        die;
    }

    public function checkValidationAction()
    {
        $data = [
            "user_id" => "62b2b27be74e6133280cbde9",
            "source_sku" => "0016027501710",
            "low_sku" => "0016027501710",
            "sku" => "0016027501710",
            "quantity" => "0",
            "default_locale" => "en-US",
            "title" => "Testing 0016027501710",
            "price" => "120",
            "currency_code" => "USD",
            "catalog_id" => "2y0vl7s2j",
            "source_product_id" => "Ef4ylI7Gtk",
            "container_id" => "Ef4ylI7Gtk",
            "type" => "simple",
        ];
        $dynamoObj = $this->di->getObjectManager()->get('App\Connector\Components\ImportValidation');
        $dynamoObj->validateProduct($data);
    }

    public function testNotificationsAction()
    {
        $data1 = '{
      "data": {
        "NotificationVersion" : "1.0",
        "NotificationType" : "MFN_ORDER_STATUS_CHANGE",
        "PayloadVersion" : "1.0",
        "EventTime" : "2022-09-18T09:52:04.357Z",
        "Payload" : {
          "MFNOrderStatusChangeNotification" : {
            "SellerId" : "A23ZXE1PGURN7U",
            "MarketplaceId" : "ATVPDKIKX0DER",
            "AmazonOrderId" : "410-3703604-7896077",
            "PurchaseDate" : 1663366664955,
            "OrderStatus" : "CANCELED",
            "DestinationPostalCode" : null,
            "SupplySourceId" : null,
            "OrderItemId" : "61772225342761:",
            "SellerSKU" : "F0-D65E-XKYU",
            "Quantity" : 0
          }
        },
        "NotificationMetadata" : {
          "ApplicationId" : "amzn1.sellerapps.app.b5994c79-9567-4ba5-b045-0645faf723b6",
          "SubscriptionId" : "50167765-5843-48ec-bb42-cb162e7c8797",
          "PublishTime" : "2022-09-18T09:52:04.399Z",
          "NotificationId" : "e0abbf4c-7425-40bf-8795-1465474ea057"
        }
      }
    }';
        $data2 = ' {
      "data": {
      "NotificationVersion" : "1.0",
      "NotificationType" : "MFN_ORDER_STATUS_CHANGE",
      "PayloadVersion" : "1.0",
      "EventTime" : "2022-09-18T08:22:47.865Z",
      "Payload" : {
        "MFNOrderStatusChangeNotification" : {
          "SellerId" : "A2IF3P5Z7Q1X5D",
          "MarketplaceId" : "ATVPDKIKX0DER",
          "AmazonOrderId" : "984-8925819-1146001",
          "PurchaseDate" : 1663489357662,
          "OrderStatus" : "CANCELED",
          "DestinationPostalCode" : null,
          "SupplySourceId" : null,
          "OrderItemId" : "61799027877321:",
          "SellerSKU" : "CTRXMKFM-SC",
          "Quantity" : 1
        }
      },
      "NotificationMetadata" : {
        "ApplicationId" : "amzn1.sellerapps.app.b5994c79-9567-4ba5-b045-0645faf723b6",
        "SubscriptionId" : "09029712-87cc-45c1-bc44-477cee6328e7",
        "PublishTime" : "2022-09-18T08:22:47.900Z",
        "NotificationId" : "cf64c2d0-98fb-4d53-b46d-fa37ddb8c6f2"
      }
    }}';

        $data3 = ' {
      "data": {
      "NotificationVersion" : "1.0",
      "NotificationType" : "MFN_ORDER_STATUS_CHANGE",
      "PayloadVersion" : "1.0",
      "EventTime" : "2022-09-18T08:22:47.865Z",
      "Payload" : {
        "MFNOrderStatusChangeNotification" : {
          "SellerId" : "A2IF3P5Z7Q1X5D",
          "MarketplaceId" : "ATVPDKIKX0DER",
          "AmazonOrderId" : "832-7405014-3646780",
          "PurchaseDate" : 1663489357662,
          "OrderStatus" : "CANCELED",
          "DestinationPostalCode" : null,
          "SupplySourceId" : null,
          "OrderItemId" : "61799027877321:",
          "SellerSKU" : "CTRXMKFM-SC",
          "Quantity" : 1
        }
      },
      "NotificationMetadata" : {
        "ApplicationId" : "amzn1.sellerapps.app.b5994c79-9567-4ba5-b045-0645faf723b6",
        "SubscriptionId" : "09029712-87cc-45c1-bc44-477cee6328e7",
        "PublishTime" : "2022-09-18T08:22:47.900Z",
        "NotificationId" : "cf64c2d0-98fb-4d53-b46d-fa37ddb8c6f2"
      }
    }}';
        $notificationAmazon = $this->di->getObjectManager()->get('App\Amazon\Components\Webhook\OrderNotifications');
        $data = [json_decode($data1, 1), json_decode($data2, 1), json_decode($data3, 1)];
        $notificationAmazon->getNotificationsData($data);
        die;
    }

    public function failedOrderSyncAction()
    {
        $cronTask = 'failed_order_sync';
        $limit = 100;

        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');

        $amazonCronCollection = $mongo->getCollectionForTable(\App\Amazon\Components\Common\Helper::AMAZON_CRON_TASKS);

        $cronData = $amazonCronCollection->findOne(['task' => $cronTask], ['typeMap' => ['root' => 'array', 'document' => 'array']]);

        $skip = 0;
        if (!empty($cronData) && isset($cronData['offset'])) {
            $skip = $cronData['offset'];
        }

        $collection = $mongo->getCollectionForTable('user_details');

        $options = [
            'limit' => $limit,
            'skip' => $skip,
            'typeMap' => ['root' => 'array', 'document' => 'array']
        ];

        $user_details = $collection->find(['shops.marketplace' => 'amazon'], $options)->toArray();

        if (empty($user_details)) {
            $options = [
                'limit' => $limit,
                'skip' => 0,
                'typeMap' => ['root' => 'array', 'document' => 'array']
            ];

            $user_details = $collection->find(['shops.marketplace' => 'amazon'], $options)->toArray();
        }

        // $users_list = ['shoxtec-suspension.myshopify.com']; // remove this for production

        foreach ($user_details as $user) {
            // remove this for production
            // if(isset($user['username']) && in_array($user['username'], $users_list)) {
            //     continue;
            // }
            // remove this for production

            $helper = $this->di->getObjectManager()->get('\App\Amazon\Components\Cron\Route\Requestcontrol')->syncFailedOrder(['user_id' => $user['user_id']]);


            print_r($helper);
            die('dasdasdadadada');
            //            if (isset($user['user_id'])) {
            //                $handlerData = [
            //                    'type' => 'full_class',
            //                    'class_name' => '\App\Amazon\Components\Cron\Route\Requestcontrol',
            //                    'method' => 'syncFailedOrder',
            //                    'queue_name' => $this->di->getObjectManager()->get('\App\Amazon\Components\Cron\Helper')->getFailedOrderSyncQueueName(),
            //                    'user_id' => $user['user_id'],
            //                ];
            //
            //
            //                /*$helper = $this->di->getObjectManager()->get('\App\Rmq\Components\Helper');
            //
            //                $helper->createQueue($handlerData['queue_name'], $handlerData);*/
            //            }
        }

        if (!empty($cronData)) {
            $offset = $limit + $skip;
            $user_count = $collection->count(['shops.marketplace' => 'amazon']);
            if ($offset >= $user_count) {
                $offset = 0;
            }

            $status = $amazonCronCollection->updateOne(['task' => $cronTask], ['$set' => ['offset' => $offset]]);
            $status->getModifiedCount();
        } else {
            $status = $amazonCronCollection->insertOne(['task' => $cronTask, 'offset' => $limit + $skip]);
            $status->getInsertedCount();
        }

        echo count($user_details) . " merchants pushed in sqs for {$cronTask}";
    }


    public function updateRefineEntries()
    {

        $msg = 'Product(s) import Requ456est is accepted by Shopify.';
        $progress = $this->di->getObjectManager()->get('\App\Connector\Models\QueuedTasks')->updateFeedProgress('6401e714096c6c2cd80017f9', 1, $msg);

        print_r($progress);die('qeqweqweqwe');


        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $mongoCollection = $mongo->getCollectionForTable('product_details');
        $query = $mongoCollection->find(['target_marketplace' => 'amazon', 'source_shop_id' => ''],['projection' => ['user_id' => 1,'source_product_id' => 1, 'source_shop_id' => 1]])->toArray();

        print_r([count($query), $query]);die('asdfg');

    }

    public function selfImportAction()
    {
        $this->updateRefineEntries();
        /*$request_params = $this->request->get();
        $data = $this->request->getJsonRawBody(true);

        $user_id = $request_params['user_id'];
        $container_id = (string)$request_params['container_id'];
        $action = $request_params['action'];

        $response = $this->setDiForUser($this->request->get('user_id'));
        if (!$response['success']) {
            return $response;
        }

        if ($container_id) {
            $target = $this->di->getObjectManager()->get('\App\Shopifyhome\Components\Shop\Shop')->getUserMarkeplace();

            $user_details = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');

            $user_details = $user_details->getDataByUserID($user_id, $target);

            $source_shop_id = (string)$user_details['_id'];
            $shop_name = $user_details['myshopify_domain'];
            $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                ->init($target, 'true')
                ->call('/product',['Response-Modifier'=>'0'],['id'=>$container_id,'shop_id'=>$user_details['remote_shop_id'],'sales_channel' => 1], 'GET');

            if($remoteResponse['success'] && !empty($remoteResponse['data']))
            {
                $queue_data['shop'] = $shop_name;
                $queue_data['data'] = $remoteResponse['data'];
                $queue_data['user_id'] = $user_id;
                $queue_data['shop_id'] = $source_shop_id;
                $queue_data['action'] = $action;
                $queue_data['method'] = "triggerWebhooks";
                $queue_data['type'] = "full_class";
                $queue_data['marketplace'] = "shopify";
                $queue_data['queue_name'] = "amazonbyced_product_listings_update";
                $queue_data['app_codes'] = $this->getAppCodesForSimilarWebhook($user_id, $source_shop_id, $request_params['action']);
            }

        }
        $obj = $this->di->getObjectManager()->get('App\Shopifyhome\Models\SourceModel');
        $processListing = $obj->processListing($queue_data);

        if ($processListing['success']) {
            $function = $processListing['function'];

            $a = $obj->$function($queue_data);
            print_r($a);
            die('product create/update manually');
        }
        die(json_encode($processListing));*/

    }

    public function setDiForUser($user_id)
    {
        try {
            $getUser = \App\Core\Models\User::findFirst([['_id' => $user_id]]);
        } catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }
        if (empty($getUser)) {
            return [
                'success' => false,
                'message' => 'User not found.'
            ];
        }
        $getUser->id = (string)$getUser->_id;
        $this->di->setUser($getUser);
        if ($this->di->getUser()->getConfig()['username'] == 'admin') {
            return [
                'success' => false,
                'message' => 'user not found in DB. Fetched di of admin.'
            ];
        }
        return [
            'success' => true,
            'message' => 'user set in di successfully'
        ];
    }

    public function getAppCodesForSimilarWebhook($userId, $shopId, $code)
    {

        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $mongoCollection = $mongo->getCollectionForTable('user_details');
        $appCodes = [];
        $options = ['typeMap' => ['root' => 'array', 'document' => 'array']];

        $query = [
            ['$match' => ['user_id' => $userId, 'shops._id' => $shopId]],
            ['$unwind' => '$shops'],
            ['$unwind' => '$shops.apps'],
            ['$unwind' => '$shops.apps.webhooks'],
            ['$match' => ['shops.apps.webhooks.code' => $code]],
            ['$project' => ['shops.apps.code' => 1, '_id' => 0]]
        ];

        $searchResponse = $mongoCollection->aggregate($query, $options)->toArray();

        if (isset($searchResponse) && count($searchResponse) > 0) {
            foreach ($searchResponse as $key => $shop) {
                $code = $shop['shops']['apps']['code'];
                $appCodes[$code] = $code;
            }
        }

        $appCodes = array_values($appCodes);

        return $appCodes;
    }

    public function updateWebhookCheckAction()
    {
        $request_params = $this->request->get();
        $data = $this->request->getJsonRawBody(true);

        $user_id = $request_params['user_id'];
        $container_id = (string)$request_params['container_id'];
        $action = 'product_listings_update';

        $response = $this->setDiForUser($this->request->get('user_id'));
        if (!$response['success']) {
            return $response;
        }

        if ($container_id) {
            $target = $this->di->getObjectManager()->get('\App\Shopifyhome\Components\Shop\Shop')->getUserMarkeplace();

            $user_details = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');

            $user_details = $user_details->getDataByUserID($user_id, $target);

            $source_shop_id = (string)$user_details['_id'];
            $shop_name = $user_details['myshopify_domain'];
            $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                ->init($target, 'true')
                ->call('/product',['Response-Modifier'=>'0'],['id'=>$container_id,'shop_id'=>$user_details['remote_shop_id'],'sales_channel' => 1], 'GET');

            if($remoteResponse['success'] && !empty($remoteResponse['data']))
            {
                $queue_data['shop'] = $shop_name;
                $queue_data['data'] = $remoteResponse['data'];
                $queue_data['user_id'] = $user_id;
                $queue_data['shop_id'] = $source_shop_id;
                $queue_data['action'] = $action;
                $queue_data['method'] = "triggerWebhooks";
                $queue_data['type'] = "full_class";
                $queue_data['marketplace'] = "shopify";
                $queue_data['queue_name'] = "amazonbyced_product_listings_update";
                $queue_data['app_codes'] = $this->getAppCodesForSimilarWebhook($user_id, $source_shop_id, $action);
            }

        }

        $obj = $this->di->getObjectManager()->get('App\Shopifyhome\Models\SourceModel');
        $processListing = $obj->processListing($queue_data, $action);

        if ($processListing['success']) {
            $function = $processListing['function'];

            $a = $obj->$function($queue_data);
            if(isset($a['success'], $a['data']['db_data']))
            {
                print_r(json_encode($a));die('asdfg');
            }

            print_r(json_encode($a));
            die('product create/update manually');

        }
        die(json_encode($processListing));

    }

    public function createWebhookCheckAction()
    {
        $request_params = $this->request->get();
        $data = $this->request->getJsonRawBody(true);

        $user_id = $request_params['user_id'];
        $container_id = (string)$request_params['container_id'];
        $action = 'product_listings_add';

        $response = $this->setDiForUser($this->request->get('user_id'));
        if (!$response['success']) {
            return $response;
        }

        if ($container_id) {
            $target = $this->di->getObjectManager()->get('\App\Shopifyhome\Components\Shop\Shop')->getUserMarkeplace();

            $user_details = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');

            $user_details = $user_details->getDataByUserID($user_id, $target);

            $source_shop_id = (string)$user_details['_id'];
            $shop_name = $user_details['myshopify_domain'];
            $remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                ->init($target, 'true')
                ->call('/product',['Response-Modifier'=>'0'],['id'=>$container_id,'shop_id'=>$user_details['remote_shop_id'],'sales_channel' => 1], 'GET');

            if($remoteResponse['success'] && !empty($remoteResponse['data']))
            {
                $queue_data['shop'] = $shop_name;
                $queue_data['data'] = $remoteResponse['data'];
                $queue_data['user_id'] = $user_id;
                $queue_data['shop_id'] = $source_shop_id;
                $queue_data['action'] = $action;
                $queue_data['method'] = "triggerWebhooks";
                $queue_data['type'] = "full_class";
                $queue_data['marketplace'] = "shopify";
                $queue_data['queue_name'] = "amazonbyced_product_listings_update";
                $queue_data['app_codes'] = $this->getAppCodesForSimilarWebhook($user_id, $source_shop_id, $action);
            }

        }

        $obj = $this->di->getObjectManager()->get('App\Shopifyhome\Models\SourceModel');
        $processListing = $obj->processListing($queue_data, $action);

        if ($processListing['success']) {
            $function = $processListing['function'];

            $a = $obj->$function($queue_data);
            print_r(json_encode($a));
            die('product create/update manually');
        }
        die(json_encode($processListing));

    }

    public function DeleteWebhookCheckAction()
    {
        $request_params = $this->request->get();
        $data = $this->request->getJsonRawBody(true);

        $user_id = $request_params['user_id'];
        $container_id = (string)$request_params['container_id'];
//        $action = $request_params['action'];

        $response = $this->setDiForUser($this->request->get('user_id'));
        if (!$response['success']) {
            return $response;
        }

        if ($container_id) {
            $target = $this->di->getObjectManager()->get('\App\Shopifyhome\Components\Shop\Shop')->getUserMarkeplace();

            $user_details = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');

            $user_details = $user_details->getDataByUserID($user_id, $target);

            $source_shop_id = (string)$user_details['_id'];
            $shop_name = $user_details['myshopify_domain'];
            /*$remoteResponse = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                ->init($target, 'true')
                ->call('/product',['Response-Modifier'=>'0'],['id'=>$container_id,'shop_id'=>$user_details['remote_shop_id'],'sales_channel' => 1], 'GET');*/

            $remoteResponse['data']['product_listing']['product_id'] = (string)$container_id;

            $queue_data['shop'] = $shop_name;
            $queue_data['data'] = $remoteResponse['data'];
            $queue_data['user_id'] = $user_id;
            $queue_data['shop_id'] = $source_shop_id;
            $queue_data['action'] = 'product_listings_remove';
            $queue_data['method'] = "triggerWebhooks";
            $queue_data['type'] = "full_class";
            $queue_data['marketplace'] = "shopify";
            $queue_data['queue_name'] = "amazonbyced_product_listings_update";
            $queue_data['app_codes'] = $this->getAppCodesForSimilarWebhook($user_id, $source_shop_id, 'product_listings_remove');

        }

        $obj = $this->di->getObjectManager()->get('App\Shopifyhome\Components\Product\Hook');
        $processListing = $obj->removeProductWebhook($queue_data);
        print_r(json_encode($processListing));die(' product deleted response');
    }


    /**
     * to register webhooks for app_subscription
     *
     * @return void
     */
    public function registerWebhooksAction()
    {
      $baseMongo = $this->di->getObjectManager()->get('App\Plan\Models\BaseMongo');
      $userCollection = $baseMongo->getCollectionForTable('user_details');
      $sourceModel = $this->di->getObjectManager()->get('App\Connector\Models\SourceModel');
      $lastTraversedObjectId = $this->getLastTraversedObjectId();
      $query = [];
      if (!is_null($lastTraversedObjectId)) {
        $query = ['_id' => ['$gt' => $lastTraversedObjectId]];
      }
      
      $size = 100;
      $options = [
          'limit' => $size,
          'typeMap' => ['root' => 'array', 'document' => 'array']
      ];
      $users = $userCollection->find($query, $options)->toArray();

      $destinationId = "125";//this will be changed as per server
      $appTag = 'amazon_sales_channel';////this will be changed as per server

      if (!empty($users)) {
        foreach ($users as $user) {
          if (isset($user['user_id'])) {
            $userId = $user['user_id'];
            $this->di->getLog()->logContent('User Id: '. $userId, 'info', 'webhook_test.log');
            $diResponse = $this->setDiForUser($userId);
            if ($diResponse['success']) {
              $this->di->getLog()->logContent('Di set successfully', 'info', 'webhook_test.log');
              if (isset($user['shops']) && !empty($user['shops'])) {
                $this->di->getLog()->logContent('Shops found', 'info', 'webhook_test.log');
                $this->di->getLog()->logContent('Shops data: '.json_encode($user['shops'], true), 'info', 'webhook_test.log');
                foreach ($user['shops'] as $shop) {
                  if (isset($shop['marketplace']) && ($shop['marketplace'] == 'shopify')) {
                    try {
                      $response = $sourceModel->routeRegisterWebhooks($shop, $shop['marketplace'], $appTag, $destinationId);
                      $this->di->getLog()->logContent('Response: '. json_encode($response, true), 'info', 'webhook_test.log');
                      print_r($response);
                    } catch (\Exception $e) {
                      $this->di->getLog()->logContent('Exception occurs: '. json_encode($e->getMessage(), true), 'info', 'webhook_test.log');
                      print_r($e->getMessage());
                    }
                  }
                }
              }
            }
          }
        }
        $this->updateLastTraversedObjectId($users);
      }
      die('end');
    }

    public function getLastTraversedObjectId()
    {
      $cronTaskCollection = "cron_tasks";
      $cronTaskName = "register_webhook_task";
      $baseMongo = $this->di->getObjectManager()->get('App\Plan\Models\BaseMongo');
      $cronTaskCollection = $baseMongo->getCollectionForTable($cronTaskCollection);
        $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
        $query = [
            'task' => $cronTaskName,
        ];
        $cronTask = $cronTaskCollection->findOne($query, $options);
        return $cronTask['last_traversed_object_id'] ?? null;
    }

    public function updateLastTraversedObjectId($users)
    {
        $lastTraversedObjectId = null;
        if (!empty($users)) {
            $lastTraversedUser = end($users);
            $lastTraversedObjectId = $lastTraversedUser['_id'];
        }

        $cronTaskCollection = "cron_tasks";
        $cronTaskName = "register_webhook_task";
        $baseMongo = $this->di->getObjectManager()->get('App\Plan\Models\BaseMongo');
        $cronTaskCollection = $baseMongo->getCollectionForTable($cronTaskCollection);
        $query = ['task' => $cronTaskName];
        $update = ['$set' => ['last_traversed_object_id' => $lastTraversedObjectId]];
        $cronTaskCollection->updateOne($query, $update, ['upsert' => true]);
    }
}
