<?php

namespace App\Connector\Controllers;

class SourceController extends \App\Core\Controllers\BaseController
{
    public function getFilterAttributesAction()
    {
        $contentType = $this->request->getHeader('Content-Type');
        $rawBody = [];
        if (strpos($contentType, 'application/json') !== false) {
            $rawBody = $this->request->getJsonRawBody(true);
        } else {
            $rawBody = $this->request->get();
        }
        if ($code = $rawBody['source']['marketplace']) {
            if ($model = $this->di->getConfig()->connectors->get($code)->get('source_model')) {
                $data = $this->di->getObjectManager()->get($model)->getFilterAttributes($rawBody);
                if (count($data['data']) > 0) {
                    return $this->prepareResponse(['success' => true, 'data' => $data['data']]);
                } else {
                    return $this->prepareResponse(['success' => false, 'data' => $data['data']]);
                }
            }
        } else {
            return $this->prepareResponse(['success' => false, 'code' => 'missing_required_params', 'message' => 'Missing Code.']);
        }
    }
}
