<?php

namespace App\Connector\Setup;

use \Phalcon\Di\DiInterface;

class UpgradeSchema extends \App\Core\Setup\Schema
{
    
    public function up(DiInterface $di, $moduleName, $currentVersion)
    {
        $this->applyOnSingle($di, $moduleName, $currentVersion, 'db', function ($connection, $dbVersion) use ($di) {
            if ($dbVersion < '3.0.1') {
                $collection = $connection->selectCollection('product_container');
                $collection->createIndex(["_id" => 1]);
                $collection->createIndex(["user_id" => 1, 'shop_id' => 1, 'container_id' => 1]);
                $collection->createIndex(["user_id" => 1, 'shop_id' => 1, 'source_sku' => 1]);
                $collection->createIndex(["user_id" => 1, 'shop_id' => 1, 'source_product_id' => 1]);
                $collection->createIndex(["user_id" => 1, 'source_marketplace' => 1, 'source_product_id' => 1]);

                $collection = $connection->selectCollection('temp_webhook_container');
                $collection->createIndex(["user_id" => 1, 'shop_id' => 1, 'container_id' => 1]);

                $collection = $connection->selectCollection('refine_product');
                $collection->createIndex(["user_id" => 1, 'source_shop_id' => 1, 'target_shop_id' => 1, 'source_product_id' => 1, 'container_id' => 1]);
                return true;
            }
        });
    }
}