<?php

namespace App\Connector\Models;

use App\Core\Models\BaseMongo;
use App\Connector\Components\Helper As ConnectorHelper;

class Notifications extends BaseMongo
{
    protected $table = 'notifications';

    public function initialize()
    {
        $this->setSource($this->table);
        $this->setConnectionService($this->getMultipleDbManager()->getDb());
    }

    public function getAllNotifications($params)
    {
        $userId = $this->di->getUser()->id;
        $count = 5;
        $activePage = 0;
        $aggregate = [];
        if (isset($params['count']) && isset($params['activePage'])) {
            $count = $params['count'];
            $activePage = $params['activePage'] - 1;
            $activePage = $activePage * $count;
        } else if (isset($params['count'])) {
            $count = $params['count'];
        }
        if ( isset($params['filter']) ) {
            $obj = $this->di->getObjectManager()->get('\App\Connector\Models\ProductContainer');
            $aggregateSearch = $obj->search($params);
        }
        $sourceShopId = isset($params['source']) && isset($params['source']['shopId']) ? $params['source']['shopId'] : $this->di->getRequester()->getSourceId();
        $targetShopId = isset($params['target']) && isset($params['target']['shopId']) ? $params['target']['shopId'] : $this->di->getRequester()->getTargetId();


        if (isset($params['app_tag'])) {
            $appTag = $params['app_tag'];
        } else {
            $appTag = $this->di->getAppCode()->getAppTag();
        }


        $aggregate = [
            [
                // matching with userid
                '$match' => [
                    'user_id' => $userId,
                    "appTag" => $appTag,
                ]
            ],
            [
                //sorting array
                '$sort' => [
                    'created_at' => -1
                ]
            ],
            [
                //matching with either source shop id or target shop id
                '$match' => [
                    '$or' => [
                        [
                            'shop_id' => $targetShopId
                        ],
                        [
                            'shop_id' => $sourceShopId
                        ]
                    ]
                ]
            ]
        ];
        if (isset($params['severity'])) {
            $aggregate[] = [
                '$match' => [
                    "severity" => $params['severity']
                ],
            ];
        }
        if ( isset($aggregateSearch) && count($aggregateSearch) > 0 )
            $aggregate[] = [
                '$match' => $aggregateSearch
            ];
        $countQuery = $aggregate;
        $aggregate[] = [
            '$skip' => (int) $activePage,
        ];
        $aggregate[] = [
            '$limit' => (int) $count,
        ];
        $collection = $this->getCollection();

        $notifications = $collection->aggregate($aggregate);
        $countQuery[] = [
            '$count' => 'count',
        ];
        $count = $collection->aggregate($countQuery)->toArray();
        !empty($count) ? $count = $count[0]['count'] : $count = 0;
        $notifications = $notifications->toArray();
        return ['success' => true, 'data' => ['rows' => $notifications, 'count' => $count]];
    }

    //New Function
    public function addNotification($shopId, $notificationData)
    {
        try {
            $userId = $this->di->getUser()->id;
            if (empty($notificationData)) {
                return ['success' => false, 'message' => 'Notification Data missing.'];
            }
            if (!$shopId) {
                return [
                    "success" => false, "message" => "shop_id does not exist"
                ];
            };
            if (!isset($notificationData['marketplace'])) {
                return [
                    "success" => false, "message" => "markeplace does not exist"
                ];
            }

            if (!isset($notificationData['appTag'])) {
                $appTag = $this->di->getAppCode()->getAppTag();
            } else {
                $appTag = $notificationData['appTag'];
            }

            $notification = $this->di->getObjectManager()->create('\App\Connector\Models\Notifications');

            $data = [
                'user_id' => $notificationData['user_id'] ?? $userId,
                "shop_id" => $shopId,
                'marketplace' => $notificationData['marketplace'],
                'appTag' => $appTag,
                'created_at' => date('c')
            ];
            if (isset($notificationData['additional_data'])) {
                $data['additional_data'] = $notificationData['additional_data'];
            }
            if (isset($notificationData['severity'])) {
                $data['severity'] = $notificationData['severity'];
            }
            if (isset($notificationData['message'])) {
                $data['message'] = $notificationData['message'];
            };
            if (isset($notificationData['tag'])) {
                $data['tag'] = $notificationData['tag'];
            } else {
                $user_details = $this->getCollectionForTable("user_details");
                $userdata = $user_details->findOne(
                    ["user_id" => $userId]
                );
                $name = [];
                if ($userdata) {
                    foreach ($userdata['shops'] as $shop) {
                        if (isset($shop['name']) && $shopId === $shop['_id']) {
                            $name[] = $shop['name'];
                        }
                    }
                }
                $data['tag'] = implode(', ', $name);
            };

            if (isset($notificationData['url'])) {
                $data['url'] = $notificationData['url'];
            }
            $notification->setData($data);
            $notification->save();

            if (!empty($appTag) && $this->di->getConfig()->get("app_tags")->get($appTag) !== null) {
            /* Trigger websocket (if configured) */
            $websocketConfig = $this->di->getConfig()->get("app_tags")
                ->get($appTag)
                ->get('websocket');
            if (
                isset($websocketConfig['client_id'], $websocketConfig['allowed_types']['notification']) &&
                $websocketConfig['client_id'] &&
                $websocketConfig['allowed_types']['notification']
            ) {
                $helper = $this->di->getObjectManager()->get(ConnectorHelper::class);
                $helper->handleMessage([
                    'user_id' => $userId,
                    'notification' => $notification->getData()
                ]);
            }
            /* Trigger websocket (if configured) */
        }
            return $this;
        
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }

    public function clearAllNotifications($userId, $shopId, $appTag)
    {
        $collection = $this->getCollection();
        if ($collection->count(['user_id' => $userId, 'shop_id' => $shopId, 'appTag' => $appTag])) {
            $collection->deleteMany(['user_id' => $userId, 'shop_id' => $shopId, 'appTag' => $appTag]);
            return ['success' => true, 'message' => 'All your activities are cleared.'];
        }
        return ['success' => false, 'message' => 'There are no activities for this shop'];
    }
}