<?php

namespace App\Connector\Components\Profile;

use App\Core\Models\BaseMongo;

class GetProductProfileMerge extends BaseMongo
{
    public $defaultLimit = 10;

    public $userId = '';

    public $allSourceProductIds = [];

    public function init($data = [])
    {
        if (isset($data['user_id'])) {
            $this->userId = $data['user_id'];
        } else {
            $this->userId = $this->di->getUser()->id;
        }
    }

    public function getMessage($data, $appendKey = ' initiated', $findVaraintCountOnly = 0)
    {
        if ($data['operationType'] === "product_upload" && $findVaraintCountOnly) {
            return ucfirst(explode("_", $data['operationType'])[0] . " variants upload" . $appendKey);
        } else {
            return ucfirst(implode(" ", explode("_", $data['operationType'])) . $appendKey);
        }
    }

    public function getproductsByProfile($data, $directReturnProducts = false)
    {

        $this->init($data);
        $data['user_id'] = $this->userId;
        if ($directReturnProducts) {
            $aggregate = $this->getProfileIdAggregate($data);

            return $this->getProducts($data, $aggregate, "getVariantFormatted", "getProfileInfo", $data['next_available']);
        }
        $message = $this->getMessage($data);
        $SqsObject = new  \App\Connector\Components\Profile\SQSWorker;
        $newData = [
            'user_id' => $this->userId,
            'class_name' => '\App\Connector\Components\Profile\GetProductProfileMerge',
            'method_name' => 'getProductsWithMergedDataSqsMethod',
            'params' => array_merge($data, ['activePage' => 1, 'aggregate_method' => 'getProfileIdAggregate']),
            'worker_name' =>  isset($data['workerName']) ? $data['workerName'] : 'product_profile_id_upload_danish',
            'message' => $message,
            'process_code' => $data['operationType'],
            "additional_data" => ['bulk' => true, 'source_info' => $data['source'] ?? 'source_info_not_found']
        ];
        $SqsObject->CreateWorker($newData, $data['create_queued_tasks']);

        return ['success' => true, 'message' => $message];
    }

    public function getproductsByProductIds($data, $directReturnProducts = false)
    {
        $this->init($data);
        $data['user_id'] = $this->userId;
        if ($directReturnProducts) {
            $aggregate = $this->getProductIdsAggregate($data);
            return  $products = $this->getProducts($data, $aggregate, "getVariantFormatted", "getProfileInfo", $data['next_available']);
        }
        $mesasge = $this->getMessage($data);
        $SqsObject = new  \App\Connector\Components\Profile\SQSWorker;
        $newData = [
            'user_id' => $this->userId,
            'class_name' => '\App\Connector\Components\Profile\GetProductProfileMerge',
            'method_name' => 'getProductsWithMergedDataSqsMethod',
            'params' => array_merge($data, ['activePage' => 1, 'aggregate_method' => 'getProductIdsAggregate']),
            'worker_name' => isset($data['workerName']) ? $data['workerName'] : 'product_id_profile_upload_danish',
            'message' => $mesasge,
            'process_code' => $data['operationType'],
            "additional_data" => ['bulk' => false,  'source_info' => $data['source'] ?? 'source_info_not_found']
        ];
        $SqsObject->CreateWorker($newData, $data['create_queued_tasks']);
        return ['success' => true, 'message' => $mesasge];
    }

    public function getProductsWithMergedDataSqsMethod($data)
    {
        //getProfileIdAggregate
        $params = $data['data']['params'];
        $aggregateMethod = $params['aggregate_method'];
        $aggregate = $this->$aggregateMethod($params);
        //graph look up ke sath 
        $products = $this->getProducts($params, $aggregate, "getVariantFormatted", "getProfileInfo", $params['next_available']);

        if (isset($params['totalParentProccessed'])) {
            $params['totalParentProccessed'] = $params['totalParentProccessed'] + $products['parentInCurrentChunk'];
        } else {
            $params['totalParentProccessed'] = $products['parentInCurrentChunk'];
        }

        $products['data']['operationType'] = $params['operationType'];
        $products['data']['params'] = $params;
        $products['data']['count_status'] = $data['data']['count'] ?? [];
        $SqsObject = new  \App\Connector\Components\Profile\SQSWorker;
        $model = $this->di->getConfig()->connectors->get($params['target']['marketplace'])->get('source_model');
        $syncFunc = $this->di->getObjectManager()->get($model)->startSync($products);

        if (isset($syncFunc['marketplace_additional_data'])) {
            $data['data']['marketplace_additional_data'] = $syncFunc['marketplace_additional_data'];
        }

        if (isset($syncFunc['count']['success']) && isset($syncFunc['count']['error']) && isset($syncFunc['count']['warning'])) {
            if (!isset($data['data']['count'])) {
                $data['data']['count'] = [
                    'success' => 0,
                    'error' => 0,
                    'warning' => 0,
                ];
            }
            $data['data']['count'] = [
                'success' => $data['data']['count']['success'] + $syncFunc['count']['success'],
                'error' => $data['data']['count']['error'] + $syncFunc['count']['error'],
                'warning' => $data['data']['count']['warning'] + $syncFunc['count']['warning'],
            ];
        }

        $addtional_data = ['bulk' => isset($params['source_product_ids']) ? false : true];

        if ($syncFunc['CODE'] == 'REQUEUE') {
            $data['apply_limit'] = isset($syncFunc['time_out']) ? $syncFunc['time_out'] : 60;
            $params['requeue_count'] = isset($params['requeue_count']) ? $params['requeue_count'] + 1 : 1;
        } else if ($syncFunc['CODE'] == 'SUCCESS') {
            $progress = (1 / $params['totalPages']) * 100;
            if ($params['create_queued_tasks']) {
                if ($data['data']['feed_id']) {
                    $findVaraintCountOnly = isset($params['findVaraintCountOnly']) ?  $params['findVaraintCountOnly'] : false;

                    $processed =  $findVaraintCountOnly  ? (($params['activePage'] * $params['limit']) -  $params['totalParentProccessed']) : ($params['activePage'] * $params['limit']);
                    $total = $findVaraintCountOnly ? $params['totalCount'] - $params['parentCount'] : $params['totalCount'];
                    $this->di->getObjectManager()->get('\App\Connector\Models\QueuedTasks')
                        ->updateFeedProgress($data['data']['feed_id'], $progress, $processed . ' of ' . $total  . " " .
                            $this->getMessage($params, ' in progress', $findVaraintCountOnly), $addNupdate = true);  //updating progresss
                }
            }
            $params['activePage'] = $params['activePage'] + 1;
        } else if ($syncFunc['CODE'] == 'TERMINATE') {
            $data['data']['params'] = $params;
            $this->clearInfoFromCache($data);
            if ($params['create_queued_tasks']) {
                if ($data['data']['feed_id']) {
                    $this->di->getObjectManager()->get('\App\Connector\Models\QueuedTasks')
                        ->updateFeedProgress($data['data']['feed_id'], 100, "Upload Terminated", $addNupdate = true); //updating progresss
                }
                if ($params['create_notification']) {
                    $this->di->getObjectManager()->get('\App\Connector\Models\Notifications')->addNotification(
                        $params['target']['shopId'],
                        [
                            "user_id" => $params['user_id'],
                            "marketplace" => $params['target']['marketplace'],
                            "message" => $this->getMessage($params, " terminated"),
                            "severity" => "error",
                            "shop_id" => $params['target']['shopId'],
                            "additional_data" => $addtional_data
                        ]
                    ); //adding notification
                }
            }
            return true;
        }

        $data['data']['params'] = $params;
        if (!$params['next_available'] && $syncFunc['CODE'] != 'REQUEUE') {
            $this->clearInfoFromCache($data);
            if ($params['create_notification']) {
                $this->di->getObjectManager()->get('\App\Connector\Models\Notifications')->addNotification(
                    $params['target']['shopId'],
                    [
                        "user_id" => $params['user_id'],
                        "marketplace" => $params['target']['marketplace'],
                        "message" => $this->getMessage($params, ' completed on ' . $params['target']['marketplace']),
                        "severity" => "success",
                        "shop_id" => $params['target']['shopId'],
                        "additional_data" => $addtional_data
                    ]
                ); //adding notification
            }

            return true;
        }
        $SqsObject->pushToQueue($data);
    }

    /**
     *
     * @param [array] $data
     * @return array
     */
    public function getSingleProductData($data)
    {
        $params = $data['data']['params'];

        $aggregateMethod = $params['aggregate_method'];
        $aggregate = $this->$aggregateMethod($params);

        $products = $this->getProducts($params, $aggregate, "getVariantFormatted", "getProfileInfo", $params['next_available']);

        $products['data']['operationType'] = $params['operationType'];
        $products['data']['params'] = $params;

        $model = $this->di->getConfig()->connectors->get($params['target']['marketplace'])->get('source_model');
        $syncFunc = $this->di->getObjectManager()->get($model)->startSync($products);
        return $syncFunc;
    }

    public function getAllSourceIds(&$data)
    {
        $aggregate = [];
        $cacheInfo = [];

        $tableTOuse = isset($data['useRefinProduct']) ? ($data['useRefinProduct'] ?  'refine_product' : 'product_container') : 'product_container';

        if (isset($data['unique_key_for_sqs'])) {
            $cacheInfo = $this->di->getCache()->get((string)$data['unique_key_for_sqs']);
        }

        if (isset($cacheInfo['all_source_product_ids'])) {
            return $cacheInfo['all_source_product_ids'];
        } else if (isset($data['source_product_ids'])) {
            $this->handleDefAggregateForProductIds($data, $aggregate, 'forSourceIds');
        } else if (isset($data['profile_id'])) {
            //5
            $this->handleDefAggregateForProfileId($data, $aggregate, 'forSourceIds');
        }

        $flag = isset($data['mergeVariants']) ?  $data['mergeVariants'] : false;

        $findVaraintCountOnly = isset($data['findVaraintCountOnly']) ?  $data['findVaraintCountOnly'] : false;

        $parentCount = 0;

        $aggregateAdd =  $findVaraintCountOnly ? ['container_id' => ['$addToSet' => '$container_id'], 'type' => ['$addToSet' => '$type']] : [];
        if ($tableTOuse == 'product_container') {
            $aggregate[] = [
                '$group' => [
                    '_id' => '$' . ($flag ? '' : 'marketplace.') . 'source_product_id'
                ] +  $aggregateAdd
            ];
        } else {
            $aggregate[] = [
                '$group' => [
                    '_id' => '$' . ($flag ? '' : 'items.') . 'source_product_id'
                ] +  $aggregateAdd
            ];
        }

        $aggregate[] = [
            '$sort' => ['_id' => 1]
        ];

        $allSourceProductIds = [];

        $productArr = $this->getCollectionForTable($tableTOuse)->aggregate($aggregate)->toArray();

        foreach ($productArr as $key => $value) {
            $allSourceProductIds = array_merge($allSourceProductIds, array_unique((array) $value['_id']));
            if (isset($value['type']) && $value['type'][0] == 'variation') {
                $parentCount++;
            }
        }

        $data['parentCount'] = $parentCount;
        $getTime = time();

        $data['unique_key_for_sqs'] = $data['user_id'] . 'target_id' . $data['target']['shopId'] . 'source_id' . $data['source']['shopId'] . $data['operationType'] . $getTime;

        $this->di->getCache()->set((string)$data['unique_key_for_sqs'],  array_merge((array)$cacheInfo, ['all_source_product_ids' => array_unique($allSourceProductIds)]));

        return array_unique($allSourceProductIds);
    }

    public function getProfilId($target_id, $data)
    {
        foreach ($data as $key => $value) {
            if ($value['target_shop_id'] == $target_id) {
                return $value['profile_id'];
            }
        }
        return null;
    }

    public function getProducts($data, $aggregateAl = [], $getVariantFormatted = NULL, $getProfileInfo = NULL, $nextAvailable = false)
    {
        //6
        if (count($aggregateAl) == 0) {
            return ['success' => false, 'message' => 'send Pipeline Array', 'code' => 'data_missing'];
        }

        $aggregate = $aggregateAl;

        $limit = isset($data['limit']) ? $data['limit'] : $this->defaultLimit;
        $aggregate[] = ['$limit' => (int)$limit + 1];

        $tableTOuse = isset($data['useForcedRefineProductTable']) ? ($data['useForcedRefineProductTable'] ?  'refine_product' : 'product_container') : 'product_container';

        //TODO add try and catch and remove lookup and get all varaint data from another db call.
        $productArr = $this->getCollectionForTable($tableTOuse)->aggregate($aggregate);

        $onPage = 0;

        $pointerArr = [];
        if (isset($data['next'])) {
            $decodedVal = json_decode(base64_decode($data['next']), true);
            $onPage = $decodedVal['onPage'];
            $pointerArr = $decodedVal['pointers'];
        }

        if (isset($data['prev'])) {
            $decodedVal = json_decode(base64_decode($data['prev']), true);
            $onPage = $decodedVal['onPage'];
            $pointerArr = $decodedVal['pointers'];
        }

        $it = new \IteratorIterator($productArr);
        $it->rewind();

        $rows = [];
        $parentInCurrentChunk = 0;
        while ($limit > 0  &&  $doc = $it->current()) {

            if (isset($doc['type']) && $doc['type'] == 'variation') {
                $parentInCurrentChunk++;
            }

            if ($getVariantFormatted) {
                $this->$getVariantFormatted($doc, $doc['variants'], $data);
            }

            if (isset($doc['profile']) && isset($doc['visibility']) && $doc['visibility'] == 'Catalog and Search' && $getProfileInfo && $profileId = $this->getProfilId($data['target']['shopId'], $doc['profile'])) {
                $profileInfoRec = $this->$getProfileInfo($profileId, $data);
                if ($profileInfoRec) {
                    $doc['profile_info'] = $profileInfoRec;
                }
            }

            $rows[] = $doc;

            $limit--;

            $it->next();
        }
        $next = null;
        $cursor = $onPage != 0 ? $pointerArr[$onPage - 1] : null;
        $row_count = count($rows);

        if (isset($data['prev'])) {
            array_pop($pointerArr);
        } else if ($row_count != 0) {
            $pointerArr[] = $rows[0]['_id'];
        }
        if ($it->valid()) {
            $next = base64_encode(json_encode([
                'cursor' => ($doc)['_id'],
                'pointers' => $pointerArr,
                'onPage' => $onPage + 1
            ]));
        }
        $prev = null;
        if (isset($decodedVal) && isset($decodedVal['pointers']) && $onPage != 0) {
            $prev = base64_encode(json_encode([
                'cursor' => $cursor,
                'pointers' =>  $pointerArr,
                'onPage' => $onPage - 1
            ]));
        }
        return ['success' => true, 'unique_key_for_sqs' => $data['unique_key_for_sqs'] ?? '', 'message' => 'Fetched Successfully', 'data' => array_merge(['rows' => $rows, 'count' => $row_count],  isset($data['activePage']) ? ['next' => $nextAvailable] : ['next' => $next, 'prev' => $prev]), 'parentInCurrentChunk' => $parentInCurrentChunk];
    }

    public function getVariantFormatted(&$data, $variantDetails, $params)
    {
        $mappedProducts = [];
        $parent_details = [];
        foreach ($variantDetails as $key => $value) {
            if (isset($value['source_id']) && !isset($value['source_product_id'])) {
                $value['source_product_id'] = $value['source_id'];
            }
            if (isset($value['source_product_id']) && isset($value['container_id'])) {
                if ($data['source_product_id'] == $value['source_product_id'] && isset($value['target_marketplace'])) {
                    $data['edited'] = clone ($value);
                    continue;
                }
                $toMerge = isset($value['target_marketplace']) ? ['edited' => $value] : $value;
                $mappedProducts[$value['source_product_id']] = isset($mappedProducts[$value['source_product_id']]) ? array_merge((array)$mappedProducts[$value['source_product_id']], (array)$toMerge) : $toMerge;
            }
        }
        unset($data['variants']);
        if (isset($params['mergeVariants']) && $params['mergeVariants']) {
            unset($mappedProducts[$data['source_product_id']]);
            $data['variants'] =  array_values($mappedProducts);
        }
        if ($data['type'] == 'simple') {
            if ($data['visibility'] == 'Catalog and Search') {
            } else {
                $parent_details = $mappedProducts[$data['container_id']];
                if (isset($parent_details['profile']) && $profileId = $this->getProfilId($params['target']['shopId'], $parent_details['profile'])) {
                    $parent_details['profile_info'] = $this->getProfileInfo($profileId, $params);
                    $data['profile_info'] = $parent_details['profile_info'];
                }
                $data['parent_details'] = $parent_details;
            }
        }
    }

    public function formatProfileDataForPriorityBasis($profile, $data)
    {

        $targetShopId = $data['target']['shopId'];
        $targetMarketplace = $data['target']['marketplace'];
        $sourceShopId = $data['source']['shopId'];

        $priorityArr = ['source_warehouse', 'source_shop', 'warehouse', 'shop', 'target', 'profile'];
        $holdArr = [];

        $idToArr = [];
        foreach ($profile as $key => $value) {
            $idToArr[(string)$value['_id']] = $value;
            if ($value['type'] == 'shop' && $value['shop_id'] == $targetShopId) {
                $holdArr['shop'] = $value;
            }
            if ($value['type'] == 'shop' && $value['shop_id'] == $sourceShopId) {
                $holdArr['source_shop'] = $value;
            }
            if ($value['type'] == 'profile') {
                $holdArr['profile'] = $value;
                if (isset($value['targets'])) {
                    foreach ($value['targets'] as $index => $targetData) {
                        if (isset($targetData['target_marketplace']) && $targetData['target_marketplace'] == $targetMarketplace) {
                            $holdArr['target'] = $targetData;
                        }
                    }
                }
            }
        }
        $attribute = [];
        $category = [];
        $dataToData = [];
        $holdArr['warehouse'] = isset($holdArr['shop']['warehouses'][0]['id'])
        ? (isset($idToArr[(string)$holdArr['shop']['warehouses'][0]['id']]) ? $idToArr[(string)$holdArr['shop']['warehouses'][0]['id']] : [])
        : [];
        $holdArr['source_warehouse'] = isset($holdArr['source_shop']['warehouses'][0]['id'])
        ? (isset($idToArr[(string)$holdArr['source_shop']['warehouses'][0]['id']]) ? $idToArr[(string)$holdArr['source_shop']['warehouses'][0]['id']] : [])
        : [];

        foreach ($priorityArr as $val) {
            if (count($attribute) !== 0 && !empty($category) && count($dataToData)) {
                break;
            }
            if (isset($holdArr[$val]['category_id']) && empty($category)) {
                $category = $holdArr[$val]['category_id'];
            }
            if (isset($holdArr[$val]['attributes_mapping']) && count($attribute) == 0) {
                $attribute = $idToArr[(string)$holdArr[$val]['attributes_mapping']];
            }
            if (isset($holdArr[$val]['data']) && count($dataToData) == 0) {
                $dataToData = $holdArr[$val]['data'];
            }
        }
        return ['category_settings' => $category, 'attributes_mapping' => $attribute, 'data' => $dataToData];
    }

    public function getProfileInfo($profileId, $data)
    {
        $cacheInfo = $this->di->getCache()->get((string)$data['unique_key_for_sqs']);
        if (isset($cacheInfo[(string)$profileId])) {
            return $cacheInfo[(string)$profileId];
        } else {
            $condition = [
                '$or' => [
                    ['profile_id' => $profileId], ['_id' => $profileId]
                ]
            ];
            $profileData = $this->getCollectionForTable('profile')->find($condition)->toArray();

            if (count($profileData) == 0) {
                $this->di->getCache()->set((string)$data['unique_key_for_sqs'], array_merge((array)$cacheInfo ?? [], [(string)$profileId => false]));
                return false;
            }

            $profileInfo = $this->formatProfileDataForPriorityBasis($profileData, $data);

            $this->di->getCache()->set((string)$data['unique_key_for_sqs'], array_merge((array)$cacheInfo ?? [], [(string)$profileId => $profileInfo]));
            return $profileInfo;
        }
    }

    public function getProfileIdAggregate(&$data)
    {
        //1
        $aggregate = [];
        $this->handleDefAggregateForProfileId($data, $aggregate, 'getProducts');

        //cache , or => ['']

        $addTagetOr = $this->sourceCondtions($data);
        $addTagetOr[] = [
            'shop_id' => $data['target']['shopId'],
            'target_marketplace' => $data['target']['marketplace'],
        ];

        //check if we can avoid graphlookup
        $aggregate[] = [
            '$graphLookup' => [
                'from' => 'product_container',
                'startWith' => '$container_id',
                'connectFromField' => 'container_id',
                'connectToField' => 'container_id',
                'restrictSearchWithMatch' => [
                    '$or' => $addTagetOr,
                    'user_id' => $data['user_id'],
                ],
                'as' => 'variants'
            ]
        ];

        return $aggregate;
    }

    public function handleDefAggregateForProfileId(&$data, &$aggregate, $for = 'getProducts')
    {

        //2
        $tableTOuse = isset($data['useRefinProduct']) ? ($data['useRefinProduct'] ?  'refine_product' : 'product_container') : 'product_container';

        $orCond = $this->sourceCondtions($data, $for);

        $aggregate[] = [
            '$match' => [
                'user_id' => $data['user_id'],
            ]
        ];
        if ($for != 'getProducts') {
            if ($data['profile_id'] !== 'all_products') {
                $aggregate[] = [
                    '$match' => [
                        'profile.profile_id' => new \MongoDB\BSON\ObjectId($data['profile_id']),
                    ]
                ];
            }

            if (!empty($data['or_filter'])) {
                $containerModel = new \App\Connector\Models\ProductContainer();
                $filter = ['filter' => $data['or_filter']];
                $orQuery = $containerModel->search($filter);
                $filterType = '$or';
                $aggregate[] = ['$match' => [
                    $filterType => [
                        $orQuery,
                    ],
                ]];
            }
            if (!empty($data['filter'])) {
                $filter = ['filter' => $data['filter']];
                $containerModel = new \App\Connector\Models\ProductContainer();
                $andQuery = $containerModel->search($filter);
                $filterType = '$and';
                $aggregate[] = ['$match' => [
                    $filterType => [
                        $andQuery,
                    ],
                ]];
            }
        }
        if ($for != 'getProducts' && $tableTOuse == 'product_container') {
            $aggregate[] = [
                '$match' => [
                    'visibility' => 'Catalog and Search'
                ]
            ];
        }

        //3
        if ($for == 'getProducts') {
            $this->getProductsAggregateDefBySourceIds($data, $aggregate);
        }
        $aggregate[] = [
            '$match' => [
                '$or' => $orCond
            ]
        ];
    }

    public function getProductIdsAggregate(&$data)
    {
        $aggregate = [];
        $this->handleDefAggregateForProductIds($data, $aggregate, 'getProducts');
        $addTagetOr = $this->sourceCondtions($data);

        $addTagetOr[] = [
            'shop_id' => $data['target']['shopId'],
            'target_marketplace' => $data['target']['marketplace'],
        ];

        $aggregate[] = [
            '$graphLookup' => [
                'from' => 'product_container',
                'startWith' => '$container_id',
                'connectFromField' => 'container_id',
                'connectToField' => 'container_id',
                'restrictSearchWithMatch' => [
                    'user_id' => $data['user_id'],
                    '$or' => $addTagetOr,
                ],
                'as' => 'variants'
            ]
        ];
        return $aggregate;
    }

    public function handleDefAggregateForProductIds(&$data, &$aggregate, $for = 'getProducts')
    {
        $aggregate[] = [
            '$match' => [
                'user_id' => $data['user_id']
            ]
        ];

        $orCond = $this->sourceCondtions($data, $for);

        $aggregate[] = [
            '$match' => [
                '$or' => $orCond,
            ]
        ];
        if ($for == 'forSourceIds') {
            $this->addOrCondForIds($data['source_product_ids'], $aggregate);
        }
        if ($for == 'getProducts') {
            $this->getProductsAggregateDefBySourceIds($data, $aggregate);
        }
    }

    public function getProductsAggregateDefBySourceIds(&$data, &$aggregate)
    {
        //4
        $allSourceProductIds = $this->getAllSourceIds($data);
        $limit = isset($data['limit']) ? $data['limit'] : $this->defaultLimit;
        $skip = ($data['activePage'] - 1) * $limit;
        $data['next_available'] = ($skip + $limit) < count($allSourceProductIds);
        $data['totalCount'] = count($allSourceProductIds);
        $data['totalPages'] = $data['totalCount'] == 0 ? 1 : ceil($data['totalCount'] / $data['limit']);
        $toIterateonArray = array_splice($allSourceProductIds, $skip, $limit);
        if (count($toIterateonArray) == 0) {
            $aggregate[] = [
                '$match' => [
                    'user_id' => $this->userId . $this->userId . "empty" //here it is to create a condition in which no products will be available
                ]
            ];
        } else {
            //5
            $this->addOrCondForIds($toIterateonArray, $aggregate);
        }
    }

    public function addOrCondForIds($arr, &$aggregate)
    {
        $orCondition = [];
        foreach ($arr as $key => $value) {
            $orCondition[] = ['source_product_id' => (string) $value];
        }

        if (!empty($orCondition)) {
            $aggregate[] = [
                '$match' => [
                    '$or' => $orCondition
                ]
            ];
        }
    }

    public function sourceCondtions($data, $for = 'getProducts')
    {
        $tableTOuse = isset($data['useRefinProduct']) ? ($data['useRefinProduct'] ?  'refine_product' : 'product_container') : 'product_container';

        if ($tableTOuse == 'product_container' || $for == 'getProducts') {
            return [
                [
                    'shop_id' => $data['source']['shopId'],
                    'source_marketplace' => $data['source']['marketplace'],
                ]
            ];
        } else {
            return [
                [
                    'source_shop_id' => $data['source']['shopId']
                ]
            ];
        }
    }

    public function clearInfoFromCache($data)
    {
        $this->di->getCache()->delete((string) $data['data']['params']['unique_key_for_sqs']);
    }

    public function nextPrevActivePageHandle($data, &$aggregate)
    {
        if (isset($data['next'])) {
            $nextDecoded = json_decode(base64_decode($data['next']), true);
            $aggregate[] = [
                '$match' => ['_id' => [
                    '$gt' => $nextDecoded['cursor'],
                ]],
            ];
        } else if (isset($data['prev'])) {
            $nextDecoded = json_decode(base64_decode($data['prev']), true);
            $aggregate[] = [
                '$match' => ['_id' => [
                    '$gte' => $nextDecoded['cursor'],
                ]],
            ];
        } else if (isset($data['activePage'])) {
            $limit = isset($data['limit']) ? $data['limit'] : $this->defaultLimit;
            $aggregate[] = [
                '$skip' => ($data['activePage'] - 1) * $limit
            ];
        }
    }
}
