<?php

namespace App\Connector\Components\Product;

class Hook extends \App\Core\Components\Base
{
    private $ignoreKeys = ['updated_at', '_id', "source_updated_at"];

    public function productCreateOrUpdate($sqsData)
    {
        if (isset($sqsData['app_codes'])) {
            $appCodes = $sqsData['app_codes'];
        } elseif (isset($sqsData['app_code'])) {
            $appCodes[] = $sqsData['app_code'];
        }

        $data = $this->prepareDbData($sqsData);
        $productData = $this->di->getObjectManager()->get('\App\Connector\Components\Product\Data');
        $productRequestControl = $this->di->getObjectManager()->get('\App\Connector\Components\Route\ProductRequestcontrol');

        if ($sqsData['action'] == "product_update" && !isset($sqsData['forceUpdateCreate'])) {
            $productImportActive = $productData->isImportingActive($sqsData);
            if ($productImportActive) return true;
        }

        if (isset($sqsData['data']) && !empty($sqsData['data'])) {
            $marketplace = $sqsData['marketplace'];

            try {
                $moduleHome = ucfirst($marketplace);
                $moduleHook = $this->di->getObjectManager()->get('\App\\' . $moduleHome . '\Components\Product\Hook');
            } catch (\Exception $e) {
                $moduleHome = ucfirst($marketplace) . "home";
                $moduleHook = $this->di->getObjectManager()->get('\App\\' . $moduleHome . '\Components\Product\Hook');
            }

            foreach ($appCodes as  $key => $appCode) {
                $sqsData['app_code'] = $appCode;
                $isSaleChannel = $this->di->getConfig()->apiconnector->$marketplace->$appCode->get('is_saleschannel') ? true : false;
                $sqsData['is_saleschannel'] = $isSaleChannel;
                $sqsData['product_db_data'] = $data;
                $formattedProduct = $moduleHook->formatProductInMarketplace($sqsData);
                //Check product exists in db before update it
                $productExist = $this->isProductExists($formattedProduct, $sqsData);
                if ($sqsData['action'] == "product_create" && $productExist) {
                    return true;
                } else if ($sqsData['action'] == "product_update" && !$productExist) {
                    $durationAfterMsgRemoved = 1;
                    if (isset($sqsData['creation_date'])) {
                        $dateDifference = date_diff(date_create($sqsData['creation_date']), date_create(date('Y-m-d')));
                        $daysDifference = intval($dateDifference->format('%R%a'));
                        // Check if the message is older than 3 days
                        if ($daysDifference >= $durationAfterMsgRemoved) {
                            // Delete the message from the queue
                            return true;
                        }
                    }
                    sleep(30);  //wait for 30 sec before push the message.
                    $sqsData['handle_added'] = 0;
                    if (!isset($sqsData['creation_date'])) $sqsData['creation_date'] = date('Y-m-d');
                    $this->di->getMessageManager()->pushMessage($sqsData);
                    return true;
                }

                if (!empty($formattedProduct['pushToMaindb'])) {
                    $sqsData['data'] = $formattedProduct['pushToMaindb'];
                    if (!isset($data['db_data']) || empty($data['db_data'])) {
                        $data = $this->prepareDbData($sqsData);
                    }
                    $additionalData['shop_id'] =  $sqsData['shop_id'];
                    $additionalData['marketplace'] = $sqsData['marketplace'];
                    $additionalData['isWebhook'] = true;
                    $additionalData['app_code'] = $appCode;
                    $updateOnly = $this->di->getConfig()->get('apiconnector')
                        ->get($marketplace)
                        ->get($appCode)->get('update_only') ?? false;
                    $additionalData['update_only'] = $updateOnly;
                    $productRequestControl->pushToProductContainer($formattedProduct['pushToMaindb'], $additionalData);
                    $productRequestControl->deleteIsExistsKeyAndVariants($sqsData); //vikas
                }
                if (!empty($formattedProduct['pushToTempdb'])) {
                    $sqsData['data'] = $formattedProduct['pushToTempdb'];
                    if (!isset($data['db_data']) || empty($data['db_data'])) {
                        $data = $this->prepareDbData($sqsData);
                    }
                    $productRequestControl->pushInTempContainer($formattedProduct['pushToTempdb'], $marketplace);
                }
                $productData->moveProductsTmpToMain($sqsData);
            }
        }
        $data = $this->prepareUpdatedData($sqsData, $data);
        $data['sqs_data'] = $sqsData;
        return $data;
    }

    public function prepareDbData($sqsData)
    {
        $data = [];
        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $mongoCollection = $mongo->getCollectionForTable('product_container');
        $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
        $containerId = "";

        if (isset($sqsData['data'][0]['container_id']))
            $containerId =  $sqsData['data'][0]['container_id'];
        elseif (isset($sqsData['data']['id']))
            $containerId =  $sqsData['data']['id'];
        elseif (isset($sqsData['data']['product_listing']['product_id']))
            $containerId = $sqsData['data']['product_listing']['product_id'];
        $user_id = $sqsData['user_id'];
        $shopId = $sqsData['shop_id'];
        if ($containerId != "") {
            $filter = ['user_id' => $user_id, 'shop_id' => $shopId, 'container_id' => (string)$containerId, "visibility" => ['$exists' => true]];
            $result = $mongoCollection->find($filter, $options)->toArray();
            $data['db_data'] = $result;
        }

        return $data;
    }

    public function prepareUpdatedData($sqsData, $data)
    {
        if (isset($sqsData['data'][0]['container_id']))
            $containerId =  $sqsData['data'][0]['container_id'];
        elseif (isset($sqsData['data']['id']))
            $containerId =  $sqsData['data']['id'];
        elseif (isset($sqsData['data']['product_listing']['product_id']))
            $containerId = $sqsData['data']['product_listing']['product_id'];

        $user_id = $sqsData['user_id'];
        $shopId = $sqsData['shop_id'];

        $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
        $mongoCollection = $mongo->getCollectionForTable('product_container');
        $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];

        if ($containerId) {
            $filter = ['user_id' => $user_id, 'shop_id' => $shopId, 'container_id' => (string)$containerId, "visibility" => ['$exists' => true]];
            $productsInCollection = $mongoCollection->find($filter, $options)->toArray();
        }
        $data['updated_data'] = [];
        $dbData = $data['db_data'];
        foreach ($productsInCollection as  $product) {
            $isFoundInDbArray = false;
            foreach ($dbData as  $dbKey => $dbProduct) {
                if ($product['source_product_id'] == $dbProduct['source_product_id']) {
                    $fields = [];
                    $isFoundInDbArray = true;
                    unset($dbData[$dbKey]);
                    foreach ($product as $key => $value) {
                        if (in_array($key, $this->ignoreKeys)) continue;

                        if (array_key_exists($key, $dbProduct)) {
                            if ($value != $dbProduct[$key])
                                array_push($fields, $key);
                        } else {
                            array_push($fields, $key);
                        }
                    }
                    if (count($fields)) {
                        if ($product['source_product_id'] == $product['container_id']) {
                            if (!isset($data['updated_data']['update_wrapper']))
                                $data['updated_data']['update_wrapper'] = [];
                            array_push($data['updated_data']['update_wrapper'], ['source_product_id' => $product['source_product_id'], 'fields' => $fields]);
                        } else {
                            if (!isset($data['updated_data']['update_child']))
                                $data['updated_data']['update_child'] = [];
                            array_push($data['updated_data']['update_child'], ['source_product_id' => $product['source_product_id'], 'fields' => $fields]);
                        }
                    }
                }
            }
            if (!$isFoundInDbArray) {
                if ($product['source_product_id'] == $product['container_id']) {
                    if (!isset($data['updated_data']['create_wrapper']))
                        $data['updated_data']['create_wrapper'] = [];
                    array_push($data['updated_data']['create_wrapper'], ['source_product_id' => $product['source_product_id'], 'fields' => []]);
                } else {
                    if (!isset($data['updated_data']['create_child']))
                        $data['updated_data']['create_child'] = [];
                    array_push($data['updated_data']['create_child'], ['source_product_id' => $product['source_product_id'], 'fields' => []]);
                }
            }
        }
        foreach ($dbData as $dbProduct) {
            if ($dbProduct['source_product_id'] == $dbProduct['container_id']) {
                if (!isset($data['updated_data']['delete_wrapper']))
                    $data['updated_data']['delete_wrapper'] = [];
                array_push($data['updated_data']['delete_wrapper'], ['source_product_id' => $dbProduct['source_product_id'], 'fields' => []]);
            } else {
                if (!isset($data['updated_data']['delete_child']))
                    $data['updated_data']['delete_child'] = [];
                array_push($data['updated_data']['delete_child'], ['source_product_id' => $dbProduct['source_product_id'], 'fields' => []]);
            }
        }
        return $data;
    }

    public function productDelete($sqsData)
    {
        $data = $this->prepareDbData($sqsData);
        $productData = $this->di->getObjectManager()->get('\App\Connector\Components\Product\Data');
        $productContainer = $this->di->getObjectManager()->get('\App\Connector\Models\ProductContainer');
        $productContainer->setSource("product_container");
        #TODO: handle product deletion from refine_product collection
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $productCollection = $mongo->getCollectionForTable('product_container');
        $marketplaceObject = $this->di->getObjectManager()->get('\App\Connector\Models\Product\Marketplace');
        $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
        $this->di->getLog()->logContent("INSIDE PRODUCT DELETE FUNCTION:\nWEBHOOK DATA:\n user_id => " . print_r($sqsData['user_id'], true) . "\n shop_id => " . print_r($sqsData['shop_id'], true)."\n container_id=>". $sqsData['data']['id'], 'info', 'webhook'.DS.'product_delete'.DS.date("Y-m-d") .DS. $sqsData['user_id'] . 'sqs.log');
        $productImportActive = $productData->isImportingActive($sqsData);
        if ($productImportActive) return true;

        $aggregation = [
            ['$match' => ['container_id' => (string)$sqsData['data']['id'], 'user_id' => $sqsData['user_id'], 'shop_id' => $sqsData['shop_id'], 'visibility' => ['$exists' => true]]],
            ['$unwind' => '$marketplace'],
            ['$project' => ['_id' => 0, 'source_product_id' => 1, 'visibility' => 1, 'shop_id' => 1]]
        ];

        $deleteArrays = $productCollection->aggregate($aggregation, $options)->toArray();

        if (empty($deleteArrays)) return true;
        $modifiedDeleteArrays = [];
        foreach ($deleteArrays as $deleteArray) {
            array_push($modifiedDeleteArrays, [
                'type' => $deleteArray['visibility'],
                "source_product_id" => $deleteArray['source_product_id'],
                'source_shop_id' => $deleteArray['shop_id'] ?? ''
            ]);
        }
        if (isset($sqsData['data']['id'])) {
            $sqsData['deleteArray'] = $modifiedDeleteArrays;
            $marketplaceObject->marketplaceDelete($sqsData);
            $response = $productContainer->deleteProduct(['source_product_id' => (string)$sqsData['data']['id']]);
            $this->di->getLog()->logContent("PRODUCT DELETE RESPONSE => ".print_r($response,true), 'info', 'webhook'.DS.'product_delete'.DS.date("Y-m-d") . DS . $sqsData['user_id'] . 'response.log');
        }
        $data['sqs_data'] = $sqsData;
        return $data;
    }

    public function isProductExists($data, $sqsData)
    {
        $data = $data['pushToMaindb'] ?? $data['pushToTempdb'];
        if (empty($data)) return true;
        $productContainer = $this->di->getObjectManager()->get('\App\Connector\Models\ProductContainer');
        $productContainer->setSource("product_container");
        $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
        $filter = ['user_id' => (string)$sqsData['user_id'], 'shop_id' => (string)$sqsData['shop_id'], 'container_id' => (string)$data[0]['container_id']];
        $response  = $productContainer->find($filter, $options)->toArray();
        if (!empty($response)) return true;
        return false;
    }
}
