<?php

namespace App\Connector\Components\Order;

class Shipment extends \App\Core\Components\Base
{
    /**
     * intiateShipment function
     * To call source and target marketplace functions
     * @param [array] $data
     * @return array
     */
    public function initiateShipment($data)
    {
        $className = \App\Connector\Contracts\Sales\Order\ShipInterface::class;
        $sourceShipmentService = $this->di->getObjectManager()->get($className, [], $data['marketplace']);
        $moldData = $sourceShipmentService->mold($data);
        if (!empty($moldData)) {
            $connectorShipmentService = $this->di->getObjectManager()->get($className, []);
            $savedData = $connectorShipmentService->ship($moldData);
            if (isset($savedData['success']) && $savedData['success']) {
                $targetShipmentService = $this->di->getObjectManager()->get($className, [], $savedData['data']['marketplace']);
                $targetShipmentService->ship($savedData['data']);
                return ['success' => true, 'message' => "Shipment Initiated"];
            } else {
                return ['success' => false, 'message' => $savedData['message']];
            }
        } else {
            return ['success' => false, 'message' => 'Data not found'];
        }
    }
}
