let feed_server_side_details = db.feed_server_side.findOne({ '_id': ObjectId(id) });

let data = feed_server_side_details['data'];

class UpdateTargetMarketplace {

    constructor(product_container) {
        this.setLimit = 5000;
        this.filter_table = db.refine_product;
        this.limitLeft = this.setLimit;
        this.product_container = product_container;
        this.bulk = this.filter_table.initializeUnorderedBulkOp();
        this.initiateTargetUpdate();
    }


    initiateTargetUpdate() {

        let data = this.product_container.aggregate(this.getAggregate());

        let t0 = new Date();
        let i = 0;
        data.forEach((eachRow) => {
            this.limitLeft--;

            let producProfile =eachRow['profile'];
            let len = producProfile.length;
            for (let i = 0; i < len; i++) {

                let targetSourceInfo = {
                    targetId : producProfile[i]['target_shop_id'] ,
                    sourceId : eachRow['shop_id']
                }
                this.bulk.find(this.findQuery(eachRow,targetSourceInfo)).update({
                    '$set' : this.dataToUpdate(eachRow , producProfile[i],targetSourceInfo)
                })
            }

            if (this.limitLeft == 0) {
                this.updateMongo();
            }
        });
        if (this.limitLeft < this.setLimit) {
            this.updateMongo();
        }
        let t1 = new Date();

        print(t1 - t0 + ' milisecounds taken');
        db.feed_server_side.deleteOne({'_id': ObjectId(id)});
    }

    dataToUpdate(product, producProfile, targetSourceInfo) {
        return {
            ...this.findQuery(product ,targetSourceInfo),
            profile : producProfile
        }
    }

    findQuery(product, targetSourceInfo) {
        return {
            user_id: product['user_id'],
            container_id: product['container_id'],
            source_product_id: product['source_product_id'],
            target_shop_id: targetSourceInfo.targetId,
            source_shop_id : targetSourceInfo.sourceId
        }
    }

    updateMongo() {
        this.bulk.execute();
        this.bulk = this.filter_table.initializeUnorderedBulkOp();
        this.limitLeft = this.setLimit;
    }

    getAggregate() {
        let aggregate = [];
        aggregate.push({
            '$match': {
                'old_profile.profile_id': { '$in': data }
            }
        });
        return aggregate;
    }
}

var connection = new UpdateTargetMarketplace(db.product_container);