<?php

namespace App\Connector\Components\Migration\NewProfile;

use App\Core\Models\BaseMongo;

class ProfileConversion extends BaseMongo
{
    public $idsToArrayMap = [];

    public $maintainAttributeIds = [];

    public $table = 'profile';

    public $newProfileProductKey = 'profile';

    public $sourceMarketplace;

    public $userId = '';

    public $shopIds = [];

    public $profileId = null;

    public $dbConfig;

    public $amazonMultiDatabaseInfo;

    public $amazonMultiDatabaseInfoRemote;

    public $homeCopyDatabaseInfo;

    public $amazonMultiHome;

    public $homeCopy;

    public function setDbSource($database)
    {

        $dsn =  $database['host'];
        $mongo = new \MongoDB\Client($dsn, array("username" => $database['username'], "password" => $database['password']));
        $mongo =  $mongo->selectDatabase($database['dbname']);

        return $mongo;
    }

    public function init($data = [])
    {
        $this->dbConfig = $this->di->getConfig()->get('databases')->toArray();

        $this->amazonMultiDatabaseInfo = $this->dbConfig['db_mongo'];

        $this->amazonMultiDatabaseInfoRemote = $this->dbConfig['multiRemote'];

        $this->homeCopyDatabaseInfo = $this->dbConfig['singleHome'];
        $this->amazonMultiHome = $this->setDbSource($this->amazonMultiDatabaseInfo);
        $this->homeCopy = $this->setDbSource($this->homeCopyDatabaseInfo);
        if (isset($data['user_id'])) {
            $this->userId = $data['user_id'];
        } else {
            // $this->userId = $this->di->getUser()->id;
        }
    }



    /*
    @profile save and update start
     */
    public function validateData($data)
    {
        return (isset($data['name']) && isset($data['category_id']));
    }

    public function updateToMongoInstance(&$data, $key)
    {
        if (!($data[$key] instanceof \MongoDB\BSON\ObjectID)) {
            $data[$key] = new \MongoDB\BSON\ObjectId($data[$key]['$oid']);
        }
    }

    public function saveChunk(&$data)
    {
        $data['user_id'] = $this->userId;
        $profileTable = $this->amazonMultiHome->selectCollection($this->table);
        if (isset($data['_id'])) {
            $this->updateToMongoInstance($data, '_id');
            if ($data == $this->checkPresentReturnValue((string)$data['_id'], $this->idsToArrayMap)) {
                return $data['_id'];
            }
        }
        if (isset($data['profile_id'])) {
            $this->updateToMongoInstance($data, 'profile_id');
        }
        $mongo = isset($data['_id']) ? $profileTable->updateOne(['_id' => $data['_id']], ['$set' => $data]) : $profileTable->insertOne($data);
        return isset($data['_id']) ? $data['_id'] : $mongo->getInsertedId();
    }

    public function saveProfileData($data)
    {
        $profileId = $this->saveChunk($data['profile']);
        unset($data['profile']);
        foreach ($data as $key => $value) {
            foreach ($value as $keyV => $val) {
                if (!(isset($val['profile_id']))) {
                    $val['profile_id'] = $profileId;
                    $this->saveChunk($val);
                }
            }
        }
        return $profileId;
    }

    public function &checkPresentReturnValue($key, &$data)
    {
        $returnval = [];
        if (isset($data[$key])) {
            $returnval = &$data[$key];
        }
        return $returnval;
    }

    public function unsetData(&$obj, $key)
    {
        if (isset($obj[$key])) {
            unset($obj[$key]);
        }
    }

    public function checkObjectPresentInArray($obj, $arr, $keyChecking)
    {
        $this->unsetData($obj, '_id');
        $this->unsetData($obj, 'type');
        $this->unsetData($obj, 'user_id');
        foreach ($arr as $key => $value) {
            $id = $value['_id'];

            $this->unsetData($value, 'type');
            if ($keyChecking == 'attributes_mapping') {
                $value = $value['data'];
            }
            $this->unsetData($value, '_id');
            $this->unsetData($value, 'user_id');
            if ($obj == $value) {
                return $id;
            }
        }
        return false;
    }

    public function attributeMappingStructured($attributeData, &$dataToUpdateProfileId, &$mainData)
    {
        if (count($attributeData) == 0) {
            return false;
        }
        $dataToSend = [];
        $dataToSend['type'] = 'attribute';
        $dataToSend['data'] = $attributeData;
        $CheckIdPresent = $this->checkObjectPresentInArray($attributeData, $this->checkPresentReturnValue('attributes_mapping', $dataToUpdateProfileId), 'attributes_mapping');
        if (isset($attributeData['_id'])) {
            $dataToSend['_id'] = $attributeData['_id'];
            $this->updateToMongoInstance($dataToSend, '_id');
            $dataToSend['data']['_id'] = $dataToSend['_id'];
        }

        $dataToSend['_id'] = $CheckIdPresent ? $CheckIdPresent : $this->saveChunk($dataToSend);

        $attrInfos = &$dataToUpdateProfileId['attributes_mapping'];

        if (isset($attrInfos[(string)$dataToSend['_id']]) && !$CheckIdPresent) {
            unset($dataToSend['_id']);
            unset($dataToSend['data']['_id']);
            $dataToSend['_id'] = $this->saveChunk($dataToSend);
            $dataToSend['data']['_id'] = $dataToSend['_id'];
            $CheckIdPresent = $dataToSend['_id'];
        }

        $attrInfos[(string)$dataToSend['_id']] = $dataToSend;
        $mainData['attributes_mapping'] = $dataToSend['_id'];
    }

    public function warehousesAndShopsMappingStructured(&$warehouseOrShopData, &$dataToUpdateProfileId, $keyToMap)
    {
        $dataToSend = $warehouseOrShopData;
        $dataToSend['type'] = $keyToMap == 'shops' ? 'shop' : 'warehouse';
        $CheckIdPresent = $this->checkObjectPresentInArray($warehouseOrShopData, $this->checkPresentReturnValue($keyToMap, $dataToUpdateProfileId), $keyToMap);
        if (isset($dataToSend['_id'])) {
            $this->updateToMongoInstance($dataToSend, '_id');
        } else {
        }
        $dataToSend['_id'] = $CheckIdPresent ? $CheckIdPresent : $this->saveChunk($dataToSend);
        $nameId = $keyToMap == 'shops' ? 'shop_id' : 'warehouse_id';
        $warehouseOrShopData = [
            $nameId => $dataToSend[$nameId],
            'id' => $dataToSend['_id'],
        ];
        !$CheckIdPresent && $dataToUpdateProfileId[$keyToMap][] = $dataToSend;
    }


    public function iterateTillSourceWarehouse(&$data, &$dataToUpdateProfileId)
    {
        $dataToIterateOn = ['targets', 'shops', 'sources', 'warehouses'];
        for ($i = 0; $i < 4; $i++) {
            $keyItem = $dataToIterateOn[$i];
            if (isset($data[$keyItem])) {
                $val = &$data[$keyItem];
                foreach ($val as $key => &$value) {
                    $this->attributeMappingStructured($this->checkPresentReturnValue('attributes_mapping', $value), $dataToUpdateProfileId, $value);
                    $this->iterateTillSourceWarehouse($value, $dataToUpdateProfileId);

                    if ($keyItem == 'warehouses' || $keyItem == 'shops') {
                        $this->warehousesAndShopsMappingStructured($value, $dataToUpdateProfileId, $keyItem);
                    }
                }
                if ($keyItem == 'warehouses' || $keyItem == 'shops') {
                    $val = array_values($val);
                }
                break;
            }
        }
    }

    public function getShoppIds($data, $key, $target_id = null)
    {
        $targetIds = [];
        $sourceIds = [];
        if (isset($data[$key])) {
            foreach ($data[$key] as $key => $value) {
                foreach ($value['shops'] as $sKey => $sValue) {
                    $targetIds[] = $sValue['shop_id'];
                    if ($target_id) {
                        $this->shopIds[] = [
                            'source' => $sValue['shop_id'],
                            'target' => $target_id
                        ];
                    }
                    if (isset($sValue['warehouses'][0]['sources'])) {
                        $sourceIds = array_unique(array_merge($this->getShoppIds($sValue['warehouses'][0], 'sources', $sValue['shop_id'])['targets'], $sourceIds));
                    }
                }
            }
        }
        return ['targets' => $targetIds, 'sources' => $sourceIds];
    }

    public function pushProfileIdArr($name, $targetIds, $savedProfileId, $type = 'query')
    {
        $pushArr = [];

        foreach ($targetIds as $key => $value) {
            $pushArr[] = [
                'profile_id' => $savedProfileId,
                'profile_name' => $name,
                'target_shop_id' => $value,
                'type' => $type
            ];
        }
        return $pushArr;
    }

    public function getProfileId(&$data)
    {
        if (isset($data['_id'])) {
            $this->profileId = $data['_id'];
        } else {
            $dummyInfo = ['type' => 'profile'];
            $this->profileId = $this->saveChunk($dummyInfo);
            $data['_id'] = $this->profileId;
        }
    }



    public function saveProfile($params)
    {
        $data = $params['data'];
        $this->init($data);
        if ($this->validateData($data)) {
            $shopIds = $this->getShoppIds($data, 'targets');
            $targetIds = $shopIds['targets'];
            if ($this->validateProfieName(array_merge(['name' => $data['name']], $this->shopIds[0]))['success'] == false) {
                return ['success' => false];
            }

            $dataToUpdateProfileId = [];

            $this->getProfileId($data);

            $this->attributeMappingStructured($this->checkPresentReturnValue('attributes_mapping', $data), $dataToUpdateProfileId, $data);

            $this->iterateTillSourceWarehouse($data, $dataToUpdateProfileId);

            $data['type'] = 'profile';

            $data['shop_ids'] = $this->shopIds;

            $dataToUpdateProfileId['profile'] = $data;

            $savedProfileId = $this->saveProfileData($dataToUpdateProfileId);

            if (isset($data['query']) && $data['query'] !== "") {
                $this->amazonMultiHome->selectCollection('product_container')->updateMany(['old_profile.profile_id' => $data['old_profile_id']], [
                    '$pull' => [$this->newProfileProductKey => ['target_shop_id' => ['$in' => $targetIds]]],
                ]);

                $res = $this->amazonMultiHome->selectCollection('product_container')->updateMany(['old_profile.profile_id' => $data['old_profile_id']], [
                    '$push' => [$this->newProfileProductKey => ['$each' => $this->pushProfileIdArr($data['name'], $targetIds, $savedProfileId, 'query')]]
                ]);

                $this->di->getLog()->logContent('profile_id_processed = ' . json_encode((['user_id' => $this->userId, 'old_profile_id' => $data['old_profile_id'], 'new_profile_id' => (string)$savedProfileId, 'response' => $res->getModifiedCount(), 'message' => 'profile_id_aaya ']), true), 'info', 'profileMigrate.log');
            }
            return ['success' => true, 'message' => 'Saved Successfully', 'profile_id' => $savedProfileId];
        } else {
            return ['success' => false, 'message' => 'category_id or name missing', 'code' => 'data_missing'];
        }
    }

    /*
    @profile save and update end
     */



    /*
    @profile get start
     */


    public function getProfileFormattedDataAndIdsMapping($idStr, $data = [])
    {

        $id = $idStr != "" ? new \MongoDB\BSON\ObjectId($idStr) : "";
        $condition = [];
        if ($idStr == "") {
            $condition[] = [
                '$match' => ["type" => "profile"]
            ];
            $condition[] = [
                '$lookup' => [
                    'from' => 'product_container',
                    'as' => 'product_count',
                    'let' => ['profile_id' => '$_id', 'type' => '$type'],
                    'pipeline' => [
                        [
                            '$match' => [
                                'user_id' => $this->userId,
                                '$expr' => [
                                    '$eq' => ['$$type', 'profile']
                                ],
                            ],
                        ],
                        [
                            '$match' => [
                                'visibility' => 'Catalog and Search'
                            ]
                        ],
                        [
                            '$match' => [
                                '$expr' => [
                                    '$eq' => [[
                                        '$reduce' => [
                                            "input" => '$profile', 'initialValue' => false,
                                            'in' =>
                                            [
                                                '$cond' => [
                                                    'if' => [
                                                        '$eq' => ['$$value', true]
                                                    ],
                                                    'then' => true,
                                                    'else' => [
                                                        '$eq' => ['$$this.profile_id', '$$profile_id']
                                                    ]
                                                ]
                                            ]
                                        ]
                                    ], true]
                                ]
                            ]
                        ],
                        [
                            '$count' => 'count'
                        ]
                    ]
                ]
            ];
            $condition[] = [
                '$match' => [
                    'shop_ids' => [
                        '$elemMatch' => [
                            'target' => $this->di->getRequester()->getTargetId(),
                            'source' => $this->di->getRequester()->getSourceId()
                        ]
                    ]
                ]
            ];
        } else {
            $condition[] = [
                '$match' => [
                    '$or' => [
                        ['profile_id' => $id], ['_id' => $id]
                    ]
                ]
            ];
        }
        if (isset($data['all_profile_name'])) {
            $condition[] = [
                '$group' => [
                    '_id' => '$name'
                ]
            ];
        }
        $profileArray = $this->homeCopy->selectCollection($this->table)->aggregate($condition)->toArray();
        $formattedData = [];

        if (isset($data['all_profile_name'])) {
            $arr = [];
            foreach ($profileArray as $k => $v) {
                $arr[] = $v['_id'];
            }
            return $arr;
        }

        foreach ($profileArray as $key => $value) {
            if ($value['type'] == 'profile') {
                $formattedData[] = $value;
            }
            $id = (string)$value['_id'];
            $this->idsToArrayMap[$id] = $value;
        }
        return $formattedData;
    }

    public function unwindAttributeData(&$attributeArray)
    {
        if (count((array) $attributeArray) == 0) {
            return false;
        }
        $id = (string)$attributeArray;
        $attributeData = isset($this->idsToArrayMap[$id]) ? clone ($this->idsToArrayMap[$id]['data']) : [];
        $attributeData['_id'] = $attributeArray;
        $attributeArray = $attributeData;
    }


    public function mergeAllArrays(&$profileMainArray)
    {
        $arr = ['targets', 'shops', 'warehouses', 'sources'];
        for ($i = 0; $i < 4; $i++) {
            $keyItem = $arr[$i];
            if (isset($profileMainArray[$keyItem])) {
                $val = &$profileMainArray[$keyItem];
                foreach ($val as $key => &$value) {
                    if ($keyItem == 'shops' || $keyItem == 'warehouses') {
                        $value = isset($this->idsToArrayMap[(string)$value['id']]) ?  clone ($this->idsToArrayMap[(string)$value['id']]) : [];
                        unset($value['user_id']);
                    }
                    if (isset($value['attributes_mapping'])) {
                        $this->unwindAttributeData($value['attributes_mapping']);
                    }
                    $this->mergeAllArrays($value);
                }
            }
        }
    }

    public function idValid($id)
    {
        return $id instanceof \MongoDB\BSON\ObjectID
            || preg_match('/^[a-f\d]{24}$/i', $id);
    }

    public function getProfileData($data)
    {
        $this->init($data);
        if (isset($data['id']) && !$this->idValid($data['id'])) {
            return ['success' => false, 'message' => 'Invalid Profile ID', 'code' => 'invalid_profie_id'];
        }
        $id = isset($data['id']) ? $data['id'] : "";
        $profileMainArray = $this->getProfileFormattedDataAndIdsMapping($id, $data);
        if (count($profileMainArray) == 0) {
            return ['success' => false, 'message' => 'Wrong Profile ID', 'code' => 'wrong_profie_id'];
        }
        if ($id == "") {
            if (isset($data['all_profile_name'])) {
                return ['success' => true, 'data' => $profileMainArray];
            }
            if (isset($data['activePage']) && isset($data['count'])) {
                $countT = count($profileMainArray);
                $activePage = $data['activePage'];
                $count = $data['count'];
                $skip = ($activePage - 1) * $count;
                $next = ($skip + $count) < $countT;
                $toIterateonArray = array_splice($profileMainArray, $skip, $count);
                return ['success' => true, 'data' => $toIterateonArray, 'total_count' => $countT, 'next' => $next];
            } else {
                return ['success' => false, 'message' => 'ActivePage or Count Missing', 'code' => 'data_missing'];
            }
        }
        $dataAllProfiles = [];
        $len = 0;

        foreach ($profileMainArray as $key => $profileData) {
            $len++;
            $this->unwindAttributeData($profileData['attributes_mapping']);

            $this->mergeAllArrays($profileData);

            $dataAllProfiles[] = $profileData;
        }

        return ['success' => true, 'data' => $dataAllProfiles, 'count' => $len];
    }

    /*
    @profile get end
     */

    public function deleteProfile($data)
    {
        $this->init($data);
        if (!isset($data['id'])) {
            return ['success' => false, 'message' => 'No Profile id given', 'code' => 'missing_data'];
        }
        if (isset($data['id']) && !$this->idValid($data['id'])) {
            return ['success' => false, 'message' => 'Invalid Profile ID', 'code' => 'invalid_profie_id'];
        }
        $id = new \MongoDB\BSON\ObjectId($data['id']);
        $condition = [
            '$or' => [
                ['profile_id' => $id], ['_id' => $id]
            ]
        ];
        $this->homeCopy->selectCollection($this->table)->deleteMany($condition);

        return ['success' => true, 'message' => 'Successfully deleted'];
    }


    public function getAggregateForName($data)
    {
        $aggregate = [];
        $aggregate[] = [
            '$match' => [
                'user_id' => $this->userId,
                'type' => 'profile'
            ]
        ];
        $aggregate[] = [
            '$match' => [
                'shop_ids' => [
                    '$elemMatch' => [
                        'target' => $data['target'],
                        'source' => $data['source']
                    ]
                ]
            ]
        ];
        $aggregate[] = [
            '$project' => ['name' => 1]
        ];
        return $aggregate;
    }


    public function validateProfieName($data)
    {
        if (!isset($data['name'])) {
            return ['success' => false, 'message' => 'Send Name', 'code' => 'data_missing'];
        }

        $profile = $this->amazonMultiHome->selectCollection($this->table)->aggregate($this->getAggregateForName($data))->toArray();

        $toValidateName = $data['name'];
        $correctName = true;
        foreach ($profile as $key => $value) {
            if ($value['name'] == $toValidateName) {
                $correctName = false;
            }
        }

        if ($correctName) {
            return ['success' => true, 'message' => 'unique name'];
        } else {
            return ['success' => false, 'message' => 'Duplicate name', 'code' => 'duplicate_name'];
        }
    }
}
