<?php

namespace App\Connector\Components\Migration\NewProfile;

use App\Core\Models\BaseMongo;

use GuzzleHttp\Client;

use function GuzzleHttp\json_encode;

class NewProfile extends BaseMongo
{
    public $tableOldProfile = 'profiles';

    public $tableSettings = 'profile_settings';

    public $userId = "";

    public $DbConfig;

    public $amazonMultiDataBaseInfo;

    public $amazonMultiDataBaseInfoRemote;

    public $homeCopyDatabaseInfo;

    public $amazonMultiHome;

    public $homeCopy;

    public $amazonMultiRemoteCopy;

    public $queryToMap = [
        '%LIKE%' => 'contains',
        '!%LIKE%' => 'does not contains',
        '==' =>  'equals',
        '!=' => 'not equals',
        '>' => 'greater than',
        '<' => 'less than',
        '>=' => 'greater than or equal to',
        '<=' => 'less than or equal to'
    ];



    public function setDbSource($database, $dbName = false)
    {

        $dsn =  $database['host'];
        $mongo = new \MongoDB\Client($dsn, array("username" => $database['username'], "password" => $database['password']));
        $mongo =  $mongo->selectDatabase($database['dbname']);

        return $mongo;
    }


    public function init($data = [])
    {
        $this->DbConfig = $this->di->getConfig()->get('databases')->toArray();

        $this->amazonMultiDataBaseInfo = $this->DbConfig['db_mongo'];

        $this->amazonMultiDataBaseInfoRemote = $this->DbConfig['multiRemote'];

        $this->homeCopyDatabaseInfo = $this->DbConfig['singleHome'];
        $this->amazonMultiHome = $this->setDbSource($this->amazonMultiDataBaseInfo);
        $this->homeCopy = $this->setDbSource($this->homeCopyDatabaseInfo);
        $this->amazonMultiRemoteCopy = $this->setDbSource($this->amazonMultiDataBaseInfoRemote);;


        if (isset($data['user_id'])) {
            $this->userId = $data['user_id'];
        } else {
            $this->userId = $this->di->getUser()->id;
        }
    }

    public function warehouse($profile)
    {
        foreach ($profile['targets'] as $targetName => $targetValue) {
        }
    }

    public function getprofileSettings($id)
    {
        $settings = $this->homeCopy->selectCollection($this->tableSettings)->find(['_id' => (int)$id])->toArray()[0];
        return $settings;
    }

    public function unsetData(&$data, $unseArr)
    {
        foreach ($unseArr as $k => $v) {
            unset($data[$v]);
        }
    }

    public function getCategory($categorySettings, $targetId)
    {
        $additonaData = ['user_id' => $this->userId, 'target' => ['shopId' => $targetId]];
        $res = $this->di->getObjectManager()->get('\App\Amazon\Components\Common\Helper')->getBrowseNode(array_merge((array)$categorySettings, (array)$additonaData));
        if ($res['success']) {
            return $res['response'];
        } else {
            return [];
        }
    }

    public function prepareData($data)
    {
        $temp = [];
        foreach ($data as $k => $v) {
            $val = $this->getprofileSettings($v['id']);
            $val['data_type'] = $val['type'] . '_settings';
            if ($val['data_type'] == 'product_settings') {
                if (isset($val['data']['selected_attributes'])) {
                    foreach ($val['data']['selected_attributes'] as $selK => $selV) {
                        if ($selV == 'product_syncing') {
                            $val['data']['product_details'] = true;
                        }
                        $val['data'][$selV] = true;
                    }
                }
            }
            if ($val['data_type'] == 'pricing_settings') {
                $val['data']['data_type'] = 'price_settings';
            } else {
                $val['data']['data_type'] = $val['data_type'];
            }
            $this->unsetData($val, ['_id', 'marketplace', 'merchant_id', 'type']);
            $temp[] = $val;
        }
        return $temp;
    }

    public function formateToNewProfile($targetId, $sourceId, $sourceWarehouseIds, $globalSettings, $profileInfo)
    {
        $createProfile = [];
        $warehouseIds = array_keys((array)$profileInfo['warehouses']);
        $warehouseValue = array_values((array)$profileInfo['warehouses']);

        $data = $warehouseValue[0]['data'];

        $categorySettings = $this->getprofileSettings($data['category_setting']['id']);

        $attributeMapping = $categorySettings['data']['attributes_mapping'];

        unset($categorySettings['data']['attributes_mapping']);

        unset($data['category_setting']);

        $categorySettings = $categorySettings['data'];

        if ($categorySettings['browser_node_id'] != "0") {
            $newCategoryInfo = $this->getCategory($categorySettings, $targetId);
            if (isset($newCategoryInfo['displayPath']) && $newCategoryInfo['displayPath']) {
                $categorySettings['displayPath'] = $newCategoryInfo['displayPath'];
            }
            if (isset($newCategoryInfo['parentNodes']) && $newCategoryInfo['parentNodes']) {
                $categorySettings['parentNodes'] = $newCategoryInfo['parentNodes'];
            }
        } elseif ($categorySettings['primary_category'] == 'default') {
            $categorySettings['browser_node_id'] = 'default';
            $categorySettings['displayPath'] = ['Default'];
            $categorySettings['parentNodes'] = [];
        }

        $dataToSave = $this->prepareData($data);

        $shopIDs = [
            [
                'source' => $sourceId,
                'target' => $targetId
            ]
        ];
        $createProfile = clone ($globalSettings);
        $this->unsetData($createProfile, ['query', 'settings', 'profile_id', '_id']);

        $createProfile['query'] = $globalSettings['query']['query'];
        $createProfile['queryArray'] = array_values((array)$globalSettings['query']['queryArray']);
        $queryArray = &$createProfile['queryArray'];
        foreach ($queryArray as $index => &$queryValue) {
            foreach ($queryValue as $indexK => &$queryValueV) {
                $queryValueV['condition'] = $this->queryToMap[$queryValueV['condition']];
                if ($queryValueV['attribute'] == 'variant_attribute') {
                    $queryValueV['attribute'] = 'variant_attributes';
                }
            }
        }

        $createProfile['shop_ids'] = $shopIDs;
        $createProfile['category_id'] = $categorySettings;

        $attributeMapping['required_attribute'] = array_values((array)$attributeMapping['required_attribute']);
        $attributeMapping['optional_attribute'] = array_values((array)$attributeMapping['optional_attribute']);

        $createProfile['attributes_mapping'] = $attributeMapping;
        $createProfile['overWriteExistingProducts'] = false;
        $createProfile['data'] = $dataToSave;
        $createProfile['old_profile_id'] = $globalSettings['profile_id'];
        $createProfile['manual_product_ids'] = [];

        $sourceWarehouse = [];

        foreach ($sourceWarehouseIds as $k => $v) {
            $sourceWarehouse[] = [
                'warehouse_id' => $v,
                'active' => 1,
                'data' => $dataToSave,
                'attributes_mapping' => $attributeMapping
            ];
        }

        $sourceShop[] =
            [
                'shop_id' => $sourceId,
                'active' => 1,
                'warehouses' => $sourceWarehouse,
                'data' => $dataToSave,
                'attributes_mapping' => $attributeMapping
            ];

        $sources[] =
            [
                'source_marketplace' => 'shopify',
                'data' => $dataToSave,
                'attributes_mapping' => $attributeMapping,
                'shops' => $sourceShop
            ];

        $targetWarehouseIds = [];
        foreach ($warehouseIds as $k => $v) {
            $targetWarehouseIds[] = [
                'warehouse_id' => $v,
                'active' => 1,
                'data' => $dataToSave,
                'attributes_mapping' => $attributeMapping,
                'sources' => $sources
            ];
        }

        $targetShop[] =
            [
                'shop_id' => $targetId,
                'active' => 1,
                'warehouses' => $targetWarehouseIds
            ];

        $target[] =
            [
                'target_marketplace' => 'amazon',
                'category_id' => $categorySettings,
                'data' => $dataToSave,
                'attributes_mapping' => $attributeMapping,
                'shops' => $targetShop,
            ];
        $createProfile['targets'] = $target;

        $obj = (new \App\Connector\Components\Migration\NewProfile\ProfileConversion)->saveProfile(['data' => $createProfile, 'user_id' => $this->userId]);
    }

    public function getSourceIdAndWarehouseIds($shops)
    {
        $sourceId = "";
        $warehouseIds = [];
        foreach ($shops as $shopK => $shopV) {
            if ($shopV['marketplace'] == 'shopify') {
                $sourceId = $shopV['_id'];
                foreach ($shopV['warehouses'] as $k => $v) {
                    $warehouseIds[] = $v['_id'];
                }
                break;
            }
        }
        return ['source_id' => $sourceId, 'warehouse_ids' => $warehouseIds];
    }

    public function getNewTarget($shopsData, $sourceShop)
    {
        $targets = [];
        foreach ($shopsData as $k => $v) {
            if ($v['_id'] == $sourceShop && $v['marketplace'] == 'shopify') {
                $targets = $v['targets'];
            }
        }
        return $targets;
    }

    public function testProfile($data)
    {
        if (!isset($data['user_id'])) {
            return ['success' => false, 'message' => 'need user_id'];
        }
        $this->init($data);
        $profileTable = $this->homeCopy->selectCollection($this->tableOldProfile);

        $allUserProfiles = $profileTable->find(['user_id' => $this->userId])->toArray();

        $userDetails =  $this->homeCopy->selectCollection('user_details')->find(['user_id' => $this->userId])->toArray()[0];

        if (count($userDetails) == null) {
            $this->di->getLog()->logContent('profile = ' . json_encode((['user_id' => $this->userId, 'message' => 'no mentioned user found in homecopy DB']), true), 'info', 'profileMigrate.log');
            return ['success' => false, 'message' => 'no mentioned user found in homecopy DB'];
        }

        $info = $this->getSourceIdAndWarehouseIds($userDetails['shops']);

        $userDetailsNew = $this->amazonMultiHome->selectCollection('user_details')->find(['user_id' => $this->userId])->toArray()[0];

        if (count($userDetailsNew) == null) {
            $this->di->getLog()->logContent('profile = ' . json_encode((['user_id' => $this->userId, 'message' => 'no mentioned user found in amazonmulti DB']), true), 'info', 'profileMigrate.log');
            return ['success' => false, 'message' => 'no mentioned user found in amazonmulti DB'];
        }
        $allProfileIds = [];
        $targetsConnectedTo = $this->getNewTarget($userDetailsNew['shops'], $info['source_id']);

        if (count($targetsConnectedTo) == 0) {
            $this->di->getLog()->logContent('profile = ' . json_encode((['user_id' => $this->userId, 'targetsConnectedTo' => $targetsConnectedTo, 'message' => '$targetsConnectedTo count 0 ']), true), 'info', 'profileMigrate.log');
        }

        foreach ($allUserProfiles as $k => $profiles) {
            $globalSettings = clone ($profiles);
            $sourceId = $info['source_id'];
            $sourceWarehouseIds = $info['warehouse_ids'];
            $allProfileIds[] = $profiles['profile_id'];
            unset($globalSettings['targets']);

            $shopValue = array_values((array)$profiles['targets']['amazon']['shops'])[0];
            if ($sourceId) {
                foreach ($targetsConnectedTo  as $targetkey => $targetValue) {
                    $this->formateToNewProfile((string)$targetValue['shop_id'], (string)$sourceId, $sourceWarehouseIds, $globalSettings, $shopValue);
                }
            } else {
                $this->di->getLog()->logContent('profile = ' . json_encode((['user_id' => $this->userId, 'source_id' => $sourceId, 'message' => '$sourceId problem ']), true), 'info', 'profileMigrate.log');
            }
        }
        $this->updateRefineTableProfileData($allProfileIds);
        $this->di->getLog()->logContent('profile = ' . json_encode((['user_id' => $this->userId, 'count_profiles' => count($allUserProfiles), 'message' => 'Migration successfull ']), true), 'info', 'profileMigrate.log');

        return ['success' => true, 'die' => $data, 'y' => $allUserProfiles];
    }

    public function updateRefineTableProfileData($ids)
    {
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $feedServerSide = $mongo->getCollectionForTable('feed_server_side');

        $infoR = $feedServerSide->insertOne(['data' => $ids]);

        $id = (string)$infoR->getInsertedId();

        $idTo = "'$id'";

        $mongoInfo = $this->di->getConfig()->get('databases')['db_mongo'];

        $host  = $mongoInfo['host_server_side'];

        $username = $mongoInfo['username'];

        $password = $mongoInfo['password'];

        $basePath = BP . DS . 'app/code/connector/Components/Migration/NewProfile/updateRefineTable.js';

        $eval = '"var id = ' . $idTo . ' " ';

        $createCommand = "mongo " . $host . ' --username ' . $username . ' -p ' . $password .   ' --eval ' . $eval . $basePath;
        return (shell_exec($createCommand));
    }
}
