<?php

namespace App\Connector\Components\Migration\NewProfile;

use App\Core\Models\BaseMongo;

class GetQueryConverted extends BaseMongo
{

    public $shopIds = [];


    public function extractRuleFromProfileData($profileData, $type = 'find', $shopIds = [])
    {
        $userId = isset($profileData['user_id']) ? $profileData['user_id'] :  $this->di->getUser()->id;
        $this->shopIds = $shopIds;
        $finalQuery = [];
        $mainQuery = $this->convertQueryFromMysqlToMongo($profileData['query']);
        $finalQuery['$and'][] = $mainQuery;
        if (count($finalQuery)) {
            $finalQuery['$and'][] = ['user_id' => $userId];
            $finalQuery['$and'][] = ['visibility' => 'Catalog and Search'];
            if (isset($shopIds['sources'])) {
                foreach ($shopIds['sources'] as $key => $value) {
                    $finalQuery['$and'][] = ['shop_id' => $value];
                }
            }
            if (isset($profileData['overWriteExistingProducts']) && !$profileData['overWriteExistingProducts'] && isset($shopIds['targets'])) {
                foreach ($shopIds['targets'] as $key => $value) {
                    $finalQuery['$and'][] = ['profile.target_shop_id' => ['$ne' => $value]];
                }
            }
            if ($type == 'find') {
                return $finalQuery;
            } else {

                return [
                    ['$match' => $finalQuery]
                ];
            }
        } else {
            return false;
        }
    }

    public function convertQueryFromMysqlToMongo($query)
    {
        if ($query != '') {
            $filterQuery = [];
            $orConditions = explode('||', $query);
            $orConditionQueries = [];
            foreach ($orConditions as $key => $value) {
                $andConditionQuery = trim($value);
                $andConditionQuery = trim($andConditionQuery, '()');
                $andConditions = explode('&&', $andConditionQuery);
                $andConditionSet = [];
                foreach ($andConditions as $andKey => $andValue) {
                    $andConditionSet[] = $this->getAndConditions($andValue);
                }
                $orConditionQueries[] = [
                    '$and' => $andConditionSet,
                ];
            }
            $orConditionQueries = [
                '$or' => $orConditionQueries,
            ];
            return $orConditionQueries;
        }
        return false;
    }

    public function createMarketplaceCond(&$preparedCondition, $regex, $keyValue)
    {
        $orCond = [
            [
                'marketplace' => [
                    '$elemMatch' => [
                        trim($keyValue[0]) => [
                            '$exists' => false
                        ],
                        'shop_id' => ['$in' => $this->shopIds['targets']]
                    ]
                ]
            ],
            [
                'marketplace.shop_id' => [
                    '$not' => ['$in' => $this->shopIds['targets']]
                ]
            ]
        ];
        $condI = [
            [
                ''
            ]
        ];
        $preparedCondition['$or'] = [
            [
                'marketplace' => [
                    '$elemMatch' => [
                        trim($keyValue[0]) => $regex,
                        'shop_id' => ['$in' => $this->shopIds['targets']]
                    ]
                ],
            ],
            [
                'marketplace' => [
                    '$elemMatch' => [
                        trim($keyValue[0]) => $regex,
                        'shop_id' => ['$in' => $this->shopIds['sources']],
                    ]
                ],
                '$or' => $orCond
            ],
            [
                trim($keyValue[0]) => $regex,
                '$or' => $orCond
            ]
        ];
    }

    public function getAndConditions($andCondition)
    {
        $varintAttr = [];
        $preparedCondition = [];
        $conditions = ['==', '!=', '!%LIKE%', '%LIKE%', '>=', '<=', '>', '<'];
        $andCondition = trim($andCondition);

        foreach ($conditions as $key => $value) {
            if (strpos($andCondition, $value) !== false) {
                $keyValue = explode($value, $andCondition);
                $isNumeric = false;

                $valueOfProduct = trim(addslashes($keyValue[1]));
                if (trim($keyValue[0]) == 'collections') {
                    $productIds = $this->di->getObjectManager()->get('\App\Shopify\Models\SourceModel')->getProductIdsByCollection((string) $valueOfProduct);
                    if ($productIds && count($productIds)) {
                        if ($value == '==' || $value == '%LIKE%') {
                            $preparedCondition['source_product_id'] = [
                                '$in' => $productIds,
                            ];
                        } elseif (
                            $value == '!=' ||
                            $value == '!%LIKE%'
                        ) {
                            $preparedCondition['source_product_id'] = [
                                '$nin' => $productIds,
                            ];
                        }
                    } else {
                        $preparedCondition['source_product_id'] = [
                            '$in' => $productIds,
                        ];
                    }
                    continue;
                }
                switch ($value) {
                    case '==':
                        if ($isNumeric) {
                            $preparedCondition[trim($keyValue[0])] = $valueOfProduct;
                        } else {
                            if (trim($keyValue[0]) == 'variant_attributes') {
                                $this->formatCondForVariantAttr($preparedCondition, trim($keyValue[0]), $valueOfProduct);
                            } else {
                                $this->createMarketplaceCond($preparedCondition, [
                                    '$regex' => '^' . $valueOfProduct . '$',
                                    '$options' => 'i',
                                ], $keyValue);
                            }
                        }
                        break;
                    case '!=':
                        $this->createMarketplaceCond($preparedCondition, [
                            '$not' => [
                                '$regex' => '^' . $valueOfProduct . '$',
                                '$options' => 'i',
                            ],
                        ], $keyValue);
                        break;
                    case '%LIKE%':
                        if (trim($keyValue[0]) == 'variant_attributes') {
                            $this->formatCondForVariantAttr($preparedCondition, trim($keyValue[0]), $valueOfProduct);
                        } else {
                            $this->createMarketplaceCond($preparedCondition,  [
                                '$regex' => ".*" . $valueOfProduct . ".*",
                                '$options' => 'i',
                            ], $keyValue);
                        }
                        break;
                    case '!%LIKE%':
                        $this->createMarketplaceCond($preparedCondition, [
                            '$regex' => "^((?!" . $valueOfProduct . ").)*$",
                            '$options' => 'i',
                        ], $keyValue);
                        break;
                    case '>':
                        $this->createMarketplaceCond($preparedCondition, [
                            '$gt' => (float) $valueOfProduct,
                        ], $keyValue);
                        break;
                    case '<':
                        $this->createMarketplaceCond($preparedCondition, [
                            '$lt' => (float) $valueOfProduct,
                        ], $keyValue);
                        break;
                    case '>=':
                        $this->createMarketplaceCond($preparedCondition, [
                            '$gte' => (float) $valueOfProduct,
                        ], $keyValue);
                        break;
                    case '<=':
                        $this->createMarketplaceCond($preparedCondition, [
                            '$lte' => (float) $valueOfProduct,
                        ], $keyValue);
                        break;
                }
                break;
            }
        }
        return $preparedCondition;
    }

    public function formatCondForVariantAttr(&$preparedCondition, $keyValue, $valueOfProduct)
    {
        $var = explode(",", $valueOfProduct);
        $i = 0;
        foreach ($var as $key => $value) {
            $createIndex = $keyValue . ".$key.key";
            $preparedCondition[$createIndex] = trim($value);
            $i++;
        }
        $preparedCondition[$keyValue] = ['$size' => $i];
    }
}
