<?php
namespace App\Connector\Components\Migration;

class MigrationHelper extends \App\Core\Components\Base
{
    const appCode = "amazon_sales_channel";
    const singleHome = "singleHome";

    public function getUserDetails($userId)
    {
        $db = $this->getSingleHomeDb();
        $collection = $db->selectCollection('user_details');
        $userDetails = $collection->findOne(["user_id"=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        $userDetailsArr = [];
        if(!empty($userDetails))
        {
            $userDetailsArr = $userDetails;
        }
        return $userDetailsArr;
        
    }
    public function getUserDetailsShop($userId,$shopId)
    {
        $db = $this->getSingleHomeDb();
        $collection = $db->selectCollection('user_details');
        $userDetails = $collection->findOne(["user_id"=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        $userDetailsArr = [];
        if(!empty($userDetails))
        {
            $userDetailsArr = $userDetails;
        }
        $shops = $userDetailsArr['shops'];
        $allShop = [];
        foreach($shops as $key => $shop)
        {
            if($shop['remote_shop_id'] != $shopId)
            {
                unset($userDetailsArr['shops'][$key]);
            }
            else {
                $allShop[] = $shop;
            }
        }
        if(!empty($allShop))
        {
            $userDetailsArr['shops'] = $allShop;
        }
        return $userDetailsArr;
    }

    public function getUserDetailsShopByMarketplace($userId,$marketplace)
    {
        $db = $this->getSingleHomeDb();
        $collection = $db->selectCollection('user_details');
        $userDetails = $collection->findOne(["user_id"=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        $userDetailsArr = [];
        if(!empty($userDetails))
        {
            $userDetailsArr = $userDetails;
        }
        $shops = $userDetailsArr['shops'];
        $allShop = [];
        foreach($shops as $key => $shop)
        {
            if($shop['marketplace'] != $marketplace)
            {
                unset($userDetailsArr['shops'][$key]);
            }
            else {
                $allShop[] = $shop;
            }
        }
        if(!empty($allShop))
        {
            $userDetailsArr['shops'] = $allShop;
        }
        return $userDetailsArr;
    }

    public function getAppDetails($remoteShopId)
    {
        $appDetails = '{
            "_id" : 125,
            "shop_url" : "florida-state-line.myshopify.com",
            "token" : "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",
            "group_code" : "shopify",
            "app_code" : "amazon_sales_channel",
            "apps" : {
                "amazon_sales_channel" : {
                    "app_id" : 1,
                    "token" : "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",
                    "sub_app_id" : 1
                }
            },
            "sub_apps" : [
                1
            ],
            "app_id" : 1
        }
        ';

        return json_decode($userDetails,true);
    }

    public function initiatProductImport($userId,$shopId)
    {

    }

    public function prepareProductEdit($userId,$shopId,$sourceProductId,$containerId)
    {

    }

    public function getSingleHomeDb()
    {
        $db = $this->di->get(self::singleHome);
        return $db;
    }

}