<?php
namespace App\Connector\Components\Migration;
use Phalcon\Events\Event;
use Aws\DynamoDb\DynamoDbClient;

class Migration extends \App\Core\Components\Base
{
    protected $user_id;
    protected $shop_id;
    protected $step;
    const collectionName = "user_migrate_progress";

    //demo details
    
    // const homeUrl = "https://multi-account.sellernext.com/home/public";
    // const remoteUrl = "https://multi-account.sellernext.com/remote/public";
    // const shopifyPrivateKey = "-----BEGIN PRIVATE KEY-----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\nreRlIrc5Zblh7eIKMfVJrVRx+wk=\n-----END PRIVATE KEY-----\n";
    // const amazonPrivateKey =  "-----BEGIN PRIVATE KEY-----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\neVYq0ESIGk01Bz7+WL+tm64vABkeDlU=\n-----END PRIVATE KEY-----\n";
    // const shopifyAppCode = "amazon_sales_channel";
    // const amazonAppCode = "amazon";
    // const shopifySappId = "1";
    // const amazonSappId = "2";
    // const amazonAppId = "2";
    // const shopifyAppId = "1";
    // const multiRemote = "multiRemote";
    // const singleHome = "singleHome";
    // const singleRemote = "singleRemote";



    const homeUrl = "https://amazon-sales-channel-app-backend.cifapps.com";
    const remoteUrl = "https://api-backend.cifapps.com";
const shopifyPrivateKey = "-----BEGIN PRIVATE KEY-----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-----END PRIVATE KEY-----";
const amazonPrivateKey = "-----BEGIN PRIVATE KEY-----
MIIJQwIBADANBgkqhkiG9w0BAQEFAASCCS0wggkpAgEAAoICAQD79lzDf4FCp34q
Hr0JaWCss351M1sMI4OImyF09tlTV7BMzMwDItnLmA8RLDLEPnwl3VscLSgBhvpt
0B5yYteLHLFCqtvrT5rqRX1oEFO4uHCsmYC4Ysn5TVjrNG5mUdSGJw+QIeSRVoMU
YH4V2IJKVIQxGrEiYP7++8QRcxX8Zct7NQAQ74SwwoY5y/XNojBtzJVURybuJAJf
e5n5oiToRo2ZlACbL2ikQQoDfrkPr6frGgmu70HXNBBSIlFSvZwg1DBwKtnIr0U0
RRgn2gp3qFz3i0vwfvgAmVLP8jv2U23PWAjzN8vf2/re+40Gp9lFaAvNtpaVLzsx
CBSWLsQDsNh91mJub0+g/hG6/2rNmWW9Sbi93t+KnIYoqlpfOUeAj9mw7fEae9td
jrrlFZ2D7Xr7o7NRytc+N/Ni43xskfDBFCaK0ffKTrIVHFhOGZnRWdumdjxHpbaz
LeQ2dCj3y3dKbfWaNPnUUdIuJQzqZzZw+V8yYKZHrsgkv4ePdw5pVvQn1KS5HHuS
k7FRGkMBGqVN++QzfCwICf92i+u6ljxCWqvQMEhBot+3t35jHBGCD5k+VvH57+9a
QARrzRDuIsFEaK1IAHelgRjZxc+6pWviKGo98r3Bxzua9yof02mGuDX8AZNYDWw/
HsBYerxGqFmnBjaGberqO/HrbBNTIwIDAQABAoICAENYdTD36qfTNwCxGJvkY6el
jl5rLKHQ+D5SIJ4vwKTrIj9U2g7YiNhHO3e+lY8omGxSfyDH3RKTbmpdn1W5n50a
PTLxkjiSHXkSu9NN0eLkwZEQsnwWQ5/0EZlEeWG165Uz6Y//zyUdt4mBxRG3vhN6
BZ9OYBwtStsClkSHu0+sMbgr0Wm1a4UHaXMXVgrxl/oxHZTaM8ihLVUyJ1S3ByBi
g0SSb5sLD/AfRjrq6zILJFnNqtrsLnAEBXy+mXgBIDMSJCRG/9EJL/kpoqw8NmIH
SVoNDG4qscUPNjhIqchMQmSSRkokFsUt+h8Ro38s7AEGL2l7rUIQzsRrQX1m4JMI
M/ST/Rb1UUZAxgdHrCzaChRSSoHtpDc5QnrFNZ6wALrKULdd5PGGHjTn4HKHtTZY
cWgV3zSyXxQOCBR/SzXQctRptuivdUjrrwPax0xq71uKDk4zl+jlaWDOq/SqPLWE
5WVMTvbFDnuD2DBb+Zl8kcxjat+7IBUvw9FilHRP1dFddgtV/VBu5S3JIvxPwWHB
NByLXdz7hqf4Je1Qv4kQdM5+S5tznfs3AzKnsTCAbMNqBrp3ObJObp+m8DhCi+3f
aCBMngHjvvKs/wuvojWTB7FXBKLME+g6ke3FNjNIAFabqs/A+myFtHFEI5EEzIOa
I6/n+oXxMqJCUYH7CVL5AoIBAQD+0hzekNnHmeCjX+KNq77nbUS4+kP3YT2yG97k
Ra4l+k8vGLlR56rSr77d8ncA6r9u62Kvoyip6iRNpgX4NpHsGAZ+RK4wNOsbKSFE
aoMbJGQHB2DyAKnzbEu8xvXzX6hWYeUSIyfL7RnanJbz7nqbClE7d6jxxw+aUUBd
KKCYa4YuHxzOa27YBuDyL9255dgimFv3goWRRKLauTltGodZ9jS129G9dgTb3oZp
qzD15Y3r4u7khAWUj2p/fddiW8ly5w5+uMxdWNBIXf/FlESjmEAVWjCy1gJ6oyEK
sY8cZjLzUKSBwphaY1bWiElGSWLa2/nR8LLT4tcSHh0VTX3nAoIBAQD9INz8h4QM
F7uAaQkwCI9fIyd+eoQh1PN4AOsIhtTbXcEFoDEbsFr+xU3mrPLz1ZfDyvfL7YQq
8LgoeENWomQHJ4CaMFXPFLE12FC4iPNttOPtgo8Ou08rMPyJdxxfnvJmFylTwEe0
8/4U4139ItutqwGxBnzomQlJdMGYouf3qzbwi9e2drGLTCEIGhdePBSLStdHyq21
Ed87b18WxFAg0KvfRLy9L/23Z7PikoZCrjMHOgXDEbrkLlHKq4Hjo4bgQVV8FGSy
O+yIR64pl6y0ir7tblituNSk0f5T8O/LBpANp5rB+Nuj4VUBKpUnp0bKeeQKzjWF
ppNgQTRxD0FlAoIBADzknut8t94f4nOIHU53hTYugWamv4klHqYqTNhF4njG2RdL
FDYDY2nXf4fwQgnhDwAFld6c4cHA5w37J6AKAlLl5t9TsEBq1Of3qzB7N3tL9e9M
DxmlmPdHoM2qyelvqX2DBUeRSRhNP4ljNBt0mK3mCEVqsd+dDxh0ZCoe5EmoIDdz
TeHyAFn1Qtn9IEIlL8IMoKWD9kEhor0b2CI/Xarcz/nJXtSkmEKmaX5k311TjteY
sje/aMn4f52Zx9eEUZ54opkbthJ0f8lbVRy08rYZUu8HT23dAFioFORGTAmgTnqg
gb9Ubi3jYUQA62m1bb8ZJBjMKR/DLFvzAEYv728CggEBAJMs/XBS9uL1FY8XA0GL
aJkfXoI6iAMHxzv6BK4jfzXA8E7uEj+QLYg+fgnmeyhtA13S8HsAsb0p01msezKv
HsvOGwcLnYjW9iZhjKWO80LRT0k0hStCm0h4pgzjVXr/dt8HDn9kqAy9ZPkOLgLV
trbmXAhqxkuTV4P/P+UYqxkk0r/P/29W2eotLHOCgB3JfwRyUnOqk49ZQdtT6Qza
veAmlBgv5jF16uYthLjzCt9QW9kS0nDWKT0s9V+Kku4hkXVoZ2TKkrXTA7dFPi1u
w/sBRPvWEfeIJRNkCaUSzMnWGgHmdqPbpxFFHeCcuragmxd1AbOKrDH2ZXAs2Wn3
PcUCggEBALwkH2blXxSsfIpthITrpmxU7qBr5pVLEVcl5Mu5lLzhsLUOyqw9GQSu
9DGwr4FO7Wi7LH56aJR7iFWzxSAT4CSE2/AaNWng4BUYDFja4o8ZB+u+LE/ya/7c
lVUT2xcIQB47eLymLUVfYq2TTINy05rbNd6XBeCxMDVOenuMA2PF+zJyMOOWCzxV
PaL69Eh3QyJedxYf5Cqr1+SWyCovCWAOqnZMhYPbH0bskpDqqrEa2SxxswdD45Ma
DMVFF5fe+rDXCkw3XMGhjjpEaOSeLPe5zLXmjO4S2Tq/2I32lamss7+DHMXFci7j
fsE5qU5MbXvdz9f+jW07MS4QPj2kQbM=
-----END PRIVATE KEY-----";
const shopifyAppCode = "amazon_sales_channel";
const amazonAppCode = "amazon";
const shopifySappId = "1";
const amazonSappId = "2";
const amazonAppId = "2";
const shopifyAppId = "1";
const multiRemote = "multiRemote";
const singleHome = "singleHome";
const singleRemote = "singleRemote";

const migrationsteps = [
    [
        'step'=>1,
        'function'=>'validateUser'
    ],
    [
        'step'=>2,
        'function'=>'shopifyAccount'
    ]
];

    public function beforeStep($currentStep,$userId)
    {
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $usermigrateCol = $mongo->getCollectionForTable(self::collectionName);
        $userInfo = $usermigrateCol->findOne(['user_id'=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        if(!empty($userInfo))
        {
            if($userInfo['step'] == $currentStep && $userInfo['abort'])
            {
                return true;
            } else {
                return false;
            }
            
        } else {
            return false;
        }

    }

    public function isStart($data)
    {

        $user_id = $data['userid'];
        $step = $data['step'] ?? 1;
        $shopId = $data['shop_id'] ?? false;
        if($user_id == '6283d163c79862702d059bf5')
        {
            // $this->afterProductImportNew($data);
            // $this->editProductMove($user_id);
            // echo "editProductMove done".PHP_EOL;
            // $this->profile($user_id);
            // echo "profile done".PHP_EOL;
            // $this->order($user_id);
            $this->addNotification($user_id);

        }
        else{
            $this->start($user_id,$step,$shopId);
        }
       return true;
    }

    public function migrationStart(string $user_id,int $step,$shopId = false)
    {
        $this->user_id = $user_id;
        $this->step = $step ?? 1;

        if($shopId)
        {
            $this->shop_id = $shopId;
        }

        $migrationsteps = self::migrationsteps;
        foreach($migrationsteps as $step)
        {
            if($step['step'] == $step)
            {
                $functiname = $step['function'];
                $this->$functiname($user_id);
            }

        }

    }

    public function validateUser($userId)
    {
        if($this->beforeStep(1,$userId))
        {
            return ['success'=>true];
        }
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $collection = $mongo->getCollectionForTable('user_details');
        $userInfo = $collection->findOne(['user_id'=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        if($userInfo)
        {
            $startDate = date("c");
            $data = [
                'user_id'=>$userId,
                'completed'=>false,
                'step'=>1,
                'abort'=> true,
                'msg'=> 'user already exist',
                'start_migration'=>$startDate
            ];
            $this->saveUserMigratesDetails($data,$userId);
            return ['success'=>false,'message'=>'user already exist'];
        } else {
            $db = $this->getSingleHomeDb();
            $userCollections = $db->selectCollection('user_details');
            $userInfo = $userCollections->findOne(['user_id'=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
            if(!empty($userInfo))
            {
                $startDate = date("c"); 

                if(!empty($userInfo['shops']))
                {
                    

                    foreach($userInfo['shops'] as $shop)
                    {
                        $homeShopId = (string)$shop['_id'];
                        $homeInfo = $collection->findOne(['user_id'=>$userId,'shops._id'=>$homeShopId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
                        if(!empty($homeInfo))
                        {
                            $data = [
                                'user_id'=>$userId,
                                'completed'=>false,
                                'step'=>1,
                                'abort'=> true,
                                'msg'=> 'home Shop alreday exists',
                                'start_migration'=>$startDate
                            ];
                            $this->saveUserMigratesDetails($data,$userId);
                            

                            return ['success'=>false,'message'=>$data['msg']];

                        } 
                      
                    }
                    $data = [
                        'user_id'=>$userId,
                        'completed'=>false,
                        'step'=>1,
                        'abort'=> false,
                        'msg'=> 'user validated successfully',
                        'start_migration'=>$startDate
                    ];
                    $this->saveUserMigratesDetails($data,$userId);
                    $userLog = $mongo->getCollectionForTable('user_log');
                    $userLogInfo = $userLog->findOne(['user_id'=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
                

                    if(!empty($userLogInfo))
                    {

                    } else {
                         $userLog->insertOne($userInfo);

                    }
                    

                    return ['success'=>true,'message'=>$data['msg']];

                } else {
                    $data = [
                        'user_id'=>$userId,
                        'completed'=>false,
                        'step'=>1,
                        'abort'=> true,
                        'msg'=> 'shops not exists',
                        'start_migration'=>$startDate 
                    ];
                    $this->saveUserMigratesDetails($data,$userId);
                    $this->saveShops();
                    return ['success'=>true,'message'=>$data['msg']];
                }


            } else {
                $data = [
                    'user_id'=>$userId,
                    'completed'=>false,
                    'step'=>1,
                    'abort'=> true,
                    'msg'=> 'user not exist in our old system'
                ];
                $this->saveUserMigratesDetails($data,$userId);
                return ['success'=>false,'message'=>$data['msg']];
            }
        }
    }

    public function removeServerLessInfo($remote_shop_id)
    {
        $singleHomeDb = $this->getSingleHomeDb();
        $dynamodetails = $singleHomeDb->selectCollection('dynamo_credentails');
        $data = $dynamodetails->findOne([], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
       

        if(!empty($data))
        {
            unset($data['_id']);
            $dynamoClient = DynamoDbClient::factory($data);
            
            $response = $dynamoClient->deleteItem([
                'Key' => [ 
                    'id' => [
                        'N' => (string)$remote_shop_id
                    ]
                ],
                'TableName' => 'amazon_order_sync_shops', // REQUIRED
            ]);
          //  var_dump($data,$remote_shop_id);die;

            
        }
                
    }

    public function saveShops()
    {

        $oldUserData = $this->userDetails($this->user_id);
        
        foreach($oldUserData['shops'] as $shop)
        {
            
            $oldShopData = $this->getDataFromOldAppShop($shop['remote_shop_id']);
           
            if($oldShopData['success']){
                $oldShopData = $oldShopData['data'];
            } else {
                continue;
            }

            if($shop['marketplace'] =='shopify')
            {
                $filter = [];
                $filter['shop_url'] = $oldShopData['shop_url'];
                $newAppShop = $this->getDataFromNewAppShop($filter);
                $filter = [];
            }
            elseif($shop['marketplace'] == 'amazon') {
                $filter = [];
                $filter['marketplace_id'] = $oldShopData['marketplace_id'];
                $filter['seller_id'] = $oldShopData['seller_id'];
                $newAppShop = $this->getDataFromNewAppShop($filter);
                $filter = [];

            }
            if($newAppShop['success']){
                continue;
            }
            unset($oldShopData['_id']);
            $marketplaceShop = [];
            $marketplaceShop['_id'] = (string)$this->getCounter('app_shop_id');
            $marketplaceShop['id'] = (string)$marketplaceShop['_id'];
            $allSubApps = [];
            foreach($oldShopData['sub_apps'] as $subappId){
                if(!in_array($subappId,$allSubApps))
                {
                    $allSubApps[] = (string)$subappId;
                }
            }
            $marketplaceShop['sub_apps'] = $allSubApps;
            $apps = [];
            unset($oldShopData['apps']);
            unset($oldShopData['sub_apps']);
            
            $app = $oldShopData;
            $app['app_id']  = (string)$oldShopData['app_id'];
            if($shop['marketplace'] =='shopify')
            {
                $marketplaceShop['group_code'] = 'shopify';
                $marketplaceShop['app_code'] = self::shopifyAppCode;
                $app['app_code'] = self::shopifyAppCode;
                $app['sub_app_id']  = self::shopifySappId;
                $marketplaceShop['shop_url'] = $oldShopData['shop_url'];
            } elseif($shop['marketplace'] == 'amazon') {
                $marketplaceShop['group_code'] = 'amazon';
                $marketplaceShop['marketplace_id'] = $oldShopData['marketplace_id'];
                $marketplaceShop['seller_id'] = $oldShopData['seller_id'];
                $app['sub_app_id']  = self::amazonSappId;
                $marketplaceShop['app_code'] = self::amazonAppCode;
                $app['app_code'] = self::amazonAppCode;
            }
            if(isset($app['region']) && $app['region'] =='IN')
            {
                $app['region'] = 'EU';
            }
            $marketplaceShop['apps'][] = $app;

            $this->setDataFromNewAppShop($marketplaceShop);
            $cedcommerceShop = [];
            $cedcommerceShop = [
                "ced_subuser_id"=> "1",
                "remote_shop_id"=>$marketplaceShop['id'],
                "sAppId"=> $app['sub_app_id'],
                "ced_sAppId"=> "3"
            ];

            $this->saveCedcommerceShop($cedcommerceShop);
        }
      

    }

    public function saveCedcommerceShop($data)
    {
        $db = $this->getMultiRemoteDb();
        $collection = $db->selectCollection('cedcommerce_app_shops');
        $insert = $collection->updateOne(['remote_shop_id'=>$data['remote_shop_id']],['$set'=>$data],['upsert'=>true]);

    }
    
    public function start(string $user_id,int $step,$shopId = false)
    {
        $this->user_id = $user_id;
      
       
        $this->step = $step ?? 1;
        if($shopId)
        {
            $this->shop_id = $shopId;
        } else {
            $validateUser =  $this->validateUser($user_id);
            if(isset($validateUser['success']) && !$validateUser['success'])
            {
                // $data = [
                //     'user_id'=>$user_id,
                //     'completed'=>false,
                //     'step'=>1,
                //     'abort'=> true,
                //     'msg'=> json_encode($validateUser)
                // ];
                // $this->saveUserMigratesDetails($data,$this->user_id);
    
            }
        }
        
       

        $datasave = $this->saveShops();
        
        if(!$shopId){
            $datasave = $this->saveUser();
        }
        $migrationHelper = $this->di->getObjectManager()->get(\App\Connector\Components\Migration\MigrationHelper::class);
        $userData = $migrationHelper->getUserDetailsShop($this->user_id,$this->shop_id);
        
        
        $shops = $userData['shops'][0];
        $allUserData = $migrationHelper->getUserDetails($this->user_id);
        $sourceShopId = '';
        
        foreach($allUserData['shops'] as $allShop){
            if($allShop['marketplace'] =='shopify')
            {
                $sourceShopId =  $allShop['_id'];
            }
        }
      
        if($shops['marketplace'] == 'shopify'){
            $this->sendShopifyData($shops['remote_shop_id']);
        } else {
            $this->sendAmazonData($shops['remote_shop_id'],$sourceShopId);
        }
       
    }

    public function getDataFromNewAppShop($filter)
    {
        $db = $this->getMultiRemoteDb();
        $collection = $db->selectCollection('apps_shop');
        $appShop = $collection->findOne($filter, ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        if($appShop)
        {
            return ['success'=>true,'data'=>$appShop];
        } else {
            return ['success'=>false];
        }
    }

    public function setDataFromNewAppShop($data)
    {
        $db = $this->getMultiRemoteDb();
        $collection = $db->selectCollection('apps_shop');
        $insert = $collection->insertOne($data);
    }

    public function getDataFromOldAppShop($remoteShopId)
    {
        
        $db = $this->getSingleRemoteDb();
        $collection = $db->selectCollection('apps_shop');
        $appShop = $collection->findOne(["_id"=>(int)$remoteShopId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        if($appShop)
        {
            return ['success'=>true,'data'=>$appShop];
        } else {
            return ['success'=>false];
        }
    }

    public function saveShopifyAppShop($remoteShopId)
    {
        $migrationHelper = $this->di->getObjectManager()->get(\App\Connector\Components\Migration\MigrationHelper::class);
        $shopData = $migrationHelper->getUserDetailsShop($remoteShopId);
        return ['success'=>true,'message'=>'data_inserted'];
    }

    public function saveAmazonAppShop($remoteShopId)
    {
        $migrationHelper = $this->di->getObjectManager()->get(\App\Connector\Components\Migration\MigrationHelper::class);
        $shopData = $migrationHelper->getUserDetailsShop($remoteShopId);
        return ['success'=>true,'message'=>'data_inserted'];
    }

    public function sendShopifyData($shopId)
    {
        

        // if($this->beforeStep(2,$userId))
        // {
        //     $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        //     $usermigrateCol = $mongo->getCollectionForTable(self::collectionName);
        //     $options = [
        //         "typeMap" => ['root' => 'array', 'document' => 'array'],
        //     ];
        //     $saveUserData = $usermigrateCol->findOne(['user_id'=>$this->user_id], $options);
        //     $inprogessShopId = $saveUserData['inprogressShop'][0];

        //     return $this->start($this->user_id,3,$inprogessShopId);
        // }

        $oldAppShop = $this->getDataFromOldAppShop($shopId);

        if(isset($oldAppShop['success']) && $oldAppShop['success'])
        {
            $oldAppShop = $oldAppShop['data'];

            $shopUrl = $oldAppShop['shop_url'];
            $filter = [];
            $filter['shop_url'] = $shopUrl;
            $newAppShop = $this->getDataFromNewAppShop($filter);

            if($newAppShop['success'])
            {
                $newShopId = $newAppShop['data']['_id'];

            } else {
                return ['success'=>false,'message'=>'shop not found in new shop'];
            }
            

        } else {
            return ['success'=>false,'message'=>'shop not found'];
        }

        
        $url = self::homeUrl.'/connector/request/commenceHomeAuth';
        $params = [];
        $params['sAppId'] = self::shopifySappId;
        $params['state'] = json_encode([
            'old_shop_id'=>$shopId
        ]);
        $helper = $this->di->getObjectManager()->get('\App\Core\Components\Helper');
        $date1 = new \DateTime('+360 second');
        $result = [];
        $result['data']['marketplace'] = 'shopify';
        

        $token = [
            "data" => ['shop_id'=>(string)$newShopId , 'marketplace'=>'shopify'],
            "exp" => $date1->getTimestamp()
        ];
       
         
        $token = $helper->getJwtToken($token, 'RS256', false, self::shopifyPrivateKey);
        $params['data'] = $token;
        $params['app_code'] = self::shopifyAppCode;
        $params['success'] = '1';
        $params['no_redirect'] = '1';
        $params['marketplace'] = 'shopify';
        
        
        $curlResponse = $this->sentCurl($url,$params);
        $shopifyResponse = json_decode($curlResponse , true);
        print_r($shopifyResponse);

        if($shopifyResponse['success']){
            
            $saveUser = $this->saveUser();
            print_r($saveUser);


            if($shopifyResponse['success']){
                $saveUserData = $saveUser['data'];
                $inprogessShopId = $saveUserData['inprogressShop'][0];
                $data = [
                    'user_id'=>$this->user_id,
                    'completed'=>false,
                    'step'=>2,
                    'abort'=> false,
                    'msg'=> 'user shopify setup'
                ];
                $this->saveUserMigratesDetails($data,$this->user_id);
                return $this->start($this->user_id,3,$inprogessShopId);
            }
            
        }else{
            $this->pushToQueue($this->user_id,false);
        }
    }

    public function sendAmazonData($shopId,$sourceShopId)
    {
        $oldAppShop = $this->getDataFromOldAppShop($shopId);

        if(isset($oldAppShop['success']) && $oldAppShop['success'])
        {
            $oldAppShop = $oldAppShop['data'];

           
            $filter = [];
            $filter['marketplace_id'] = $oldAppShop['marketplace_id'];
            $filter['seller_id'] = $oldAppShop['seller_id'];

            $newAppShop = $this->getDataFromNewAppShop($filter);
            if($newAppShop['success'])
            {
                $newShopId = $newAppShop['data']['_id'];

            } else {
                return ['success'=>false,'message'=>'shop not found in new shop'];
            }
            

        } else {
            return ['success'=>false,'message'=>'shop not found'];
        }
        
        
        $url = self::homeUrl.'/connector/request/commenceHomeAuth';
        $params = [];
        $params['sAppId'] = self::amazonSappId;
        $params['state'] = json_encode([
            "user_id"=>$this->getUserid(),
            "source"=>'shopify',
            "source_shop_id"=>(string)$sourceShopId,
            'app_tag'=>'amazon_sales_channel',
            'old_shop_id'=>$shopId
        ]);
        $helper = $this->di->getObjectManager()->get('\App\Core\Components\Helper');
        $date1 = new \DateTime('+360 second');
        $result = [];
        $result['data']['marketplace'] = 'amazon';
        $token = [
            "data" => ['shop_id'=>(string)$newShopId , 'remote_shop_ids'=>[(string)$newShopId],'marketplace'=>'amazon'],
            "exp" => $date1->getTimestamp()
        ];
        $token = $helper->getJwtToken($token, 'RS256', false, self::amazonPrivateKey);
        $params['data'] = $token;
        $params['app_code'] = self::amazonAppCode;
        $params['success'] = '1';
        $params['no_redirect'] = '1';
        $params['marketplace'] = 'amazon';
            // if ($shopId=='2382') {
            //     echo "In Here".PHP_EOL;
            //     print_r($url);
            //     print_r($params);

            // }
        //print_r($url,$params);die;
        
        $curlResponse = $this->sentCurl($url,$params);
        // if ($shopId=='2382') {
        //     echo "In Here".PHP_EOL;
        //     print_r($curlResponse);

        // }
        // if ($curlResponse) {
        //     $this->pushToQueue($this->user_id,false);
        // }
        $amazonResponse = json_decode($curlResponse , true);
        if(isset($amazonResponse['success']))
        {
            $data = [
                'user_id'=>$this->user_id,
                'completed'=>false,
                'step'=>3,
                'abort'=> false,
                'msg'=> 'user amazon setup',
                'response'=>$curlResponse
            ];
            $this->saveUserMigratesDetails($data,$this->user_id);
            $this->removeServerLessInfo($shopId);
            // $this->pushToQueue($this->user_id,true);

        } else {
            $this->pushToQueue($this->user_id,false);
            // $data = [
            //     'user_id'=>$this->user_id,
            //     'completed'=>false,
            //     'step'=>3,
            //     'abort'=> true,
            //     'msg'=> json_encode($amazonResponse)
            // ];
            // $this->saveUserMigratesDetails($data,$this->user_id);
        }

    }

    public function sentCurl($url , $params)
    {
        if(!empty($params))
        {
            $queryParams = http_build_query($params);
            $url = $url .'?'.$queryParams;
        }
       
        // print_r($url);die;

       
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
         CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 400,
        CURLOPT_CONNECTTIMEOUT=>200,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        ));

       // curl_setopt($ch, CURLOPT_TIMEOUT, 400);
        
        $response = curl_exec($curl);
        print_r($response);
        
        $info = curl_error($curl);
        curl_close($curl);
        return $response;

    }

    public function saveUser()
    {
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $collection = $mongo->getCollectionForTable(self::collectionName);
        $userDataSave = [];
        $oldUserData = $this->userDetails($this->user_id);
        $filters = [];
        $filters['username'] = $oldUserData['username'];
        $filters['email'] = $oldUserData['email'];
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array'],
        ];
        $response = $collection->findOne($filters, $options);
        if(empty($response)){
            $userDataSave['username'] = $oldUserData['username'];
            $userDataSave['email'] = $oldUserData['email'];
            $userDataSave['user_id'] = $oldUserData['user_id'];
            $userDataSave['step'] = 1;
            $remoteShopIds = [];
            $fisrtShop = false;
            
            foreach($oldUserData['shops'] as $shop)
            {
                if(!$fisrtShop){
                    $fisrtShop = $shop['remote_shop_id']; 
                }
                $remoteShopIds[] = $shop['remote_shop_id'];
            }
            $userDataSave['allShops'] = $remoteShopIds;
            $userDataSave['completedShop'] = [];
            $userDataSave['inprogressShop'] = [$fisrtShop];
            $this->saveUserMigratesDetails($userDataSave,$this->user_id);
           // $res = $collection->insertOne($userDataSave);
            $this->shop_id = $fisrtShop;
            return ['success'=>true,'data'=>$userDataSave];
        } else {
            $userDataSave['completedShop'] = $response['inprogressShop'];
            $allShops = $response['allShops'];
            $fisrtShop = false;
            foreach($allShops as $shopId){
                if(!in_array($shopId,$userDataSave['completedShop']) && !$fisrtShop)
                {
                    $fisrtShop = $shopId; 
                }
            }
            if($fisrtShop){
                $userDataSave['inprogressShop'] = [$fisrtShop];
                $this->shop_id = $fisrtShop;
              //  $res = $collection->updateOne($filters,['$set'=>$userDataSave]);

                $this->saveUserMigratesDetails($userDataSave,$this->user_id);
                return ['success'=>true,'data'=>$userDataSave];
            }
            return ['success'=>false,'message'=>'no shop found'];
            
        } 
    }

    public function updateUserStatus()
    {
        $userId = $this->getUserid();
        $shopId = $this->getCurrentShop();
        $step = $this->getStep();
        if($step == 8) {

        } else {

        }
    }

    public function getFunctionName()
    {
        $step = $this->getStep();
        $migrationStep = $this->migrationStep();
        foreach($migrationStep as $migration)
        {
            if($migration['code'] == $step) {
                return $migration['function_name'];

            } elseif($step == 8) {
                $this->updateUserStatus();
            }
        }

    }

    public function getUserid()
    {
        return $this->user_id;
    }

    public function getStep()
    {
        return $this->step;
    }

    public function getCurrentShop()
    {
        return $this->shop_id;
    }

    public function userDetails()
    {
        $migrationHelper = $this->di->getObjectManager()->get(\App\Connector\Components\Migration\MigrationHelper::class);
        $userData = $migrationHelper->getUserDetails($this->getUserid());
        return $userData;

    }

    public function editProductMove($userId)
    {   
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);

        $singleHomeDb = $this->getSingleHomeDb();
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
       
        $secondProductContainer = $singleHomeDb->selectCollection('amazon_product_container');
        $productContainer = $mongo->getCollectionForTable('product_container');

        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array'],
        ];
        
        $amazonProductData = $secondProductContainer->find(['user_id'=>$userId],$options)->toArray();
        $amazonProductData = json_decode(json_encode($amazonProductData),true);

        $userContainer = $mongo->getCollectionForTable('user_details');

        $userData = $userContainer->findOne(['user_id'=>$userId],$options);

        $amazonAllHomeShopIds = [];
        $shopifyHomeShopId = '';
        foreach($userData['shops'] as $shop){
            if($shop['marketplace'] == 'amazon'){
                $amazonAllHomeShopIds[] = $shop['_id'];
            } else {
                $shopifyHomeShopId = $shop['_id'];
            }
        }


        
        $allParents = [];

       
        if(!empty($amazonProductData))
        {
            $sourceProductIds = [];

            foreach($amazonProductData as $amazonProduct)
            {
                $sourceProductIds[] = $amazonProduct['source_product_id'];
            }
            $containerWiseData = [];
            if(count($sourceProductIds))
            {
                $allProducts =  $productContainer->find(['source_product_id'=>['$in'=>$sourceProductIds],'user_id'=>$userId,'source_marketplace'=>'shopify'],$options)->toArray();
                
                foreach($allProducts as $shopifyProduct)
                {
                    $containerWiseData[$shopifyProduct['source_product_id']] = $shopifyProduct;
                }
                
            }
            if(!empty($containerWiseData))
            {
                foreach($amazonProductData as $amazonProduct)
                {
                    if(isset($amazonProduct['group_id']))
                    {
                        unset($amazonProduct['group_id']);

                    }
                    if(isset($amazonProduct['_id']))
                    {
                        unset($amazonProduct['_id']);

                    }
                    if(isset($amazonProduct['profile_id']))
                    {
                        unset($amazonProduct['profile_id']);

                    }
                    if(isset($amazonProduct['profile_name']))
                    {
                        unset($amazonProduct['profile_name']);

                    }
                    if(isset($amazonProduct['whereUpdatedFrom']))
                    {
                        unset($amazonProduct['whereUpdatedFrom']);

                    }

                    if(count($amazonProduct)<4){
                        continue;
                    }

                    $parent = [];
                    $child = [];

                    $saveData = $amazonProduct;
                    if(isset($amazonProduct['source_product_id']) && isset($amazonProduct['container_id']))
                    {
                        
                            if(isset($containerWiseData[$amazonProduct['source_product_id']]))
                            {
                                

                                $sourceProductId = $amazonProduct['source_product_id'];
                                $containerId = $amazonProduct['container_id'];
                                $multiSavedProduct = $containerWiseData[$amazonProduct['source_product_id']];
                                
                                if(($sourceProductId == $containerId) || ($multiSavedProduct['visibility'] == 'Catalog and Search'))
                                {
                            
                                    $databaseSavedData = [];

                                    $databaseSavedData = $amazonProduct;

                                    if(isset($amazonProduct['parent_sku']))
                                    {
                                        $databaseSavedData['sku'] = $amazonProduct['parent_sku'];
                                        unset($amazonProduct['parent_sku']);
                                    }
                                    if(isset($databaseSavedData['shops']))
                                    {
                                        
                                        foreach($databaseSavedData['shops'] as $savedHomeShopId => $shopWiseData)
                                        {
                                            $parendSavedShop = [];
                                            $parendSavedShop = $shopWiseData;


                                            if(!empty($parendSavedShop['variation_theme_attribute_value']))
                                            {
                                                unset($parendSavedShop['variation_theme_attribute_value']);
                                            }

                                            if(!empty($parendSavedShop['optional_attributes']))
                                            {
                                                unset($parendSavedShop['optional_attributes']);
                                            }

                                        }
                                        unset($databaseSavedData['shops']);

                                        if(isset($parendSavedShop) && !empty($parendSavedShop)){
                                            if(empty($parendSavedShop['variation_theme_attribute_name']))
                                            {
                                                unset($parendSavedShop['variation_theme_attribute_name']);

                                            }
                                            if(empty($parendSavedShop['variation_theme_attribute_value']))
                                            {
                                                unset($parendSavedShop['variation_theme_attribute_value']);

                                            }
                                            if(empty($parendSavedShop['optional_attributes']))
                                            {
                                                unset($parendSavedShop['optional_attributes']);

                                            }
                                            

                                            
                                            $databaseSavedData = array_merge($databaseSavedData,$parendSavedShop);
                                        // unset($parendSavedShop['variation_theme_attribute_name']);
                                        }
                                        $databaseSavedData['source_shop_id'] = (string)$shopifyHomeShopId;

                                        foreach($amazonAllHomeShopIds as $key => $homeId)
                                        {
                                            $databaseSavedData['shop_id'] = (string)$homeId;
                                            $databaseSavedData['target_marketplace'] = 'amazon';
                                            $databaseSavedData['source_shop_id'] = $shopifyHomeShopId;
                                            $this->savedData($databaseSavedData,$userId);
                                        }
                                        

                                    } else {
                                        $databaseSavedData['source_shop_id'] = (string)$shopifyHomeShopId;

                                        foreach($amazonAllHomeShopIds as $key => $homeId)
                                        {
                                            $databaseSavedData['shop_id'] = (string)$homeId;
                                            $databaseSavedData['target_marketplace'] = 'amazon';
                                            $databaseSavedData['source_shop_id'] = $shopifyHomeShopId;
                                            $this->savedData($databaseSavedData,$userId);
                                        }

                                    }

                                } else {
                                    if(isset($amazonProduct['shops']))
                                    {
                                        $parent = [];
                                    

                                        foreach($amazonProduct['shops'] as $shopWiseData){
                                            $edited_variant_attributes = [];

                                            if(isset($shopWiseData['category_settings']))
                                            {
                                                $category_settings = $shopWiseData['category_settings'];
                                                $parent['category_settings'] = $category_settings;

                                                if(!empty($shopWiseData['variation_theme_attribute_name'])){
                                                    $parent['variation_theme_attribute_name'] = $shopWiseData['variation_theme_attribute_name'];
                                                }

                                                if(!empty($shopWiseData['variation_theme_attribute_value']))
                                                {
                                                    
                                                    foreach($shopWiseData['variation_theme_attribute_value'] as $amazonAttribute => $amazonAttrVal)
                                                    {
                                                        $childVal = [];
                                                        $childVal['amazon_attribute'] = $amazonAttribute;
                                                        $childVal['custom_text'] = $amazonAttrVal;
                                                        $childVal['shopify_select'] = 'custom';
                                                        $childVal['shopify_attribute'] = 'custom';
                                                        $childVal['recommendation'] = '';
                                                        $edited_variant_attributes['edited_variant_attributes'][] = $childVal;
                                                    }
                                                // unset($shopWiseData['variation_theme_attribute_value']);
                                                    

                                                }


                                                if(!empty($shopWiseData['optional_attributes']))
                                                {
                                                    foreach($shopWiseData['optional_attributes'] as $amazonAttribute => $amazonAttrVal)
                                                    {
                                                        $childVal = [];
                                                        $childVal['amazon_attribute'] = $amazonAttribute;
                                                        $childVal['custom_text'] = $amazonAttrVal;
                                                        $childVal['shopify_select'] = 'custom';
                                                        $childVal['shopify_attribute'] = 'custom';
                                                        $childVal['recommendation'] = '';
                                                        $edited_variant_attributes['edited_variant_attributes'][] = $childVal;
                                                    }
                                                //  unset($shopWiseData['optional_attributes']);
                                                }

                                            }
                                        }
                                        unset($amazonProduct['shops']);

                                        if(!empty($parent))
                                        {
                                            $parent = array_merge($parent,$amazonProduct);
                                            $parent['source_product_id'] = $parent['container_id'];
                                            $childSave = [];
                                            $childSave = $parent;

                                            if(isset($parent['barcode']))
                                            {
                                                unset($parent['barcode']);
                                            }
                                            if(isset($parent['sku']))
                                            {
                                                unset($parent['sku']);
                                            }
                                        
                                            if(isset($childSave['category_settings']['attributes_mapping']))
                                            {
                                                unset($childSave['category_settings']['attributes_mapping']);
                                                if(!empty($edited_variant_attributes))
                                                {
                                                    $childSave = array_merge($childSave,$edited_variant_attributes);
                                                }
                                            }

                                            if(isset($parent['category_settings']['primary_category']) && $parent['category_settings']['primary_category'] =='default')
                                            {
                                                if($parent['category_settings']['primary_category'] =='default' && $parent['category_settings']['sub_category'] =='default' && isset($parent['category_settings']['browser_node_id']) && $parent['category_settings']['browser_node_id']=='0')
                                                {
                                                    if(isset($parent['category_settings']['barcode_exemption']))
                                                    {
                                                        $a = $parent['category_settings'];
                                                        $parent['category_settings'] = [];
                                                        $parent['category_settings']['barcode_exemption'] = $a['barcode_exemption'];
                                                    }

                                                } else {
                                                    $a = $parent['category_settings']['attributes_mapping'];
                                                    $defaultSave = [];
                                                    if($parent['category_settings']['primary_category'] =='default')
                                                    {
                                                        $defaultSave['primary_category'] = 'default';
                                                    }
                                                    if($parent['category_settings']['sub_category'] =='default')
                                                    {
                                                        $defaultSave['sub_category'] = 'default';
                                                    }
                                                    if(isset($parent['category_settings']['browser_node_id']))
                                                    {
                                                        $defaultSave['browser_node_id'] = $parent['category_settings']['browser_node_id'];
                                                    }
                                                    if(isset($parent['category_settings']['barcode_exemption']))
                                                    {
                                                        $b = $parent['category_settings']['barcode_exemption'];
                                                       // $parent['category_settings']['barcode_exemption'] = $a['barcode_exemption'];
                                                    }

                                                    unset($parent['category_settings']);
                                                    $parent['category_settings'] = $defaultSave;
                                                    $parent['category_settings']['attributes_mapping'] =  $a;
                                                    if(isset($b))
                                                    {
                                                        $parent['category_settings']['barcode_exemption'] = $b;
                                                    }

                                                }
                                                
                                            }

                                        

                                            if(count($parent)<4){
                                                continue;
                                            }
                                            // foreach($amazonAllHomeShopIds as $key => $homeId)
                                            // {
                                            //     $parent['shop_id'] = (string)$homeId;
                                            //     $parent['target_marketplace'] = 'amazon';
                                            //     $allParents[$parent['container_id']][] = $parent;

                                            
                                            // }
                                    
                                            $parent['target_marketplace'] = 'amazon';
                                            $allParents[$parent['container_id']][] = $parent;

                                            if(!empty($childSave))
                                            {
                                                if(isset($childSave['category_settings']) && isset($childSave['category_settings']['primary_category']) && $childSave['category_settings']['primary_category'] =='default' && isset($childSave['category_settings']['sub_category']) && $childSave['category_settings']['sub_category'] =='default' && isset($childSave['category_settings']['browser_node_id']) && $childSave['category_settings']['browser_node_id']=='0')
                                                {
                                                    if(isset($childSave['category_settings']['barcode_exemption']))
                                                    {
                                                        $ca = $childSave['category_settings'];
                                                        $childSave['category_settings'] = [];
                                                        $childSave['category_settings']['barcode_exemption'] = $ca['barcode_exemption'];
                                                    } else {
                                                        unset($childSave['category_settings']);
                                                    }
                                                }

                                                $childSave['source_product_id'] = $amazonProduct['source_product_id'];
                                                $childSave['source_shop_id'] = (string)$shopifyHomeShopId;

                                                foreach($amazonAllHomeShopIds as $key => $homeId)
                                                {
                                                    $childSave['shop_id'] = (string)$homeId;
                                                    $childSave['target_marketplace'] = 'amazon';
                                                    $this->savedData($childSave,$userId);
                                                }
                                            }
                                            
                                        }

                                    } else {
                                        $isParentExist = false;
                                        $databaseSavedData = [];
                                        $databaseSavedData = $amazonProduct;
                                        if(isset($databaseSavedData['title']))
                                        {
                                            $isParentExist = true;
                                            unset($databaseSavedData['title']);
                                        }
                                        if(isset($databaseSavedData['description']))
                                        {
                                            $isParentExist = true;
                                            unset($databaseSavedData['description']);
                                        }
                                        if(isset($databaseSavedData['parent_sku']))
                                        {
                                            $isParentExist = true;
                                            unset($databaseSavedData['parent_sku']);
                                        }
                                        $databaseSavedData['source_shop_id'] = (string)$shopifyHomeShopId;
                                        foreach($amazonAllHomeShopIds as $key => $homeId)
                                        {
                                            $databaseSavedData['shop_id'] = (string)$homeId;
                                            $databaseSavedData['target_marketplace'] = 'amazon';
                                        //  $allParents[$databaseSavedData['container_id']][] = $databaseSavedData;
                                        $this->savedData($databaseSavedData,$userId);
                                        }

                                        if($isParentExist)
                                        {
                                            $parentSave = [];
                                            $parentSave = $amazonProduct;
                                            $parentSave['source_product_id'] = $parentSave['cotainer_id'];
                                            // foreach($amazonAllHomeShopIds as $key => $homeId)
                                            // {
                                            //     $parentSave['shop_id'] = (string)$homeId;
                                            //     $parentSave['target_marketplace'] = 'amazon';
                                            //     $allParents[$databaseSavedData['container_id']][] = $parentSave;
                                            // //$this->savedData($databaseSavedData,$userId);
                                            // }

                                            //$parentSave['shop_id'] = (string)$homeId;
                                            $parentSave['target_marketplace'] = 'amazon';
                                            $allParents[$databaseSavedData['container_id']][] = $parentSave;

                                        }
                                    }
                                    
                                }
                            } else {
                                //product not found
                            }
                        
                        

                    }
                
                    
                }
            }
        }
        if(!empty($allParents))
        {
           


            foreach($allParents as $savedContainerId => $containerData)
            {
               
                $parent = [];
                foreach($containerData as $savedData)
                {

                    if(empty($parent['parent_sku']) && isset($savedData['parent_sku']))
                    {
                        $parent['sku'] = $savedData['parent_sku'];
                        unset($savedData['parent_sku']);
                     } else {
                        unset($savedData['parent_sku']);
                     }

                    if(empty($parent['category_setting']['attributes_mapping']) && !empty($savedData['category_setting']['attributes_mapping']))
                    {
                        $parent['category_setting']['attributes_mapping'] = $savedData['category_setting']['attributes_mapping'];

                    }
                    $parent = array_merge($parent,$savedData);

                }
               
              

                if(!empty($parent))
                {
                    $parent['source_shop_id'] = $shopifyHomeShopId;
                    
                    foreach($amazonAllHomeShopIds as $key => $homeId)
                    {
                        $parent['shop_id'] = (string)$homeId;
                       

                        $this->savedData($parent,$userId);
                    }
                }

            }
        }


    }

    public function savedData($data, $userId)
    {
       
        $editObject = $this->di->getObjectManager()->get(\App\Connector\Models\Product\Edit::class);
        $res = $editObject->saveProduct([$data],$userId);
        
    }

    public function profile($userId)
    {
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $usermigrateCol = $mongo->getCollectionForTable(self::collectionName);
        $usermigrateCol->updateOne(['user_id'=>$userId],['$set'=>['msg'=>'ProfileStart']]);
        $this->di->getObjectManager()->get('\App\Connector\Components\Migration\NewProfile\NewProfile')->testProfile(['user_id'=>$userId]);
    }

    public function config($userId)
    {

        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $usermigrateCol = $mongo->getCollectionForTable(self::collectionName);
        $usermigrateCol->updateOne(['user_id' => $userId], ['$set' => ['msg' => 'ConfigStart']]);
        //TODO
        // change source to single account
        $singleHomeDb = $this->getSingleHomeDb();
        //$mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        //$productcollection = $mongo->getCollectionForTable('product_container');
        $user_services = $singleHomeDb->selectCollection('user_details');
        $configDB = $singleHomeDb->selectCollection('configuration');


        // $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        // $user_services = $mongo->getCollectionForTable("user_details");
        // $configDB = $mongo->getCollectionForTable("configuration");

        if (!isset($userId)) {
            return ['success' => false, 'message' => 'user_id is missing in data'];
        }

        $old_user_id = $userId; //$data['user_id'];
        $new_user_id = $userId;

        $user_details = $user_services->findOne(['user_id' => $old_user_id]);
        $config = $configDB->findOne(['user_id' => $old_user_id]);
        $config = json_decode(json_encode($config), true);
        // print_r($user_details['shops']);die;
        if (!isset($user_details['shops']) || count($user_details) == 0) {
            return ['success' => false, 'message' => 'user_id not found'];
        }

        $source = [];
        $targets = [];

        $default_app_tag = 'amazon_sales_channel';

        $saveConfig = [];

        foreach ($user_details['shops'] as $shop) {
            if ($shop['marketplace'] == 'shopify') {
                $source = $shop;
            } else if ($shop['marketplace'] == 'amazon') {
                $targets[] = $shop;
            } else {
                return [
                    'success' => false, 'message' => 'given marketplace not found'
                ];
            }
        }

        if (!isset($config['data'])) {
            return [
                'success' => false,
                'message' => 'no Config Data Found'
            ];
        }
        foreach ($targets as $target) {
            if (!isset($user_details['stepsCompleted'])) {
                $saveConfig[] = [
                    'source_shop_id' => (string)$source['_id'],
                    'target_shop_id' => (string)$target['_id'],
                    'key' => 'stepsCompleted',
                    'value' => $user_details['stepsCompleted'] == "4" ? "4" : "0",
                    'user_id' => $new_user_id,
                    "group_code" => "order_sync",
                    "app_tag" => $default_app_tag ?? "default",
                ];
            }


            if (isset($config['data']['order_settings'])) {
                foreach ($config['data']['order_settings'] as $key => $value) {
                    $newKey = $key;

                    $newValue = $value;

                    $flagSkip = false;
                    switch ($key) {
                        case 'tagsInOrder':
                            if (!is_array($value)) {
                                    $value = [];
                            }
                            $saveConfig[] = [
                                'source_shop_id' => (string)$source['_id'],
                                'target_shop_id' => (string)$target['_id'],
                                'key' => 'tags_in_order_enabled',
                                'value' => in_array('seller_id', $value) 
                                || in_array('amazon_order_id', $value)
                                || in_array('amazon', $value),
                                'user_id' => $new_user_id,
                                "group_code" => "order",
                                "app_tag" => $default_app_tag ?? "default",
                            ];
                            $newKey = 'tagsInOrder';
                            $newValue = [
                                "seller_id" => in_array('seller_id', $value),
                                "marketplace_reference_id" => in_array('amazon_order_id', $value),
                                "marketplace" => in_array('amazon', $value),
                                "custom" => false,
                            ];
                            break;
                        case 'order_status':
                            $newKey = 'order_status';
                            $newValue = [
                                "Unshipped" => in_array('Unshipped', $value),
                            ];
                            break;
                        case "amazonOrderIdAsShopifyOrderId":
                            $newKey = 'source_marketplace_order_id_as_order_name';
                            $newValue =  $value;
                            break;
                        case "amazonorderstatusOptions":
                            $flagSkip =  $value;
                            break;
                        case "order_for_product_not_existing":
                            $newKey = 'order_for_product_not_existing';
                            $newValue =  $value;
                            break;
                        case "email_on_failed_order":
                            $newKey = 'email_on_failed_order';
                            $newValue =  $value;
                            break;
                        case "settings_enabled":
                            $newKey = 'order_sync';
                            $newValue =  $value;
                            break;
                        case "amazon_order_channel":
                            $flagSkip =  true;
                            break;
                        default:
                            $newKey = $key;
                    }
                    if ($flagSkip) continue;
                    $saveConfig[] = [
                        'source_shop_id' => (string)$source['_id'],
                        'target_shop_id' => (string)$target['_id'],
                        'key' => $newKey,
                        'value' => $newValue,
                        'user_id' => $new_user_id,
                        "group_code" => "order",
                        "app_tag" => $default_app_tag ?? "default",
                    ];
                }
            }

            if (isset($config['data']['inventory_settings'])) {
                foreach ($config['data']['inventory_settings'] as $key => $value) {
                    $newKey = $key;

                    $newValue = $value;

                    switch ($key) {
                        case 'customize_inventory':
                            // $newKey = 'reserved_inventory';
                            break;
                        case 'settings_selected':
                            $newValue['warehouses_settings'] = true;
                            break;
                        default:
                            $newKey = $key;
                    }

                    $saveConfig[] = [
                        'source_shop_id' => (string)$source['_id'],
                        'target_shop_id' => (string)$target['_id'],
                        'key' => $newKey,
                        'value' => $newValue,
                        'user_id' => $new_user_id,
                        "group_code" => "inventory",
                        "app_tag" => $default_app_tag ?? "default",
                    ];
                }
            }

            if (isset($config['data']['pricing_settings'])) {
                foreach ($config['data']['pricing_settings'] as $key => $value) {
                    $newKey = $key;

                    $newValue = $value;

                    switch ($key) {
                        case 'tagsInOrder':
                            break;
                        default:
                            $newKey = $key;
                    }

                    $saveConfig[] = [
                        'source_shop_id' => (string)$source['_id'],
                        'target_shop_id' => (string)$target['_id'],
                        'key' => $newKey,
                        'value' => $newValue,
                        'user_id' => $new_user_id,
                        "group_code" => "price",
                        "app_tag" => $default_app_tag ?? "default",
                    ];
                }
            }

            if (isset($config['data']['product_settings'])) {
                foreach ($config['data']['product_settings'] as $key => $value) {
                    $newKey = $key;

                    $newValue = $value;
                    $flagSkip = false;
                    switch ($key) {
                        case 'selected_attributes':
                            $newValue = [];
                            if (in_array('product_syncing', $value)) {
                                $saveConfig[] = [
                                    'source_shop_id' => (string)$source['_id'],
                                    'target_shop_id' => (string)$target['_id'],
                                    'key' => 'product_details',
                                    'value' => true,
                                    'user_id' => $new_user_id,
                                    "group_code" => "product",
                                    "app_tag" => $default_app_tag ?? "default",
                                ];
                                $newValue[] = 'product_details';
                            } else {
                                $saveConfig[] = [
                                    'source_shop_id' => (string)$source['_id'],
                                    'target_shop_id' => (string)$target['_id'],
                                    'key' => 'product_details',
                                    'value' => false,
                                    'user_id' => $new_user_id,
                                    "group_code" => "product",
                                    "app_tag" => $default_app_tag ?? "default",
                                ];
                            }
                            if (in_array('images', $value)) {
                                $saveConfig[] = [
                                    'source_shop_id' => (string)$source['_id'],
                                    'target_shop_id' => (string)$target['_id'],
                                    'key' => 'images',
                                    'value' => true,
                                    'user_id' => $new_user_id,
                                    "group_code" => "product",
                                    "app_tag" => $default_app_tag ?? "default",
                                ];
                                $newValue[] = 'images';
                            } else {
                                $saveConfig[] = [
                                    'source_shop_id' => (string)$source['_id'],
                                    'target_shop_id' => (string)$target['_id'],
                                    'key' => 'images',
                                    'value' => false,
                                    'user_id' => $new_user_id,
                                    "group_code" => "product",
                                    "app_tag" => $default_app_tag ?? "default",
                                ];
                            }
                            break;
                        case "settings_enabled":
                            $newKey = 'settings_enabled';
                            $newValue =  $value;
                            break;
                        case "enable_syncing":
                            $flagSkip = true;
                            break;
                        default:
                            $newKey = $key;
                    }

                    if ($flagSkip) continue;
                    $saveConfig[] = [
                        'source_shop_id' => (string)$source['_id'],
                        'target_shop_id' => (string)$target['_id'],
                        'key' => $newKey,
                        'value' => $newValue,
                        'user_id' => $new_user_id,
                        "group_code" => "product",
                        "app_tag" => $default_app_tag ?? "default",
                    ];
                }
            }

            $saveConfig[] = [
                'source_shop_id' => (string)$source['_id'],
                'target_shop_id' => (string)$target['_id'],
                'key' => 'sync_status_with',
                'value' => [
                    "sku" => true,
                    "barcode" => false
                ],
                'user_id' => $new_user_id,
                "group_code" => "product",
                "app_tag" => $default_app_tag ?? "default",
            ];
        }

        $this->di->getLog()->logContent('user_id : ' . $userId, 'info', 'config-migration.log');
        $this->di->getLog()->logContent('config : ' . json_encode($saveConfig), 'info', 'config-migration.log');
        $this->di->getLog()->logContent('x.x.x.x.x.x.x.x.x.x.x', 'info', 'config-migration.log');


        $objectManager = $this->di->getObjectManager();
        $configObj = $objectManager->get('\App\Core\Models\Config\Config');
        $configObj->setUserId($new_user_id);
        $configObj->setConfig($saveConfig);
        return true;
    }
    
    public function order($userId)
    {
        try {
            $this->di->getLog()->logContent('started : ' .$userId , 'info', 'migration-handling.log');
            $this->di->getLog()->logContent(print_r(['time'=>date("h:i:sa")], true) , 'info', 'timeStartOrder.log');

            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array'],
            ];
            $singleHomeDb = $this->getSingleHomeDb();
            $orderContainer = $singleHomeDb->selectCollection('order_container');
            if($userId == '624c4e4fbc43a910726d3566')
            {
                $allOrder = $orderContainer->find(['user_id'=>$userId,'placed_at'=>['$gte'=>'2022-12-15']],$options)->toArray();
    
            } else {
                $allOrder = $orderContainer->find(['user_id'=>$userId,'placed_at'=>['$gte'=>'2022-11-02']],$options)->toArray();
    
            }
            var_dump(count($allOrder));
    
            
            if(!empty($allOrder))
            {
                $migrationHelper = $this->di->getObjectManager()->get(\App\Connector\Components\Migration\MigrationHelper::class);
                $allUserData = $migrationHelper->getUserDetails($userId);
                $sourceShopId = '';
                
                foreach($allUserData['shops'] as $allShop){
                    if($allShop['marketplace'] =='shopify')
                    {
                        $sourceShopId =  $allShop['_id'];
                    }
                }
             //   var_dump(count($allOrder));die;
    
                $count = 0;
    
                foreach($allOrder as $order)
                {
                    echo $count+1;
    
                    $this->di->getLog()->logContent(print_r(['time'=>date("h:i:sa")], true) , 'info', 'timeStartOrder.log');
    
                    if(!empty($order['source_order_data']))
                    {
                        if(isset($order['source_order_data']['success']))
                        {
                            unset($order['source_order_data']['success']);
                        }
                        $orderData = [];
                        $homeShopId = (string)$order['shop_id'];
                        $orderData['shop_id'] = $homeShopId;
                        $orderData['marketplace'] = 'amazon';
                        $orderData['order'] = $order['source_order_data'];
                        $orderData['type'] = "sources";
                        $orderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class, [], $orderData['marketplace']);
                        $preparedData = $orderService->prepareForDb($orderData);
                        if ($preparedData['success']) {
                            $connectorOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class);
                            $params = [];
                            $params['marketplace_shop_id'] = $orderData['shop_id'];
                            $params['marketplace'] = $orderData['marketplace'];
                            $params['marketplace_reference_id'] = $preparedData['data']['marketplace_reference_id'];
                           
    
                            $mongo = $this->di->getObjectManager()->get('\App\Core\Models\BaseMongo');
                            $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
                            $collection = $mongo->getCollection('order_container');
                            $savedOrder = $collection->findOne($params,$options);
                           
                            if(empty($savedOrder))
                            {
                                $connectorOrderService->setSchemaObject('source_order');
                                $preparedData['data']['status']= $order['target_status'];
                                $connectorResponse = $connectorOrderService->create($preparedData['data']);
                                if($preparedData['data']['status']=='failed')
                                {
                                    $failedPrepare = [];
                                    $failedPrepare = [
                                        'shop_id' => $sourceShopId,
                                        'marketplace'=> 'shopify',
                                        'error'=> [$order['target_error_message']]
                                    ];
    
                                    $cifOrderId = $connectorResponse['data']['cif_order_id'];
                                    $this->updateFailedOrder($userId,$cifOrderId,$failedPrepare);
    
                                } else {
                                    if ($connectorResponse['success']) {
                                        
                                        if(!empty($order['target_order_data']))
                                        {
                                          // var_dump($order['target_order_data']); die("vjjv");
    
                                            if(isset($order['target_order_data']['success']) && $order['target_order_data']['success']){
                                                unset($order['target_order_data']['success']);
                                                $sourceCreatedOrder = [];
                                                $sourceCreatedOrder['shop_id'] = $sourceShopId;
                                                $sourceCreatedOrder['marketplace'] = 'shopify';
                                                $sourceCreatedOrder['order'] = $order['target_order_data']['data'];
                                                $sourceCreatedOrder['user_id'] = $userId;
                                                $sourceCreatedOrder['status'] = $order['source_status'];
                                                $sourcerOrderService = $this->di->getObjectManager()->get(\App\Connector\Contracts\Sales\OrderInterface::class, [], 'shopify');
                                             //   print_r($sourceCreatedOrder);die;
                                                $sourceOrderCreate = $sourcerOrderService->prepareForDb($sourceCreatedOrder);
                                               
                                            //   var_dump($sourceOrderCreate);die;
    
                                                if($sourceOrderCreate['success'])
                                                {
                                                    $connectorOrderService->setSchemaObject('target_order');
                                                    $sourceOrderCreate['data']['cif_order_id'] = $connectorResponse['data']['cif_order_id'];
                                                    $sourceOrderCreate['data']['targets'] = [
                                                        [
                                                            'shop_id' => $connectorResponse['data']['shop_id'],
                                                            'marketplace'=> $connectorResponse['data']['marketplace'],
                                                            'order_id'=> $connectorResponse['data']['marketplace_reference_id'],
                                                            'status'=> $connectorResponse['data']['marketplace_status']
                                                        ]
                                                    ];
                        
                                                    $connectorTargetResponse = $connectorOrderService->create($sourceOrderCreate['data']); 
                                                    if($connectorTargetResponse['success']){
                                                        $cifOrderId = $connectorResponse['data']['cif_order_id'];
                                                        $sucessOrderUpdate = [];
                                                        $successOrderUpdate['shop_id'] = $connectorTargetResponse['data']['shop_id'];
                                                        $successOrderUpdate['marketplace'] = $connectorTargetResponse['data']['marketplace'];
                                                        $successOrderUpdate['order_id'] = (string) $connectorTargetResponse['data']['marketplace_reference_id'];
                                                        $this->updateSuccessOrder($userId,$cifOrderId,$successOrderUpdate);
                                                        //$allSuccessSourceOrder[] = $successOrderUpdate;
                                                    }                   
                                                } 
                                            }
                                            
                                            
        
                                        }
                                    }
                                }
    
                                
                                
                            }
                            
                        }
                    }
                }
                $this->di->getLog()->logContent(print_r(['time'=>date("h:i:sa")], true) , 'info', 'timeStartOrder.log');
    
            }
            $this->plan($userId);
            $this->deleteOldWebhook($userId);
        } catch (\Exception $th) {
            $this->di->getLog()->logContent('res : ' . print_r($th->getMessage()) , 'info', 'migration-handling.log');

        }
       
    }

    public function updateSuccessOrder($user_id, $cifOrderId,$successOrder)
    {
         $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
         $collection = $mongo->getCollectionForTable('order_container');
         $checkTargetsObj = $collection->findOne(['user_id'=>$user_id,'cif_order_id'=>$cifOrderId,'object_type'=>'source_order','targets.shop_id'=>$successOrder['shop_id']],["typeMap" => ['root' => 'array', 'document' => 'array']]);
         if($checkTargetsObj){
             $collection->updateOne(['user_id'=>$user_id,'cif_order_id'=>$cifOrderId,'object_type'=>'source_order','targets.shop_id'=>$successOrder['shop_id']],['$set'=>['targets.$[target_base].status'=>'Created','targets.$[target_base].order_id'=>$successOrder['order_id']]], ['arrayFilters'=> [['target_base.shop_id'=>$successOrder['shop_id']]]]);
         } else {
             $addTargets = [];
             $addTargets['shop_id'] = $successOrder['shop_id'];
             $addTargets['marketplace'] = $successOrder['marketplace'];
             $addTargets['order_id'] = $successOrder['order_id'];
             $addTargets['status'] = 'Created';
             $collection->updateOne(['user_id'=>$user_id,'cif_order_id'=>$cifOrderId,'object_type'=>'source_order'],['$addToSet'=>['targets'=>$addTargets]]);            
         }
    }

    public function updateFailedOrder($user_id,$cifOrderId,$failedOrder)
    {
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $collection = $mongo->getCollectionForTable('order_container');
        $addTargets = [];
        $addTargets['shop_id'] = (string)$failedOrder['shop_id'];
        $addTargets['marketplace'] = $failedOrder['marketplace'];
        $addTargets['errors'] = $failedOrder['error'];
        $addTargets['status'] = 'failed';
        $collection->updateOne(['user_id'=>$user_id,'cif_order_id'=>$cifOrderId,'object_type'=>'source_order'],['$addToSet'=>['targets'=>$addTargets]]);
    }
    

    public function getMultiRemoteDb()
    {
        $db = $this->di->get(self::multiRemote);
        return $db;
    }

    public function getSingleRemoteDb()
    {
        $db = $this->di->get(self::singleRemote);
        return $db;
    }

    public function getSingleHomeDb()
    {
        $db = $this->di->get(self::singleHome);
        return $db;
    }

    public function afterProductImport(Event $event, $myComponent, $data)
    {
        try {
            $date = date('d-m-Y');
        $logFile = "amazonmigration/AfterMigrationProductImport/{$date}.log";
        $data['user_id_set'] = $this->di->getUser()->id;
        $this->di->getLog()->logContent('afterProductImport start event Data = ' . print_r($data, true), 'info', $logFile);
       
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $collection = $mongo->getCollectionForTable(self::collectionName);
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array'],
        ];
        $user_id = $this->di->getUser()->id;
        $userMigrationSave = $collection->findOne(['user_id'=>$user_id],$options);
        
        if(empty($userMigrationSave))
        {
            echo "not found in user migration";
            return;
        } 
        if($userMigrationSave['completed'])
        {
            echo "user migration done";
            return;
        } elseif($userMigrationSave['completed']=='true')
        {
            echo "user migration done";
            return;
        }
        $singleHomeDb = $this->getSingleHomeDb();
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $productcollection = $mongo->getCollectionForTable('product_container');
        $collection = $singleHomeDb->selectCollection('product_container');
        $condition = [];
        $condition[] = [
            '$match' => [
                '$and' => [
                    [
                        "user_id"=>$user_id,
                        'profile' => ['$exists'=>true]]
                ]
            ]
        ];
        $profileArray = $collection->aggregate($condition)->toArray();
        if(!empty($profileArray))
        {
            foreach($profileArray as $profile)
            {
                $sourceProductId = $profile['source_product_id'];
                $containerId = $profile['container_id'];
               
                if($profile['visibility'] == 'Catalog and Search')
                {
                    if(isset($profile['profile']))
                    {
                        $productcollection->updateOne(['user_id' => $user_id,'source_product_id'=>$sourceProductId], ['$set'=>['old_profile'=>$profile['profile']]]);

                    }
                } 
            }
        }
        $data = [
            'user_id'=>$user_id,
            'completed'=>false,
            'step'=>4,
            'abort'=> false,
            'msg'=> 'product import completed'
        ];
        $this->saveUserMigratesDetails($data,$user_id);

        $this->stepComplete($user_id);
        $this->config($user_id);
        $data = [
            'user_id'=>$user_id,
            'completed'=>false,
            'step'=>5,
            'abort'=> false,
            'msg'=> 'product setting completed'
        ];
        $this->saveUserMigratesDetails($data,$user_id);

        $this->plan($user_id);
        $data = [
            'user_id'=>$user_id,
            'completed'=>false,
            'step'=>6,
            'abort'=> false,
            'msg'=> 'customer plan completed'
        ];
        $this->saveUserMigratesDetails($data,$user_id);

        $this->editProductMove($user_id);
        $data = [
            'user_id'=>$user_id,
            'completed'=>false,
            'step'=>8,
            'abort'=> false,
            'msg'=> 'customer edit info completed'
        ];
        $this->saveUserMigratesDetails($data,$user_id);

        $this->profile($user_id);
        $data = [
            'user_id'=>$user_id,
            'completed'=>false,
            'step'=>9,
            'abort'=> false,
            'msg'=> 'customer profile completed'
        ];
        $this->saveUserMigratesDetails($data,$user_id);

        $this->order($user_id);
        $endDate = date("c");
        $data = [
            'user_id'=>$user_id,
            'completed'=>true,
            'step'=>10,
            'abort'=> false,
            'msg'=> 'user amazon setup',
            'end_migration'=>$endDate
        ];
        $this->saveUserMigratesDetails($data,$user_id);
        $this->addNotification($user_id);
        } catch (\Exception $th) {
            $this->di->getLog()->logContent('res : ' . print_r($th->getMessage()) , 'info', 'migration-handling1.log');
        }
        

        
    }



    public function stepComplete($userId)
    {
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $usermigrateCol = $mongo->getCollectionForTable(self::collectionName);
        $usermigrateCol->updateOne(['user_id'=>$userId],['$set'=>['msg'=>'StepCompletedStart']]);

        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $userDetails = $mongo->getCollectionForTable('user_details');
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array'],
        ];
        $user = $userDetails->findOne(['user_id'=>$userId], $options);
      
        if(!empty($user))
        {
            $shops = $user['shops'];
            foreach($shops as $shop)
            {
                if($shop['marketplace']=='amazon')
                {
                    $amazonHomeShopId = $shop['_id'];
                    $sellername = $shop['warehouses'][0]['region'].'_'.$shop['warehouses'][0]['marketplace_id'].'_'.$shop['warehouses'][0]['seller_id'];
                } 
            }
            if(isset($sellername))
            {

                $userDetails->updateOne(['user_id'=>$userId,'shops._id'=>$amazonHomeShopId],['$set'=>['shops.$[homeShop].sellerName'=>$sellername]], ['arrayFilters'=> [['homeShop._id'=>$amazonHomeShopId]]]);

                $config = $mongo->getCollectionForTable('config');
                $config->updateOne(['user_id'=>$userId,'key'=>'stepsCompleted'],['$set'=>['value'=>4]]);
            }
        }
        
    }

    public function plan($userId)
    {
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $usermigrateCol = $mongo->getCollectionForTable(self::collectionName);
        $usermigrateCol->updateOne(['user_id'=>$userId],['$set'=>['msg'=>'PlanStart']]);

        $singleHomeDb = $this->getSingleHomeDb();
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
       
        $payment = $singleHomeDb->selectCollection('payment_details');
        $filters = [];
        $filters['user_id'] = $userId;

        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array'],
        ];
        
        
        $getPayment = $payment->find($filters, $options)->toArray();

        $getPayment = json_decode(json_encode($getPayment),true); 
        $newGetPayment = $mongo->getCollectionForTable('payment_details');
        $res = $newGetPayment->deleteMany(['user_id'=>$userId]);

        $newuserpayment = $newGetPayment->findOne(['user_id'=>$userId], $options);
      //  var_dump($res,$userId);die;
        if(!empty($newuserpayment))
        {
            return;
        }
        if(!empty($getPayment) && isset($getPayment[0]))
        {
            $user = $singleHomeDb->selectCollection('user_details');
            $user = $user->findOne(['user_id'=>$userId], $options);
            $shopifyShopId = '';
            if(isset($user['shops']))
            {
                foreach($user['shops'] as $shop)
                {
                    if($shop['marketplace']=='shopify')
                    {
                        $shopifyShopId = (string)$shop['_id'];
                        break;
                    }
                }
            }
            if(!empty($shopifyShopId))
            {

                $addExtraData = [
                    'source_id'=>$shopifyShopId,
                    "app_tag"=>"amazon_sales_channel",
                    "source_marketplace" =>"shopify",
                    "target_marketplace" => "amazon",
                    "method" => "shopify",
                ];
               // var_dump($addExtraData);die;

                foreach($getPayment as $payment)
                {
                    $type = $payment['type'];
                    $addPayment = [];

                    if($type='payment')
                    {
                       // $type = $payment['type'];
                        $addPayment = array_merge($payment,$addExtraData);
                    } elseif($type='quote')
                    {
                       // $type = $payment['type'];
                        $addPayment['plan_details'] = array_merge($payment['plan_details'],$addExtraData);
                    }
                    elseif($type='active_plan')
                    {
                        //$type = $payment['type']; 
                        $addPayment['plan_details'] = array_merge($payment['plan_details'],$addExtraData);
                    }
                    elseif($type='user_service')
                    {
                       // $type = $payment['type'];
                    //    $payment['prepaid']['available_credits'] = $payment['prepaid']['service_credits'];
                    //    $payment['prepaid']['total_used_credits'] = 0;
                    //    $payment['postpaid']['available_credits'] = $payment['prepaid']['capped_credit'];
                    //    $payment['postpaid']['total_used_credits'] = 0;
                        $addPayment = array_merge($payment,$addExtraData);
                    }
                    elseif($type='monthly_usage')
                    {
                       // $type = $payment['type'];
                      
                       $addPayment = array_merge($payment,$addExtraData);
                    }
                    if(isset($addPayment['_id']))
                        unset($addPayment['_id']);
                    if(isset($addPayment['plan_details']) && isset($addPayment['plan_details']['_id']))
                        unset($addPayment['plan_details']['_id']);
                    if(isset($addPayment['plan']) && isset($addPayment['plan']['details']))
                        unset($addPayment['plan']['details']['_id']);
                    $newGetPayment->insertOne($addPayment);
                }
             
            }
     
        }

        

    }

    public function getCounter($counterKey)
    {
        $db = $this->getMultiRemoteDb();
        $counterCollection = $db->selectCollection('counter');

        $document = $counterCollection->findOneAndUpdate(
            ['_id'=>$counterKey ],
            ['$inc'=>['sequence_value'=>1]],
            ['writeConcern' => new \MongoDB\Driver\WriteConcern(\MongoDB\Driver\WriteConcern::MAJORITY)]
        );
        return (string)$document->sequence_value;
    }

    public function saveUserMigratesDetails($data,$userId)
    {
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $usermigrateCol = $mongo->getCollectionForTable(self::collectionName);
        $usermigrateCol->updateOne(['user_id'=>$userId],['$set'=>$data],['upsert'=>true]);
       // return ['success'=>false,'message'=>$data['msg']];

    }

    public function deleteOldWebhook($userId)
    {
        
        $mongo = $this->di->getObjectManager()->create(\App\Core\Models\BaseMongo::class);
        $collection = $mongo->getCollectionForTable('user_details');
        $userInfo = $collection->findOne(['user_id'=>$userId], ["typeMap" => ['root' => 'array', 'document' => 'array']]);
        
        if(!empty($userInfo))
        {
            $sourceShopId = '';
        
            foreach($userInfo['shops'] as $allShop){
                if($allShop['marketplace'] =='shopify')
                {
                    $sourceShopId =  $allShop['remote_shop_id'];
                }
            }
            $responseWbhook = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                                ->init('shopify', 'true')
                                ->call("/webhook", [], ['shop_id' => $sourceShopId], 'GET');
           // var_dump($responseWbhook);die;

            if(isset($responseWbhook['success']) && $responseWbhook['success'])
            {
                $webhooks = $responseWbhook['data'];
                foreach($webhooks as $webhook)
                {
                    $address = $webhook['address'];
                    if (strpos($address, 'multiaccount') !== false) {
                        
                    } else {
                        $responseWbhook = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
                        ->init('shopify', 'true')
                        ->call("/webhook/unregister", [], ['shop_id' => $sourceShopId, 'id' => $webhook['id'], 'topic' => $webhook['topic']], 'DELETE');

                    }
                }

            }


        }
       

    }
    public function addNotification($user_id)
    {
        
        try {
            $user_details=$this->di->getUser()->getConfig();
        

        $sourceShopId = '';
        
            foreach($user_details['shops'] as $allShop){
                if($allShop['marketplace'] =='shopify')
                {
                    $sourceShopId =  $allShop['_id'];
                }
            }
            echo "here";
            echo $sourceShopId;

            if (!empty($sourceShopId)) {
                $res = $this->di->getObjectManager()->get('\App\Connector\Models\Notifications')->addNotification(
                    $sourceShopId,
                    [
                        "user_id" => $user_id,
                        "marketplace" => 'amazon',
                        "message" =>'Migration completed at : '.date('c'),
                        "severity" => "success",
                        "shop_id" => $sourceShopId,
                        "appTag"=>'amazon_sales_channel'
                    ]
                ); 

               

            }
            $this->pushToQueue($user_id);
            return true;
        
        } catch (\Exception $th) {
            $this->di->getLog()->logContent('res : ' . print_r($th->getMessage()), 'info', 'migration_check.log');
            ;
        }
        
    }
    public function pushToQueue($user_id,$result=true)
    {
        $db = $this->di->get(self::singleHome);
        $collection = $db->selectCollection("tobemigrated_user");
        $data=$collection->findOne(['user_id'=>$user_id]);
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        if (!empty($data)) {
            if($result){
                $res=$collection->updateOne(['user_id'=>$user_id],['$set'=>['migration_completed'=>true]]);
                $this->di->getLog()->logContent('update : '.$user_id .'=>' . json_encode($res,128), 'info', 'test-migration.log');
            }else{
                 $user_details=$db->selectCollection("user_details");
                $res=$collection->updateOne(['user_id'=>$user_id],['$set'=>['migration_aborted'=>true]]);
                $res=$user_details->updateOne(['user_id'=>$user_id],['$set'=>['migration_aborted'=>true]]);
                $migrate_collection = $mongo->getCollectionForTable('user_migrate_progress');
                $user_details_multi = $mongo->getCollectionForTable('user_details');
                $user_details_multi->deleteOne(['user_id'=>$user_id]);
                $migrate_collection->deleteOne(['user_id'=>$user_id]);
                $this->di->getLog()->logContent('delete user : '.$user_id . json_encode($res,128), 'info', 'test-migration.log');
            }
            $next_user=$collection->findOne(['_id'=>['$gt'=>new \MongoDB\BSON\ObjectId($user_id)],'migration_initiated'=>['$exists'=>false],'migration_aborted'=>['$exists'=>false]],["typeMap" => ['root' => 'array', 'document' => 'array']]);
            $this->di->getLog()->logContent('next : ' . json_encode($next_user,128), 'info', 'test-migration.log');
            if(isset($next_user['user_id']))
            {
                $collection2 = $mongo->getCollectionForTable('user_details');
                $data=$collection2->findOne(['user_id'=>$next_user['user_id']]);
                if(empty($data)){
                    $collection->updateOne(['user_id'=>$next_user['user_id']],['$set'=>['migration_initiated'=>true]]);
                    $sqsData=[
                        "type"=> "full_class",
                        "class_name"=> "\\App\\Connector\\Components\\Migration\\Migration",
                        "method"=> "isStart",
                        "userid"=> $next_user['user_id'],
                        "queue_name"=> "user_migration",
                        "app_code"=> "amazon_sales_channel",
                        "marketplace"=> "shopify",
                        "step"=>1
                    ];
                    $rmqHelper = $this->di->getObjectManager()->get('App\Core\Components\Message\Handler\Sqs');
                    $rmqHelper->pushMessage($sqsData);
                }
                else{
                    $this->pushToQueue($next_user['user_id']);
                }
            }
    
        }
        return true;
        
    }

}


