<?php

namespace App\Connector\Components;

use Phalcon\Events\Event;

class AppReInstallEvent extends \App\Core\Components\Base
{

    /**
     * @param Event $event
     * @param $myComponent
     */
    public function appReInstall(Event $event, $myComponent, $data)
    {
        $userId = $this->di->getUser()->id;
        $userName = $this->di->getUser()->username;
        $email = $this->di->getUser()->email;
        $userDetails = $this->di->getObjectManager()->get('\App\Core\Models\User\Details');
        $mongo = $this->di->getObjectManager()->get("App\Core\Models\BaseMongo");
        $userDetailCollection = $mongo->getCollection("user_details");
        $shop  = $data['source_shop'];
        $appCode = $data['re_install_app'];
        $isBackFound = $userDetails->isBackupPresent($userName, $email, $appCode);

        $unsetOperations = [
            'shops.$[shop].apps.$[app].erase_data_after_date' => true,
            'shops.$[shop].apps.$[app].uninstall_date' => true,
            'shops.$[shop].apps.$[app].temporarly_uninstall' => true,
        ];

        $updateDocument = ['$unset' => $unsetOperations];

        if ($isBackFound['success']) {
            $updateDocument['$set'] = [
                'shops.$[shop].apps.$[app].reinstalled' => true
            ];
        }

        $userDetailCollection->updateOne(
            ["user_id" => $userId],
            $updateDocument,
            [
                'arrayFilters' => [
                    [
                        'shop._id' => $shop['_id']
                    ],
                    [
                        'app.code' => $appCode
                    ]
                ]
            ]
        );
        $this->di->getObjectManager()->get("\App\Core\Models\User\Details")->setStatusInUser("active", false, $shop['_id'], $appCode);

        if (isset($shop['targets'])) {
            foreach ($shop['targets'] as $target) {
                $targetUpdateResponse = $userDetailCollection->updateOne(
                    ['user_id' => $userId],
                    [
                        '$unset' => [
                            'shops.$[shop].sources.$[source].disconnected' => true
                        ]
                    ],
                    [
                        'arrayFilters' => [
                            ['shop._id' => $target['shop_id']],
                            ['source.shop_id' => $shop['_id'], 'source.app_code' => $appCode ,'source.erase_data_after_date' => ['$exists' => false]]
                        ]
                    ]
                );
                if ($targetUpdateResponse->getModifiedCount()) {
                    $userDetailCollection->updateOne(
                        ['user_id' => $userId],
                        [
                            '$unset' => [
                                'shops.$[shop].targets.$[target].disconnected' => true
                            ]
                        ],
                        [
                            'arrayFilters' => [
                                ['shop._id' => $shop['_id']],
                                ['target.shop_id' => $target['shop_id'], 'target.app_code' => $target['app_code']]
                            ]
                        ]
                    );
                }
            }
        }
    }
}
