<?php

return array(
    "restapi" => [
        "v1" => [
            "GET" => [
                "routes" => [
                    "subscriptions" => [
                        "url" => "subscriptions",
                        "method" => "getSubscriptions",
                        "resource" => "getSubscriptions",
                        "component" => "Subscription",
                    ],
                    "subscriptions/get-single" => [
                        "url" => "subscription/get-single",
                        "method" => "getSingleSubscription",
                        "resource" => "getSingleSubscription",
                        "component" => "Subscription",
                    ],
                    "hosted-pages" => [
                        "url" => "hosted-pages",
                        "method" => "getHostedPages",
                        "resource" => "getHostedPages",
                        "component" => "HostedPages",
                    ],
                    "hosted-pages/get-single" => [
                        "url" => "hosted-pages/get-single",
                        "method" => "getSingleHostedPage",
                        "resource" => "getSingleHostedPage",
                        "component" => "HostedPages",
                    ]
                ]
            ],
            "POST" => [
                "routes" => [
                    "hosted-pages/acknowledge" => [
                        "url" => "hosted-pages/acknowledge",
                        "method" => "acknowledgeHostedPage",
                        "resource" => "acknowledgeHostedPage",
                        "component" => "HostedPages",
                    ],
                    "subscriptions/cancel-for-items" => [
                        "url" => "subscriptions/cancel-for-items",
                        "method" => "cancelForItems",
                        "resource" => "cancelForItems",
                        "component" => "Subscription",
                    ],
                    "subscriptions/update-for-items" => [
                        "url" => "subscriptions/update-for-items",
                        "method" => "updateForItems",
                        "resource" => "updateForItems",
                        "component" => "Subscription",
                    ],
                ],
            ],
        ]
    ]
);
