# How to setup chargebee app on remote admin panel
### Creating app on admin panel
* Pull and setup latest version of [remote admin panel](https://github.com/cedcommerce/react-remote-admin) and login as admin
* Click on `Create New App` button and select `chargebee` from app dropdown list
* It is required to fill `App Code`, `Group Code` & `Marketplace Handler` fields as `chargebee`
> As chargebee is a global app, which will be common and available for all users on your server, so there is currently no way to determine the app code and we have to agree on common app code.
* `site_name` field is the name of your sub domain on chargebee. (if your sub domain is abc.chargebee.com then fill "abc" on "site_name")
* Fill your chargebee api key on `api_key` field
* Other fields like `App Location` , `Erase Time` can be ignored (add dummy values if required)
* Save your data to create app config

### Giving sub user permissons
* go to `Sub Users > [Your Sub User] > Edit` to open apps listed for your sub user
* Click on the checkbox before Chargebee app to add app.
* Click on the lock button at last of Chargebee app to unlock it. (button icon will change to circle tick after unlock)
* Other columns like `Auth Url` , `domain`, `Frontend Uri` can be ignored (add dummy values if required)
* In the `ACL Group` table, check `webapi > rest > v1` 
* Click on "Update" button to update your sub user

### Setting up tokens
* Logout from admin panel as an admin and then login from your sub user
* Scroll down until you see your Chargebee app
* Click on `Create Access Token` button to generate access token.
* navigate to your server/docker's `home/app/etc/config.php` file and add these keys inside `apiconnector` key
```php
'chargebee' => [
            'chargebee' => [
                'sub_app_id' => ,
                'refresh_token' => '',
                'public_key' => ''
            ]
        ]
```
* Navigate back to your admin panel
* Copy the `App Id` & paste on `sub_app_id` key
* Click on `Copy Access Token` & paste on `refresh_token` key
* Click on `Copy Secret Key` & paste on `public_key` key

### Setup Payment Config
* Navigate to your server/docker's `home/app/etc/config.php` file and add these keys.
```php
'payment_config' => [
        'app_tag' => 'chargebee',
        'app_name' => '',
        'source_marketplace' => '',
        'target_marketplace' => '',
        'payment_method' => 'chargebee',
        'marketplace' => 'chargebee',
        'marketplace_app_code' => 'chargebee'
    ]
```
* fill `app_name`, `source_marketplace`, `target_marketplace` according to your app.

Finally need to upgrade the setup. if you are on docker then perform `bin/update`. if you are on server then navigate to your home setup directory and perform `php app/cli setup:upgrade` & `php app/cli cache:flush`
