# Subscriptions API Docs
A Chargebee subscription contains a customer record to products/services. It describes what the customer has signed up for and how often they're charged for it.

### Get all subscriptions
Returns list of all subscriptions.
```
/subscriptions (GET)
```
###### Parameters
* **limit:** (1-100) default 10
* **offset:** used for pagination. it is returned by response on `next_offset` key
* **filter:** used to filter data [know more](../api-docs.md#how-to-pass-filters-)
<details>
  <summary>Response</summary>

  ```json
  {
    "success": true,
    "data": [
        {
            "customer": {
                "allow_direct_debit": false,
                "auto_collection": "off",
                "card_status": "no_card",
                "created_at": 1612890938,
                "deleted": false,
                "excess_payments": 0,
                "first_name": "John",
                "id": "__test__8asukSOXe0QYSR",
                "last_name": "Doe",
                "net_term_days": 0,
                "object": "customer",
                "pii_cleared": "active",
                "preferred_currency_code": "USD",
                "promotional_credits": 0,
                "refundable_credits": 0,
                "resource_version": 1612890938000,
                "taxability": "taxable",
                "unbilled_charges": 0,
                "updated_at": 1612890938
            },
            "subscription": {
                "activated_at": 1612890938,
                "billing_period": 1,
                "billing_period_unit": "month",
                "created_at": 1612890938,
                "currency_code": "USD",
                "current_term_end": 1615310138,
                "current_term_start": 1612890938,
                "customer_id": "__test__8asukSOXe0QYSR",
                "deleted": false,
                "due_invoices_count": 1,
                "due_since": 1612890938,
                "has_scheduled_changes": false,
                "id": "__test__8asukSOXe0W3SU",
                "mrr": 0,
                "next_billing_at": 1615310138,
                "object": "subscription",
                "remaining_billing_cycles": 1,
                "resource_version": 1612890938000,
                "started_at": 1612890938,
                "status": "active",
                "subscription_items": [
                    {
                        "amount": 1000,
                        "billing_cycles": 1,
                        "free_quantity": 0,
                        "item_price_id": "basic-USD",
                        "item_type": "plan",
                        "object": "subscription_item",
                        "quantity": 1,
                        "unit_price": 1000
                    }
                ],
                "total_dues": 1100,
                "updated_at": 1612890938
            }
        }
    ],
    "next_offset": "[\"1686307397000\",\"41385805\"]"
}
  ```
</details>

### Get specific subscription
Returns a specific subscription via subscription id.
```
/subscriptions/get-single (GET)
```
###### Parameters
* **subscription_id:**\* id of subscription
<details>
  <summary>Response</summary>

  ```json
  {
    "success": true,
    "data": {
        "customer": {
            "allow_direct_debit": false,
            "auto_collection": "off",
            "card_status": "no_card",
            "created_at": 1612890938,
            "deleted": false,
            "excess_payments": 0,
            "first_name": "John",
            "id": "__test__8asukSOXe0QYSR",
            "last_name": "Doe",
            "net_term_days": 0,
            "object": "customer",
            "pii_cleared": "active",
            "preferred_currency_code": "USD",
            "promotional_credits": 0,
            "refundable_credits": 0,
            "resource_version": 1612890938000,
            "taxability": "taxable",
            "unbilled_charges": 0,
            "updated_at": 1612890938
        },
        "subscription": {
            "activated_at": 1612890938,
            "billing_period": 1,
            "billing_period_unit": "month",
            "created_at": 1612890938,
            "currency_code": "USD",
            "current_term_end": 1615310138,
            "current_term_start": 1612890938,
            "customer_id": "__test__8asukSOXe0QYSR",
            "deleted": false,
            "due_invoices_count": 1,
            "due_since": 1612890938,
            "has_scheduled_changes": false,
            "id": "__test__8asukSOXe0W3SU",
            "mrr": 0,
            "next_billing_at": 1615310138,
            "object": "subscription",
            "remaining_billing_cycles": 1,
            "resource_version": 1612890938000,
            "started_at": 1612890938,
            "status": "active",
            "subscription_items": [
                {
                    "amount": 1000,
                    "billing_cycles": 1,
                    "free_quantity": 0,
                    "item_price_id": "basic-USD",
                    "item_type": "plan",
                    "object": "subscription_item",
                    "quantity": 1,
                    "unit_price": 1000
                }
            ],
            "total_dues": 1100,
            "updated_at": 1612890938
        }
    }
}
  ```
</details>

### Update subscription for items
Updates the subscription.
```
/subscriptions/update-for-items (POST)
```
###### Parameters
* **subscription_id:**\* id of subscription
* **\<key\>:** a key can be any valid key that you want to update in subscription data along with the data
* This API will return the updated subscription data on response.

### Cancel subscription for items
Cancels the subscription.
```
/subscriptions/cancel-for-items (POST)
```
###### Parameters
* **subscription_id:**\* id of subscription
* **end_of_term:** default value `false`. 
set this value to `false` to cancel the subscription immediately. if the value is set as `true`, then status of the subscription will be changed to `non_renewing` and it will be cancelled at the end of billing cycle
* **cancel_at:** timestamp (in milliseconds) . Specify the date/time at which you want to cancel the subscription `(end_of_term = false)`
* This API will return the updated subscription data on response.
