# API documentation
before starting, make sure to read some important points to have better understanding
#### Section wise API docs
* [Subscriptions](./api-docs/subscriptions.md)
#### How to call any API from home ?
* Create a client object. (app code & marketplace will be 'chargebee')
* Use call() from client object to call your api
```php
const CODE = "chargebee";
$params = [
    'limit' => 2,
    'filter' => [
        id => [
            "starts_with" => "gfgewW"
        ]
    ]
];
$client = $this->di->getObjectManager()->get("\App\Connector\Components\ApiClient")
            ->init(self::CODE, 'true', self::CODE);
$response = client->call('subscriptions', [], $params, "GET");
```
> There is not need to pass `shop_id` (remote shop id) on $params as chargebee is global app, and will be same across all users on your server

#### How to pass filters ?
* Certain API (like subscriptions) support filters.
* All filters are passed on `filter` key inside `$params`
* A filter has following structure:
```
<key> => [
        <condition> => <value>
    ]
    
A <key> can be a valid key that exists on data
A <condition> can be a valid operator supported by that <key> (list of conditions are mentioned below)
```
#### List of supported filter conditions
* **is :** matches data where a \<value> is equals to the value of \<key>
* **is_not :** matches data where a \<value> is not equals to the value of \<key>
*  **starts_with :** matches data where value of the \<key> starts with your \<value>

These filters will be applicable on numeric data
* **gt :** matches data where a \<value> is greater than the value of \<key>
* **gte :** matches data where a \<value> is greater than and equals to the value of \<key>
* **lt :** matches data where a \<value> is less than the value of \<key>
* **lte :** matches data where a \<value> is less than and equals to the value of \<key>

These filters will be applicable on dates & timestamps
* **before :** matches data where a \<value> is before the value of \<key>
* **after :** matches data where a \<value> is after the value of \<key>
> you can also apply filters on your custom fields that you have created on chargebee, syntax will be same.
