<?php

namespace App\Chargebeewebapi\Api;

class Subscription extends Base
{
    public function getSubscriptions($data)
    {
        $valid_res = $this->validateAndSetConfig();

        if (!$valid_res['success']) {
            return $valid_res;
        }

        unset($data['_url']);
        if (isset($data['filter'])) {
            foreach ($data['filter'] as $key => $filter_data) {
                foreach ($filter_data as $op => $value) {
                    $data[$key . "[" . $op . "]"] = $value;
                }
            }
            unset($data['filter']);
        }

        $api_res = $this->rest(self::SUBSCRIPTION_URL, 'GET', $data);
        if (!$api_res['success']) {
            return $api_res;
        }

        $final_res = [
            'success' => true,
            'data' => $api_res['data']['list'],
        ];

        if (isset($api_res['data']['next_offset'])) {
            $final_res['next_offset'] = $api_res['data']['next_offset'];
        }

        return $final_res;
    }

    public function getSingleSubscription($data)
    {
        $valid_res = $this->validateAndSetConfig();

        if (!$valid_res['success']) {
            return $valid_res;
        }

        if (!isset($data['subscription_id']) || $data['subscription_id'] == "") {
            return ['success' => false, 'message' => "Subscription ID is missing"];
        }

        $api_res = $this->rest(self::SUBSCRIPTION_URL . '/' . $data['subscription_id'], 'GET', $data);
        if (!$api_res['success']) {
            return $api_res;
        }

        return [
            'success' => true,
            'data' => $api_res['data'],
        ];
    }

    public function cancelForItems($data)
    {
        $valid_res = $this->validateAndSetConfig();

        if (!$valid_res['success']) {
            return $valid_res;
        }

        if (!isset($data['subscription_id']) || $data['subscription_id'] == "") {
            return ['success' => false, 'message' => "Subscription ID is missing"];
        }
        $subscription_id = $data['subscription_id'];
        unset($data['subscription_id']);
        unset($data['_url']);

        $api_res = $this->rest(self::SUBSCRIPTION_URL . '/' . $subscription_id . '/' . self::CANCEL_ITEM_URL, 'POST', $data);
        return $api_res;
    }

    public function updateForItems($data)
    {
        $valid_res = $this->validateAndSetConfig();

        if (!$valid_res['success']) {
            return $valid_res;
        }

        if (!isset($data['subscription_id']) || $data['subscription_id'] == "") {
            return ['success' => false, 'message' => "Subscription ID is missing"];
        }
        $subscription_id = $data['subscription_id'];
        unset($data['subscription_id']);
        unset($data['_url']);

        $api_res = $this->rest(self::SUBSCRIPTION_URL . '/' . $subscription_id . '/' . self::UPDATE_ITEM_URL, 'POST', $data, 'query');
        return $api_res;
    }
}
