<?php

namespace App\Chargebeewebapi\Api;

class HostedPages extends Base
{
    public function getHostedPages($data)
    {
        $valid_res = $this->validateAndSetConfig();

        if (!$valid_res['success']) {
            return $valid_res;
        }

        unset($data['_url']);
        if (isset($data['filter'])) {
            foreach ($data['filter'] as $key => $filter_data) {
                foreach ($filter_data as $op => $value) {
                    $data[$key . "[" . $op . "]"] = $value;
                }
            }
            unset($data['filter']);
        }

        $api_res = $this->rest(self::HOSTED_PAGE_URL, 'GET', $data);
        if (!$api_res['success']) {
            return $api_res;
        }

        $final_res = [
            'success' => true,
            'data' => $api_res['data']['list'],
        ];

        if (isset($api_res['data']['next_offset'])) {
            $final_res['next_offset'] = $api_res['data']['next_offset'];
        }

        return $final_res;
    }

    public function getSingleHostedPage($data)
    {
        $valid_res = $this->validateAndSetConfig();

        if (!$valid_res['success']) {
            return $valid_res;
        }

        if (!isset($data['hosted_page_id']) || $data['hosted_page_id'] == "") {
            return ['success' => false, 'message' => "Hosted page ID is missing"];
        }

        $api_res = $this->rest(self::HOSTED_PAGE_URL . '/' . $data['hosted_page_id'], 'GET', $data);
        if (!$api_res['success']) {
            return $api_res;
        }

        return [
            'success' => true,
            'data' => $api_res['data'],
        ];
    }

    public function acknowledgeHostedPage($data)
    {
        $valid_res = $this->validateAndSetConfig();

        if (isset($valid_res['success']) && !$valid_res['success']) {
            return $valid_res;
        }

        if (!isset($data['hosted_page_id']) || $data['hosted_page_id'] == "") {
            return ['success' => false, 'message' => "Hosted page ID is missing"];
        }

        $url = self::HOSTED_PAGE_URL . '/' . $data['hosted_page_id'] . '/' . self::ACKNOWLEDGE_URL;
        $api_res = $this->rest($url, 'POST', $data);
        if (!$api_res['success']) {
            return $api_res;
        }

        return $api_res;
    }
}
