<?php

namespace App\Chargebeewebapi\Api;

use GuzzleHttp\Client;

class Base extends \App\Apiconnect\Api\Base
{
    const DOMAIN = "chargebee.com";
    const API_VER = "v2";
    const MID_URL = self::DOMAIN . "/api/" . self::API_VER;
    const SUBSCRIPTION_URL = "subscriptions";
    const HOSTED_PAGE_URL = "hosted_pages";
    const ACKNOWLEDGE_URL = "acknowledge";
    const CANCEL_ITEM_URL = "cancel_for_items";
    const UPDATE_ITEM_URL = "update_for_items";
    const PLAN_URL = 'item_prices';
    private $_config = [];

    public function validateAndSetConfig()
    {
        $this->setConfig([]);
        $appConfig = $this->di->getRegistry()->getAppConfig();

        if (empty($appConfig)) {
            return [
                'success' => false,
                'message' => 'App Config is missing'
            ];
        }

        if (
            !isset($appConfig['live']['site_name']) ||
            !isset($appConfig['live']['api_key']) ||
            $appConfig['live']['site_name'] == "" ||
            $appConfig['live']['api_key'] == ""
        ) {
            return [
                'success' => false,
                'message' => 'Site name or API key is missing'
            ];
        }
        $this->setConfig($appConfig['live']);

        return ['success' => true];
    }

    public function rest($api_route, $type, $body, $data_type = null)
    {
        $config = $this->getConfig();
        if (empty($config)) {
            //you are required to call validateAndSetConfig() method,
            //to initialize the config
            return [
                'success' => false,
                'code' => 'remote_config_error',
                'message' => "Config is not initialized",
            ];
        }

        $url = "https://" . $config['site_name'] . '.' . self::MID_URL . '/' . $api_route;

        $headers = [
            'Authorization' => 'Basic ' . base64_encode($config['api_key'])
        ];
        try {
            $response = $this->call($url, $headers, $body, $type, $data_type);
            if (isset($response['error_code'])) {
                return [
                    'success' => false,
                    'message' => $response['message'],
                    'code' => $response['error_code'],
                ];
            }

            return ['success' => true, 'data' => $response];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'code' => 'remote_exception',
                'message' => $e->getMessage(),
            ];
        }
    }

    public function call($url, $headers = [], $data = [], $type = 'GET', $dataType = null)
    {
        $client = new Client(["verify" => false]);
        switch ($type) {
            case 'DELETE':
                $response = $client->delete(
                    $url,
                    [
                        'headers' => $headers,
                        (is_null($dataType) ? 'query' : $dataType) => $data
                    ]
                );
                break;
            case 'DELETE/FORM':
                $response = $client->delete(
                    $url,
                    [
                        'headers' => $headers,
                        (is_null($dataType) ? 'form_params' : $dataType) => $data
                    ]
                );
                break;

            case 'POST':
                $response = $client->post(
                    $url,
                    [
                        'headers' => $headers,
                        (is_null($dataType) ? 'form_params' : $dataType) => $data,
                        'http_errors' => false
                    ]
                );
                break;

            case 'PUT':
                $response = $client->put(
                    $url,
                    [
                        'headers' => $headers,
                        (is_null($dataType) ? 'json' : $dataType) => $data,
                    ]
                );
                break;

            default:
                $response = $client->get(
                    $url,
                    [
                        'headers' => $headers,
                        (is_null($dataType) ? 'query' : $dataType) => $data,
                        'http_errors' => false
                    ]
                );
                break;
        }
        $bodyContent = $response->getBody()->getContents();
        return json_decode($bodyContent, true);
    }

    public function setConfig($config)
    {
        $this->_config = $config;
    }

    public function getConfig()
    {
        return $this->_config;
    }
}
