<?php
return [
    'restapi' => [
        'v1' => [
            'GET' => [
                'routes' => [
                    'event/destination' => [
                        'url' => 'event/destination',
                        'method' => 'getEventDestination',
                        'resource' => 'event/destination',
                        'component' => 'EventDestination',
                    ],
                    'event/subscription' => [
                        'url' => 'event/subscription',
                        'method' => 'getEventSubscription',
                        'resource' => 'event/subscription',
                        'component' => 'EventSubscription',
                    ],
                ]
            ],
            'POST' => [
                'routes' => [
                    'event/destination' => [
                        'url' => 'event/destination',
                        'method' => 'createEventDestination',
                        'resource' => 'event/destination',
                        'component' => 'EventDestination',
                    ],
                    'event/subscription' => [
                        'url' => 'event/subscription',
                        'method' => 'createEventSubscription',
                        'resource' => 'event/subscription',
                        'component' => 'EventSubscription',
                    ],
                    'create/destination' => [
                        'url' => 'create/destination',
                        'method' => 'createDestination',
                        'resource' => 'notification/createDestination',
                        'component' => 'Notification',
                    ],
                    'create/subscription' => [
                        'url' => 'create/subscription',
                        'method' => 'createSubscription',
                        'resource' => 'notification/createSubscription',
                        'component' => 'Notification',
                    ],
                    're-register/webhooks' => [
                        'url' => 're-register/webhooks',
                        'method' => 'reRegisterWebhooks',
                        'resource' => 'base/reRegisterWebhooks',
                        'class' => 'App\Cedcommercewebapi\Api\Base',
                    ]
                ],
            ],
            'PUT' => [
                'routes' => [
                    'event/destination' => [
                        'url' => 'event/destination',
                        'method' => 'updateEventDestination',
                        'resource' => 'event/destination',
                        'component' => 'EventDestination',
                    ],
                    'event/subscription' => [
                        'url' => 'event/subscription',
                        'method' => 'updateEventSubscription',
                        'resource' => 'event/subscription',
                        'component' => 'EventSubscription',
                    ],
                ],
            ],
            'DELETE' => [
                'routes' => [
                    'event/destination' => [
                        'url' => 'event/destination',
                        'method' => 'deleteEventDestination',
                        'resource' => 'event/destination',
                        'component' => 'EventDestination',
                    ],
                    'event/subscription' => [
                        'url' => 'event/subscription',
                        'method' => 'deleteEventSubscription',
                        'resource' => 'event/subscription',
                        'component' => 'EventSubscription',
                    ],
                    'delete/destination' => [
                        'url' => 'delete/destination',
                        'method' => 'deleteDestination',
                        'resource' => 'notification/deleteDestination',
                        'component' => 'Notification',
                    ],
                    'delete/subscription' => [
                        'url' => 'delete/subscription',
                        'method' => 'deleteSubscription',
                        'resource' => 'notification/deleteSubscription',
                        'component' => 'Notification',
                    ],
                    'bulkDelete/subscription' => [
                        'url' => 'bulkDelete/subscription',
                        'method' => 'deleteSubscriptionInBulk',
                        'resource' => 'bulkDelete/subscription',
                        'component' => 'EventSubscription',
                    ],
                ],
            ],
        ],
    ]
];
