<?php

return [
    'marketplace-modules' => [
        "cedcommerce" => "Cedcommercewebapi"
    ],

    'event_webhook'=>[
        'amazon'=>[
            [
                'title'=>"Event for order status change",
                'type'=>"app",
                'event_code'=>"order_status_change",
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for order cancel",
                'type'=>"app",
                'event_code'=>"order_cancel",
                'event_handler'=>"event_bridge",
            ],
            [
                'title'=>"Event for feed update",
                'type'=>"app",
                'event_code'=>"feed_update",
                'event_handler'=>"api_endpoint",
                'api_endpoint'=> "http://home.local.cedcommerce.com:8080/onyx/playground/park"
            ]
        ],
        'shopify'=>[
            [
                'title'=>"Event for App delete",
                'type'=>"user",
                'event_code'=>"app/uninstalled",
                'event_handler'=>"api_endpoint",
                'api_endpoint'=> ""
            ],
            [
                'title'=>"Event for Product Create",
                'type'=>"user",
                'event_code'=>"products/create",
                'event_handler'=>"api_endpoint",
                'api_endpoint'=> ""
            ],
            [
                'title'=>"Event for Product Delete",
                'type'=>"user",
                'event_code'=>"products/delete",
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Product Update",
                'type'=>"user",
                'event_code'=>"products/update",
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Product Listing Update",
                'type'=>"user",
                'event_code' => 'product_listings/update',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Product Listing Add",
                'type'=>"user",
                'event_code' => 'product_listings/add',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Product Listing Remove",
                'type'=>"user",
                'event_code' => 'product_listings/remove',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Inventory Levels Update",
                'type'=>"user",
                'event_code' => 'inventory_levels/update',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Locations Create",
                'type'=>"user",
                'event_code' => 'locations/create',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Locations Update",
                'type'=>"user",
                'event_code' => 'locations/update',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Locations Delete",
                'type'=>"user",
                'event_code' => 'locations/delete',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for App Uninstalled",
                'type'=>"user",
                'event_code' => 'app/uninstalled',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Orders Create",
                'type'=>"user",
                'event_code' => 'orders/create',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Orders Fullfilment",
                'type'=>"user",
                'event_code' => 'orders/fulfilled',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Partially Orders Fullfulment",
                'type'=>"user",
                'event_code' => 'orders/partially_fulfilled',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Orders Cancel",
                'type'=>"user",
                'event_code' => 'orders/cancelled',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Fulfillments Update",
                'type'=>"user",
                'event_code' => 'fulfillments/update',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Fulfillments Create",
                'type'=>"user",
                'event_code' => 'fulfillments/create',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Refund Create",
                'type'=>"user",
                'event_code' => 'refunds/create',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for Shop Update",
                'type'=>"user",
                'event_code' => 'shop/update',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title' => "Event for Order Updated",
                'type' => "user",
                'event_code' => "orders/updated",
                'event_handler' => "api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title'=>"Event for App Subscription Update",
                'type'=>"user",
                'event_code' => 'app_subscriptions/update',
                'event_handler'=>"api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title' => "Event for Customer data request",
                'type' => "app",
                'event_code' => 'customers/data_request',
                'event_handler' => "api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title' => "Event for Customer data erasure",
                'type' => "app",
                'event_code' => 'customers/redact',
                'event_handler' => "api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title' => "Event for Shop data erasure",
                'type' => "app",
                'event_code' => 'shop/redact',
                'event_handler' => "api_endpoint",
                'api_endpoint' => ""
            ],
            [
                'title' => 'Event for fulfillment order notification',
                'type' => 'user',
                'event_code' => 'fulfillment_order_notification',
                'event_handler' => 'api_endpoint',
                'api_endpoint' => ''
            ]
        ],
        'onyx' => [
            [
                'title' => "Event for Product Create",
                'type' => "user",
                'event_code' => "CATALOG_CREATE",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Update",
                'type' => "user",
                'event_code' => "CATALOG_UPDATE",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Delete",
                'type' => "user",
                'event_code' => "CATALOG_DELETE",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Order Placed",
                'type' => "user",
                'event_code' => "ORDER_PLACED",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for uninstall Webhook",
                'type' => "user",
                'event_code' => "UNINSTALL",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for buyability Webhook",
                'type' => "user",
                'event_code' => "BUYABILITY_UPDATE",
                'event_handler' => "sqs",
            ]
        ],
        'zoho' => [
            [
                'title' => "Event for Item Add or Update",
                'type' => "user",
                'event_code' => "item.add_edit",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Item Delete",
                'type' => "user",
                'event_code' => "item.delete",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Inventory Add or Update",
                'type' => "user",
                'event_code' => "inventory_adjustment.add_edit",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Item Delete",
                'type' => "user",
                'event_code' => "inventory_adjustment.delete",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Sales Order Created or Update",
                'type' => "user",
                'event_code' => "salesorder.add_edit",
                'event_handler' => "sqs",
            ]
        ],
        'walmart' => [
            [
                'title' => "Event for Offer Published",
                'type' => "user",
                'event_code' => "OFFER.PUBLISHED",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Offer Unpublished",
                'type' => "user",
                'event_code' => "OFFER.UNPUBLISHED",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Inventory Add or Update",
                'type' => "user",
                'event_code' => "INVENTORY.OOS",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Purchase Order Created or Updated",
                'type' => "user",
                'event_code' => "PO.CREATED",
                'event_handler' => "sqs",
            ]
        ],
        'woocommerce' => [
            [
                'title' => "Event for Item Create",
                'type' => "user",
                'event_code' => "product.created",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Item Delete",
                'type' => "user",
                'event_code' => "product.deleted",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Item Update",
                'type' => "user",
                'event_code' => "product.updated",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Order Update",
                'type' => "user",
                'event_code' => "order.updated",
                'event_handler' => "sqs",
            ],
            [
                'title'=>"Event for Orders Create",
                'type'=>"user",
                'event_code'=>"order.created",
                'event_handler'=>"sqs"
            ]
        ],
        'bigcommerce' => [
            [
                'title' => "Event for Order Created",
                'type' => "user",
                'event_code' => "store/order/created",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Order Updated",
                'type' => "user",
                'event_code' => "store/order/updated",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Customer Created",
                'type' => "user",
                'event_code' => "store/customer/created",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Customer Updated",
                'type' => "user",
                'event_code' => "store/customer/updated",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Created",
                'type' => "user",
                'event_code' => "store/product/created",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Updated",
                'type' => "user",
                'event_code' => "store/product/updated",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Abandoned cart",
                'type' => "user",
                'event_code' => "store/cart/abandoned",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for App UnInstall",
                'type' => "user",
                'event_code' => "store/app/uninstalled",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Delete",
                'type' => "user",
                'event_code' => "store/product/deleted",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for SKU Delete",
                'type' => "user",
                'event_code' => "store/sku/deleted",
                'event_handler' => "sqs",
            ],
        ],
        'shopline' => [
            [
                'title' => "Event for Order Created",
                'type' => "user",
                'event_code' => "orders/create",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Order Updated",
                'type' => "user",
                'event_code' => "orders/updated",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Customer Created",
                'type' => "user",
                'event_code' => "customers/create",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Customer Updated",
                'type' => "user",
                'event_code' => "customers/update",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Created",
                'type' => "user",
                'event_code' => "products/create",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Updated",
                'type' => "user",
                'event_code' => "products/update",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Product Deleted",
                'type' => "user",
                'event_code' => "products/delete",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Inventory Update",
                'type' => "user",
                'event_code' => "inventory_levels/update",
                'event_handler' => "sqs",
            ],
            [
                'title'=>"Event for Fullfilment Creation",
                'type'=>"user",
                'event_code' => 'fulfillments/create',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for Fullfulment Update",
                'type'=>"user",
                'event_code' => 'fulfillments/update',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for Orders Cancel",
                'type'=>"user",
                'event_code' => 'orders/cancelled',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for Locations Create",
                'type'=>"user",
                'event_code' => 'logistics/create',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for Locations Update",
                'type'=>"user",
                'event_code' => 'logistics/update',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for Locations Delete",
                'type'=>"user",
                'event_code' => 'logistics/delete',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for Inventory Connect",
                'type'=>"user",
                'event_code' => 'inventory_levels/connect',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for Inventory Disconnect",
                'type'=>"user",
                'event_code' => 'inventory_levels/disconnect',
                'event_handler'=>"sqs",
            ],
            [
                'title'=>"Event for App Uninstallation",
                'type'=>"user",
                'event_code' => 'apps/installed_uninstalled',
                'event_handler'=>"sqs",
            ],
        ],
        'hubspot' => [
            [
                'title' => "Event for HubSpot Contact Property Update",
                'type' => "user",
                'event_code' => "contact/property/updated",
                'event_handler' => "sqs",
            ],
        ],
        'amazonmcf' => [
            [
                'title' => "Event for account status changed",
                'type' => "user",
                'event_code' => "ACCOUNT_STATUS_CHANGED",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for offer changed",
                'type' => "user",
                'event_code' => "ANY_OFFER_CHANGED",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for B2B offer changed",
                'type' => "user",
                'event_code' => "B2B_ANY_OFFER_CHANGED",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for FBA inventory availability changes",
                'type' => "user",
                'event_code' => "FBA_INVENTORY_AVAILABILITY_CHANGES",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for FBA outbound shipment status",
                'type' => "user",
                'event_code' => "FBA_OUTBOUND_SHIPMENT_STATUS",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for fee promotion",
                'type' => "user",
                'event_code' => "FEE_PROMOTION",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for feed processing finished",
                'type' => "user",
                'event_code' => "FEED_PROCESSING_FINISHED",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for fulfillment order status",
                'type' => "user",
                'event_code' => "FULFILLMENT_ORDER_STATUS",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for MFN order status change",
                'type' => "user",
                'event_code' => "MFN_ORDER_STATUS_CHANGE",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for Order status change",
                'type' => "user",
                'event_code' => "ORDER_STATUS_CHANGE",
                'event_handler' => "sqs",
            ],
            [
                'title' => "Event for report processing finished",
                'type' => "user",
                'event_code' => "REPORT_PROCESSING_FINISHED",
                'event_handler' => "sqs",
            ]
        ]
    ]
];