<?php

namespace App\Cedcommercewebapi\Components;

use Aws\DynamoDb\DynamoDbClient;
use  App\Cedcommercewebapi\Api\Base;

class EventSubscription extends Base
{

    public function createDestinationOnMarketplace($data)
    {
        #Skip marketplace destination call for app type subscription
        if (isset($data['type']) && $data['type'] == 'app') return ['success' => true,  'message' => "Marketplace destination donot create on app type subscription"];

        $awsConfig = include BP . DS . 'app' . DS . 'etc' . DS . 'aws.php';
        $ced_app_shop =  $this->di->getRegistry()->getCurrentCedAppShop();
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        $appConfig = $appModel->getSubConfig($ced_app_shop['sAppId']);
        $shop = $this->di->getRegistry()->getCurrentShop();

        #TODO: check whether createDestination method is available on marketplace
        $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);
        $notificationClass = '\App\\' . $targetMarketplace . '\\Api\\Notification';
        if (class_exists($notificationClass)) {
            if (!method_exists($notificationClass, 'createDestination')) return  ['success' => false, 'message' => 'Class found but createDestination method not found !'];
        } else return  ['success' => false, 'message' => 'Notification Class not found!'];
        $event_destination_config = $this->getEventWebhookConfig($data, $appConfig);

        #TODO: check whether the event destination config is exists 
        if (empty($event_destination_config)) return ['success' => false, 'message' => 'Event destination config not found!'];

        if (empty($data['marketplace_data'])) $data['marketplace_data'] = isset($event_destination_config['marketplace_data']) ? $event_destination_config['marketplace_data'] : [];
        if (!empty($event_destination_config)) {
            $params = [
                'shop_id' => $shop['_id'],
                'marketplace_data' => $data['marketplace_data'] ?? [],
                'event_data' => $event_destination_config
            ];
            $response = $this->marketplacesCall('create/destination', $params, 'POST');


            if ($response['success']) {
                return ['success' => true, 'destination_id' => $response['destination_id'], 'message' => "Marketplace destination created successfully"];
            }
        }
        return ['success' => false, 'message' => "Something went wrong in creating marketplace destination"];
    }


    public function createSubscriptionOnMarketplace($data, $marketplace_destination_id)
    {
        $ced_app_shop =  $this->di->getRegistry()->getCurrentCedAppShop();
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        $appConfig = $appModel->getSubConfig($ced_app_shop['sAppId']);

        if (isset($data['type']) && $data['type'] == 'app') $appConfig['marketplace'] = $data['queue_data']['marketplace'];

        $shop = $this->di->getRegistry()->getCurrentShop();
        $event_destination_config = $this->getEventWebhookConfig($data, $appConfig);
        #TODO: check whether the event destination is exists 
        if (empty($event_destination_config)) return ['success' => false, 'message' => 'Event destination config not found!'];

        if (empty($data['marketplace_data'])) $data['marketplace_data'] = isset($event_destination_config['marketplace_data']) ? $event_destination_config['marketplace_data'] : [];

        #TODO: check whether createSubscription method is available on marketplace
        $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);
        $notificationClass = '\App\\' . $targetMarketplace . '\\Api\\Notification';
        if (class_exists($notificationClass)) {
            if (!method_exists($notificationClass, 'createSubscription')) return  ['success' => false, 'message' => 'Class found but createSubscription method not found !'];
        } else return  ['success' => false, 'message' => 'Notification Class not found!'];

        $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $options = [
            "typeMap" => ['root' => 'array', 'document' => 'array']
        ];

        if ($data['type'] == 'app') {
            $filters = ['marketplace' => $appConfig['marketplace'], 'event_code' => $data['event_code']];
        } else {
            $filters = ['marketplace' => $appConfig['marketplace'], 'event_code' => $data['event_code'], 'remote_shop_id' => $shop['_id']];
        }

        if (isset($data['type']) && ($data['type'] == "user_app" || $data['type'] == 'app')) $filters['app_code'] = $data['queue_data']['app_code'];
        $collection = $model->getCollection('marketplace_subscription');
        $marketplace_subscription = $collection->findOne($filters, $options);

      
        if (empty($marketplace_subscription)) {

            $insertData = [
                '_id' => $model->getCounter('marketplace_subscription_id'),
                'marketplace' => $appConfig['marketplace'],
                'event_code' => $data['event_code'],
                'remote_shop_id' => $shop['_id'],
                'destination_id' => $marketplace_destination_id,
            ];
            if (isset($data['type']) && $data['type'] == "user_app") $insertData['app_code'] = $data['queue_data']['app_code'];
            $params = [
                'shop_id' => $shop['_id'],
                'marketplace_data' => $data['marketplace_data'] ?? [],
                'destination_id' => $marketplace_destination_id,
                'event_code' => $data['event_code'],
                'type' => $data['type']
            ];
            if (isset($data['type']) && ($data['type'] == "user_app" || $data['type'] == 'app')) $params['app_code'] = $data['queue_data']['app_code'];
            $response = $this->marketplacesCall('create/subscription', $params, 'POST');
            // $this->di->getLog()->logContent('RESPONSE SUBSCRIPTION = ' . print_r($response, true), 'critical', 'shopify/subscription.log');

            if ($response['success'] && $response['subscription_id']) {
                $insertData['marketplace_subscription_id'] = (string)$response['subscription_id'];
                $insertData['created_at'] = date("Y-m-d H:i:s");
                $collection->insertOne($insertData);
                return ['success' => true, 'subscription_id' => $response['subscription_id'], 'message' => "Marketplace subscription created successfully"];
            }elseif($response['success'] && is_null($response['subscription_id'])){
                return ['success' => true, 'message' => "Marketplace subscription call does not exist"];
            }else{
                return ['success' => false, 'message' => "Marketplace subscription not created"];
            }
        } else {
            $params = [
                'shop_id' => $shop['_id'],
                'marketplace_data' => $data['marketplace_data'] ?? [],
                'destination_id' => $marketplace_destination_id,
                'event_code' => $data['event_code'],
            ];
            if (isset($data['type']) && $data['type'] == "user_app") $params['app_code'] = $data['queue_data']['app_code'];
            $response = $this->marketplacesCall('create/subscription', $params, 'POST');

            if (isset($response['subscription_id']) && $response['subscription_id'] != null) {
                $updateEventSubscription = $collection->updateOne(
                    ['marketplace_subscription_id' => (string)$marketplace_subscription['marketplace_subscription_id']],
                    ['$set' => ['marketplace_subscription_id' => (string)$response['subscription_id']]]
                );
                // $this->di->getLog()->logContent('RESPONSE SUBSCRIPTION = ' . print_r($response, true), 'critical', $appConfig['marketplace'] . '/subscription.log');
                return ['success' => true, 'subscription_id' => $response['subscription_id'], 'activated' => true, 'message' => "Marketplace subscription activated successfully"];
            } else {
                // $this->di->getLog()->logContent('RESPONSE SUBSCRIPTION = ' . print_r($response, true), 'critical', $appConfig['marketplace'] . '/subscription.log');
                return ['success' => true, 'subscription_id' => $marketplace_subscription['marketplace_subscription_id'], 'message' => "Marketplace subscription already created"];
            }
        }
    }

    public function insertSubscriptionIntoDynamoDb($data)
    {
        $client = DynamoDbClient::factory(include BP . '/app/etc/dynamo.php');
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];

        $ced_app_shop =  $this->di->getRegistry()->getCurrentCedAppShop();
        $appConfig = $this->di->getRegistry()->getAppConfig();
        $app = $this->di->getObjectManager()->get("App\Apiconnect\Models\Apps\Shop")->getAppInShopById($ced_app_shop['remote_shop_id'], $appConfig['_id']);
        // todo : temporary code
        $app_id = null;


        if (isset($app['cif_app_id'])) {
            $app_id = $app['cif_app_id'];
        } elseif (isset($appConfig['_id'])) {
            $app_id = $appConfig['_id'];
        }

        // setting appConfig for marketplace
        if ($data['type'] != 'app') {
            $uniqueKey = $this->getSubscriptionSortKey($data);
            if ($data['type'] == "user_app") $uniqueKey = $uniqueKey . "_" . $appConfig['app_code'];
        } else {
            $uniqueKey = $data['marketplace'] . "_" . $data['event_code'];
        }

        $tableName = $this->di->getConfig()->get('add_dynamo_prefix') ? $this->di->getConfig()->get('app_code') . "_webhook" : "webhook";

        if (isset($data['marketplace_subscription_id']) && $data['marketplace_subscription_id'] != null) {
            $collection = $mongo->getCollection('marketplace_subscription');
            $marketplace_subscription = $collection->findOne(
                [
                    "marketplace_subscription_id" => $data['marketplace_subscription_id']
                ],
                $options
            );
            $insertFields = [];
            if (!empty($marketplace_subscription)) {
                $insertFields = [
                    'marketplace' => [
                        'S' => (string)$marketplace_subscription['marketplace'],
                    ],
                    'event_code' => [
                        'S' => (string)$marketplace_subscription['event_code'],
                    ],
                    'remote_shop_id' => [
                        'S' => (string)$marketplace_subscription['remote_shop_id'],
                    ],
                    'destination_id' => [
                        'S' => (string)$marketplace_subscription['destination_id'],
                    ],
                ];
            }
            $partition_sort_keys = [
                'PK' => [
                    'S' => "subscription_marketplace",
                ],
                'SK' => [
                    'S' => $uniqueKey . "_marketplace",
                ],
            ];
            $Item = array_merge($partition_sort_keys, $insertFields);

            $client->putItem([
                'Item' => $Item,
                'TableName' => $tableName,
            ]);
        }

        if (isset($data['subscription_id'])) {
            $collection = $mongo->getCollection('cif_subscription');
            $cif_subscription = $collection->findOne(
                [
                    "_id" => $data['subscription_id']
                ],
                $options
            );
            $insertFields = [];
            if (!empty($cif_subscription)) {

                $insertFields = [
                    'marketplace' => [
                        'S' => (string)$cif_subscription['marketplace'],
                    ],
                    'remote_shop_id' => [
                        'S' => (string)$cif_subscription['remote_shop_id'],
                    ],
                    'event_code' => [
                        'S' => (string)$cif_subscription['event_code'],
                    ],
                    'destination_id' => [
                        'S' => (string)$cif_subscription['destination_id'],
                    ],
                    'type' => [
                        'S' => (string)$cif_subscription['type'],
                    ],
                    'marketplace_data' => [
                        'S' => json_encode($cif_subscription['marketplace_data']),
                    ],
                    'queue_data' => [
                        'S' => json_encode($cif_subscription['queue_data']),
                    ],
                    'app_id' => [
                        'S' => (string)$app_id,
                    ],
                ];
                if(!empty($cif_subscription['subscription_id'])){
                    $insertFields['subscription_id'] = [
                        'S' => (string)$cif_subscription['subscription_id'],
                    ];
                }
            }
            $partition_sort_keys = [
                'PK' => [
                    'S' => "subscription_cif",
                ],
                'SK' => [
                    'S' => $uniqueKey . "_" . $data['subscription_id'],
                ],
            ];
            $Item = array_merge($partition_sort_keys, $insertFields);
            $client->putItem([
                'Item' => $Item,
                'TableName' => $tableName,
            ]);
        }
        if (isset($data['marketplace_destination_id']) && $data['marketplace_destination_id'] != null) {
            $collection = $mongo->getCollection('marketplace_destination');
            $marketplace_destination = $collection->findOne(
                [
                    "destination_id" => $data['marketplace_destination_id']
                ],
                $options
            );
            $insertFields = [];
            if (!empty($marketplace_destination)) {
                $insertFields = [
                    'title' => [
                        'S' => (string)$marketplace_destination['title'],
                    ],
                    'type' => [
                        'S' => (string)$marketplace_destination['type'],
                    ],
                    'event_handler' => [
                        'S' => (string)$marketplace_destination['event_handler'],
                    ],
                    'destination_id' => [
                        'S' => (string)$marketplace_destination['destination_id'],
                    ],
                ];
            }
            $partition_sort_keys = [
                'PK' => [
                    'S' => "destination_marketplace",
                ],
                'SK' => [
                    'S' => "marketplace_" . $data['marketplace_destination_id'],
                ],
            ];
            $Item = array_merge($partition_sort_keys, $insertFields);
            $client->putItem([
                'Item' => $Item,
                'TableName' => $tableName,
            ]);
        }
        if (isset($data['destination_id']) && $data['destination_id'] != null) {
            $collection = $mongo->getCollection('cif_destination');
            $cif_destination = $collection->findOne(
                [
                    "_id" => $data['destination_id']
                ],
                $options
            );
            $insertFields = [];
            if (!empty($cif_destination)) {

                $insertFields = [
                    'title' => [
                        'S' => (string)$cif_destination['title'],
                    ],
                    'type' => [
                        'S' => (string)$cif_destination['type'],
                    ],
                    'subuser_id' => [
                        'S' => (string)$cif_destination['subuser_id'],
                    ],
                    'event_handler' => [
                        'S' => (string)$cif_destination['event_handler'],
                    ],
                    'destination_data' => [
                        'S' => json_encode($cif_destination['destination_data']),
                    ],
                ];
            }
            $partition_sort_keys =  [
                'PK' => [
                    'S' => "destination_cif",
                ],
                'SK' => [
                    'S' => "cif_" . $data['destination_id'],
                ],
            ];
            $Item = array_merge($partition_sort_keys, $insertFields);
            $client->putItem([
                'Item' => $Item,
                'TableName' => $tableName,
            ]);
        }
    }

    public function deleteSubscriptionFromDynamodb($data)
    {
        $client = DynamoDbClient::factory(include BP . '/app/etc/dynamo.php');
        if ($data['type'] != 'app') {
            $uniqueKey = $this->getSubscriptionSortKey($data);
            if ($data['type'] == "user_app") $uniqueKey = $uniqueKey . "_" . $data['app_code'];
        } else {
            $uniqueKey = $data['marketplace'] . "_" . $data['event_code'] . "_" . $data['subscription_id'];
        }
        $tableName = $this->di->getConfig()->get('add_dynamo_prefix') ? $this->di->getConfig()->get('app_code') . "_webhook" : "webhook";


        if (isset($data['marketplace_subscription_id']) && $data['marketplace_subscription_id'] != null) {
            $partition_sort_keys = [
                'PK' => [
                    'S' => "subscription_marketplace",
                ],
                'SK' => [
                    'S' => $uniqueKey . "_marketplace",
                ],
            ];
            $client->deleteItem([
                'Key' => $partition_sort_keys,
                'TableName' => $tableName,
            ]);
        }

        if (isset($data['subscription_id'])) {
            $partition_sort_keys = [
                'PK' => [
                    'S' => "subscription_cif",
                ],
                'SK' => [
                    'S' => $uniqueKey . "_" . $data['subscription_id'],
                ],
            ];
            $client->deleteItem([
                'Key' => $partition_sort_keys,
                'TableName' => $tableName,
            ]);
        }
    }

    public function updateSubscriptionInDynamodb($cif_subscription_id)
    {
        $client = DynamoDbClient::factory(include BP . '/app/etc/dynamo.php');
        $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
        $collection = $mongo->getCollection('cif_subscription');

        $ced_app_shop =  $this->di->getRegistry()->getCurrentCedAppShop();
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        $appConfig = $appModel->getSubConfig($ced_app_shop['sAppId']);


        $app = $this->di->getObjectManager()->get("App\Apiconnect\Models\Apps\Shop")->getAppInShopById($ced_app_shop['remote_shop_id'], $appConfig['_id']);
        // todo : temporary code
        $app_id = null;
        if (isset($app['cif_app_id'])) {
            $app_id = $app['cif_app_id'];
        } elseif (isset($appConfig['_id'])) {
            $app_id = $appConfig['_id'];
        }

        $tableName = $this->di->getConfig()->get('add_dynamo_prefix') ? $this->di->getConfig()->get('app_code') . "_webhook" : "webhook";

        if (isset($cif_subscription_id) && $cif_subscription_id != null) {
            $cif_subscription = $collection->findOne(
                [
                    "_id" => $cif_subscription_id
                ],
                $options
            );
            $insertFields = [];
            if (!empty($cif_subscription)) {
                $insertFields = [
                    'marketplace' => [
                        'S' => (string)$cif_subscription['marketplace'],
                    ],
                    'remote_shop_id' => [
                        'S' => (string)$cif_subscription['remote_shop_id'],
                    ],
                    'subscription_id' => [
                        'S' => (string)$cif_subscription['subscription_id'],
                    ],
                    'event_code' => [
                        'S' => (string)$cif_subscription['event_code'],
                    ],
                    'destination_id' => [
                        'S' => (string)$cif_subscription['destination_id'],
                    ],
                    'type' => [
                        'S' => (string)$cif_subscription['type'],
                    ],
                    'marketplace_data' => [
                        'S' => json_encode($cif_subscription['marketplace_data']),
                    ],
                    'queue_data' => [
                        'S' => json_encode($cif_subscription['queue_data']),
                    ],
                    'app_id' => [
                        'S' => (string)$app_id
                    ],
                ];
                // if ($cif_subscription['type'] != 'app')
                //     $uniqueKey = $this->getSubscriptionSortKey($cif_subscription);
                // else
                //     $uniqueKey = $cif_subscription['marketplace'] . "_" . $cif_subscription['event_code'] . "_" . $cif_subscription_id;
                if ($cif_subscription['type'] != 'app') {
                    $uniqueKey = $this->getSubscriptionSortKey($cif_subscription);
                    if ($data['type'] == "user_app") $uniqueKey = $uniqueKey . "_" . $appConfig['app_code'];
                } else {
                    $uniqueKey = $data['marketplace'] . "_" . $data['event_code'];
                }
                $partition_sort_keys = [
                    'PK' => [
                        'S' => "subscription_cif",
                    ],
                    'SK' => [
                        'S' => $uniqueKey . "_" . $cif_subscription_id,
                    ],
                ];
                $Item = array_merge($partition_sort_keys, $insertFields);
                $client->putItem([
                    'Item' => $Item,
                    'TableName' => $tableName,
                ]);
            }
        }
        if (isset($cif_subscription) && $cif_subscription != null) {
            $marketplace_subscription_id = $cif_subscription['subscription_id'];
        }
        if (isset($marketplace_subscription_id) && $marketplace_subscription_id != null) {
            $collection = $mongo->getCollection('marketplace_subscription');
            $marketplace_subscription = $collection->findOne(
                [
                    "marketplace_subscription_id" => $marketplace_subscription_id
                ],
                $options
            );
            $insertFields = [];
            if (!empty($marketplace_subscription)) {
                $insertFields = [
                    'marketplace' => [
                        'S' => (string)$marketplace_subscription['marketplace'],
                    ],
                    'event_code' => [
                        'S' => (string)$marketplace_subscription['event_code'],
                    ],
                    'remote_shop_id' => [
                        'S' => (string)$marketplace_subscription['remote_shop_id'],
                    ],
                    'destination_id' => [
                        'S' => (string)$marketplace_subscription['destination_id'],
                    ],
                ];
                $partition_sort_keys = [
                    'PK' => [
                        'S' => "subscription_marketplace",
                    ],
                    'SK' => [
                        'S' => $uniqueKey . "_marketplace",
                    ],
                ];
                $Item = array_merge($partition_sort_keys, $insertFields);

                $client->putItem([
                    'Item' => $Item,
                    'TableName' => $tableName,
                ]);
            }
        }
    }

    public function getSubscriptionSortKey($data)
    {
        $ced_app_shop =  $this->di->getRegistry()->getCurrentCedAppShop();
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');
        // setting appConfig for marketplace
        $appConfig = $appModel->getSubConfig($ced_app_shop['sAppId']);
        $shop = $this->di->getRegistry()->getCurrentShop();
        $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($appConfig['marketplace']) ?: ucfirst($appConfig['marketplace']);

        $handler = $this->di->getObjectManager()->get('App\\' . $targetMarketplace . '\\Api\Base');
        $subscriptionUniqueKeys = $handler->getSubscriptionUniqueKeys();

        $app_in_shop = [];
        foreach ($shop['apps'] as $app) {
            if ($app['app_id'] == $appConfig['id']) {
                $app_in_shop = $app;
            }
        }

        $uniqueKey = "";
        foreach ($subscriptionUniqueKeys as $subscriptionKey) {
            if (isset($shop[$subscriptionKey])) {
                $uniqueKey = $uniqueKey != "" ? $uniqueKey . "_" . $shop[$subscriptionKey] : $shop[$subscriptionKey];
            } elseif (isset($app_in_shop[$subscriptionKey])) {
                $uniqueKey = $uniqueKey != "" ? $uniqueKey . "_" . $app_in_shop[$subscriptionKey] : $app_in_shop[$subscriptionKey];
            } elseif (isset($data[$subscriptionKey])) {
                $uniqueKey = $uniqueKey != "" ? $uniqueKey . "_" . $data[$subscriptionKey] : $data[$subscriptionKey];
            }
        }
        return $uniqueKey;
    }
    public function getApiMode($request_data)
    {
        if (isset($request_data['sandbox']) && $request_data['sandbox']) $mode = 'sandbox';
        else $mode = 'live';

        return $mode;
    }
    public function getEventWebhookConfig($data, $appConfig)
    {
        $awsConfig = include BP . DS . 'app' . DS . 'etc' . DS . 'aws.php';
        $marketplace_events = $this->di->getConfig()->get('event_webhook')->get($appConfig['marketplace'])->toArray();
        $event_destination_config = [];
        foreach ($marketplace_events as $key => $marketplace_event) {
            if ($marketplace_event['event_code'] == $data['event_code']) {
                if ($marketplace_event['event_handler'] == "sqs") {
                    $marketplace_event['sqs'] = [
                        'region' => $awsConfig['region'],
                        'key' => $awsConfig['credentials']['key'],
                        'secret' => $awsConfig['credentials']['secret'],
                    ];
                } elseif ($marketplace_event['event_handler'] == "event_bridge") {
                    $marketplace_event['event_bridge'] = $awsConfig['event_bridge'];
                }
                $event_destination_config = $marketplace_event;
                break;
            }
        }
        return $event_destination_config;
    }
    public function bulkDeleteSubscriptionFromDynamodb($subscriptionCifSKs,$subscriptionMarketplaceSKs)
    {
        $client = DynamoDbClient::factory(include BP . '/app/etc/dynamo.php');
        $count = 0;
        $tableName = $this->di->getConfig()->get('add_dynamo_prefix') ? $this->di->getConfig()->get('app_code') . "_webhook" : "webhook";
        if (!empty($subscriptionCifSKs)) {
            $deleteRequests  = [];
            foreach ($subscriptionCifSKs as $uniqueKey) {
                $request = [
                    'DeleteRequest' => [
                        'Key' => [
                            'PK' => [
                                'S' => "subscription_cif",
                            ],
                            'SK' => [
                                'S' => $uniqueKey,
                            ]
                        ]
                    ]
                ];
                array_push($deleteRequests,$request);
                $count++;
                if ($count > 24) {
                    $params = [
                        "RequestItems" => [
                            $tableName => $deleteRequests
                        ]
                    ];
                    $client->batchWriteItem($params);
                    $deleteRequests = [];
                    $count = 0;
                }
            }
            if (!empty($deleteRequests)) {
                $params = [
                    "RequestItems" => [
                        $tableName => $deleteRequests
                    ]
                ];
                $client->batchWriteItem($params);
            }
            $deleteRequests  = [];
            $count = 0;
            foreach ($subscriptionMarketplaceSKs as $uniqueKey) {
                $request = [
                    'DeleteRequest' => [
                        'Key' => [
                            'PK' => [
                                'S' => "subscription_marketplace",
                            ],
                            'SK' => [
                                'S' => $uniqueKey,
                            ]
                        ]
                    ]
                ];
                array_push($deleteRequests,$request);
                $count++;
                if ($count > 24) {
                    $params = [
                        "RequestItems" => [
                            $tableName => $deleteRequests
                        ]
                    ];
                    $client->batchWriteItem($params);
                    $deleteRequests = [];
                    $count = 0;
                }
            }
            if (!empty($deleteRequests)) {
                $params = [
                    "RequestItems" => [
                        $tableName => $deleteRequests
                    ]
                ];
                $client->batchWriteItem($params);
            }
            return ['success' => true, "message" => "Dynamo entries deleted successfully."];
        } else {
            return ['success' => false, 'message' => "No ids to delete from DynamoDB."];
        }
    }
}
