<?php

namespace App\Cedcommercewebapi\Components;

use Aws\DynamoDb\DynamoDbClient;
use  App\Cedcommercewebapi\Api\Base;

class EventDestination extends Base
{

    public function validateDestinationData($data)
    {
        $required_indexes = ['title', 'type', 'event_handler', 'destination_data','destination_data->type'];

        foreach ($required_indexes as $index) {
            if(strpos($index, '->') === false) {
                if(!isset($data[$index])) {
                    return [
                        'success' => false,
                        'error'  => "'{$index}' is required."
                    ];
                }
            } else {
                $expl = explode('->', $index);
                if(!isset($data[$expl[0]][$expl[1]])) {
                    return [
                        'success' => false,
                        'error'  => "'{$expl[0]}[{$expl[1]}]' is required."
                    ];
                }
            }
        }

        return ['success'=>true];
    }


    public function updateDestinationInDynamodb($cif_destination_id){
        if(isset($cif_destination_id) && $cif_destination_id!=null) {
            $mongo = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $options = ["typeMap" => ['root' => 'array', 'document' => 'array']];
            $collection = $mongo->getCollection('cif_subscription');
            $cif_subscription = $collection->findOne(
                [
                    "destination_id" =>$cif_destination_id
                ], $options
            );
            if (count($cif_subscription)>0){
                $collection = $mongo->getCollection('cif_destination');
                $client = DynamoDbClient::factory(include BP.'/app/etc/dynamo.php');
                $cif_destination = $collection->findOne(
                    [
                        "_id" => $cif_destination_id
                    ], $options
                );
                $insertFields =[];
                if (!empty($cif_destination)){
                    $insertFields = [
                        'title' => [
                            'S' =>(string)$cif_destination['title'],
                        ],
                        'type' => [
                            'S' =>(string)$cif_destination['type'],
                        ],
                        'subuser_id' => [
                            'S' =>(string)$cif_destination['subuser_id'],
                        ],
                        'event_handler' => [
                            'S' =>(string)$cif_destination['event_handler'],
                        ],
                        'destination_data' => [
                            'S' =>json_encode($cif_destination['destination_data']),
                        ],
                    ];
                }
                $partition_sort_keys =  [
                    'PK' => [
                        'S' =>"destination_cif",
                    ],
                    'SK' => [
                        'S' => "cif_".$cif_destination_id,
                    ],
                ];
                $Item = array_merge($partition_sort_keys,$insertFields);
                $client->putItem([
                    'Item' => $Item,
                    'TableName' => 'webhook',
                ]);
            }
        }
    }

    public function checkDestinationDuplicacy($data)
    {
        $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
        $collection = $model->getCollection('cif_destination');
        unset($data['_id']);
        $result = $collection->findOne($data);
        if(empty($result)) {
            return ['success' => true];
        } else {
            return ['success' => false, 'destination_id' => $result['_id']];
        }
    }

}
