<?php

namespace App\Cedcommercewebapi\Api;


class EventDestination extends Base
{
    protected $_component = 'EventDestination';

    /**
     * @OA\Server(url="https://docs-app.cifapps.com/")
     * @OA\Get(path="/event/destination",
     * tags={"EventDestination"},
     * summary="Get event destination",
     * @OA\Parameter(
     *    name="app_code", *  
     *    in="query",
     *    required=true, *    
     *    description="The app_code passed to get in query string goes here",
     *    @OA\Schema(
     *       type="string"
     *    ),
     *    name="event_handler_id", *  
     *    in="query",
     *    required=true, *    
     *    description="The destination id passed to get in query string goes here",
     *    @OA\Schema(
     *       type="string"
     *    ),
     * ),
     * @OA\Response(response="200", description="Success"),
     * @OA\Response(response="404", description="Not found")
     */
    public function getEventDestination($data)
    {
        try {
            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array']
            ];
            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $collection = $model->getCollection('cif_destination');
            if (isset($data['event_handler_id'])) {
                $filter = ['_id' => $data['event_handler_id']];
            } else if (isset($data['type'])) {
                $filter = ['subuser_id' => $this->di->getRegistry()->getSubuserId(), 'type' => $data['type']];
            } else {
                $filter = ['subuser_id' => $this->di->getRegistry()->getSubuserId()];
            }
            $response = $collection->find($filter, $options)->toArray();
            if (!empty($response))
            return ['success' => true, 'data' => $response];
            return ['success' => false, 'message' => "No destination Found"];
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }


    /**
     * @OA\Post(
     *     path="/event/destination"",
     *     summary="Create Event Destination",
     *     description="Create Event Destination",
     *     operationId="create destination",
     *     tags={"event/destination"},
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema( * 
     *                 @OA\Property(
     *                     property="title",
     *                     type="string"                          
     *                 ),
     *                 @OA\Property(
     *                     property="type",
     *                     type="string"                         
     *                 ),
     *                 @OA\Property(
     *                     property="event_handler",
     *                     type="string"                         
     *                 ),
     *                 @OA\Property(
     *                     property="destination_data",
     *                     type="object" ,
     *                     @OA\Property(
     *                     property="type",
     *                     type="string"                         
     *                     ),
     *                     @OA\Property(
     *                     property="sqs",
     *                     type="object",
     *                     @OA\Property(
     *                      property="region",
     *                      type="string"                         
     *                       ),     
     *                      @OA\Property(
     *                     property="key",
     *                     type="string"                         
     *                     ), 
     *                     @OA\Property(
     *                     property="secret",
     *                     type="string"                         
     *                     ), 
     *                     @OA\Property(
     *                     property="queue_base_url",
     *                     type="string"                         
     *                     ),                  
     *                     ),                    
     *                 ),
     *                     
     *                 example={
     *                   "title": "User type Event Destination",
     *                   "type": "user",
     *                   "event_handler": "sqs",
     *                   "destination_data":
     *                        {
     *                           "type": "sqs",
     *                           "sqs":
     *                           {
     *                               "region": "ca-central-1",
     *                               "key": "you key",
     *                               "secret": "your secret",
     *                               "queue_base_url": "your url"
     *                           }
     *                      }
     *                   }
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="OK",
     *         @OA\JsonContent(
     *             @OA\Schema(
     *             schema="Result",
     *             title="Sample schema ",
     * 	           @OA\Property(
     *                  property="data",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="success",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="destination_id",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="ip",
     *                  type="string"
     *              ),
     *              @OA\Property(
     *                  property="start_time",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="end_time,
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="execution_time",
     *                  type="string"
     *              ),
     *             @OA\Examples(example="result", value={"success": true}, summary="An result object."),
     *             @OA\Examples(example="bool", value=false, summary="A boolean value."),
     *         )
     *     )
     * )
     */
    public function createEventDestination($data)
    {
        try {
            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $collection = $model->getCollection('cif_destination');
            $data = $data['data'];
            $event_destination_obj = $this->di->getObjectManager()->get('\App\Cedcommercewebapi\Components\EventDestination');
            $validate = $event_destination_obj->validateDestinationData($data);
            if (isset($validate['success']) && $validate['success']) {
                $insertData = [
                    '_id' => $model->getCounter('cif_destination_id'),
                    'title' => $data['title'],
                    'type' => $data['type'],
                    'subuser_id' => $this->di->getRegistry()->getSubuserId(),
                    'event_handler' => $data['event_handler'],
                    'destination_data' => $data['destination_data']
                ];
                $result = $event_destination_obj->checkDestinationDuplicacy($insertData);
                if (isset($result['success']) & $result['success'] == true) {
                    $response = $collection->insertOne($insertData);
                    if ($response->getInsertedCount()) {
                        return ['success' => true, 'data' => "Event destination added successfully", 'destination_id' => $response->getInsertedId()];
                    } else {
                        return ['success' => false, 'data' => "Event destination not added"];
                    }
                } else {
                    return ['success' => true, 'destination_id' => $result['destination_id'], 'message' => "Event destination already exists"];
                }
            } else {
                return $validate;
            }
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }

    /**
     * @OA\Put(
     *     path="/event/destination"",
     *     summary="Update Event Destination",
     *     description="Update Event Destination",
     *     operationId="Update destination",
     *     tags={"event/destination"},
     *     @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema( * 
     *                 @OA\Property(
     *                     property="title",
     *                     type="string"                          
     *                 ),
     *                 @OA\Property(
     *                     property="type",
     *                     type="string"                         
     *                 ),
     *                 @OA\Property(
     *                     property="event_handler",
     *                     type="string"                         
     *                 ),
     *                 @OA\Property(
     *                     property="destination_data",
     *                     type="object" ,
     *                     @OA\Property(
     *                     property="type",
     *                     type="string"                         
     *                     ),
     *                     @OA\Property(
     *                     property="sqs",
     *                     type="object",
     *                     @OA\Property(
     *                      property="region",
     *                      type="string"                         
     *                       ),     
     *                      @OA\Property(
     *                     property="key",
     *                     type="string"                         
     *                     ), 
     *                     @OA\Property(
     *                     property="secret",
     *                     type="string"                         
     *                     ), 
     *                     @OA\Property(
     *                     property="queue_base_url",
     *                     type="string"                         
     *                     ),                  
     *                     ),                    
     *                 ),
     *                     
     *                 example={
     *                   "title": "User type Event Destination",
     *                   "type": "user",
     *                   "event_handler": "sqs",
     *                   "destination_data":
     *                        {
     *                           "type": "sqs",
     *                           "sqs":
     *                           {
     *                               "region": "ca-central-1",
     *                               "key": "you key",
     *                               "secret": "your secret",
     *                               "queue_base_url": "your url"
     *                           }
     *                      }
     *                   }
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="OK",
     *         @OA\JsonContent(
     *             @OA\Schema(
     *             schema="Result",
     *             title="Sample schema ",
     * 	           @OA\Property(
     *                  property="data",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="success",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="destination_id",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="ip",
     *                  type="string"
     *              ),
     *              @OA\Property(
     *                  property="start_time",
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="end_time,
     *                  type="string"
     *              ),
     *             @OA\Property(
     *                  property="execution_time",
     *                  type="string"
     *              ),
     *             @OA\Examples(example="result", value={"success": true}, summary="An result object."),
     *             @OA\Examples(example="bool", value=false, summary="A boolean value."),
     *         )
     *     )
     * )
     */
    public function updateEventDestination($data)
    {
        try {
            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $collection = $model->getCollection('cif_destination');
            if (isset($data['event_handler_id']) && isset($data['data'])) {
                $event_destination_obj = $this->di->getObjectManager()->get('\App\Cedcommercewebapi\Components\EventDestination');
                $validate = $event_destination_obj->validateDestinationData($data['data']);
                if (isset($validate['success']) && $validate['success']) {
                    $updateEventDestination = $collection->updateOne(
                        ['_id' => (string)$data['event_handler_id']],
                        ['$set' => $data['data']]
                    );
                    if ($updateEventDestination->getModifiedCount() == 1) {
                        $event_destination_obj->updateDestinationInDynamodb($data['event_handler_id']);
                        return ['success' => true, 'data' => "Event destination updated successfully"];
                    } else {
                        return ['success' => false, 'data' => "Event destination not updated"];
                    }
                } else {
                    return $validate;
                }
            } else {
                return ['success' => false, 'data' => "event_handler_id required params"];
            }
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }

    /**
     * @OA\Server(url="https://docs-app.cifapps.com/")
     * @OA\Delete(path="/event/destination",
     * tags={"EventDestination"},
     * summary="Delete event destination",
     * @OA\Parameter(
     *    name="app_code", *  
     *    in="query",
     *    required=true, *    
     *    description="The app_code passed to get in query string goes here",
     *    @OA\Schema(
     *       type="string"
     *    ),
     *    name="event_handler_id", *  
     *    in="query",
     *    required=true, *    
     *    description="The destination id passed to get in query string goes here",
     *    @OA\Schema(
     *       type="string"
     *    ),
     * ),
     * @OA\Response(response="200", message=Event destination id deleted successfully."),
     * @OA\Response(response="404", description="Not found")
     */
    public function deleteEventDestination($data)
    {
        try {
            $model = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $collection = $model->getCollection('cif_destination');
            if (isset($data['event_handler_id'])) {
                $subscription_collection = $model->getCollection('cif_subscription');
                $filter = ['destination_id' => $data['event_handler_id']];
                $subscriptions = $subscription_collection->count($filter);
                if ($subscriptions < 1) {
                    $deleteEventDestination = $collection->deleteOne(
                        ['_id' => $data['event_handler_id']]
                    );
                    if ($deleteEventDestination->getDeletedCount() > 0) {
                        return ['success' => true, 'message' => "Event Destination deleted successfully"];
                    }
                } else {
                    return ['success' => false, 'message' => "Event Destination not deleted because cif_subscription exists with this destination"];
                }
            } else {
                return ['success' => false, 'data' => "event_handler_id required params"];
            }
        } catch (\Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }
}
