<?php

namespace App\Cedcommercewebapi\Api;

use Phalcon\Events\Event;

/**
 * FirewallMiddleware
 *
 * Checks the whitelist and allows clients or not
 */
class Base extends \App\Apiconnect\Api\Base
{

    public function marketplacesCall($apiRoute, $params = [], $method = 'GET')
    {
        $ced_app_shop =  $this->di->getRegistry()->getCurrentCedAppShop();
        $appModel = $this->di->getObjectManager()->create('App\Apiconnect\Models\Apps');

        // setting appConfig for marketplace
        $appConfig = $appModel->getSubConfig($ced_app_shop['sAppId']);
        $this->di->getRegistry()->setAppConfig($appConfig);
        if (isset($params['app_code'])) {
            $shop = $this->di->getRegistry()->getCurrentShop();
            $apps = $shop['apps'] ?? [];
            foreach ($apps as $app) {
                if (isset($app['app_code']) && $app['app_code'] == $params['app_code']) {
                    $appConfig = $appModel->getSubConfig($app['sub_app_id']);
                    $this->di->getRegistry()->setAppConfig($appConfig);
                    break;
                }
            }
        }
        // Setting App config for app type subscription
        if (isset($params['type']) && $params['type'] == 'app') {
            $apps_model = $this->di->getObjectManager()->get('App\Apiconnect\Models\Apps');
            $appConfig = $apps_model->getAppsDataByAppCode($params['app_code']);
            $this->di->getRegistry()->setAppConfig($appConfig);
        }

        $route = $this->di->getConfig()->get('restapi')->get('v1')
            ->get($method)->get('routes')->get($apiRoute);
        $method = $route->method;
        $component =  $route->component;

        $base = $this->di->getObjectManager()->get('App\Apiconnect\Api\Base');
        $instance = $base->getComponent($appConfig['marketplace'], $component);
        $response = $instance->setComponent($component)->$method($params);
        // setting appConfig for cedcommerce
        //        $appConfig = $appModel->getSubConfig($ced_app_shop['ced_sAppId']);
        //        $this->di->getRegistry()->setAppConfig($appConfig);
        return $response;
    }


    public function getFilteredParams($data)
    {
        $default_params = ['_url', 'appId', 'shop_id', 'sAppId'];
        foreach ($default_params as $key) {
            unset($data[$key]);
        }

        return $data;
    }

    public function reRegisterWebhooks($data)
    {
        try {
            $options = [
                "typeMap" => ['root' => 'array', 'document' => 'array']
            ];
            if (!isset($data['shop_id'])) {
                $shop = $this->di->getRegistry()->getCurrentShop();
                $shopId = $shop['_id'];
            } else {
                $shopId = $data['shop_id'];
            }
            $mongo = $this->getDi()->getObjectManager()->create('\App\Core\Models\BaseMongo');
            $collection = $mongo->getCollection('cif_subscription');
            $subscriptions = $collection->aggregate([
                ['$match' => ['remote_shop_id' => $shopId]],
                [
                    '$group' => [
                        '_id' => '$queue_data.shop_id',
                        'queue_data' => ['$first' => '$queue_data'],
                        'destination_id' => ['$first' => '$destination_id']
                    ]
                ]
            ], $options)->toArray();
            if (!empty($subscriptions)) {
                $requiredFields = ['type', 'class_name', 'method', 'user_id', 'shop_id', 'marketplace', 'action', 'queue_name'];
                foreach ($subscriptions as $subscription) {
                    $subscription['queue_data']['queue_name'] = str_replace($subscription['queue_data']['action'], 're_register_webhooks', $subscription['queue_data']['queue_name']);
                    $subscription['queue_data']['action'] = 're_register_webhooks';
                    $dataToSend = [];
                    foreach ($requiredFields as $requiredField) {
                        $dataToSend[$requiredField] = $subscription['queue_data'][$requiredField];
                    }
                    $eventDestinationCollection = $mongo->getCollection('cif_destination');
                    $eventDestination = $eventDestinationCollection->findOne(['_id' => $subscription['destination_id']], $options);
                    if ($eventDestination['destination_data']['type'] == 'sqs') $dataToSend['handle_added'] = 1;
                    $this->di->getObjectManager()->get("\App\Webapi\Components\Destination\\" . ucfirst(str_replace("_", "", $eventDestination['event_handler'])))->sendNotificationToDestination($eventDestination, ['queue_data' => $dataToSend]);
                }
                return ['success' => true, 'message' => "Re-register webhooks message pushed successfully !!"];
            } else {
                return ['success' => false, 'message' => "No subscriptions found."];
            }
        } catch (Exception $e) {
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }
}
