<?php
$marketplace = 'arise';
return [
    'restapi' => [
        'v1' => [
            'GET' => [
                'routes' => [
                    "{$marketplace}/admin/readfromdb" => [
                        'url'       => "{$marketplace}/admin/readfromdb",
                        'method'    => 'readFromDB',
                        'resource'  => 'admin/readFromDB',
                        'component' => 'Admin',
                    ],
                    // 'catalog' => [
                    //     'url'       => 'catalog',
                    //     'method'    => 'get',
                    //     'resource'  => 'catalog/get',
                    //     'component' => 'Catalog',
                    // ],
                    'product' => [
                        'url'       => 'product',
                        'method'    => 'get',
                        'resource'  => 'product/get',
                        'component' => 'Product',
                    ],
                    "{$marketplace}/product/item" => [
                        'url'       => "{$marketplace}/product/item",
                        'method'    => 'getItem',
                        'resource'  => 'product/getItem',
                        'component' => 'Product',
                    ],
                    'image/verifyFeed' => [
                        'url'       => 'image',
                        'method'    => 'verifyFeed',
                        'resource'  => 'image/verifyFeed',
                        'component' => 'Image',
                    ],
                    'product/getFeed' => [
                        'url'       => 'product/getFeed',
                        'method'    => 'getFeed',
                        'resource'  => 'product/getFeed',
                        'component' => 'Product',
                    ],
                    'product/getFeedDocument' => [
                        'url'       => 'product/getFeedDocument',
                        'method'    => 'getFeedDocument',
                        'resource'  => 'product/getFeedDocument',
                        'component' => 'Product',
                    ],
                    'product/getFeedDocumentData' => [
                        'url'       => 'product/getFeedDocumentData',
                        'method'    => 'getFeedDocumentData',
                        'resource'  => 'product/getFeedDocumentData',
                        'component' => 'Product',
                    ],
                    // 'image' => [
                    //     'url'       => 'image',
                    //     'method'    => 'get',
                    //     'resource'  => 'image/get',
                    //     'component' => 'Image',
                    // ],
                    // 'product/feedquery' => [
                    //     'url'       => 'product/feedquery',
                    //     'method'    => 'feedQuery',
                    //     'resource'  => 'product/feedquery',
                    //     'component' => 'Product',
                    // ],
                    // 'product/details' => [
                    //     'url'       => 'product/details',
                    //     'method'    => 'getProductDetails',
                    //     'resource'  => 'product/details',
                    //     'component' => 'Product',
                    // ],
                    // 'product/relation' => [
                    //     'url' => 'product/relation',
                    //     'method' => 'getProductRelation',
                    //     'resource' => 'product/relation',
                    //     'component' => 'Product',
                    // ],
                    // 'order' => [
                    //     'url'       => 'order',
                    //     'method'    => 'get',
                    //     'resource'  => 'order/get',
                    //     'component' => 'Order'
                    // ],
                    // 'order/manual' => [
                    //     'url' => 'order',
                    //     'method' => 'getAliexpressManualOrder',
                    //     'resource' => 'order/getAliexpressManualOrder',
                    //     'component' => 'Order'
                    // ],
                    // 'order/find' => [
                    //     'url' => 'order/find',
                    //     'method' => 'getSingleOrderDetails',
                    //     'resource' => 'order/getSingleOrderDetails',
                    //     'required' => 'order_id',
                    //     'component' => 'Order'
                    // ],
                    // 'promotion/coupon' => [
                    //     'url' => 'promotion/coupon',
                    //     'method' => 'getCoupon',
                    //     'resource' => 'promotion/coupon',
                    //     'component' => 'Promotion'
                    // ],
                    // 'promotion' => [
                    //     'url' => 'promotion',
                    //     'method' => 'get',
                    //     'resource' => 'promotion/get',
                    //     'component' => 'Promotion'
                    // ],
                    // 'site' => [
                    //     'url' => 'site',
                    //     'method' => 'get',
                    //     'resource' => 'site/get',
                    //     'component' => 'Site'
                    // ],
                    // 'promotion/coupon' => [
                    //     'url' => 'promotion/coupon',
                    //     'method' => 'getCoupon',
                    //     'resource' => 'promotion/coupon',
                    //     'component' => 'Promotion'
                    // ],
                    // 'promotion' => [
                    //     'url' => 'promotion',
                    //     'method' => 'get',
                    //     'resource' => 'promotion/get',
                    //     'component' => 'Promotion'
                    // ],
                    // 'site' => [
                    //     'url' => 'site',
                    //     'method' => 'get',
                    //     'resource' => 'site/get',
                    //     'component' => 'Site'
                    // ],
                    // 'category' => [
                    //     'url'       => 'category',
                    //     'method'    => 'get',
                    //     'resource'  => 'category/get',
                    //     'component' => 'Category'
                    // ],
                    // 'category/membership' => [
                    //     'url' => 'category/membership',
                    //     'method' => 'getCategoryMembership',
                    //     'resource' => 'category/membership',
                    //     'component' => 'Category'
                    // ],
                    'shop' => [
                        'url'       => 'shop',
                        'method'    => 'get',
                        'resource'  => 'shop',
                        'component' => 'Shop'
                    ],
                    'arise/getAttribute' => [
                        'url' => 'category/getAttributes',
                        'method' => 'getAttributes',
                        'resource' => 'category/getAttributes',
                        'component' => 'Category'
                    ],
                    'arise/getCarrier' => [
                        'url' => 'shipping/getCarrier',
                        'method' => 'getCarrier',
                        'resource' => 'shipping/getCarrier',
                        'component' => 'Shipping'
                    ],
                    'arise/getBrand' => [
                        'url' => 'category/getBrand',
                        'method' => 'getBrand',
                        'resource' => 'category/getBrand',
                        'component' => 'Category'
                    ],
                    'arise/order' => [
                        'url' => 'order/getOrder',
                        'method' => 'getOrder',
                        'resource' => 'order/getOrder',
                        'component' => 'Order'
                    ],
                    'arise/order/order_item' => [
                        'url' => 'order/getOrderItem',
                        'method' => 'getOrderItem',
                        'resource' => 'order/getOrderItem',
                        'component' => 'Order'
                    ],
                    'arise/getcategory' => [
                        'url' => 'category/getCategory',
                        'method' => 'getCategory',
                        'resource' => 'category/getCategory',
                        'component' => 'Category'
                    ],
                    'arise/getOrderCancelReason' => [
                        'url' => 'order/getCancelReason',
                        'method' => 'getCancelReason',
                        'resource' => 'order/getCancelReason',
                        'component' => 'Order'
                    ],
                    'arise/order/getSingleOrder' => [
                        'url' => 'order/getSingleOrder',
                        'method' => 'getSingleOrder',
                        'resource' => 'order/getSingleOrder',
                        'component' => 'Order'
                    ],
                    'arise/order/printAwb' => [
                        'url' => 'order/printAwb',
                        'method' => 'printAwb',
                        'resource' => 'order/printAwb',
                        'component' => 'Order'
                    ]                   
                ]
            ],
            'POST' => [
                'routes' => [
                    'product' => [
                        'url'       => 'product',
                        'method'    => 'create',
                        'resource'  => 'product/create',
                        'component' => 'Product',
                    ],
                    'product/createFeedDocument' => [
                        'url'       => 'product/createFeedDocument',
                        'method'    => 'createFeedDocument',
                        'resource'  => 'product/createFeedDocument',
                        'component' => 'Product'
                    ],
                    'product/createFeed' => [
                        'url'       => 'product/createFeed',
                        'method'    => 'createFeed',
                        'resource'  => 'product/createFeed',
                        'component' => 'Product'
                    ],
                    'image/migrate' => [
                        'url'       => 'image/migrate',
                        'method'    => 'migrateImage',
                        'resource'  => 'image/migrateImage',
                        'component' => 'Image',
                    ],
                    'images/migrate' => [
                        'url'       => 'images/migrate',
                        'method'    => 'migrateImages',
                        'resource'  => 'image/migrateImages',
                        'component' => 'Image',
                    ],
                    'arise/order/order_pack' => [
                        'url'       => 'arise/order/order_pack',
                        'method'    => 'packOrder',
                        'resource'  => 'order/packOrder',
                        'component' => 'Order',
                    ],
                    'arise/order/updateTrackingInfo' => [
                        'url'       => 'arise/order/updateTrackingInfo',
                        'method'    => 'updateTrackingInfo',
                        'resource'  => 'order/updateTrackingInfo',
                        'component' => 'Order',
                    ],
                    'arise/order/setToRts' => [
                        'url'       => 'arise/order/setToRts',
                        'method'    => 'setStatusReadyToShip',
                        'resource'  => 'order/setStatusReadyToShip',
                        'component' => 'Order',
                    ],
                    'arise/order/setDeliveryConfirm' => [
                        'url'       => 'arise/order/setDeliveryConfirm',
                        'method'    => 'setDeliveryConfirm',
                        'resource'  => 'order/setDeliveryConfirm',
                        'component' => 'Order',
                    ],
                    'arise/order/setDeliveryFailed' => [
                        'url'       => 'arise/order/setDeliveryFailed',
                        'method'    => 'setDeliveryFailed',
                        'resource'  => 'order/setDeliveryFailed',
                        'component' => 'Order',
                    ],
                    'arise/order/cancelOrder' => [
                        'url'       => 'arise/order/cancelOrder',
                        'method'    => 'cancelOrder',
                        'resource'  => 'order/cancelOrder',
                        'component' => 'Order',
                    ],
                ],

            ],
            'PUT' => [
                'routes' => [
                    'product' => [
                        'url'       => 'product',
                        'method'    => 'update',
                        'resource'  => 'product/update',
                        'component' => 'Product',
                    ],
                    'product/putFeedData' => [
                        'url'       => 'product/putFeedData',
                        'method'    => 'putFeedData',
                        'resource'  => 'product/putFeedData',
                        'component' => 'Product'
                    ],
                    'product/inventory-price' => [
                        'url'       => 'product/updateInventoryPrice',
                        'method'    => 'updateInventoryPrice',
                        'resource'  => 'product/updateInventoryPrice',
                        'component' => 'Product'
                    ],
                    "{$marketplace}/product/deactivate" => [
                        'url'       => "{$marketplace}/product/deactivate",
                        'method'    => 'deactivateProduct',
                        'resource'  => 'product/deactivateProduct',
                        'component' => 'Product'
                    ],
                    "{$marketplace}/product/activate" => [
                        'url'       => "{$marketplace}/product/activate",
                        'method'    => 'activateProduct',
                        'resource'  => 'product/activateProduct',
                        'component' => 'Product'
                    ]
                ],
            ],
            'DELETE' => [
                'routes' => [
                    'product' => [
                        'url' => 'product',
                        'method'    => 'delete',
                        'resource'  => 'product/delete',
                        'component' => 'Product',
                    ],
                    "{$marketplace}/admin/deletefromdb" => [
                        'url'       => "{$marketplace}/admin/deletefromdb",
                        'method'    => 'deleteFromDB',
                        'resource'  => 'admin/deleteFromDB',
                        'component' => 'Admin',
                    ],
                    "{$marketplace}/user/deleteaccount" => [
                        'url'       => "{$marketplace}/user/deleteaccount",
                        'method'    => 'deleteAccount',
                        'resource'  => 'user/deleteAccount',
                        'component' => 'User',
                    ],
                    "{$marketplace}/product/deleteBulkUploadDocument" => [
                        'url'       => "{$marketplace}/product/deleteBulkUploadDocument",
                        'method'    => 'deleteBulkUploadDocument',
                        'resource'  => 'product/deleteBulkUploadDocument',
                        'component' => 'Product',
                    ]
                ],
            ],
        ],
    ]
];
        
