<?php
namespace App\Arisewebapi\Components\User;
use App\Arisewebapi\Components\Core\Common;

/**
 * Arise User handlers core logics.
 *
 * @since 1.0.0
 */
class User extends Common {

    /**
     * Will handle delete account method.
     *
     * @param array $params array containing the request params.
     *
     * @since 1.0.0
     * @return array
     */
    public function deleteAccount( $params = array() ) {
        if ( empty( $params['remote_shop_id'] ) || empty( $params['group_code'] ) ) {
            return [
                'success' => false,
                'msg'     => 'Remote shop ID is required'
            ];
        }
        $container = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo')
                    ->getCollectionForTable( 'apps_shop' );
        $res       = $container->deleteOne(
            [
                '_id'        => (string) $params['remote_shop_id'],
                'group_code' => $params['group_code']
            ]
        );

        return [
            'success' => $res->getDeletedCount() ? true : false,
            'msg'     => 'Deleted account'
        ];
    }
}