<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Arise
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Arisewebapi\Components\Shop;

use App\Arisewebapi\Components\Core\Common;
// use Exception;

/**
 * Handles the get shop at Arise.
 *
 * @since 1.0.0
 */
class Shop extends Common {

    /**
     * Get Shop.
     *
     * @param array $params array containing the request params containing the filters.
     * @since 1.0.0
     * @return array array containing the status of the request and the data.
     */
    public function get( $params = [] ) {
        
       $shoData =  $this->di->getRegistry()->getCurrentShop();
       $shoData = isset( $shoData['apps'][0]['token_data'] ) ? $shoData['apps'][0]['token_data']: '';
       if( empty( $shoData ) ) {
            return [
                'success' => false,
                'data'    => []
            ];
       }
       unset( $shoData['access_token'] );
       unset( $shoData['refresh_token'] );
       //unset( $shoData['refresh_expires_in'] );
       //unset( $shoData['expires_in'] );
       //unset( $shoData['token_expires'] );
       //unset( $shoData['refresh_expires'] );
        return [
            'success' => true,
            'data'    => $shoData
        ];
    }
}
