<?php
namespace App\Arisewebapi\Components\Shipping;
use App\Arisewebapi\Components\Core\Common;
use IopRequest;

/**
 * Arise products handlers core logics.
 *
 * @since 1.0.0
 */
class Shipping extends Common {
	
	/**
	 * Function to get arise shipping carrier
	 *
	 * @param int $seller_id  current seller id.
	 * @return void
	 */
	public function getAriseShipping() {

		$seller_id = $this->getSellerID() ?? false;
		$request = new IopRequest('/order/shipment/sof/providers/get');
		$request->addApiParam('getDBSShipmentProviderReq','{"sellerId":' . $seller_id . '}');

		return [
			'success' => true,
			'data'    => $this->execute( $request )
		];
	}

	/**
     * Get Seller Id for current shop.
     *
     * @since 1.0.0
     * @return string|boolean
     */
    	public function getSellerID() {
		$shopData = $this->di->getRegistry()->getCurrentShop();
		return ! empty( $shopData['apps'][0]['seller_id'] ) ? $shopData['apps'][0]['seller_id'] : false;
	}
}