<?php

namespace App\Arisewebapi\Components\Route;

use App\Apiconnect\Components\Authenticate\HandlerInterface;
use App\Arisewebapi\Components\Core\Common;

/**
 * Class Handler
 * @package App\Arisewebapi\Components\Route
 */
class Handler extends Common implements HandlerInterface {

    /**
     * get the redirect url.
     *
     * @param array $postData
     * @return void
     */
    public function requestRedirectAuthUrl( $postData ) {
        $auth = $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Authenticate\Sellerauth')->fetchAuthenticationUrl($postData);

        return $auth;
    }


    /**
     * Process the authentication
     *
     * @return array
     */
    public function processAuth() {
        $postData = $this->di->getRequest()->get();
        $this->di->getLog()->logContent( 'processAuth:path::/arisewebapi/Components/Route/Handler: PostData - ' . json_encode( $postData ), 'info', 'arise' . DS . 'User' . DS . 'authentication-' . date( 'Y-m-d' ) . '.log' );
        unset( $postData['_url'] );
        unset( $postData['sAppId'] );
       
        $tokenInfo = $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Authenticate\Sellerauth')->requestAccessToken( $postData );
        $this->di->getLog()->logContent( 'processAuth:path::/arisewebapi/Components/Route/Handler: tokenInfo - ' . json_encode( $tokenInfo ), 'info', 'arise' . DS . 'User' . DS . 'authentication-' . date( 'Y-m-d' ) . '.log' );
        $appConfig = $this->di->getRegistry()->getAppConfig();
        if( $tokenInfo['success'] ) {
            if ( ! empty( $tokenInfo['token']['remote_shop_id'] ) ) {
                $remoteShopId = $tokenInfo['token']['remote_shop_id'];
                unset( $tokenInfo['token']['remote_shop_id'] );
                // For switch account.
                $response = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                    [
                        'access_token'        => $tokenInfo['token']['access_token'],
                        'refresh_token'       => $tokenInfo['token']['refresh_token'],
                        'refresh_expires_in'  => $tokenInfo['token']['refresh_expires_in'],
                        'expires_in'          => $tokenInfo['token']['expires_in'],
                        'token_expires'       => $tokenInfo['token']['token_expires'],
                        'refresh_expires'     => $tokenInfo['token']['refresh_expires'],
                        'seller_id'           => $tokenInfo['token']['seller_id'],
                        'group_code'          => $appConfig['group_code'],
                        'marketplace'         => $appConfig['marketplace'],
                        'token_data'          => $tokenInfo['token'],
                        'id'                  => $remoteShopId
                    ],
                    ['id','marketplace']
                );
                if ( ! empty( $response['success'] ) ) {
                    $container = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo')
                                    ->getCollectionForTable( 'apps_shop' );
                    $oldShopData = $container->findOne( [ '_id' => $remoteShopId, 'marketplace' => $appConfig['marketplace'] ] );
                    if ( ! is_null( $oldShopData ) ) {
                        $oldShopData = json_decode( \MongoDB\BSON\toJSON( \MongoDB\BSON\fromPHP( $oldShopData ) ), true );
                        $apps        = $oldShopData['apps'] ?? array();
                        foreach ( $apps as $shopData ) {
                            if ( isset( $shopData['marketplace'] ) && $shopData['marketplace'] === $appConfig['marketplace'] ) {
                                $container->updateOne(
                                    [ '_id' => $remoteShopId, 'marketplace' => $appConfig['marketplace'] ],
                                    [ '$set' => [ 'seller_id' => $shopData['seller_id'] ] ]
                                );
                                break;
                            }
                        }
                    }
                }
                $response['data']['update_account'] = "yes";
                $this->di->getLog()->logContent( 'processAuth:path::/arisewebapi/Components/Route/Handler: Switch account data - ' . json_encode( $response ), 'info', 'arise' . DS . 'User' . DS . 'authentication-' . date( 'Y-m-d' ) . '.log' );
               
            } else {
                // For fresh onboarding.
                $response = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                    [
                        'access_token'        => $tokenInfo['token']['access_token'],
                        'refresh_token'       => $tokenInfo['token']['refresh_token'],
                        'refresh_expires_in'  => $tokenInfo['token']['refresh_expires_in'],
                        'expires_in'          => $tokenInfo['token']['expires_in'],
                        'token_expires'       => $tokenInfo['token']['token_expires'],
                        'refresh_expires'     => $tokenInfo['token']['refresh_expires'],
                        'seller_id'           => $tokenInfo['token']['seller_id'],
                        'group_code'          => $appConfig['group_code'],
                        'marketplace'         => $appConfig['marketplace'],
                        'token_data'          => $tokenInfo['token']
                    ],
                    ['seller_id','marketplace']
                );
                $this->di->getLog()->logContent( 'processAuth:path::/arisewebapi/Components/Route/Handler: New account data - ' . json_encode( $response ), 'info', 'arise' . DS . 'User' . DS . 'authentication-' . date( 'Y-m-d' ) . '.log' );
            }
            return $response;
        }
        return $tokenInfo;
    }
}
