<?php
namespace App\Arisewebapi\Components\Order;
use App\Arisewebapi\Components\Core\Common;
use IopRequest;

/**
 * Arise products handlers core logics.
 *
 * @since 1.0.0
 */
class Order extends Common {

     public function getOrder( $data ) {

          $offset =  ( $data['current_page'] - 1 ) * $data['per_page'];
          $request = new IopRequest('/orders/get','GET');
          // $request->addApiParam('offset', $offset);
          // $request->addApiParam('limt',$data['per_page']);
          // $request->addApiParam('created_before','2022-08-27T00:00:00+00:00');
          // $request->addApiParam('created_after','2022-08-26T00:00:00+00:00');
          $request->addApiParam('created_before', gmdate('c'));
          $request->addApiParam('created_after', gmdate( "c", strtotime( "now -5 hour") ));
          $request->addApiParam('status','pending');
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];

     }

     public function getOrderItem(  $order_id ) {

          $request = new IopRequest('/order/items/get','GET');
          $request->addApiParam('order_id', $order_id);
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];
     }

     public function packOrder( $data ) {

          $item_id = $data['item_ids'];
          $order_id = $data['order_id'];
          $request = new IopRequest('/order/pack');
          $request->addApiParam('packReq',
          json_encode(
               [
                    "pack_order_list"=>[
                         [
                              "order_item_list"=> $item_id,
                              "order_id"=> $order_id
                         ]
                    ],
                    "delivery_type"=> "dropship",
                    "shipping_allocate_type" => "TFS"
               ]
          )
          );
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];

     }

     public function updateTrackingInfo( $data ) {

          $request = new IopRequest('/order/package/tracking/update');
          $request->addApiParam('updateTrackingInfoReq', json_encode( $data ));
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];
     }

     public function setStatusReadyToShip( $data ) {
          $request = new IopRequest('/order/package/rts');
          $request->addApiParam('readyToShipReq', json_encode( $data ));
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];
     }

     public function setDeliveryConfirm( $data ) {
          $request = new IopRequest('/order/package/sof/delivered');
          $request->addApiParam('dbsDeliveryReq',json_encode( $data ));
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];

     }

     public function setDeliveryFailed( $data ) {
          
          $request = new IopRequest('/order/package/sof/failed_delivery');
          $request->addApiParam('dbsFailedDeliveryReq',json_encode( $data ));
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];

     }

     public function getCancelReason( $param ) {


          $request = new IopRequest('/order/reverse/cancel/validate','GET');
          $request->addApiParam('order_item_id_list', $param['order_item_ids'] );
          $request->addApiParam('order_id', $param['order_id']);          
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];
     }
     
     public function cancelOrder($param ) {

          $request = new IopRequest('/order/reverse/cancel/create','GET');
          $request->addApiParam('order_item_id_list', $param['order_item_ids']);
          $request->addApiParam('order_id', $param['order_id']);
          $request->addApiParam('reason_id', $param['reason_id']);

          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];
     }


     /**
      * Function to use get Single Order Details
      *
      * @param int $orderId order id.
      * @return array
      */
     public function getSingleOrder( $orderId ) {

          $request = new IopRequest('/order/get','GET');
          $request->addApiParam('order_id', $orderId);
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];

     }

     public function printAwb( $data ) {
          $package_id = $data['package_id'];
          $request = new IopRequest('/order/package/document/get','GET');
          $request->addApiParam('getDocumentReq', json_encode( ["doc_type" => "PDF", "packages" => [["package_id" => $package_id]]] ));
          return [
               'success' => true,
               'data'    => $this->execute( $request )
          ];

     }
}