<?php
namespace App\Arisewebapi\Components\Image;
use App\Arisewebapi\Components\Core\Common;
use IopRequest;

/**
 * Arise products handlers core logics.
 *
 * @since 1.0.0
 */
class Image extends Common {

    /**
     * Will migrate image to Arise.
     *
     * @since 1.0.0
     * @return array
     */
    public function migrateImage( $params ) {
        if ( empty( $params['image_url'] ) ) {
            return [
                'success' => false,
                'msg'     => 'Image URL is required'
            ];
        }
    
        $request = new IopRequest( '/image/migrate' );
        $request->addApiParam(
            'payload',
            json_encode(
                [
                    'Request' => [
                        'Image' => [
                            'Url' => $params['image_url']
                        ]
                    ]
                ]
            )
        );
        return [
            'success' => true,
            'data'    => $this->execute( $request ),
        ];
    }

    /**
     * Will migrate images to Arise.
     *
     * @param array $params array containing the params.
     * @since 1.0.0
     * @return array
     */
    public function migrateImages( $params ) {
        if ( empty( $params['image_urls'] ) || ! is_array( $params['image_urls'] ) ) {
            return [
                'success' => false,
                'msg'     => 'Image URLs are required'
            ];
        }
    
        $request = new IopRequest( '/images/migrate' );
        $request->addApiParam(
            'payload',
            json_encode(
                [
                    'Request' => [
                        'Images' => [
                            'Url' => $params['image_urls']
                        ]
                    ]
                ]
            )
        );
        return [
            'success' => true,
            'data'    => $this->execute( $request ),
        ];
    }

    /**
     * Will verify feed from Arise.
     *
     * @param array $params array containing the feed ID from the bulk image upload.
     * @since 1.0.0
     * @return array
     */
    public function verifyFeed( $params ) {
        if ( empty( $params['batch_id'] ) ) {
            return [
                'success' => false,
                'msg'     => 'Batch ID is required to verify image feed'
            ];
        }
        $request = new IopRequest( '/image/response/get', 'GET' );
        $request->addApiParam( 'batch_id', $params['batch_id'] );

        return [
            'success' => true,
            'data'    => $this->execute( $request ),
        ];
    }
}