<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Arisewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Arisewebapi\Components\Core;

use IopClient;
use IopRequest;

use Phalcon\Http\Client\Request;

/**
 * Handle common funtinality.
 */
class Common extends \App\Apiconnect\Components\Authenticate\Common {
    
    /**
     * Will execute api request to arise server.
     *
     * @param object $request request object from Arise API.
     * @since 1.0.0
     * @return string|boolean
     */
    public function execute( $request, $get_token = false, $accessToken = false ) {
        try {
            $appcredentials = $this->getAppCredentials();
            if ( ! $appcredentials['app_key'] ) {
                return[
                    'success' => false,
                    'message' => 'Oops! App key not found'
                ];
            }
            if ( ! $appcredentials['app_secret'] ) {
                return[
                    'success' => false,
                    'message' => 'Oops! App secret not found'
                ];
            }
            if ( ! $appcredentials['base_url'] ) {
                return[
                    'success' => false,
                    'message' => 'Oops! Endpoint url not found'
                ];
            }
            if( ! $get_token ) {
                $refreshResponse = $this->validateToken();
                $accessToken     = $this->getAccessToken();
                if ( ! $accessToken ) {
                    return[
                        'success' => false,
                        'message' => 'Oops! Access token not found'
                    ];
               }
            }
            $connection  = new IopClient( $appcredentials['base_url'], $appcredentials['app_key'], $appcredentials['app_secret'] );
    
            return $connection->execute( $request, $accessToken);
        } catch ( \Exception $e ) {

            $this->di->getLog()->logContent( 'execute:path::/arisewebapi/Components/Core/Common: Exception - ' . print_r( $appcredentials , true ) . 'Request Data' . print_r( $request, true ), 'info', 'arise' . DS . 'admin' . DS . 'product-' . date( 'Y-m-d' ) . '-error.log' );
            return $e->getMessage();
        }
    }

    /**
     * Get app credentials.
     *
     * @return array
     * @since 1.0.0
     */
    public function getAppCredentials(){
       
        $requestData = $this->di->getRequest()->get();
        
        if( ! empty( $requestData['sandbox'] ) ) {
            $mode = 'sandbox';
        } else {
            $mode = 'live';
        }
        $configData = $this->di->getRegistry()->getAppConfig();
        return [
            'app_key'      => ! empty( $configData[ $mode ]['app_key'] ) ? $configData[ $mode ]['app_key'] : false,
            'app_secret'   => ! empty( $configData[ $mode ]['app_secret'] ) ? $configData[ $mode ]['app_secret'] : false,
            'base_url'   => ! empty( $configData[ $mode ]['base_url'] ) ? $configData[ $mode ]['base_url'] : false,
            'redirect_uri' => ! empty( $configData[ $mode ]['redirect_uri'] ) ? $configData[ $mode ]['redirect_uri'] : false
        ];
    }
    /**
     * Get access token for current shop.
     *
     * @since 1.0.0
     * @return string|boolean
     */
    public function getAccessToken() {
        $shopData = $this->di->getRegistry()->getCurrentShop();
        return ! empty( $shopData['apps'][0]['access_token'] ) ? $shopData['apps'][0]['access_token'] : false;
    }

    /**
     * Refresh access token for current shop.
     *
     * @since 1.0.0
     * @return string|boolean
     */
    public function validateToken() {
        $shopData = $this->di->getRegistry()->getCurrentShop();
        $tokenExpire = !empty( $shopData['apps'][0]['token_expires'] ) ? $shopData['apps'][0]['token_expires'] : false;
        $currentTime = strtotime("-30 minutes");
        if( $currentTime >= $tokenExpire ) {
            $refreshToken = !empty( $shopData['apps'][0]['refresh_token'] ) ? $shopData['apps'][0]['refresh_token'] : false;
            $request = new IopRequest('/auth/token/refresh');
            $request->addApiParam('refresh_token', $refreshToken );
            $tokenResponse = $this->execute( $request,true );
            $tokenResponse = json_decode( $tokenResponse, true );
            if( isset( $tokenResponse['code'] ) && $tokenResponse['code'] == '0' ) {
                $tokenResponse['token_expires'] = strtotime("+{$tokenResponse['expires_in']} seconds");
                $tokenResponse['refresh_expires'] = strtotime("+{$tokenResponse['refresh_expires_in']} seconds");
                $tokenResponse['seller_id'] = $shopData['seller_id'];
                $tokenResponse['marketplace'] = $shopData['marketplace'];
                $response = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(
                    [
                        'access_token'        => $tokenResponse['access_token'],
                        'refresh_token'       => $tokenResponse['refresh_token'],
                        'refresh_expires_in'  => $tokenResponse['refresh_expires_in'],
                        'expires_in'          => $tokenResponse['expires_in'],
                        'token_expires'       => $tokenResponse['token_expires'],
                        'refresh_expires'     => $tokenResponse['refresh_expires'],
                        'token_data'          => $tokenResponse,
                        'seller_id'           => $tokenResponse['seller_id'],
                        'marketplace'         => $tokenResponse['marketplace'],

                    ],
                    ['seller_id','marketplace']
                );
                return $response;
            }
        }    
    }
    
     /** 
     * Will excute direct request to the URL provided
     *
     * @param string $url URL to send request at.
     * @param array  $data params to send at the URL.
     * @param string $method method to use for request.
     * @since 1.0.0
     * @return object
     */
    public function executeRequest( $url, $data = array(), $method = 'GET' ) {
        $provider = Request::getProvider();
        $provider->setOption( CURLOPT_SSL_VERIFYPEER, false );
        $provider->setOption( CURLOPT_SSL_VERIFYHOST, false );
        $provider->header->set( 'Accept', 'application/json' );
        $provider->header->set( 'Content-Type', 'application/json' );

        switch ( $method ) {
            case 'POST':
                $response = $provider->post( $url, json_encode( $data ) );
                break;
            case 'PUT':
                $response = $provider->put( $url, $data );
                break;
            case 'DELETE':
                $response = $provider->delete( $url, $data );
                break;
            default:
                $response = $provider->get( $url, $data );
                break;
        }

        return $response;
    }
}