<?php
namespace App\Arisewebapi\Components\Category;
use App\Arisewebapi\Components\Core\Common;
use IopRequest;

/**
 * Arise products handlers core logics.
 *
 * @since 1.0.0
 */
class Category extends Common {

     public function getCategory( $param ) {
          $languageCode = $param['language_code'] ?? 'en_US';
          $request = new IopRequest( '/category/tree/get', 'GET' );
          $request->addApiParam('language_code',$languageCode );
  
          return [
              'success' => true,
              'data'    => $this->execute( $request )
          ];

     }

     public function getAttributes( $param ) {
          $request = new IopRequest('/category/attributes/get');
          $request->addApiParam('primary_category_id', $param['category_id']);
          $request->addApiParam('language_code', $param['launguage_code']);
  
          return [
              'success' => true,
              'data'    => $this->execute( $request )
          ];
     }
     public function getBrand( $param ) {
          $request = new IopRequest('/category/brands/query','GET');
          $request->addApiParam('start_row',$param['start_row'] ?? 0 );
          $request->addApiParam('page_size',$param['page_size'] ?? 50 );
          return [
               'success' => true,
               'data'    => $this->execute( $request, true )

          ];
     }
}