<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Arisewebapi
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CEDCOMMERCE (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace App\Arisewebapi\Components\Authenticate;

use App\Arisewebapi\Components\Core\Common As CoreCommon;
use IopRequest;

/**
 * Handle authentication process.
 */
class Sellerauth extends CoreCommon
{

    /**
     * The redirect url.
     *
     * @var string
     */
    protected $redirectUrl;

    /**
     * Get the auth url.
     *
     * @param array $postData posted data for authoriation.
     * @return array
     */
    public function fetchAuthenticationUrl( $postData )
    {
        try{
            $response = $this->getRedirectUrl($postData);
            $this->di->getLog()->logContent( 'fetchAuthenticationUrl:path::/arisewebapi/Components/Authenticate/Sellerauth: post data - ' . json_encode( $response ).'Post data'.json_encode( $postData ), 'info', 'arise' . DS . 'User' . DS . 'authentication-' . date( 'Y-m-d' ) . '.log' );
            if( ! $response['success'] ) {
                return [
                    'success' => true,
                    'authUrl' => $this->redirectUrl
                ];
            }
            else{
                return [
                    'success' => true,
                    'authUrl' => $response['authUrl']
                ];
            }
        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        } 
    }

    /**
     * Get app redirect url.
     *
     * @param array $postData
     * @return array
     */
    public function getRedirectUrl( $postData ) {
        try{
            $appcredentials    = $this->getAppCredentials();
            $this->redirectUrl = $appcredentials['redirect_uri'];
            if ( ! $this->redirectUrl ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Redirect link is missing'
                ];
            }
            $params = array(
                'code'          => $postData['code'],
                'redirect_uri'  => $this->redirectUrl,
                'state'         => $postData['state'],
            );
            $this->di->getLog()->logContent( 'getRedirectUrl:path::/arisewebapi/Components/Authenticate/Sellerauth: post data - ' . json_encode( $params ), 'info', 'arise' . DS . 'User' . DS . 'authentication-' . date( 'Y-m-d' ) . '.log' );
            $authUrl = $this->redirectUrl .'&' . http_build_query( $params );
            $result  = array(
                'success' => true,
                'authUrl' => $authUrl
            );

            return $result;
        }catch (\Exception $exception) {

            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }

    /**
     * Get the access token from Arise.
     *
     * @param array $postData
     * @return array
    */
    public function requestAccessToken( $postData ) {
        try{

            $code       = isset( $postData['code'] ) ? $postData['code'] : '';
            $extraParam = array(); 
            if ( isset( $postData['state'] ) ) {
                $state = @json_decode( $postData['state'], true );
                if ( ! empty( $state['remote_shop_id'] ) ) {
                    $extraParam['remote_shop_id'] = $state['remote_shop_id'];
                }
            }
            if ( empty( $code ) ) {
                return ['success' => false, 'message' => 'Authorization code missing'];
            }
            $request = new IopRequest('/auth/token/create');
            $request->addApiParam('code', $code );
            $tokenResponse = $this->execute( $request,true );

            $tokenResponse = json_decode( $tokenResponse, true );
            if( isset( $tokenResponse['code'] ) && $tokenResponse['code'] != '0' ) {
                return ['success' => false, 'message' => $tokenResponse['message'] ?? 'Token error'];
            }
            $tokenResponse['token_expires'] = strtotime("+{$tokenResponse['expires_in']} seconds");
            $tokenResponse['refresh_expires'] = strtotime("+{$tokenResponse['refresh_expires_in']} seconds");
            
            $accessToken = $tokenResponse['access_token'] ?? false;
            $request = new IopRequest('/seller/get','GET');
            $response = $this->execute( $request, true, $accessToken );
            $response = json_decode( $response, true );
            if( isset( $response['code'] ) && $response['code'] != '0' ) {
                return ['success' => false, 'message' => $response['message'] ?? 'Token error'];
            }
            $responseData = $response['data'] ?? array();
            $response = array_merge( $tokenResponse, $responseData, $extraParam );
            unset( $response['code'] );
            unset( $response['request_id'] );
            $this->di->getLog()->logContent( 'requestAccessToken:path::/arisewebapi/Components/Authenticate/Sellerauth: token response - ' . json_encode( $response ), 'info', 'arise' . DS . 'User' . DS . 'authentication-' . date( 'Y-m-d' ) . '.log' );
            return ['success' => true, 'token' => $response ];

        } catch (\Exception $exception) {
            return [
                'success' => false,
                'message' => $exception->getMessage()
            ];
        }
    }
}