<?php
namespace App\Arisewebapi\Components\Admin;
use App\Arisewebapi\Components\Core\Common;

/**
 * Arise products handlers core logics.
 *
 * @since 1.0.0
 */
class Admin extends Common {

    /**
     * Will delete data from DB.
     *
     * @param array $params array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function deleteFromDB( $params ) {
        if ( empty( $params['query'] ) || empty( $params['params']['container'] ) ) {
            return [
                'success' => false,
                'msg'     => 'empty query or container detected.'
            ];
        }
        $container    = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo')
                        ->getCollectionForTable( $params['params']['container'] );
        $res          = $container->deleteMany( $params['query'] );
        $deletedCount  = $res->getDeletedCount();
        if ( $deletedCount ) {
            return [
                'success'        => true,
                'msg'            => 'Data deleted successfully from container' . $params['params']['container'],
                'affected_count' => $deletedCount
            ];
        }
        return [
            'success' => false,
            'msg'     => 'Unable to delete data from remote container ' . $params['params']['container']
        ];
    }

    /**
     * Will read data from DB.
     *
     * @param array $params array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function readFromDB( $params ) {
        if ( empty( $params['query'] ) || empty( $params['params']['container'] ) ) {
            return [
                'success' => false,
                'msg'     => 'empty query or container detected.'
            ];
        }
        $container = $this->di->getObjectManager()->create('\App\Core\Models\BaseMongo')
                        ->getCollectionForTable( $params['params']['container'] );
        $res       = $container->find( $params['query'] );
        return [
            'success'        => true,
            'container_name' => $params['params']['container'],
            'data'           => ! is_null( $res ) ? json_decode( \MongoDB\BSON\toJSON( \MongoDB\BSON\fromPHP( $res->toArray() ) ), true ) : 'Oops! Error occured during data reading.',
            
        ];
    }
}