<?php
namespace App\Arisewebapi\Api;

/**
 * Handles User related endpoints and will call the respective methods from components.
 *
 * @since 1.0.0
 */
class User extends Base {

    /**
     * Current component name, will be used by etc/webapi.php to call the respective class.
     *
     * @var string
     * @since 1.0.0
     */
    protected $_component = 'User';

    /**
     * Delete account for user details passed.
     *
     * @param array $data request params.
     * @since 1.0.0
     * @return array
     */
    public function deleteAccount( $data = array() ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\User\User')->deleteAccount( $this->getFilteredParams($data) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }
}