<?php
namespace App\Arisewebapi\Api;
use App\Arisewebapi\Components\Shop\Shop As ComponentResponse;
/**
 * Handles attibute set related endpoints and will call the respective methods from components.
 *
 * @since 1.0.0
 */
class Shop extends Base {

    /**
     * Current component name, will be used by etc/webapi.php to call the respective class.
     *
     * @var string
     * @since 1.0.0
     */
    protected $_component = 'Shop';

    /**
     * Manages get request for attribute and will call respective method from component.
     *
     * @param array $data array containing the request data.
     * @since 1.0.0
     * @return array array containing the request status and the response data.
     */
    public function get( $data ) {
        try {
            if( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get(ComponentResponse::class)->get( $data );
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }
}