<?php

namespace App\Arisewebapi\Api;

/**
 * Main class file to manage Shipping.
 *
 * @since 1.0.0
 */
class Shipping extends Base {

     public function getCarrier() {
          try {
			if ( ! $this->di->getRegistry()->getCurrentShop() ) {
			    return [
			        'success' => false,
			        'msg'     => 'Oops! Shop ID not found'
			    ];
			}
  
			return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Shipping\Shipping')->getAriseShipping();
		} catch ( \Exception $e ) {
			return [
				'success' => false,
				'msg'     => $e->getMessage()
			];
		}
     }
}