<?php

namespace App\Arisewebapi\Api;

/**
 * Main class file to manage Products.
 *
 * @since 1.0.0
 */
class Product extends Base {

    /**
     * Set component name wil be used to map the Component in the etc/rest/webapi.php endpoints callback.
     *
     * @var string
     * @since 1.0.0
     */
    protected $_component = 'Product';

    /**
     * Will call get products method from components.
     *
     * @param array $data array array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function get( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Product\Product')->getAriseProducts($this->getFilteredParams($data));
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will get Item data from arise.
     *
     * @param array $data array containing the request data.
     * @since 1.0.0
     * @return array
     */
    public function getItem( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Product\Product')->getItem( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Create product at Arise.
     *
     * @param array $data array containing the params.
     * @since 1.0.0
     * @return array
     */
    public function create( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->uploadProductArise( $this->getFilteredParams( $data ), 'insert' );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will create Feed for bulk product upload ( step 1 ).
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function createFeedDocument( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->createFeedDocumentArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will create Feed by specifying type for bulk product upload ( step 2 ).
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function putFeedData( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->putFeedDataArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will create Feed by specifying type for bulk product upload ( step 3 ).
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function createFeed( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->createFeedArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will get Feed status ( step 4 ).
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function getFeed( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->getFeedArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Get feed result document from Arise ( step 5 ).
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function getFeedDocument( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->getFeedDocumentArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Get feed document result data ( step 6 ).
     *
     * @param array $data array containing the request paams.
     * @return void
     * @since 1.0.0
     */
    public function getFeedDocumentData( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->getFeedDocumentDataArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will update products.
     *
     * @since 1.0.0
     * @return array
     */
    public function update( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->uploadProductArise( $this->getFilteredParams( $data ), 'update' );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will delete products.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function delete( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found',
                    'data'    => 'error'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->deleteProductArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will update Inventory and/or Price.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function updateInventoryPrice( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found',
                    'data'    => 'error'
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->updateInventoryPriceArise( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will deactivate product on marketplace.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function deactivateProduct( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found',
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->deactivateProduct( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will activate product on marketplace.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function activateProduct( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found',
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->activateProduct( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }

    /**
     * Will delete bulk upload document.
     *
     * @param array $data array containing the request params.
     * @since 1.0.0
     * @return array
     */
    public function deleteBulkUploadDocument( $data ) {
        try {
            if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                return [
                    'success' => false,
                    'msg'     => 'Oops! Shop ID not found',
                ];
            }

            return $this->di->getObjectManager()->get( '\App\Arisewebapi\Components\Product\Product' )->deleteBulkUploadDocument( $this->getFilteredParams( $data ) );
        } catch ( \Exception $e ) {
            return [
                'success' => false,
                'msg'     => $e->getMessage()
            ];
        }
    }
}