<?php

namespace App\Arisewebapi\Api;

use Exception;

/**
 * Main class file to manage Products.
 *
 * @since 1.0.0
 */
class Order extends Base {

     public function getOrder( $data ) {

          try{

               if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                        'success' => false,
                        'msg'     => 'Oops! Shop ID not found'
                    ];
               }
               return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->getOrder( $data );

          } catch( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }

          // return [
          //      'success' => true,
          //      'data'    => 'hn'
          // ];
     }

     public function getOrderItem(  $data ) {

          try{

               if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                        'success' => false,
                        'msg'     => 'Oops! Shop ID not found'
                    ];
               }
               return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->getOrderItem( $data['order_id'] );

          } catch( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }


     }


     public function packOrder( $data ) {
          try{

               if ( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                        'success' => false,
                        'msg'     => 'Oops! Shop ID not found'
                    ];
               }
             
               return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->packOrder( $data );

          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }
     }

     public function updateTrackingInfo( $data ) {

          try {
               $sendData['update_packages'] = $data['tracking_data'];
              
                if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops! Shop ID not Found'
                    ];
                    
               }

               return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->updateTrackingInfo( $this->getFilteredParams( $sendData ) );

          } catch( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }
     }

     public function setStatusReadyToShip( $data ) {
          try{

               if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops!! Shop Id not Found'
                    ];
               }
               $sendData['packages'] = $data['package_list'];

               return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->setStatusReadyToShip( $this->getFilteredParams( $sendData ) );


          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }
     }

     public function setDeliveryConfirm( $data ) {
          try{

               if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops!! Shop Id not Found'
                    ];
               }
               $sendData['packages'] = $data['package_list'];

               return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->setDeliveryConfirm(  $sendData );


          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }
     }

     public function setDeliveryFailed( $data ) {
          try{

               if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops!! Shop Id not Found'
                    ];
               }
               $sendData['packages'] = $data['package_list'];

               return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->setDeliveryFailed( $this->getFilteredParams( $sendData ) );


          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }
     }

     public function getCancelReason( $param ) {
          
          try{

               if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops!! Shop Id not Found'
                    ];
               }

          return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->getCancelReason( $this->getFilteredParams( $param ) );


          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }
     }
     public function cancelOrder( $param ) {
          
          try{

               if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops!! Shop Id not Found'
                    ];
               }

          return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->cancelOrder( $this->getFilteredParams( $param ) );


          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }
     }

     public function getSingleOrder( $data ) {

          try{
           

               if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops!! Shop Id not Found'
                    ];
               }

          return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->getSingleOrder( $data['order_id'] );


          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }

     }

     public function printAwb( $data ) {

          try{
           

               if( ! $this->di->getRegistry()->getCurrentShop() ) {
                    return [
                         'success' => false,
                         'msg'     => 'Oops!! Shop Id not Found'
                    ];
               }

          return $this->di->getObjectManager()->get('\App\Arisewebapi\Components\Order\Order')->printAwb( $data );


          } catch ( \Exception $e ) {
               return [
                    'success' => false,
                    'msg'     => $e->getMessage()
               ];
          }

     }
}